@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.Ipv6CircuitConnectionConfigResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.network.kotlin.outputs.Ipv6CircuitConnectionConfigResponse.Companion.toKotlin as ipv6CircuitConnectionConfigResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin

/**
 * Builder for [ExpressRouteCircuitConnection].
 */
@PulumiTagMarker
public class ExpressRouteCircuitConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExpressRouteCircuitConnectionArgs = ExpressRouteCircuitConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExpressRouteCircuitConnectionArgsBuilder.() -> Unit) {
        val builder = ExpressRouteCircuitConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ExpressRouteCircuitConnection {
        val builtJavaResource =
            com.pulumi.azurenative.network.ExpressRouteCircuitConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ExpressRouteCircuitConnection(builtJavaResource)
    }
}

/**
 * Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### ExpressRouteCircuitConnectionCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var expressRouteCircuitConnection = new AzureNative.Network.ExpressRouteCircuitConnection("expressRouteCircuitConnection", new()
 *     {
 *         AddressPrefix = "10.0.0.0/29",
 *         AuthorizationKey = "946a1918-b7a2-4917-b43c-8c4cdaee006a",
 *         CircuitName = "ExpressRouteARMCircuitA",
 *         ConnectionName = "circuitConnectionUSAUS",
 *         ExpressRouteCircuitPeering = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid1/resourceGroups/dedharcktinit/providers/Microsoft.Network/expressRouteCircuits/dedharcktlocal/peerings/AzurePrivatePeering",
 *         },
 *         Ipv6CircuitConnectionConfig = new AzureNative.Network.Inputs.Ipv6CircuitConnectionConfigArgs
 *         {
 *             AddressPrefix = "aa:bb::/125",
 *         },
 *         PeerExpressRouteCircuitPeering = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid2/resourceGroups/dedharcktpeer/providers/Microsoft.Network/expressRouteCircuits/dedharcktremote/peerings/AzurePrivatePeering",
 *         },
 *         PeeringName = "AzurePrivatePeering",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewExpressRouteCircuitConnection(ctx, "expressRouteCircuitConnection", &network.ExpressRouteCircuitConnectionArgs{
 * 			AddressPrefix:    pulumi.String("10.0.0.0/29"),
 * 			AuthorizationKey: pulumi.String("946a1918-b7a2-4917-b43c-8c4cdaee006a"),
 * 			CircuitName:      pulumi.String("ExpressRouteARMCircuitA"),
 * 			ConnectionName:   pulumi.String("circuitConnectionUSAUS"),
 * 			ExpressRouteCircuitPeering: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid1/resourceGroups/dedharcktinit/providers/Microsoft.Network/expressRouteCircuits/dedharcktlocal/peerings/AzurePrivatePeering"),
 * 			},
 * 			Ipv6CircuitConnectionConfig: &network.Ipv6CircuitConnectionConfigArgs{
 * 				AddressPrefix: pulumi.String("aa:bb::/125"),
 * 			},
 * 			PeerExpressRouteCircuitPeering: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid2/resourceGroups/dedharcktpeer/providers/Microsoft.Network/expressRouteCircuits/dedharcktremote/peerings/AzurePrivatePeering"),
 * 			},
 * 			PeeringName:       pulumi.String("AzurePrivatePeering"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ExpressRouteCircuitConnection;
 * import com.pulumi.azurenative.network.ExpressRouteCircuitConnectionArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.Ipv6CircuitConnectionConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var expressRouteCircuitConnection = new ExpressRouteCircuitConnection("expressRouteCircuitConnection", ExpressRouteCircuitConnectionArgs.builder()
 *             .addressPrefix("10.0.0.0/29")
 *             .authorizationKey("946a1918-b7a2-4917-b43c-8c4cdaee006a")
 *             .circuitName("ExpressRouteARMCircuitA")
 *             .connectionName("circuitConnectionUSAUS")
 *             .expressRouteCircuitPeering(SubResourceArgs.builder()
 *                 .id("/subscriptions/subid1/resourceGroups/dedharcktinit/providers/Microsoft.Network/expressRouteCircuits/dedharcktlocal/peerings/AzurePrivatePeering")
 *                 .build())
 *             .ipv6CircuitConnectionConfig(Ipv6CircuitConnectionConfigArgs.builder()
 *                 .addressPrefix("aa:bb::/125")
 *                 .build())
 *             .peerExpressRouteCircuitPeering(SubResourceArgs.builder()
 *                 .id("/subscriptions/subid2/resourceGroups/dedharcktpeer/providers/Microsoft.Network/expressRouteCircuits/dedharcktremote/peerings/AzurePrivatePeering")
 *                 .build())
 *             .peeringName("AzurePrivatePeering")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ExpressRouteCircuitConnection circuitConnectionUSAUS /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/peerings/{peeringName}/connections/{connectionName}
 * ```
 */
public class ExpressRouteCircuitConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.network.ExpressRouteCircuitConnection,
) : KotlinCustomResource(javaResource, ExpressRouteCircuitConnectionMapper) {
    /**
     * /29 IP address space to carve out Customer addresses for tunnels.
     */
    public val addressPrefix: Output<String>?
        get() = javaResource.addressPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The authorization key.
     */
    public val authorizationKey: Output<String>?
        get() = javaResource.authorizationKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Express Route Circuit connection state.
     */
    public val circuitConnectionStatus: Output<String>
        get() = javaResource.circuitConnectionStatus().applyValue({ args0 -> args0 })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Reference to Express Route Circuit Private Peering Resource of the circuit initiating connection.
     */
    public val expressRouteCircuitPeering: Output<SubResourceResponse>?
        get() = javaResource.expressRouteCircuitPeering().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * IPv6 Address PrefixProperties of the express route circuit connection.
     */
    public val ipv6CircuitConnectionConfig: Output<Ipv6CircuitConnectionConfigResponse>?
        get() = javaResource.ipv6CircuitConnectionConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> ipv6CircuitConnectionConfigResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Reference to Express Route Circuit Private Peering Resource of the peered circuit.
     */
    public val peerExpressRouteCircuitPeering: Output<SubResourceResponse>?
        get() = javaResource.peerExpressRouteCircuitPeering().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The provisioning state of the express route circuit connection resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ExpressRouteCircuitConnectionMapper : ResourceMapper<ExpressRouteCircuitConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.ExpressRouteCircuitConnection::class == javaResource::class

    override fun map(javaResource: Resource): ExpressRouteCircuitConnection =
        ExpressRouteCircuitConnection(
            javaResource as
                com.pulumi.azurenative.network.ExpressRouteCircuitConnection,
        )
}

/**
 * @see [ExpressRouteCircuitConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ExpressRouteCircuitConnection].
 */
public suspend fun expressRouteCircuitConnection(
    name: String,
    block: suspend ExpressRouteCircuitConnectionResourceBuilder.() -> Unit,
):
    ExpressRouteCircuitConnection {
    val builder = ExpressRouteCircuitConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ExpressRouteCircuitConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun expressRouteCircuitConnection(name: String): ExpressRouteCircuitConnection {
    val builder = ExpressRouteCircuitConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
