@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.ExpressRouteCircuitConnectionArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.Ipv6CircuitConnectionConfigArgs
import com.pulumi.azurenative.network.kotlin.inputs.Ipv6CircuitConnectionConfigArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### ExpressRouteCircuitConnectionCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var expressRouteCircuitConnection = new AzureNative.Network.ExpressRouteCircuitConnection("expressRouteCircuitConnection", new()
 *     {
 *         AddressPrefix = "10.0.0.0/29",
 *         AuthorizationKey = "946a1918-b7a2-4917-b43c-8c4cdaee006a",
 *         CircuitName = "ExpressRouteARMCircuitA",
 *         ConnectionName = "circuitConnectionUSAUS",
 *         ExpressRouteCircuitPeering = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid1/resourceGroups/dedharcktinit/providers/Microsoft.Network/expressRouteCircuits/dedharcktlocal/peerings/AzurePrivatePeering",
 *         },
 *         Ipv6CircuitConnectionConfig = new AzureNative.Network.Inputs.Ipv6CircuitConnectionConfigArgs
 *         {
 *             AddressPrefix = "aa:bb::/125",
 *         },
 *         PeerExpressRouteCircuitPeering = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid2/resourceGroups/dedharcktpeer/providers/Microsoft.Network/expressRouteCircuits/dedharcktremote/peerings/AzurePrivatePeering",
 *         },
 *         PeeringName = "AzurePrivatePeering",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewExpressRouteCircuitConnection(ctx, "expressRouteCircuitConnection", &network.ExpressRouteCircuitConnectionArgs{
 * 			AddressPrefix:    pulumi.String("10.0.0.0/29"),
 * 			AuthorizationKey: pulumi.String("946a1918-b7a2-4917-b43c-8c4cdaee006a"),
 * 			CircuitName:      pulumi.String("ExpressRouteARMCircuitA"),
 * 			ConnectionName:   pulumi.String("circuitConnectionUSAUS"),
 * 			ExpressRouteCircuitPeering: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid1/resourceGroups/dedharcktinit/providers/Microsoft.Network/expressRouteCircuits/dedharcktlocal/peerings/AzurePrivatePeering"),
 * 			},
 * 			Ipv6CircuitConnectionConfig: &network.Ipv6CircuitConnectionConfigArgs{
 * 				AddressPrefix: pulumi.String("aa:bb::/125"),
 * 			},
 * 			PeerExpressRouteCircuitPeering: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid2/resourceGroups/dedharcktpeer/providers/Microsoft.Network/expressRouteCircuits/dedharcktremote/peerings/AzurePrivatePeering"),
 * 			},
 * 			PeeringName:       pulumi.String("AzurePrivatePeering"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ExpressRouteCircuitConnection;
 * import com.pulumi.azurenative.network.ExpressRouteCircuitConnectionArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.Ipv6CircuitConnectionConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var expressRouteCircuitConnection = new ExpressRouteCircuitConnection("expressRouteCircuitConnection", ExpressRouteCircuitConnectionArgs.builder()
 *             .addressPrefix("10.0.0.0/29")
 *             .authorizationKey("946a1918-b7a2-4917-b43c-8c4cdaee006a")
 *             .circuitName("ExpressRouteARMCircuitA")
 *             .connectionName("circuitConnectionUSAUS")
 *             .expressRouteCircuitPeering(SubResourceArgs.builder()
 *                 .id("/subscriptions/subid1/resourceGroups/dedharcktinit/providers/Microsoft.Network/expressRouteCircuits/dedharcktlocal/peerings/AzurePrivatePeering")
 *                 .build())
 *             .ipv6CircuitConnectionConfig(Ipv6CircuitConnectionConfigArgs.builder()
 *                 .addressPrefix("aa:bb::/125")
 *                 .build())
 *             .peerExpressRouteCircuitPeering(SubResourceArgs.builder()
 *                 .id("/subscriptions/subid2/resourceGroups/dedharcktpeer/providers/Microsoft.Network/expressRouteCircuits/dedharcktremote/peerings/AzurePrivatePeering")
 *                 .build())
 *             .peeringName("AzurePrivatePeering")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ExpressRouteCircuitConnection circuitConnectionUSAUS /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/peerings/{peeringName}/connections/{connectionName}
 * ```
 * @property addressPrefix /29 IP address space to carve out Customer addresses for tunnels.
 * @property authorizationKey The authorization key.
 * @property circuitName The name of the express route circuit.
 * @property connectionName The name of the express route circuit connection.
 * @property expressRouteCircuitPeering Reference to Express Route Circuit Private Peering Resource of the circuit initiating connection.
 * @property id Resource ID.
 * @property ipv6CircuitConnectionConfig IPv6 Address PrefixProperties of the express route circuit connection.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property peerExpressRouteCircuitPeering Reference to Express Route Circuit Private Peering Resource of the peered circuit.
 * @property peeringName The name of the peering.
 * @property resourceGroupName The name of the resource group.
 */
public data class ExpressRouteCircuitConnectionArgs(
    public val addressPrefix: Output<String>? = null,
    public val authorizationKey: Output<String>? = null,
    public val circuitName: Output<String>? = null,
    public val connectionName: Output<String>? = null,
    public val expressRouteCircuitPeering: Output<SubResourceArgs>? = null,
    public val id: Output<String>? = null,
    public val ipv6CircuitConnectionConfig: Output<Ipv6CircuitConnectionConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val peerExpressRouteCircuitPeering: Output<SubResourceArgs>? = null,
    public val peeringName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.ExpressRouteCircuitConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.ExpressRouteCircuitConnectionArgs =
        com.pulumi.azurenative.network.ExpressRouteCircuitConnectionArgs.builder()
            .addressPrefix(addressPrefix?.applyValue({ args0 -> args0 }))
            .authorizationKey(authorizationKey?.applyValue({ args0 -> args0 }))
            .circuitName(circuitName?.applyValue({ args0 -> args0 }))
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .expressRouteCircuitPeering(
                expressRouteCircuitPeering?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .ipv6CircuitConnectionConfig(
                ipv6CircuitConnectionConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .peerExpressRouteCircuitPeering(
                peerExpressRouteCircuitPeering?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .peeringName(peeringName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExpressRouteCircuitConnectionArgs].
 */
@PulumiTagMarker
public class ExpressRouteCircuitConnectionArgsBuilder internal constructor() {
    private var addressPrefix: Output<String>? = null

    private var authorizationKey: Output<String>? = null

    private var circuitName: Output<String>? = null

    private var connectionName: Output<String>? = null

    private var expressRouteCircuitPeering: Output<SubResourceArgs>? = null

    private var id: Output<String>? = null

    private var ipv6CircuitConnectionConfig: Output<Ipv6CircuitConnectionConfigArgs>? = null

    private var name: Output<String>? = null

    private var peerExpressRouteCircuitPeering: Output<SubResourceArgs>? = null

    private var peeringName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value /29 IP address space to carve out Customer addresses for tunnels.
     */
    @JvmName("fjdlibkyipgfxacj")
    public suspend fun addressPrefix(`value`: Output<String>) {
        this.addressPrefix = value
    }

    /**
     * @param value The authorization key.
     */
    @JvmName("ggakwfseufybqeqy")
    public suspend fun authorizationKey(`value`: Output<String>) {
        this.authorizationKey = value
    }

    /**
     * @param value The name of the express route circuit.
     */
    @JvmName("mxotjusbsfmbtgik")
    public suspend fun circuitName(`value`: Output<String>) {
        this.circuitName = value
    }

    /**
     * @param value The name of the express route circuit connection.
     */
    @JvmName("fuaeehwgigbkfbld")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value Reference to Express Route Circuit Private Peering Resource of the circuit initiating connection.
     */
    @JvmName("hpdhacxgywclgsfy")
    public suspend fun expressRouteCircuitPeering(`value`: Output<SubResourceArgs>) {
        this.expressRouteCircuitPeering = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("woapjopuekejcbtc")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value IPv6 Address PrefixProperties of the express route circuit connection.
     */
    @JvmName("yrtwglijqkkqnodf")
    public suspend fun ipv6CircuitConnectionConfig(`value`: Output<Ipv6CircuitConnectionConfigArgs>) {
        this.ipv6CircuitConnectionConfig = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("someecmjkfnigyll")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Reference to Express Route Circuit Private Peering Resource of the peered circuit.
     */
    @JvmName("ncbldbvahvcqonse")
    public suspend fun peerExpressRouteCircuitPeering(`value`: Output<SubResourceArgs>) {
        this.peerExpressRouteCircuitPeering = value
    }

    /**
     * @param value The name of the peering.
     */
    @JvmName("mneqavjgnwjbfags")
    public suspend fun peeringName(`value`: Output<String>) {
        this.peeringName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wwrrwbtfccbquhtm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value /29 IP address space to carve out Customer addresses for tunnels.
     */
    @JvmName("anxpikfpmqnuaovg")
    public suspend fun addressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefix = mapped
    }

    /**
     * @param value The authorization key.
     */
    @JvmName("uljpbllpxrdycpor")
    public suspend fun authorizationKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationKey = mapped
    }

    /**
     * @param value The name of the express route circuit.
     */
    @JvmName("vshqgiryfmlyokbm")
    public suspend fun circuitName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.circuitName = mapped
    }

    /**
     * @param value The name of the express route circuit connection.
     */
    @JvmName("qbhwwlnnehygjqyx")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value Reference to Express Route Circuit Private Peering Resource of the circuit initiating connection.
     */
    @JvmName("jhghbdulnpvxxloj")
    public suspend fun expressRouteCircuitPeering(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressRouteCircuitPeering = mapped
    }

    /**
     * @param argument Reference to Express Route Circuit Private Peering Resource of the circuit initiating connection.
     */
    @JvmName("yaahxguswoyvjtjb")
    public suspend
    fun expressRouteCircuitPeering(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.expressRouteCircuitPeering = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("etbvottcynfsjwni")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value IPv6 Address PrefixProperties of the express route circuit connection.
     */
    @JvmName("puvdlfvafseiqhea")
    public suspend fun ipv6CircuitConnectionConfig(`value`: Ipv6CircuitConnectionConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6CircuitConnectionConfig = mapped
    }

    /**
     * @param argument IPv6 Address PrefixProperties of the express route circuit connection.
     */
    @JvmName("jnqqerchxgqgtkgj")
    public suspend
    fun ipv6CircuitConnectionConfig(argument: suspend Ipv6CircuitConnectionConfigArgsBuilder.() -> Unit) {
        val toBeMapped = Ipv6CircuitConnectionConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ipv6CircuitConnectionConfig = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("mfnppvffkbseejbx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Reference to Express Route Circuit Private Peering Resource of the peered circuit.
     */
    @JvmName("makjilxgnobvnsud")
    public suspend fun peerExpressRouteCircuitPeering(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerExpressRouteCircuitPeering = mapped
    }

    /**
     * @param argument Reference to Express Route Circuit Private Peering Resource of the peered circuit.
     */
    @JvmName("iafwruugwrlgljqn")
    public suspend
    fun peerExpressRouteCircuitPeering(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.peerExpressRouteCircuitPeering = mapped
    }

    /**
     * @param value The name of the peering.
     */
    @JvmName("avbibxcapxejjygs")
    public suspend fun peeringName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xayoqtugtejvtegq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ExpressRouteCircuitConnectionArgs = ExpressRouteCircuitConnectionArgs(
        addressPrefix = addressPrefix,
        authorizationKey = authorizationKey,
        circuitName = circuitName,
        connectionName = connectionName,
        expressRouteCircuitPeering = expressRouteCircuitPeering,
        id = id,
        ipv6CircuitConnectionConfig = ipv6CircuitConnectionConfig,
        name = name,
        peerExpressRouteCircuitPeering = peerExpressRouteCircuitPeering,
        peeringName = peeringName,
        resourceGroupName = resourceGroupName,
    )
}
