@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitConnectionResponse
import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitPeeringConfigResponse
import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitStatsResponse
import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteConnectionIdResponse
import com.pulumi.azurenative.network.kotlin.outputs.Ipv6ExpressRouteCircuitPeeringConfigResponse
import com.pulumi.azurenative.network.kotlin.outputs.PeerExpressRouteCircuitConnectionResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitConnectionResponse.Companion.toKotlin as expressRouteCircuitConnectionResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitPeeringConfigResponse.Companion.toKotlin as expressRouteCircuitPeeringConfigResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitStatsResponse.Companion.toKotlin as expressRouteCircuitStatsResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteConnectionIdResponse.Companion.toKotlin as expressRouteConnectionIdResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.Ipv6ExpressRouteCircuitPeeringConfigResponse.Companion.toKotlin as ipv6ExpressRouteCircuitPeeringConfigResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PeerExpressRouteCircuitConnectionResponse.Companion.toKotlin as peerExpressRouteCircuitConnectionResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin

/**
 * Builder for [ExpressRouteCircuitPeering].
 */
@PulumiTagMarker
public class ExpressRouteCircuitPeeringResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExpressRouteCircuitPeeringArgs = ExpressRouteCircuitPeeringArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExpressRouteCircuitPeeringArgsBuilder.() -> Unit) {
        val builder = ExpressRouteCircuitPeeringArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ExpressRouteCircuitPeering {
        val builtJavaResource =
            com.pulumi.azurenative.network.ExpressRouteCircuitPeering(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ExpressRouteCircuitPeering(builtJavaResource)
    }
}

/**
 * Peering in an ExpressRouteCircuit resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2017-09-01, 2019-02-01, 2019-06-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create ExpressRouteCircuit Peerings
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var expressRouteCircuitPeering = new AzureNative.Network.ExpressRouteCircuitPeering("expressRouteCircuitPeering", new()
 *     {
 *         CircuitName = "circuitName",
 *         PeerASN = 200,
 *         PeeringName = "AzurePrivatePeering",
 *         PrimaryPeerAddressPrefix = "192.168.16.252/30",
 *         ResourceGroupName = "rg1",
 *         SecondaryPeerAddressPrefix = "192.168.18.252/30",
 *         VlanId = 200,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewExpressRouteCircuitPeering(ctx, "expressRouteCircuitPeering", &network.ExpressRouteCircuitPeeringArgs{
 * 			CircuitName:                pulumi.String("circuitName"),
 * 			PeerASN:                    pulumi.Float64(200),
 * 			PeeringName:                pulumi.String("AzurePrivatePeering"),
 * 			PrimaryPeerAddressPrefix:   pulumi.String("192.168.16.252/30"),
 * 			ResourceGroupName:          pulumi.String("rg1"),
 * 			SecondaryPeerAddressPrefix: pulumi.String("192.168.18.252/30"),
 * 			VlanId:                     pulumi.Int(200),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ExpressRouteCircuitPeering;
 * import com.pulumi.azurenative.network.ExpressRouteCircuitPeeringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var expressRouteCircuitPeering = new ExpressRouteCircuitPeering("expressRouteCircuitPeering", ExpressRouteCircuitPeeringArgs.builder()
 *             .circuitName("circuitName")
 *             .peerASN(200)
 *             .peeringName("AzurePrivatePeering")
 *             .primaryPeerAddressPrefix("192.168.16.252/30")
 *             .resourceGroupName("rg1")
 *             .secondaryPeerAddressPrefix("192.168.18.252/30")
 *             .vlanId(200)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ExpressRouteCircuitPeering AzurePrivatePeering /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/peerings/{peeringName}
 * ```
 */
public class ExpressRouteCircuitPeering internal constructor(
    override val javaResource: com.pulumi.azurenative.network.ExpressRouteCircuitPeering,
) : KotlinCustomResource(javaResource, ExpressRouteCircuitPeeringMapper) {
    /**
     * The Azure ASN.
     */
    public val azureASN: Output<Int>?
        get() = javaResource.azureASN().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The list of circuit connections associated with Azure Private Peering for this circuit.
     */
    public val connections: Output<List<ExpressRouteCircuitConnectionResponse>>?
        get() = javaResource.connections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        expressRouteCircuitConnectionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The ExpressRoute connection.
     */
    public val expressRouteConnection: Output<ExpressRouteConnectionIdResponse>?
        get() = javaResource.expressRouteConnection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> expressRouteConnectionIdResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The GatewayManager Etag.
     */
    public val gatewayManagerEtag: Output<String>?
        get() = javaResource.gatewayManagerEtag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IPv6 peering configuration.
     */
    public val ipv6PeeringConfig: Output<Ipv6ExpressRouteCircuitPeeringConfigResponse>?
        get() = javaResource.ipv6PeeringConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    ipv6ExpressRouteCircuitPeeringConfigResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Who was the last to modify the peering.
     */
    public val lastModifiedBy: Output<String>
        get() = javaResource.lastModifiedBy().applyValue({ args0 -> args0 })

    /**
     * The Microsoft peering configuration.
     */
    public val microsoftPeeringConfig: Output<ExpressRouteCircuitPeeringConfigResponse>?
        get() = javaResource.microsoftPeeringConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    expressRouteCircuitPeeringConfigResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The peer ASN.
     */
    public val peerASN: Output<Double>?
        get() = javaResource.peerASN().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The list of peered circuit connections associated with Azure Private Peering for this circuit.
     */
    public val peeredConnections: Output<List<PeerExpressRouteCircuitConnectionResponse>>
        get() = javaResource.peeredConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> peerExpressRouteCircuitConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * The peering type.
     */
    public val peeringType: Output<String>?
        get() = javaResource.peeringType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The primary port.
     */
    public val primaryAzurePort: Output<String>?
        get() = javaResource.primaryAzurePort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The primary address prefix.
     */
    public val primaryPeerAddressPrefix: Output<String>?
        get() = javaResource.primaryPeerAddressPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provisioning state of the express route circuit peering resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The reference to the RouteFilter resource.
     */
    public val routeFilter: Output<SubResourceResponse>?
        get() = javaResource.routeFilter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subResourceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The secondary port.
     */
    public val secondaryAzurePort: Output<String>?
        get() = javaResource.secondaryAzurePort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The secondary address prefix.
     */
    public val secondaryPeerAddressPrefix: Output<String>?
        get() = javaResource.secondaryPeerAddressPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The shared key.
     */
    public val sharedKey: Output<String>?
        get() = javaResource.sharedKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The peering state.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The peering stats of express route circuit.
     */
    public val stats: Output<ExpressRouteCircuitStatsResponse>?
        get() = javaResource.stats().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    expressRouteCircuitStatsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The VLAN ID.
     */
    public val vlanId: Output<Int>?
        get() = javaResource.vlanId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ExpressRouteCircuitPeeringMapper : ResourceMapper<ExpressRouteCircuitPeering> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.ExpressRouteCircuitPeering::class == javaResource::class

    override fun map(javaResource: Resource): ExpressRouteCircuitPeering =
        ExpressRouteCircuitPeering(
            javaResource as
                com.pulumi.azurenative.network.ExpressRouteCircuitPeering,
        )
}

/**
 * @see [ExpressRouteCircuitPeering].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ExpressRouteCircuitPeering].
 */
public suspend fun expressRouteCircuitPeering(
    name: String,
    block: suspend ExpressRouteCircuitPeeringResourceBuilder.() -> Unit,
):
    ExpressRouteCircuitPeering {
    val builder = ExpressRouteCircuitPeeringResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ExpressRouteCircuitPeering].
 * @param name The _unique_ name of the resulting resource.
 */
public fun expressRouteCircuitPeering(name: String): ExpressRouteCircuitPeering {
    val builder = ExpressRouteCircuitPeeringResourceBuilder()
    builder.name(name)
    return builder.build()
}
