@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.ExpressRoutePortArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ExpressRoutePortsBillingType
import com.pulumi.azurenative.network.kotlin.enums.ExpressRoutePortsEncapsulation
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteLinkArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteLinkArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.network.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ExpressRoutePort resource definition.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### ExpressRoutePortCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var expressRoutePort = new AzureNative.Network.ExpressRoutePort("expressRoutePort", new()
 *     {
 *         BandwidthInGbps = 100,
 *         BillingType = AzureNative.Network.ExpressRoutePortsBillingType.UnlimitedData,
 *         Encapsulation = AzureNative.Network.ExpressRoutePortsEncapsulation.QinQ,
 *         ExpressRoutePortName = "portName",
 *         Location = "westus",
 *         PeeringLocation = "peeringLocationName",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewExpressRoutePort(ctx, "expressRoutePort", &network.ExpressRoutePortArgs{
 * 			BandwidthInGbps:      pulumi.Int(100),
 * 			BillingType:          pulumi.String(network.ExpressRoutePortsBillingTypeUnlimitedData),
 * 			Encapsulation:        pulumi.String(network.ExpressRoutePortsEncapsulationQinQ),
 * 			ExpressRoutePortName: pulumi.String("portName"),
 * 			Location:             pulumi.String("westus"),
 * 			PeeringLocation:      pulumi.String("peeringLocationName"),
 * 			ResourceGroupName:    pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ExpressRoutePort;
 * import com.pulumi.azurenative.network.ExpressRoutePortArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var expressRoutePort = new ExpressRoutePort("expressRoutePort", ExpressRoutePortArgs.builder()
 *             .bandwidthInGbps(100)
 *             .billingType("UnlimitedData")
 *             .encapsulation("QinQ")
 *             .expressRoutePortName("portName")
 *             .location("westus")
 *             .peeringLocation("peeringLocationName")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### ExpressRoutePortUpdateLink
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var expressRoutePort = new AzureNative.Network.ExpressRoutePort("expressRoutePort", new()
 *     {
 *         BandwidthInGbps = 100,
 *         BillingType = AzureNative.Network.ExpressRoutePortsBillingType.UnlimitedData,
 *         Encapsulation = AzureNative.Network.ExpressRoutePortsEncapsulation.QinQ,
 *         ExpressRoutePortName = "portName",
 *         Links = new[]
 *         {
 *             new AzureNative.Network.Inputs.ExpressRouteLinkArgs
 *             {
 *                 AdminState = AzureNative.Network.ExpressRouteLinkAdminState.Enabled,
 *                 Name = "link1",
 *             },
 *         },
 *         Location = "westus",
 *         PeeringLocation = "peeringLocationName",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewExpressRoutePort(ctx, "expressRoutePort", &network.ExpressRoutePortArgs{
 * 			BandwidthInGbps:      pulumi.Int(100),
 * 			BillingType:          pulumi.String(network.ExpressRoutePortsBillingTypeUnlimitedData),
 * 			Encapsulation:        pulumi.String(network.ExpressRoutePortsEncapsulationQinQ),
 * 			ExpressRoutePortName: pulumi.String("portName"),
 * 			Links: network.ExpressRouteLinkArray{
 * 				&network.ExpressRouteLinkArgs{
 * 					AdminState: pulumi.String(network.ExpressRouteLinkAdminStateEnabled),
 * 					Name:       pulumi.String("link1"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			PeeringLocation:   pulumi.String("peeringLocationName"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ExpressRoutePort;
 * import com.pulumi.azurenative.network.ExpressRoutePortArgs;
 * import com.pulumi.azurenative.network.inputs.ExpressRouteLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var expressRoutePort = new ExpressRoutePort("expressRoutePort", ExpressRoutePortArgs.builder()
 *             .bandwidthInGbps(100)
 *             .billingType("UnlimitedData")
 *             .encapsulation("QinQ")
 *             .expressRoutePortName("portName")
 *             .links(ExpressRouteLinkArgs.builder()
 *                 .adminState("Enabled")
 *                 .name("link1")
 *                 .build())
 *             .location("westus")
 *             .peeringLocation("peeringLocationName")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ExpressRoutePort portName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ExpressRoutePorts/{expressRoutePortName}
 * ```
 * @property bandwidthInGbps Bandwidth of procured ports in Gbps.
 * @property billingType The billing type of the ExpressRoutePort resource.
 * @property encapsulation Encapsulation method on physical ports.
 * @property expressRoutePortName The name of the ExpressRoutePort resource.
 * @property id Resource ID.
 * @property identity The identity of ExpressRoutePort, if configured.
 * @property links The set of physical links of the ExpressRoutePort resource.
 * @property location Resource location.
 * @property peeringLocation The name of the peering location that the ExpressRoutePort is mapped to physically.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 */
public data class ExpressRoutePortArgs(
    public val bandwidthInGbps: Output<Int>? = null,
    public val billingType: Output<Either<String, ExpressRoutePortsBillingType>>? = null,
    public val encapsulation: Output<Either<String, ExpressRoutePortsEncapsulation>>? = null,
    public val expressRoutePortName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val links: Output<List<ExpressRouteLinkArgs>>? = null,
    public val location: Output<String>? = null,
    public val peeringLocation: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.ExpressRoutePortArgs> {
    override fun toJava(): com.pulumi.azurenative.network.ExpressRoutePortArgs =
        com.pulumi.azurenative.network.ExpressRoutePortArgs.builder()
            .bandwidthInGbps(bandwidthInGbps?.applyValue({ args0 -> args0 }))
            .billingType(
                billingType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .encapsulation(
                encapsulation?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .expressRoutePortName(expressRoutePortName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .links(links?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .peeringLocation(peeringLocation?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ExpressRoutePortArgs].
 */
@PulumiTagMarker
public class ExpressRoutePortArgsBuilder internal constructor() {
    private var bandwidthInGbps: Output<Int>? = null

    private var billingType: Output<Either<String, ExpressRoutePortsBillingType>>? = null

    private var encapsulation: Output<Either<String, ExpressRoutePortsEncapsulation>>? = null

    private var expressRoutePortName: Output<String>? = null

    private var id: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var links: Output<List<ExpressRouteLinkArgs>>? = null

    private var location: Output<String>? = null

    private var peeringLocation: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Bandwidth of procured ports in Gbps.
     */
    @JvmName("awjvxodggvsejrue")
    public suspend fun bandwidthInGbps(`value`: Output<Int>) {
        this.bandwidthInGbps = value
    }

    /**
     * @param value The billing type of the ExpressRoutePort resource.
     */
    @JvmName("ecqodbqufsfqrkvo")
    public suspend fun billingType(`value`: Output<Either<String, ExpressRoutePortsBillingType>>) {
        this.billingType = value
    }

    /**
     * @param value Encapsulation method on physical ports.
     */
    @JvmName("qdqnutnennsknvjy")
    public suspend
    fun encapsulation(`value`: Output<Either<String, ExpressRoutePortsEncapsulation>>) {
        this.encapsulation = value
    }

    /**
     * @param value The name of the ExpressRoutePort resource.
     */
    @JvmName("cbgpqqgvmcuxlqgy")
    public suspend fun expressRoutePortName(`value`: Output<String>) {
        this.expressRoutePortName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("nssyajenkyyjyvaf")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The identity of ExpressRoutePort, if configured.
     */
    @JvmName("soxbxgachimcopwo")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The set of physical links of the ExpressRoutePort resource.
     */
    @JvmName("eojpvbxldnpnewam")
    public suspend fun links(`value`: Output<List<ExpressRouteLinkArgs>>) {
        this.links = value
    }

    @JvmName("pkgdqbbmjnsfsjpw")
    public suspend fun links(vararg values: Output<ExpressRouteLinkArgs>) {
        this.links = Output.all(values.asList())
    }

    /**
     * @param values The set of physical links of the ExpressRoutePort resource.
     */
    @JvmName("yjemvbonbisudkjl")
    public suspend fun links(values: List<Output<ExpressRouteLinkArgs>>) {
        this.links = Output.all(values)
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ifobjmdehlvnqevr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the peering location that the ExpressRoutePort is mapped to physically.
     */
    @JvmName("uguypucotuvgteve")
    public suspend fun peeringLocation(`value`: Output<String>) {
        this.peeringLocation = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hkpqwkarbbgbwgmi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pvjlaovjpqmlkyyb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Bandwidth of procured ports in Gbps.
     */
    @JvmName("mubinoramlhnpggv")
    public suspend fun bandwidthInGbps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidthInGbps = mapped
    }

    /**
     * @param value The billing type of the ExpressRoutePort resource.
     */
    @JvmName("amsqwgvseafonmku")
    public suspend fun billingType(`value`: Either<String, ExpressRoutePortsBillingType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingType = mapped
    }

    /**
     * @param value The billing type of the ExpressRoutePort resource.
     */
    @JvmName("utxfwumqcwtbcqra")
    public fun billingType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExpressRoutePortsBillingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.billingType = mapped
    }

    /**
     * @param value The billing type of the ExpressRoutePort resource.
     */
    @JvmName("wvoykpsglniguhmv")
    public fun billingType(`value`: ExpressRoutePortsBillingType) {
        val toBeMapped = Either.ofRight<String, ExpressRoutePortsBillingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.billingType = mapped
    }

    /**
     * @param value Encapsulation method on physical ports.
     */
    @JvmName("mxjpkqfmlmxgmsiy")
    public suspend fun encapsulation(`value`: Either<String, ExpressRoutePortsEncapsulation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encapsulation = mapped
    }

    /**
     * @param value Encapsulation method on physical ports.
     */
    @JvmName("lgrvtwyrmngsohct")
    public fun encapsulation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExpressRoutePortsEncapsulation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encapsulation = mapped
    }

    /**
     * @param value Encapsulation method on physical ports.
     */
    @JvmName("fsudcdonwjitfrpk")
    public fun encapsulation(`value`: ExpressRoutePortsEncapsulation) {
        val toBeMapped = Either.ofRight<String, ExpressRoutePortsEncapsulation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encapsulation = mapped
    }

    /**
     * @param value The name of the ExpressRoutePort resource.
     */
    @JvmName("rrlffstvpgnywsgi")
    public suspend fun expressRoutePortName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressRoutePortName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("uhkcmqvsosuttahq")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The identity of ExpressRoutePort, if configured.
     */
    @JvmName("riskblfmowmqdjbx")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of ExpressRoutePort, if configured.
     */
    @JvmName("iwlnjxpdkiadvjra")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The set of physical links of the ExpressRoutePort resource.
     */
    @JvmName("oyxdycfbuqcoqiwu")
    public suspend fun links(`value`: List<ExpressRouteLinkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.links = mapped
    }

    /**
     * @param argument The set of physical links of the ExpressRoutePort resource.
     */
    @JvmName("crdxrqfbfkrsadnd")
    public suspend fun links(argument: List<suspend ExpressRouteLinkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExpressRouteLinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.links = mapped
    }

    /**
     * @param argument The set of physical links of the ExpressRoutePort resource.
     */
    @JvmName("ofkqmmtugubkdtcw")
    public suspend fun links(vararg argument: suspend ExpressRouteLinkArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExpressRouteLinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.links = mapped
    }

    /**
     * @param argument The set of physical links of the ExpressRoutePort resource.
     */
    @JvmName("ikbstkuqlmyjgqrc")
    public suspend fun links(argument: suspend ExpressRouteLinkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ExpressRouteLinkArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.links = mapped
    }

    /**
     * @param values The set of physical links of the ExpressRoutePort resource.
     */
    @JvmName("clbtaygdrrodhkug")
    public suspend fun links(vararg values: ExpressRouteLinkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.links = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ewdrqnvudwejkxcv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the peering location that the ExpressRoutePort is mapped to physically.
     */
    @JvmName("dfqtixarpdkedybc")
    public suspend fun peeringLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringLocation = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xbgddfqrmsavmvhr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hwtmoygcamulxopq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("onnnhcfsepltxuhx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ExpressRoutePortArgs = ExpressRoutePortArgs(
        bandwidthInGbps = bandwidthInGbps,
        billingType = billingType,
        encapsulation = encapsulation,
        expressRoutePortName = expressRoutePortName,
        id = id,
        identity = identity,
        links = links,
        location = location,
        peeringLocation = peeringLocation,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
