@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ExpressRoutePortAuthorization].
 */
@PulumiTagMarker
public class ExpressRoutePortAuthorizationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExpressRoutePortAuthorizationArgs = ExpressRoutePortAuthorizationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExpressRoutePortAuthorizationArgsBuilder.() -> Unit) {
        val builder = ExpressRoutePortAuthorizationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ExpressRoutePortAuthorization {
        val builtJavaResource =
            com.pulumi.azurenative.network.ExpressRoutePortAuthorization(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ExpressRoutePortAuthorization(builtJavaResource)
    }
}

/**
 * ExpressRoutePort Authorization resource definition.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2022-01-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create ExpressRoutePort Authorization
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var expressRoutePortAuthorization = new AzureNative.Network.ExpressRoutePortAuthorization("expressRoutePortAuthorization", new()
 *     {
 *         AuthorizationName = "authorizatinName",
 *         ExpressRoutePortName = "expressRoutePortName",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewExpressRoutePortAuthorization(ctx, "expressRoutePortAuthorization", &network.ExpressRoutePortAuthorizationArgs{
 * 			AuthorizationName:    pulumi.String("authorizatinName"),
 * 			ExpressRoutePortName: pulumi.String("expressRoutePortName"),
 * 			ResourceGroupName:    pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ExpressRoutePortAuthorization;
 * import com.pulumi.azurenative.network.ExpressRoutePortAuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var expressRoutePortAuthorization = new ExpressRoutePortAuthorization("expressRoutePortAuthorization", ExpressRoutePortAuthorizationArgs.builder()
 *             .authorizationName("authorizatinName")
 *             .expressRoutePortName("expressRoutePortName")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ExpressRoutePortAuthorization authorizationName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRoutePorts/{expressRoutePortName}/authorizations/{authorizationName}
 * ```
 */
public class ExpressRoutePortAuthorization internal constructor(
    override val javaResource: com.pulumi.azurenative.network.ExpressRoutePortAuthorization,
) : KotlinCustomResource(javaResource, ExpressRoutePortAuthorizationMapper) {
    /**
     * The authorization key.
     */
    public val authorizationKey: Output<String>
        get() = javaResource.authorizationKey().applyValue({ args0 -> args0 })

    /**
     * The authorization use status.
     */
    public val authorizationUseStatus: Output<String>
        get() = javaResource.authorizationUseStatus().applyValue({ args0 -> args0 })

    /**
     * The reference to the ExpressRoute circuit resource using the authorization.
     */
    public val circuitResourceUri: Output<String>
        get() = javaResource.circuitResourceUri().applyValue({ args0 -> args0 })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning state of the authorization resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ExpressRoutePortAuthorizationMapper : ResourceMapper<ExpressRoutePortAuthorization> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.ExpressRoutePortAuthorization::class == javaResource::class

    override fun map(javaResource: Resource): ExpressRoutePortAuthorization =
        ExpressRoutePortAuthorization(
            javaResource as
                com.pulumi.azurenative.network.ExpressRoutePortAuthorization,
        )
}

/**
 * @see [ExpressRoutePortAuthorization].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ExpressRoutePortAuthorization].
 */
public suspend fun expressRoutePortAuthorization(
    name: String,
    block: suspend ExpressRoutePortAuthorizationResourceBuilder.() -> Unit,
):
    ExpressRoutePortAuthorization {
    val builder = ExpressRoutePortAuthorizationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ExpressRoutePortAuthorization].
 * @param name The _unique_ name of the resulting resource.
 */
public fun expressRoutePortAuthorization(name: String): ExpressRoutePortAuthorization {
    val builder = ExpressRoutePortAuthorizationResourceBuilder()
    builder.name(name)
    return builder.build()
}
