@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyFilterRuleCollectionResponse
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyNatRuleCollectionResponse
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [FirewallPolicyRuleCollectionGroup].
 */
@PulumiTagMarker
public class FirewallPolicyRuleCollectionGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FirewallPolicyRuleCollectionGroupArgs = FirewallPolicyRuleCollectionGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FirewallPolicyRuleCollectionGroupArgsBuilder.() -> Unit) {
        val builder = FirewallPolicyRuleCollectionGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FirewallPolicyRuleCollectionGroup {
        val builtJavaResource =
            com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FirewallPolicyRuleCollectionGroup(builtJavaResource)
    }
}

/**
 * Rule Collection Group resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create FirewallPolicyNatRuleCollectionGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallPolicyRuleCollectionGroup = new AzureNative.Network.FirewallPolicyRuleCollectionGroup("firewallPolicyRuleCollectionGroup", new()
 *     {
 *         FirewallPolicyName = "firewallPolicy",
 *         Priority = 100,
 *         ResourceGroupName = "rg1",
 *         RuleCollectionGroupName = "ruleCollectionGroup1",
 *         RuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.FirewallPolicyNatRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.FirewallPolicyNatRuleCollectionActionArgs
 *                 {
 *                     Type = AzureNative.Network.FirewallPolicyNatRuleCollectionActionType.DNAT,
 *                 },
 *                 Name = "Example-Nat-Rule-Collection",
 *                 Priority = 100,
 *                 RuleCollectionType = "FirewallPolicyNatRuleCollection",
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.NatRuleArgs
 *                     {
 *                         DestinationAddresses = new[]
 *                         {
 *                             "152.23.32.23",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "8080",
 *                         },
 *                         IpProtocols = new[]
 *                         {
 *                             AzureNative.Network.FirewallPolicyRuleNetworkProtocol.TCP,
 *                             AzureNative.Network.FirewallPolicyRuleNetworkProtocol.UDP,
 *                         },
 *                         Name = "nat-rule1",
 *                         RuleType = "NatRule",
 *                         SourceAddresses = new[]
 *                         {
 *                             "2.2.2.2",
 *                         },
 *                         SourceIpGroups = new() { },
 *                         TranslatedFqdn = "internalhttp.server.net",
 *                         TranslatedPort = "8080",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFirewallPolicyRuleCollectionGroup(ctx, "firewallPolicyRuleCollectionGroup", &network.FirewallPolicyRuleCollectionGroupArgs{
 * 			FirewallPolicyName:      pulumi.String("firewallPolicy"),
 * 			Priority:                pulumi.Int(100),
 * 			ResourceGroupName:       pulumi.String("rg1"),
 * 			RuleCollectionGroupName: pulumi.String("ruleCollectionGroup1"),
 * 			RuleCollections: pulumi.Array{
 * 				network.FirewallPolicyNatRuleCollection{
 * 					Action: network.FirewallPolicyNatRuleCollectionAction{
 * 						Type: network.FirewallPolicyNatRuleCollectionActionTypeDNAT,
 * 					},
 * 					Name:               "Example-Nat-Rule-Collection",
 * 					Priority:           100,
 * 					RuleCollectionType: "FirewallPolicyNatRuleCollection",
 * 					Rules: []interface{}{
 * 						network.NatRuleType{
 * 							DestinationAddresses: []string{
 * 								"152.23.32.23",
 * 							},
 * 							DestinationPorts: []string{
 * 								"8080",
 * 							},
 * 							IpProtocols: []network.FirewallPolicyRuleNetworkProtocol{
 * 								network.FirewallPolicyRuleNetworkProtocolTCP,
 * 								network.FirewallPolicyRuleNetworkProtocolUDP,
 * 							},
 * 							Name:     "nat-rule1",
 * 							RuleType: "NatRule",
 * 							SourceAddresses: []string{
 * 								"2.2.2.2",
 * 							},
 * 							SourceIpGroups: []interface{}{},
 * 							TranslatedFqdn: "internalhttp.server.net",
 * 							TranslatedPort: "8080",
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroup;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallPolicyRuleCollectionGroup = new FirewallPolicyRuleCollectionGroup("firewallPolicyRuleCollectionGroup", FirewallPolicyRuleCollectionGroupArgs.builder()
 *             .firewallPolicyName("firewallPolicy")
 *             .priority(100)
 *             .resourceGroupName("rg1")
 *             .ruleCollectionGroupName("ruleCollectionGroup1")
 *             .ruleCollections(FirewallPolicyNatRuleCollectionArgs.builder()
 *                 .action(FirewallPolicyNatRuleCollectionActionArgs.builder()
 *                     .type("DNAT")
 *                     .build())
 *                 .name("Example-Nat-Rule-Collection")
 *                 .priority(100)
 *                 .ruleCollectionType("FirewallPolicyNatRuleCollection")
 *                 .rules(NatRuleArgs.builder()
 *                     .destinationAddresses("152.23.32.23")
 *                     .destinationPorts("8080")
 *                     .ipProtocols(
 *                         "TCP",
 *                         "UDP")
 *                     .name("nat-rule1")
 *                     .ruleType("NatRule")
 *                     .sourceAddresses("2.2.2.2")
 *                     .sourceIpGroups()
 *                     .translatedFqdn("internalhttp.server.net")
 *                     .translatedPort("8080")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create FirewallPolicyRuleCollectionGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallPolicyRuleCollectionGroup = new AzureNative.Network.FirewallPolicyRuleCollectionGroup("firewallPolicyRuleCollectionGroup", new()
 *     {
 *         FirewallPolicyName = "firewallPolicy",
 *         Priority = 100,
 *         ResourceGroupName = "rg1",
 *         RuleCollectionGroupName = "ruleCollectionGroup1",
 *         RuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.FirewallPolicyFilterRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.FirewallPolicyFilterRuleCollectionActionArgs
 *                 {
 *                     Type = AzureNative.Network.FirewallPolicyFilterRuleCollectionActionType.Deny,
 *                 },
 *                 Name = "Example-Filter-Rule-Collection",
 *                 Priority = 100,
 *                 RuleCollectionType = "FirewallPolicyFilterRuleCollection",
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.NetworkRuleArgs
 *                     {
 *                         DestinationAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "*",
 *                         },
 *                         IpProtocols = new[]
 *                         {
 *                             AzureNative.Network.FirewallPolicyRuleNetworkProtocol.TCP,
 *                         },
 *                         Name = "network-rule1",
 *                         RuleType = "NetworkRule",
 *                         SourceAddresses = new[]
 *                         {
 *                             "10.1.25.0/24",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFirewallPolicyRuleCollectionGroup(ctx, "firewallPolicyRuleCollectionGroup", &network.FirewallPolicyRuleCollectionGroupArgs{
 * 			FirewallPolicyName:      pulumi.String("firewallPolicy"),
 * 			Priority:                pulumi.Int(100),
 * 			ResourceGroupName:       pulumi.String("rg1"),
 * 			RuleCollectionGroupName: pulumi.String("ruleCollectionGroup1"),
 * 			RuleCollections: pulumi.Array{
 * 				network.FirewallPolicyFilterRuleCollection{
 * 					Action: network.FirewallPolicyFilterRuleCollectionAction{
 * 						Type: network.FirewallPolicyFilterRuleCollectionActionTypeDeny,
 * 					},
 * 					Name:               "Example-Filter-Rule-Collection",
 * 					Priority:           100,
 * 					RuleCollectionType: "FirewallPolicyFilterRuleCollection",
 * 					Rules: []interface{}{
 * 						network.NetworkRule{
 * 							DestinationAddresses: []string{
 * 								"*",
 * 							},
 * 							DestinationPorts: []string{
 * 								"*",
 * 							},
 * 							IpProtocols: []network.FirewallPolicyRuleNetworkProtocol{
 * 								network.FirewallPolicyRuleNetworkProtocolTCP,
 * 							},
 * 							Name:     "network-rule1",
 * 							RuleType: "NetworkRule",
 * 							SourceAddresses: []string{
 * 								"10.1.25.0/24",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroup;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallPolicyRuleCollectionGroup = new FirewallPolicyRuleCollectionGroup("firewallPolicyRuleCollectionGroup", FirewallPolicyRuleCollectionGroupArgs.builder()
 *             .firewallPolicyName("firewallPolicy")
 *             .priority(100)
 *             .resourceGroupName("rg1")
 *             .ruleCollectionGroupName("ruleCollectionGroup1")
 *             .ruleCollections(FirewallPolicyFilterRuleCollectionArgs.builder()
 *                 .action(FirewallPolicyFilterRuleCollectionActionArgs.builder()
 *                     .type("Deny")
 *                     .build())
 *                 .name("Example-Filter-Rule-Collection")
 *                 .priority(100)
 *                 .ruleCollectionType("FirewallPolicyFilterRuleCollection")
 *                 .rules(NetworkRuleArgs.builder()
 *                     .destinationAddresses("*")
 *                     .destinationPorts("*")
 *                     .ipProtocols("TCP")
 *                     .name("network-rule1")
 *                     .ruleType("NetworkRule")
 *                     .sourceAddresses("10.1.25.0/24")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create FirewallPolicyRuleCollectionGroup With IpGroups
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallPolicyRuleCollectionGroup = new AzureNative.Network.FirewallPolicyRuleCollectionGroup("firewallPolicyRuleCollectionGroup", new()
 *     {
 *         FirewallPolicyName = "firewallPolicy",
 *         Priority = 110,
 *         ResourceGroupName = "rg1",
 *         RuleCollectionGroupName = "ruleCollectionGroup1",
 *         RuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.FirewallPolicyFilterRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.FirewallPolicyFilterRuleCollectionActionArgs
 *                 {
 *                     Type = AzureNative.Network.FirewallPolicyFilterRuleCollectionActionType.Deny,
 *                 },
 *                 Name = "Example-Filter-Rule-Collection",
 *                 RuleCollectionType = "FirewallPolicyFilterRuleCollection",
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.NetworkRuleArgs
 *                     {
 *                         DestinationIpGroups = new[]
 *                         {
 *                             "/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups2",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "*",
 *                         },
 *                         IpProtocols = new[]
 *                         {
 *                             AzureNative.Network.FirewallPolicyRuleNetworkProtocol.TCP,
 *                         },
 *                         Name = "network-1",
 *                         RuleType = "NetworkRule",
 *                         SourceIpGroups = new[]
 *                         {
 *                             "/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups1",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFirewallPolicyRuleCollectionGroup(ctx, "firewallPolicyRuleCollectionGroup", &network.FirewallPolicyRuleCollectionGroupArgs{
 * 			FirewallPolicyName:      pulumi.String("firewallPolicy"),
 * 			Priority:                pulumi.Int(110),
 * 			ResourceGroupName:       pulumi.String("rg1"),
 * 			RuleCollectionGroupName: pulumi.String("ruleCollectionGroup1"),
 * 			RuleCollections: pulumi.Array{
 * 				network.FirewallPolicyFilterRuleCollection{
 * 					Action: network.FirewallPolicyFilterRuleCollectionAction{
 * 						Type: network.FirewallPolicyFilterRuleCollectionActionTypeDeny,
 * 					},
 * 					Name:               "Example-Filter-Rule-Collection",
 * 					RuleCollectionType: "FirewallPolicyFilterRuleCollection",
 * 					Rules: []interface{}{
 * 						network.NetworkRule{
 * 							DestinationIpGroups: []string{
 * 								"/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups2",
 * 							},
 * 							DestinationPorts: []string{
 * 								"*",
 * 							},
 * 							IpProtocols: []network.FirewallPolicyRuleNetworkProtocol{
 * 								network.FirewallPolicyRuleNetworkProtocolTCP,
 * 							},
 * 							Name:     "network-1",
 * 							RuleType: "NetworkRule",
 * 							SourceIpGroups: []string{
 * 								"/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups1",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroup;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallPolicyRuleCollectionGroup = new FirewallPolicyRuleCollectionGroup("firewallPolicyRuleCollectionGroup", FirewallPolicyRuleCollectionGroupArgs.builder()
 *             .firewallPolicyName("firewallPolicy")
 *             .priority(110)
 *             .resourceGroupName("rg1")
 *             .ruleCollectionGroupName("ruleCollectionGroup1")
 *             .ruleCollections(FirewallPolicyFilterRuleCollectionArgs.builder()
 *                 .action(FirewallPolicyFilterRuleCollectionActionArgs.builder()
 *                     .type("Deny")
 *                     .build())
 *                 .name("Example-Filter-Rule-Collection")
 *                 .ruleCollectionType("FirewallPolicyFilterRuleCollection")
 *                 .rules(NetworkRuleArgs.builder()
 *                     .destinationIpGroups("/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups2")
 *                     .destinationPorts("*")
 *                     .ipProtocols("TCP")
 *                     .name("network-1")
 *                     .ruleType("NetworkRule")
 *                     .sourceIpGroups("/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups1")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create FirewallPolicyRuleCollectionGroup With Web Categories
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallPolicyRuleCollectionGroup = new AzureNative.Network.FirewallPolicyRuleCollectionGroup("firewallPolicyRuleCollectionGroup", new()
 *     {
 *         FirewallPolicyName = "firewallPolicy",
 *         Priority = 110,
 *         ResourceGroupName = "rg1",
 *         RuleCollectionGroupName = "ruleCollectionGroup1",
 *         RuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.FirewallPolicyFilterRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.FirewallPolicyFilterRuleCollectionActionArgs
 *                 {
 *                     Type = AzureNative.Network.FirewallPolicyFilterRuleCollectionActionType.Deny,
 *                 },
 *                 Name = "Example-Filter-Rule-Collection",
 *                 RuleCollectionType = "FirewallPolicyFilterRuleCollection",
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.ApplicationRuleArgs
 *                     {
 *                         Description = "Deny inbound rule",
 *                         Name = "rule1",
 *                         Protocols = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.FirewallPolicyRuleApplicationProtocolArgs
 *                             {
 *                                 Port = 443,
 *                                 ProtocolType = AzureNative.Network.FirewallPolicyRuleApplicationProtocolType.Https,
 *                             },
 *                         },
 *                         RuleType = "ApplicationRule",
 *                         SourceAddresses = new[]
 *                         {
 *                             "216.58.216.164",
 *                             "10.0.0.0/24",
 *                         },
 *                         WebCategories = new[]
 *                         {
 *                             "Hacking",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFirewallPolicyRuleCollectionGroup(ctx, "firewallPolicyRuleCollectionGroup", &network.FirewallPolicyRuleCollectionGroupArgs{
 * 			FirewallPolicyName:      pulumi.String("firewallPolicy"),
 * 			Priority:                pulumi.Int(110),
 * 			ResourceGroupName:       pulumi.String("rg1"),
 * 			RuleCollectionGroupName: pulumi.String("ruleCollectionGroup1"),
 * 			RuleCollections: pulumi.Array{
 * 				network.FirewallPolicyFilterRuleCollection{
 * 					Action: network.FirewallPolicyFilterRuleCollectionAction{
 * 						Type: network.FirewallPolicyFilterRuleCollectionActionTypeDeny,
 * 					},
 * 					Name:               "Example-Filter-Rule-Collection",
 * 					RuleCollectionType: "FirewallPolicyFilterRuleCollection",
 * 					Rules: []interface{}{
 * 						network.ApplicationRule{
 * 							Description: "Deny inbound rule",
 * 							Name:        "rule1",
 * 							Protocols: []network.FirewallPolicyRuleApplicationProtocol{
 * 								{
 * 									Port:         443,
 * 									ProtocolType: network.FirewallPolicyRuleApplicationProtocolTypeHttps,
 * 								},
 * 							},
 * 							RuleType: "ApplicationRule",
 * 							SourceAddresses: []string{
 * 								"216.58.216.164",
 * 								"10.0.0.0/24",
 * 							},
 * 							WebCategories: []string{
 * 								"Hacking",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroup;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallPolicyRuleCollectionGroup = new FirewallPolicyRuleCollectionGroup("firewallPolicyRuleCollectionGroup", FirewallPolicyRuleCollectionGroupArgs.builder()
 *             .firewallPolicyName("firewallPolicy")
 *             .priority(110)
 *             .resourceGroupName("rg1")
 *             .ruleCollectionGroupName("ruleCollectionGroup1")
 *             .ruleCollections(FirewallPolicyFilterRuleCollectionArgs.builder()
 *                 .action(FirewallPolicyFilterRuleCollectionActionArgs.builder()
 *                     .type("Deny")
 *                     .build())
 *                 .name("Example-Filter-Rule-Collection")
 *                 .ruleCollectionType("FirewallPolicyFilterRuleCollection")
 *                 .rules(ApplicationRuleArgs.builder()
 *                     .description("Deny inbound rule")
 *                     .name("rule1")
 *                     .protocols(FirewallPolicyRuleApplicationProtocolArgs.builder()
 *                         .port(443)
 *                         .protocolType("Https")
 *                         .build())
 *                     .ruleType("ApplicationRule")
 *                     .sourceAddresses(
 *                         "216.58.216.164",
 *                         "10.0.0.0/24")
 *                     .webCategories("Hacking")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create FirewallPolicyRuleCollectionGroup With http header to insert
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallPolicyRuleCollectionGroup = new AzureNative.Network.FirewallPolicyRuleCollectionGroup("firewallPolicyRuleCollectionGroup", new()
 *     {
 *         FirewallPolicyName = "firewallPolicy",
 *         Priority = 110,
 *         ResourceGroupName = "rg1",
 *         RuleCollectionGroupName = "ruleCollectionGroup1",
 *         RuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.FirewallPolicyFilterRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.FirewallPolicyFilterRuleCollectionActionArgs
 *                 {
 *                     Type = AzureNative.Network.FirewallPolicyFilterRuleCollectionActionType.Allow,
 *                 },
 *                 Name = "Example-Filter-Rule-Collection",
 *                 RuleCollectionType = "FirewallPolicyFilterRuleCollection",
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.ApplicationRuleArgs
 *                     {
 *                         Description = "Insert HTTP header rule",
 *                         FqdnTags = new[]
 *                         {
 *                             "WindowsVirtualDesktop",
 *                         },
 *                         HttpHeadersToInsert = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.FirewallPolicyHttpHeaderToInsertArgs
 *                             {
 *                                 HeaderName = "Restrict-Access-To-Tenants",
 *                                 HeaderValue = "contoso.com,fabrikam.onmicrosoft.com",
 *                             },
 *                         },
 *                         Name = "rule1",
 *                         Protocols = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.FirewallPolicyRuleApplicationProtocolArgs
 *                             {
 *                                 Port = 80,
 *                                 ProtocolType = AzureNative.Network.FirewallPolicyRuleApplicationProtocolType.Http,
 *                             },
 *                         },
 *                         RuleType = "ApplicationRule",
 *                         SourceAddresses = new[]
 *                         {
 *                             "216.58.216.164",
 *                             "10.0.0.0/24",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFirewallPolicyRuleCollectionGroup(ctx, "firewallPolicyRuleCollectionGroup", &network.FirewallPolicyRuleCollectionGroupArgs{
 * 			FirewallPolicyName:      pulumi.String("firewallPolicy"),
 * 			Priority:                pulumi.Int(110),
 * 			ResourceGroupName:       pulumi.String("rg1"),
 * 			RuleCollectionGroupName: pulumi.String("ruleCollectionGroup1"),
 * 			RuleCollections: pulumi.Array{
 * 				network.FirewallPolicyFilterRuleCollection{
 * 					Action: network.FirewallPolicyFilterRuleCollectionAction{
 * 						Type: network.FirewallPolicyFilterRuleCollectionActionTypeAllow,
 * 					},
 * 					Name:               "Example-Filter-Rule-Collection",
 * 					RuleCollectionType: "FirewallPolicyFilterRuleCollection",
 * 					Rules: []interface{}{
 * 						network.ApplicationRule{
 * 							Description: "Insert HTTP header rule",
 * 							FqdnTags: []string{
 * 								"WindowsVirtualDesktop",
 * 							},
 * 							HttpHeadersToInsert: []network.FirewallPolicyHttpHeaderToInsert{
 * 								{
 * 									HeaderName:  "Restrict-Access-To-Tenants",
 * 									HeaderValue: "contoso.com,fabrikam.onmicrosoft.com",
 * 								},
 * 							},
 * 							Name: "rule1",
 * 							Protocols: []network.FirewallPolicyRuleApplicationProtocol{
 * 								{
 * 									Port:         80,
 * 									ProtocolType: network.FirewallPolicyRuleApplicationProtocolTypeHttp,
 * 								},
 * 							},
 * 							RuleType: "ApplicationRule",
 * 							SourceAddresses: []string{
 * 								"216.58.216.164",
 * 								"10.0.0.0/24",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroup;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallPolicyRuleCollectionGroup = new FirewallPolicyRuleCollectionGroup("firewallPolicyRuleCollectionGroup", FirewallPolicyRuleCollectionGroupArgs.builder()
 *             .firewallPolicyName("firewallPolicy")
 *             .priority(110)
 *             .resourceGroupName("rg1")
 *             .ruleCollectionGroupName("ruleCollectionGroup1")
 *             .ruleCollections(FirewallPolicyFilterRuleCollectionArgs.builder()
 *                 .action(FirewallPolicyFilterRuleCollectionActionArgs.builder()
 *                     .type("Allow")
 *                     .build())
 *                 .name("Example-Filter-Rule-Collection")
 *                 .ruleCollectionType("FirewallPolicyFilterRuleCollection")
 *                 .rules(ApplicationRuleArgs.builder()
 *                     .description("Insert HTTP header rule")
 *                     .fqdnTags("WindowsVirtualDesktop")
 *                     .httpHeadersToInsert(FirewallPolicyHttpHeaderToInsertArgs.builder()
 *                         .headerName("Restrict-Access-To-Tenants")
 *                         .headerValue("contoso.com,fabrikam.onmicrosoft.com")
 *                         .build())
 *                     .name("rule1")
 *                     .protocols(FirewallPolicyRuleApplicationProtocolArgs.builder()
 *                         .port(80)
 *                         .protocolType("Http")
 *                         .build())
 *                     .ruleType("ApplicationRule")
 *                     .sourceAddresses(
 *                         "216.58.216.164",
 *                         "10.0.0.0/24")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:FirewallPolicyRuleCollectionGroup ruleCollectionGroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleCollectionGroups/{ruleCollectionGroupName}
 * ```
 */
public class FirewallPolicyRuleCollectionGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroup,
) : KotlinCustomResource(javaResource, FirewallPolicyRuleCollectionGroupMapper) {
    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Priority of the Firewall Policy Rule Collection Group resource.
     */
    public val priority: Output<Int>?
        get() = javaResource.priority().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning state of the firewall policy rule collection group resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Group of Firewall Policy rule collections.
     */
    public val ruleCollections:
        Output<List<Either<FirewallPolicyFilterRuleCollectionResponse, FirewallPolicyNatRuleCollectionResponse>>>?
        get() = javaResource.ruleCollections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.transform(
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyFilterRuleCollectionResponse.Companion.toKotlin(args0)
                            })
                        },
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyNatRuleCollectionResponse.Companion.toKotlin(args0)
                            })
                        },
                    )
                })
            }).orElse(null)
        })

    /**
     * Rule Group type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FirewallPolicyRuleCollectionGroupMapper :
    ResourceMapper<FirewallPolicyRuleCollectionGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroup::class == javaResource::class

    override fun map(javaResource: Resource): FirewallPolicyRuleCollectionGroup =
        FirewallPolicyRuleCollectionGroup(
            javaResource as
                com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroup,
        )
}

/**
 * @see [FirewallPolicyRuleCollectionGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FirewallPolicyRuleCollectionGroup].
 */
public suspend fun firewallPolicyRuleCollectionGroup(
    name: String,
    block: suspend FirewallPolicyRuleCollectionGroupResourceBuilder.() -> Unit,
):
    FirewallPolicyRuleCollectionGroup {
    val builder = FirewallPolicyRuleCollectionGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FirewallPolicyRuleCollectionGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun firewallPolicyRuleCollectionGroup(name: String): FirewallPolicyRuleCollectionGroup {
    val builder = FirewallPolicyRuleCollectionGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
