@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupDraftArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicyFilterRuleCollectionArgs
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicyNatRuleCollectionArgs
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Rule Collection Group resource.
 * Azure REST API version: 2023-11-01.
 * ## Example Usage
 * ### create or update rule collection group draft
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallPolicyRuleCollectionGroupDraft = new AzureNative.Network.FirewallPolicyRuleCollectionGroupDraft("firewallPolicyRuleCollectionGroupDraft", new()
 *     {
 *         FirewallPolicyName = "firewallPolicy",
 *         Priority = 100,
 *         ResourceGroupName = "rg1",
 *         RuleCollectionGroupName = "ruleCollectionGroup1",
 *         RuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.FirewallPolicyFilterRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.FirewallPolicyFilterRuleCollectionActionArgs
 *                 {
 *                     Type = AzureNative.Network.FirewallPolicyFilterRuleCollectionActionType.Deny,
 *                 },
 *                 Name = "Example-Filter-Rule-Collection",
 *                 Priority = 100,
 *                 RuleCollectionType = "FirewallPolicyFilterRuleCollection",
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.NetworkRuleArgs
 *                     {
 *                         DestinationAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "*",
 *                         },
 *                         IpProtocols = new[]
 *                         {
 *                             AzureNative.Network.FirewallPolicyRuleNetworkProtocol.TCP,
 *                         },
 *                         Name = "network-rule1",
 *                         RuleType = "NetworkRule",
 *                         SourceAddresses = new[]
 *                         {
 *                             "10.1.25.0/24",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFirewallPolicyRuleCollectionGroupDraft(ctx, "firewallPolicyRuleCollectionGroupDraft", &network.FirewallPolicyRuleCollectionGroupDraftArgs{
 * 			FirewallPolicyName:      pulumi.String("firewallPolicy"),
 * 			Priority:                pulumi.Int(100),
 * 			ResourceGroupName:       pulumi.String("rg1"),
 * 			RuleCollectionGroupName: pulumi.String("ruleCollectionGroup1"),
 * 			RuleCollections: pulumi.Array{
 * 				network.FirewallPolicyFilterRuleCollection{
 * 					Action: network.FirewallPolicyFilterRuleCollectionAction{
 * 						Type: network.FirewallPolicyFilterRuleCollectionActionTypeDeny,
 * 					},
 * 					Name:               "Example-Filter-Rule-Collection",
 * 					Priority:           100,
 * 					RuleCollectionType: "FirewallPolicyFilterRuleCollection",
 * 					Rules: []interface{}{
 * 						network.NetworkRule{
 * 							DestinationAddresses: []string{
 * 								"*",
 * 							},
 * 							DestinationPorts: []string{
 * 								"*",
 * 							},
 * 							IpProtocols: []network.FirewallPolicyRuleNetworkProtocol{
 * 								network.FirewallPolicyRuleNetworkProtocolTCP,
 * 							},
 * 							Name:     "network-rule1",
 * 							RuleType: "NetworkRule",
 * 							SourceAddresses: []string{
 * 								"10.1.25.0/24",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupDraft;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupDraftArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallPolicyRuleCollectionGroupDraft = new FirewallPolicyRuleCollectionGroupDraft("firewallPolicyRuleCollectionGroupDraft", FirewallPolicyRuleCollectionGroupDraftArgs.builder()
 *             .firewallPolicyName("firewallPolicy")
 *             .priority(100)
 *             .resourceGroupName("rg1")
 *             .ruleCollectionGroupName("ruleCollectionGroup1")
 *             .ruleCollections(FirewallPolicyFilterRuleCollectionArgs.builder()
 *                 .action(FirewallPolicyFilterRuleCollectionActionArgs.builder()
 *                     .type("Deny")
 *                     .build())
 *                 .name("Example-Filter-Rule-Collection")
 *                 .priority(100)
 *                 .ruleCollectionType("FirewallPolicyFilterRuleCollection")
 *                 .rules(NetworkRuleArgs.builder()
 *                     .destinationAddresses("*")
 *                     .destinationPorts("*")
 *                     .ipProtocols("TCP")
 *                     .name("network-rule1")
 *                     .ruleType("NetworkRule")
 *                     .sourceAddresses("10.1.25.0/24")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:FirewallPolicyRuleCollectionGroupDraft ruleCollectionGroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleCollectionGroups/{ruleCollectionGroupName}/ruleCollectionGroupDrafts/default
 * ```
 * @property firewallPolicyName The name of the Firewall Policy.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property priority Priority of the Firewall Policy Rule Collection Group resource.
 * @property resourceGroupName The name of the resource group.
 * @property ruleCollectionGroupName The name of the FirewallPolicyRuleCollectionGroup.
 * @property ruleCollections Group of Firewall Policy rule collections.
 */
public data class FirewallPolicyRuleCollectionGroupDraftArgs(
    public val firewallPolicyName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleCollectionGroupName: Output<String>? = null,
    public val ruleCollections:
    Output<List<Either<FirewallPolicyFilterRuleCollectionArgs, FirewallPolicyNatRuleCollectionArgs>>>? =
        null,
) : ConvertibleToJava<com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupDraftArgs> {
    override fun toJava(): com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupDraftArgs =
        com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupDraftArgs.builder()
            .firewallPolicyName(firewallPolicyName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleCollectionGroupName(ruleCollectionGroupName?.applyValue({ args0 -> args0 }))
            .ruleCollections(
                ruleCollections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                            args0.let({ args0 ->
                                args0.toJava()
                            })
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirewallPolicyRuleCollectionGroupDraftArgs].
 */
@PulumiTagMarker
public class FirewallPolicyRuleCollectionGroupDraftArgsBuilder internal constructor() {
    private var firewallPolicyName: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleCollectionGroupName: Output<String>? = null

    private var ruleCollections:
        Output<List<Either<FirewallPolicyFilterRuleCollectionArgs, FirewallPolicyNatRuleCollectionArgs>>>? =
        null

    /**
     * @param value The name of the Firewall Policy.
     */
    @JvmName("kjsdgbgvuhhetnjy")
    public suspend fun firewallPolicyName(`value`: Output<String>) {
        this.firewallPolicyName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("tgetbrmqjhgmogwn")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("soytkgaajyhitixx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Priority of the Firewall Policy Rule Collection Group resource.
     */
    @JvmName("kpcfrxsgworvgrnl")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hfetmtcpvrkhpbkn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the FirewallPolicyRuleCollectionGroup.
     */
    @JvmName("vwfmbwtvksvtbysb")
    public suspend fun ruleCollectionGroupName(`value`: Output<String>) {
        this.ruleCollectionGroupName = value
    }

    /**
     * @param value Group of Firewall Policy rule collections.
     */
    @JvmName("mtluxvdcmkknbutp")
    public suspend
    fun ruleCollections(`value`: Output<List<Either<FirewallPolicyFilterRuleCollectionArgs, FirewallPolicyNatRuleCollectionArgs>>>) {
        this.ruleCollections = value
    }

    @JvmName("skcuhvttkjfkqdad")
    public suspend fun ruleCollections(
        vararg
        values: Output<Either<FirewallPolicyFilterRuleCollectionArgs, FirewallPolicyNatRuleCollectionArgs>>,
    ) {
        this.ruleCollections = Output.all(values.asList())
    }

    /**
     * @param values Group of Firewall Policy rule collections.
     */
    @JvmName("ovxyokjsmguuqsxp")
    public suspend
    fun ruleCollections(values: List<Output<Either<FirewallPolicyFilterRuleCollectionArgs, FirewallPolicyNatRuleCollectionArgs>>>) {
        this.ruleCollections = Output.all(values)
    }

    /**
     * @param value The name of the Firewall Policy.
     */
    @JvmName("dyjlqpqlrqhdwfrl")
    public suspend fun firewallPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallPolicyName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("nxnghyrwacbqrgcr")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("tofkgussjytxyrnn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Priority of the Firewall Policy Rule Collection Group resource.
     */
    @JvmName("xvykcoxnsmkvxxhh")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("kanobkxmwejbrtgc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the FirewallPolicyRuleCollectionGroup.
     */
    @JvmName("njggtgkrhrwggljq")
    public suspend fun ruleCollectionGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleCollectionGroupName = mapped
    }

    /**
     * @param value Group of Firewall Policy rule collections.
     */
    @JvmName("blgqtysfojcowerm")
    public suspend
    fun ruleCollections(`value`: List<Either<FirewallPolicyFilterRuleCollectionArgs, FirewallPolicyNatRuleCollectionArgs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleCollections = mapped
    }

    /**
     * @param values Group of Firewall Policy rule collections.
     */
    @JvmName("culyqrpcxauqwtcq")
    public suspend fun ruleCollections(
        vararg
        values: Either<FirewallPolicyFilterRuleCollectionArgs, FirewallPolicyNatRuleCollectionArgs>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleCollections = mapped
    }

    internal fun build(): FirewallPolicyRuleCollectionGroupDraftArgs =
        FirewallPolicyRuleCollectionGroupDraftArgs(
            firewallPolicyName = firewallPolicyName,
            id = id,
            name = name,
            priority = priority,
            resourceGroupName = resourceGroupName,
            ruleCollectionGroupName = ruleCollectionGroupName,
            ruleCollections = ruleCollections,
        )
}
