@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyFilterRuleResponse
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyNatRuleResponse
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [FirewallPolicyRuleGroup].
 */
@PulumiTagMarker
public class FirewallPolicyRuleGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FirewallPolicyRuleGroupArgs = FirewallPolicyRuleGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FirewallPolicyRuleGroupArgsBuilder.() -> Unit) {
        val builder = FirewallPolicyRuleGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FirewallPolicyRuleGroup {
        val builtJavaResource =
            com.pulumi.azurenative.network.FirewallPolicyRuleGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FirewallPolicyRuleGroup(builtJavaResource)
    }
}

/**
 * Rule Group resource.
 * Azure REST API version: 2020-04-01. Prior API version in Azure Native 1.x: 2020-04-01.
 * ## Example Usage
 * ### Create FirewallPolicyRuleGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallPolicyRuleGroup = new AzureNative.Network.FirewallPolicyRuleGroup("firewallPolicyRuleGroup", new()
 *     {
 *         FirewallPolicyName = "firewallPolicy",
 *         Priority = 110,
 *         ResourceGroupName = "rg1",
 *         RuleGroupName = "ruleGroup1",
 *         Rules = new[]
 *         {
 *             new AzureNative.Network.Inputs.FirewallPolicyFilterRuleArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.FirewallPolicyFilterRuleActionArgs
 *                 {
 *                     Type = AzureNative.Network.FirewallPolicyFilterRuleActionType.Deny,
 *                 },
 *                 Name = "Example-Filter-Rule",
 *                 RuleConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.NetworkRuleConditionArgs
 *                     {
 *                         DestinationAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "*",
 *                         },
 *                         IpProtocols = new[]
 *                         {
 *                             AzureNative.Network.FirewallPolicyRuleConditionNetworkProtocol.TCP,
 *                         },
 *                         Name = "network-condition1",
 *                         RuleConditionType = "NetworkRuleCondition",
 *                         SourceAddresses = new[]
 *                         {
 *                             "10.1.25.0/24",
 *                         },
 *                     },
 *                 },
 *                 RuleType = "FirewallPolicyFilterRule",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFirewallPolicyRuleGroup(ctx, "firewallPolicyRuleGroup", &network.FirewallPolicyRuleGroupArgs{
 * 			FirewallPolicyName: pulumi.String("firewallPolicy"),
 * 			Priority:           pulumi.Int(110),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			RuleGroupName:      pulumi.String("ruleGroup1"),
 * 			Rules: pulumi.Array{
 * 				network.FirewallPolicyFilterRule{
 * 					Action: network.FirewallPolicyFilterRuleAction{
 * 						Type: network.FirewallPolicyFilterRuleActionTypeDeny,
 * 					},
 * 					Name: "Example-Filter-Rule",
 * 					RuleConditions: []interface{}{
 * 						network.NetworkRuleCondition{
 * 							DestinationAddresses: []string{
 * 								"*",
 * 							},
 * 							DestinationPorts: []string{
 * 								"*",
 * 							},
 * 							IpProtocols: []network.FirewallPolicyRuleConditionNetworkProtocol{
 * 								network.FirewallPolicyRuleConditionNetworkProtocolTCP,
 * 							},
 * 							Name:              "network-condition1",
 * 							RuleConditionType: "NetworkRuleCondition",
 * 							SourceAddresses: []string{
 * 								"10.1.25.0/24",
 * 							},
 * 						},
 * 					},
 * 					RuleType: "FirewallPolicyFilterRule",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleGroup;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallPolicyRuleGroup = new FirewallPolicyRuleGroup("firewallPolicyRuleGroup", FirewallPolicyRuleGroupArgs.builder()
 *             .firewallPolicyName("firewallPolicy")
 *             .priority(110)
 *             .resourceGroupName("rg1")
 *             .ruleGroupName("ruleGroup1")
 *             .rules(FirewallPolicyFilterRuleArgs.builder()
 *                 .action(FirewallPolicyFilterRuleActionArgs.builder()
 *                     .type("Deny")
 *                     .build())
 *                 .name("Example-Filter-Rule")
 *                 .ruleConditions(NetworkRuleConditionArgs.builder()
 *                     .destinationAddresses("*")
 *                     .destinationPorts("*")
 *                     .ipProtocols("TCP")
 *                     .name("network-condition1")
 *                     .ruleConditionType("NetworkRuleCondition")
 *                     .sourceAddresses("10.1.25.0/24")
 *                     .build())
 *                 .ruleType("FirewallPolicyFilterRule")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create FirewallPolicyRuleGroup With IpGroups
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallPolicyRuleGroup = new AzureNative.Network.FirewallPolicyRuleGroup("firewallPolicyRuleGroup", new()
 *     {
 *         FirewallPolicyName = "firewallPolicy",
 *         Priority = 110,
 *         ResourceGroupName = "rg1",
 *         RuleGroupName = "ruleGroup1",
 *         Rules = new[]
 *         {
 *             new AzureNative.Network.Inputs.FirewallPolicyFilterRuleArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.FirewallPolicyFilterRuleActionArgs
 *                 {
 *                     Type = AzureNative.Network.FirewallPolicyFilterRuleActionType.Deny,
 *                 },
 *                 Name = "Example-Filter-Rule",
 *                 RuleConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.NetworkRuleConditionArgs
 *                     {
 *                         DestinationIpGroups = new[]
 *                         {
 *                             "/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups2",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "*",
 *                         },
 *                         IpProtocols = new[]
 *                         {
 *                             AzureNative.Network.FirewallPolicyRuleConditionNetworkProtocol.TCP,
 *                         },
 *                         Name = "network-condition1",
 *                         RuleConditionType = "NetworkRuleCondition",
 *                         SourceIpGroups = new[]
 *                         {
 *                             "/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups1",
 *                         },
 *                     },
 *                 },
 *                 RuleType = "FirewallPolicyFilterRule",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFirewallPolicyRuleGroup(ctx, "firewallPolicyRuleGroup", &network.FirewallPolicyRuleGroupArgs{
 * 			FirewallPolicyName: pulumi.String("firewallPolicy"),
 * 			Priority:           pulumi.Int(110),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			RuleGroupName:      pulumi.String("ruleGroup1"),
 * 			Rules: pulumi.Array{
 * 				network.FirewallPolicyFilterRule{
 * 					Action: network.FirewallPolicyFilterRuleAction{
 * 						Type: network.FirewallPolicyFilterRuleActionTypeDeny,
 * 					},
 * 					Name: "Example-Filter-Rule",
 * 					RuleConditions: []interface{}{
 * 						network.NetworkRuleCondition{
 * 							DestinationIpGroups: []string{
 * 								"/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups2",
 * 							},
 * 							DestinationPorts: []string{
 * 								"*",
 * 							},
 * 							IpProtocols: []network.FirewallPolicyRuleConditionNetworkProtocol{
 * 								network.FirewallPolicyRuleConditionNetworkProtocolTCP,
 * 							},
 * 							Name:              "network-condition1",
 * 							RuleConditionType: "NetworkRuleCondition",
 * 							SourceIpGroups: []string{
 * 								"/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups1",
 * 							},
 * 						},
 * 					},
 * 					RuleType: "FirewallPolicyFilterRule",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleGroup;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallPolicyRuleGroup = new FirewallPolicyRuleGroup("firewallPolicyRuleGroup", FirewallPolicyRuleGroupArgs.builder()
 *             .firewallPolicyName("firewallPolicy")
 *             .priority(110)
 *             .resourceGroupName("rg1")
 *             .ruleGroupName("ruleGroup1")
 *             .rules(FirewallPolicyFilterRuleArgs.builder()
 *                 .action(FirewallPolicyFilterRuleActionArgs.builder()
 *                     .type("Deny")
 *                     .build())
 *                 .name("Example-Filter-Rule")
 *                 .ruleConditions(NetworkRuleConditionArgs.builder()
 *                     .destinationIpGroups("/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups2")
 *                     .destinationPorts("*")
 *                     .ipProtocols("TCP")
 *                     .name("network-condition1")
 *                     .ruleConditionType("NetworkRuleCondition")
 *                     .sourceIpGroups("/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups1")
 *                     .build())
 *                 .ruleType("FirewallPolicyFilterRule")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:FirewallPolicyRuleGroup ruleGroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleGroups/{ruleGroupName}
 * ```
 */
public class FirewallPolicyRuleGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.network.FirewallPolicyRuleGroup,
) : KotlinCustomResource(javaResource, FirewallPolicyRuleGroupMapper) {
    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Priority of the Firewall Policy Rule Group resource.
     */
    public val priority: Output<Int>?
        get() = javaResource.priority().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning state of the firewall policy rule group resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Group of Firewall Policy rules.
     */
    public val rules:
        Output<List<Either<FirewallPolicyFilterRuleResponse, FirewallPolicyNatRuleResponse>>>?
        get() = javaResource.rules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.transform(
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyFilterRuleResponse.Companion.toKotlin(args0)
                            })
                        },
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyNatRuleResponse.Companion.toKotlin(args0)
                            })
                        },
                    )
                })
            }).orElse(null)
        })

    /**
     * Rule Group type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FirewallPolicyRuleGroupMapper : ResourceMapper<FirewallPolicyRuleGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.FirewallPolicyRuleGroup::class == javaResource::class

    override fun map(javaResource: Resource): FirewallPolicyRuleGroup =
        FirewallPolicyRuleGroup(
            javaResource as
                com.pulumi.azurenative.network.FirewallPolicyRuleGroup,
        )
}

/**
 * @see [FirewallPolicyRuleGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FirewallPolicyRuleGroup].
 */
public suspend fun firewallPolicyRuleGroup(
    name: String,
    block: suspend FirewallPolicyRuleGroupResourceBuilder.() -> Unit,
): FirewallPolicyRuleGroup {
    val builder = FirewallPolicyRuleGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FirewallPolicyRuleGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun firewallPolicyRuleGroup(name: String): FirewallPolicyRuleGroup {
    val builder = FirewallPolicyRuleGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
