@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.HubRouteTableArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.HubRouteArgs
import com.pulumi.azurenative.network.kotlin.inputs.HubRouteArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * RouteTable resource in a virtual hub.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### RouteTablePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hubRouteTable = new AzureNative.Network.HubRouteTable("hubRouteTable", new()
 *     {
 *         Labels = new[]
 *         {
 *             "label1",
 *             "label2",
 *         },
 *         ResourceGroupName = "rg1",
 *         RouteTableName = "hubRouteTable1",
 *         Routes = new[]
 *         {
 *             new AzureNative.Network.Inputs.HubRouteArgs
 *             {
 *                 DestinationType = "CIDR",
 *                 Destinations = new[]
 *                 {
 *                     "10.0.0.0/8",
 *                     "20.0.0.0/8",
 *                     "30.0.0.0/8",
 *                 },
 *                 Name = "route1",
 *                 NextHop = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azureFirewall1",
 *                 NextHopType = "ResourceId",
 *             },
 *         },
 *         VirtualHubName = "virtualHub1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewHubRouteTable(ctx, "hubRouteTable", &network.HubRouteTableArgs{
 * 			Labels: pulumi.StringArray{
 * 				pulumi.String("label1"),
 * 				pulumi.String("label2"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			RouteTableName:    pulumi.String("hubRouteTable1"),
 * 			Routes: network.HubRouteArray{
 * 				&network.HubRouteArgs{
 * 					DestinationType: pulumi.String("CIDR"),
 * 					Destinations: pulumi.StringArray{
 * 						pulumi.String("10.0.0.0/8"),
 * 						pulumi.String("20.0.0.0/8"),
 * 						pulumi.String("30.0.0.0/8"),
 * 					},
 * 					Name:        pulumi.String("route1"),
 * 					NextHop:     pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azureFirewall1"),
 * 					NextHopType: pulumi.String("ResourceId"),
 * 				},
 * 			},
 * 			VirtualHubName: pulumi.String("virtualHub1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.HubRouteTable;
 * import com.pulumi.azurenative.network.HubRouteTableArgs;
 * import com.pulumi.azurenative.network.inputs.HubRouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hubRouteTable = new HubRouteTable("hubRouteTable", HubRouteTableArgs.builder()
 *             .labels(
 *                 "label1",
 *                 "label2")
 *             .resourceGroupName("rg1")
 *             .routeTableName("hubRouteTable1")
 *             .routes(HubRouteArgs.builder()
 *                 .destinationType("CIDR")
 *                 .destinations(
 *                     "10.0.0.0/8",
 *                     "20.0.0.0/8",
 *                     "30.0.0.0/8")
 *                 .name("route1")
 *                 .nextHop("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azureFirewall1")
 *                 .nextHopType("ResourceId")
 *                 .build())
 *             .virtualHubName("virtualHub1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:HubRouteTable hubRouteTable1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/hubRouteTables/{routeTableName}
 * ```
 * @property id Resource ID.
 * @property labels List of labels associated with this route table.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property resourceGroupName The resource group name of the VirtualHub.
 * @property routeTableName The name of the RouteTable.
 * @property routes List of all routes.
 * @property virtualHubName The name of the VirtualHub.
 */
public data class HubRouteTableArgs(
    public val id: Output<String>? = null,
    public val labels: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routeTableName: Output<String>? = null,
    public val routes: Output<List<HubRouteArgs>>? = null,
    public val virtualHubName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.HubRouteTableArgs> {
    override fun toJava(): com.pulumi.azurenative.network.HubRouteTableArgs =
        com.pulumi.azurenative.network.HubRouteTableArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routeTableName(routeTableName?.applyValue({ args0 -> args0 }))
            .routes(routes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .virtualHubName(virtualHubName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HubRouteTableArgs].
 */
@PulumiTagMarker
public class HubRouteTableArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var labels: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var routeTableName: Output<String>? = null

    private var routes: Output<List<HubRouteArgs>>? = null

    private var virtualHubName: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("nkybjqdviihwewcb")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value List of labels associated with this route table.
     */
    @JvmName("mccqspmgtqfnfpou")
    public suspend fun labels(`value`: Output<List<String>>) {
        this.labels = value
    }

    @JvmName("rhriglliwmtbhvhc")
    public suspend fun labels(vararg values: Output<String>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values List of labels associated with this route table.
     */
    @JvmName("usjqedqsgkapprtr")
    public suspend fun labels(values: List<Output<String>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("jqrgvwhqrkpsyfpa")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource group name of the VirtualHub.
     */
    @JvmName("rijlsyiodxaobqrn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the RouteTable.
     */
    @JvmName("gftnpwklpclsdfks")
    public suspend fun routeTableName(`value`: Output<String>) {
        this.routeTableName = value
    }

    /**
     * @param value List of all routes.
     */
    @JvmName("fgccyclrfwnqypms")
    public suspend fun routes(`value`: Output<List<HubRouteArgs>>) {
        this.routes = value
    }

    @JvmName("ykdysvlytnurders")
    public suspend fun routes(vararg values: Output<HubRouteArgs>) {
        this.routes = Output.all(values.asList())
    }

    /**
     * @param values List of all routes.
     */
    @JvmName("cyugxultwechtbrt")
    public suspend fun routes(values: List<Output<HubRouteArgs>>) {
        this.routes = Output.all(values)
    }

    /**
     * @param value The name of the VirtualHub.
     */
    @JvmName("kjarqnmcowhjrxnb")
    public suspend fun virtualHubName(`value`: Output<String>) {
        this.virtualHubName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("qffwymlcajfpcdxh")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value List of labels associated with this route table.
     */
    @JvmName("tjdigysrudyuochv")
    public suspend fun labels(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param values List of labels associated with this route table.
     */
    @JvmName("cxeyjiqkmbjyhads")
    public suspend fun labels(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("ycrkfetmjlmcdxny")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource group name of the VirtualHub.
     */
    @JvmName("jcbggdqvadjesshv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the RouteTable.
     */
    @JvmName("bfkyvvyjfrehbmyq")
    public suspend fun routeTableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTableName = mapped
    }

    /**
     * @param value List of all routes.
     */
    @JvmName("kqoeofmsyhxbarbn")
    public suspend fun routes(`value`: List<HubRouteArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param argument List of all routes.
     */
    @JvmName("ihuduxwpubjrunie")
    public suspend fun routes(argument: List<suspend HubRouteArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { HubRouteArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument List of all routes.
     */
    @JvmName("rauekwnkblvyrmrh")
    public suspend fun routes(vararg argument: suspend HubRouteArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { HubRouteArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument List of all routes.
     */
    @JvmName("awgjtbcwjeoggwjo")
    public suspend fun routes(argument: suspend HubRouteArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HubRouteArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param values List of all routes.
     */
    @JvmName("jqammftglvihtgck")
    public suspend fun routes(vararg values: HubRouteArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param value The name of the VirtualHub.
     */
    @JvmName("sojqucqoydopbxid")
    public suspend fun virtualHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualHubName = mapped
    }

    internal fun build(): HubRouteTableArgs = HubRouteTableArgs(
        id = id,
        labels = labels,
        name = name,
        resourceGroupName = resourceGroupName,
        routeTableName = routeTableName,
        routes = routes,
        virtualHubName = virtualHubName,
    )
}
