@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.RoutingConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.network.kotlin.outputs.RoutingConfigurationResponse.Companion.toKotlin as routingConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin

/**
 * Builder for [HubVirtualNetworkConnection].
 */
@PulumiTagMarker
public class HubVirtualNetworkConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HubVirtualNetworkConnectionArgs = HubVirtualNetworkConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HubVirtualNetworkConnectionArgsBuilder.() -> Unit) {
        val builder = HubVirtualNetworkConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HubVirtualNetworkConnection {
        val builtJavaResource =
            com.pulumi.azurenative.network.HubVirtualNetworkConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HubVirtualNetworkConnection(builtJavaResource)
    }
}

/**
 * HubVirtualNetworkConnection Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### HubVirtualNetworkConnectionPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hubVirtualNetworkConnection = new AzureNative.Network.HubVirtualNetworkConnection("hubVirtualNetworkConnection", new()
 *     {
 *         ConnectionName = "connection1",
 *         EnableInternetSecurity = false,
 *         RemoteVirtualNetwork = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/SpokeVnet1",
 *         },
 *         ResourceGroupName = "rg1",
 *         RoutingConfiguration = new AzureNative.Network.Inputs.RoutingConfigurationArgs
 *         {
 *             AssociatedRouteTable = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1",
 *             },
 *             InboundRouteMap = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap1",
 *             },
 *             OutboundRouteMap = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap2",
 *             },
 *             PropagatedRouteTables = new AzureNative.Network.Inputs.PropagatedRouteTableArgs
 *             {
 *                 Ids = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1",
 *                     },
 *                 },
 *                 Labels = new[]
 *                 {
 *                     "label1",
 *                     "label2",
 *                 },
 *             },
 *             VnetRoutes = new AzureNative.Network.Inputs.VnetRouteArgs
 *             {
 *                 StaticRoutes = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.StaticRouteArgs
 *                     {
 *                         AddressPrefixes = new[]
 *                         {
 *                             "10.1.0.0/16",
 *                             "10.2.0.0/16",
 *                         },
 *                         Name = "route1",
 *                         NextHopIpAddress = "10.0.0.68",
 *                     },
 *                     new AzureNative.Network.Inputs.StaticRouteArgs
 *                     {
 *                         AddressPrefixes = new[]
 *                         {
 *                             "10.3.0.0/16",
 *                             "10.4.0.0/16",
 *                         },
 *                         Name = "route2",
 *                         NextHopIpAddress = "10.0.0.65",
 *                     },
 *                 },
 *                 StaticRoutesConfig = new AzureNative.Network.Inputs.StaticRoutesConfigArgs
 *                 {
 *                     VnetLocalRouteOverrideCriteria = AzureNative.Network.VnetLocalRouteOverrideCriteria.Equal,
 *                 },
 *             },
 *         },
 *         VirtualHubName = "virtualHub1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewHubVirtualNetworkConnection(ctx, "hubVirtualNetworkConnection", &network.HubVirtualNetworkConnectionArgs{
 * 			ConnectionName:         pulumi.String("connection1"),
 * 			EnableInternetSecurity: pulumi.Bool(false),
 * 			RemoteVirtualNetwork: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/SpokeVnet1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			RoutingConfiguration: &network.RoutingConfigurationArgs{
 * 				AssociatedRouteTable: &network.SubResourceArgs{
 * 					Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
 * 				},
 * 				InboundRouteMap: &network.SubResourceArgs{
 * 					Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap1"),
 * 				},
 * 				OutboundRouteMap: &network.SubResourceArgs{
 * 					Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap2"),
 * 				},
 * 				PropagatedRouteTables: &network.PropagatedRouteTableArgs{
 * 					Ids: network.SubResourceArray{
 * 						&network.SubResourceArgs{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
 * 						},
 * 					},
 * 					Labels: pulumi.StringArray{
 * 						pulumi.String("label1"),
 * 						pulumi.String("label2"),
 * 					},
 * 				},
 * 				VnetRoutes: &network.VnetRouteArgs{
 * 					StaticRoutes: network.StaticRouteArray{
 * 						&network.StaticRouteArgs{
 * 							AddressPrefixes: pulumi.StringArray{
 * 								pulumi.String("10.1.0.0/16"),
 * 								pulumi.String("10.2.0.0/16"),
 * 							},
 * 							Name:             pulumi.String("route1"),
 * 							NextHopIpAddress: pulumi.String("10.0.0.68"),
 * 						},
 * 						&network.StaticRouteArgs{
 * 							AddressPrefixes: pulumi.StringArray{
 * 								pulumi.String("10.3.0.0/16"),
 * 								pulumi.String("10.4.0.0/16"),
 * 							},
 * 							Name:             pulumi.String("route2"),
 * 							NextHopIpAddress: pulumi.String("10.0.0.65"),
 * 						},
 * 					},
 * 					StaticRoutesConfig: &network.StaticRoutesConfigArgs{
 * 						VnetLocalRouteOverrideCriteria: pulumi.String(network.VnetLocalRouteOverrideCriteriaEqual),
 * 					},
 * 				},
 * 			},
 * 			VirtualHubName: pulumi.String("virtualHub1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.HubVirtualNetworkConnection;
 * import com.pulumi.azurenative.network.HubVirtualNetworkConnectionArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.RoutingConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.PropagatedRouteTableArgs;
 * import com.pulumi.azurenative.network.inputs.VnetRouteArgs;
 * import com.pulumi.azurenative.network.inputs.StaticRoutesConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hubVirtualNetworkConnection = new HubVirtualNetworkConnection("hubVirtualNetworkConnection", HubVirtualNetworkConnectionArgs.builder()
 *             .connectionName("connection1")
 *             .enableInternetSecurity(false)
 *             .remoteVirtualNetwork(SubResourceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/SpokeVnet1")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .routingConfiguration(RoutingConfigurationArgs.builder()
 *                 .associatedRouteTable(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1")
 *                     .build())
 *                 .inboundRouteMap(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap1")
 *                     .build())
 *                 .outboundRouteMap(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap2")
 *                     .build())
 *                 .propagatedRouteTables(PropagatedRouteTableArgs.builder()
 *                     .ids(SubResourceArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1")
 *                         .build())
 *                     .labels(
 *                         "label1",
 *                         "label2")
 *                     .build())
 *                 .vnetRoutes(VnetRouteArgs.builder()
 *                     .staticRoutes(
 *                         StaticRouteArgs.builder()
 *                             .addressPrefixes(
 *                                 "10.1.0.0/16",
 *                                 "10.2.0.0/16")
 *                             .name("route1")
 *                             .nextHopIpAddress("10.0.0.68")
 *                             .build(),
 *                         StaticRouteArgs.builder()
 *                             .addressPrefixes(
 *                                 "10.3.0.0/16",
 *                                 "10.4.0.0/16")
 *                             .name("route2")
 *                             .nextHopIpAddress("10.0.0.65")
 *                             .build())
 *                     .staticRoutesConfig(StaticRoutesConfigArgs.builder()
 *                         .vnetLocalRouteOverrideCriteria("Equal")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .virtualHubName("virtualHub1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:HubVirtualNetworkConnection connection1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/hubVirtualNetworkConnections/{connectionName}
 * ```
 */
public class HubVirtualNetworkConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.network.HubVirtualNetworkConnection,
) : KotlinCustomResource(javaResource, HubVirtualNetworkConnectionMapper) {
    /**
     * Deprecated: VirtualHub to RemoteVnet transit to enabled or not.
     */
    public val allowHubToRemoteVnetTransit: Output<Boolean>?
        get() = javaResource.allowHubToRemoteVnetTransit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Deprecated: Allow RemoteVnet to use Virtual Hub's gateways.
     */
    public val allowRemoteVnetToUseHubVnetGateways: Output<Boolean>?
        get() = javaResource.allowRemoteVnetToUseHubVnetGateways().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Enable internet security.
     */
    public val enableInternetSecurity: Output<Boolean>?
        get() = javaResource.enableInternetSecurity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning state of the hub virtual network connection resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Reference to the remote virtual network.
     */
    public val remoteVirtualNetwork: Output<SubResourceResponse>?
        get() = javaResource.remoteVirtualNetwork().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    public val routingConfiguration: Output<RoutingConfigurationResponse>?
        get() = javaResource.routingConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> routingConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })
}

public object HubVirtualNetworkConnectionMapper : ResourceMapper<HubVirtualNetworkConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.HubVirtualNetworkConnection::class == javaResource::class

    override fun map(javaResource: Resource): HubVirtualNetworkConnection =
        HubVirtualNetworkConnection(
            javaResource as
                com.pulumi.azurenative.network.HubVirtualNetworkConnection,
        )
}

/**
 * @see [HubVirtualNetworkConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HubVirtualNetworkConnection].
 */
public suspend fun hubVirtualNetworkConnection(
    name: String,
    block: suspend HubVirtualNetworkConnectionResourceBuilder.() -> Unit,
):
    HubVirtualNetworkConnection {
    val builder = HubVirtualNetworkConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HubVirtualNetworkConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hubVirtualNetworkConnection(name: String): HubVirtualNetworkConnection {
    val builder = HubVirtualNetworkConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
