@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceIPConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceIPConfigurationResponse.Companion.toKotlin as networkInterfaceIPConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin

/**
 * Builder for [InboundNatRule].
 */
@PulumiTagMarker
public class InboundNatRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InboundNatRuleArgs = InboundNatRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InboundNatRuleArgsBuilder.() -> Unit) {
        val builder = InboundNatRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): InboundNatRule {
        val builtJavaResource = com.pulumi.azurenative.network.InboundNatRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InboundNatRule(builtJavaResource)
    }
}

/**
 * Inbound NAT rule of the load balancer.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-06-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### InboundNatRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var inboundNatRule = new AzureNative.Network.InboundNatRule("inboundNatRule", new()
 *     {
 *         BackendPort = 3389,
 *         EnableFloatingIP = false,
 *         EnableTcpReset = false,
 *         FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/testrg/providers/Microsoft.Network/loadBalancers/lb1/frontendIPConfigurations/ip1",
 *         },
 *         FrontendPort = 3390,
 *         IdleTimeoutInMinutes = 4,
 *         InboundNatRuleName = "natRule1.1",
 *         LoadBalancerName = "lb1",
 *         Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *         ResourceGroupName = "testrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewInboundNatRule(ctx, "inboundNatRule", &network.InboundNatRuleArgs{
 * 			BackendPort:      pulumi.Int(3389),
 * 			EnableFloatingIP: pulumi.Bool(false),
 * 			EnableTcpReset:   pulumi.Bool(false),
 * 			FrontendIPConfiguration: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/testrg/providers/Microsoft.Network/loadBalancers/lb1/frontendIPConfigurations/ip1"),
 * 			},
 * 			FrontendPort:         pulumi.Int(3390),
 * 			IdleTimeoutInMinutes: pulumi.Int(4),
 * 			InboundNatRuleName:   pulumi.String("natRule1.1"),
 * 			LoadBalancerName:     pulumi.String("lb1"),
 * 			Protocol:             pulumi.String(network.TransportProtocolTcp),
 * 			ResourceGroupName:    pulumi.String("testrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.InboundNatRule;
 * import com.pulumi.azurenative.network.InboundNatRuleArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var inboundNatRule = new InboundNatRule("inboundNatRule", InboundNatRuleArgs.builder()
 *             .backendPort(3389)
 *             .enableFloatingIP(false)
 *             .enableTcpReset(false)
 *             .frontendIPConfiguration(SubResourceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/testrg/providers/Microsoft.Network/loadBalancers/lb1/frontendIPConfigurations/ip1")
 *                 .build())
 *             .frontendPort(3390)
 *             .idleTimeoutInMinutes(4)
 *             .inboundNatRuleName("natRule1.1")
 *             .loadBalancerName("lb1")
 *             .protocol("Tcp")
 *             .resourceGroupName("testrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:InboundNatRule natRule1.1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatRules/{inboundNatRuleName}
 * ```
 */
public class InboundNatRule internal constructor(
    override val javaResource: com.pulumi.azurenative.network.InboundNatRule,
) : KotlinCustomResource(javaResource, InboundNatRuleMapper) {
    /**
     * A reference to backendAddressPool resource.
     */
    public val backendAddressPool: Output<SubResourceResponse>?
        get() = javaResource.backendAddressPool().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A reference to a private IP address defined on a network interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations is forwarded to the backend IP.
     */
    public val backendIPConfiguration: Output<NetworkInterfaceIPConfigurationResponse>
        get() = javaResource.backendIPConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                networkInterfaceIPConfigurationResponseToKotlin(args0)
            })
        })

    /**
     * The port used for the internal endpoint. Acceptable values range from 1 to 65535.
     */
    public val backendPort: Output<Int>?
        get() = javaResource.backendPort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
     */
    public val enableFloatingIP: Output<Boolean>?
        get() = javaResource.enableFloatingIP().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
     */
    public val enableTcpReset: Output<Boolean>?
        get() = javaResource.enableTcpReset().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * A reference to frontend IP addresses.
     */
    public val frontendIPConfiguration: Output<SubResourceResponse>?
        get() = javaResource.frontendIPConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.
     */
    public val frontendPort: Output<Int>?
        get() = javaResource.frontendPort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The port range end for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
     */
    public val frontendPortRangeEnd: Output<Int>?
        get() = javaResource.frontendPortRangeEnd().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The port range start for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
     */
    public val frontendPortRangeStart: Output<Int>?
        get() = javaResource.frontendPortRangeStart().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
     */
    public val idleTimeoutInMinutes: Output<Int>?
        get() = javaResource.idleTimeoutInMinutes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource that is unique within the set of inbound NAT rules used by the load balancer. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The reference to the transport protocol used by the load balancing rule.
     */
    public val protocol: Output<String>?
        get() = javaResource.protocol().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning state of the inbound NAT rule resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object InboundNatRuleMapper : ResourceMapper<InboundNatRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.InboundNatRule::class == javaResource::class

    override fun map(javaResource: Resource): InboundNatRule = InboundNatRule(
        javaResource as
            com.pulumi.azurenative.network.InboundNatRule,
    )
}

/**
 * @see [InboundNatRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InboundNatRule].
 */
public suspend fun inboundNatRule(
    name: String,
    block: suspend InboundNatRuleResourceBuilder.() -> Unit,
): InboundNatRule {
    val builder = InboundNatRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InboundNatRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun inboundNatRule(name: String): InboundNatRule {
    val builder = InboundNatRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
