@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.EndpointServiceResponse
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.EndpointServiceResponse.Companion.toKotlin as endpointServiceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceResponse.Companion.toKotlin as networkInterfaceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse.Companion.toKotlin as subnetResponseToKotlin

/**
 * Builder for [InterfaceEndpoint].
 */
@PulumiTagMarker
public class InterfaceEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InterfaceEndpointArgs = InterfaceEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InterfaceEndpointArgsBuilder.() -> Unit) {
        val builder = InterfaceEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): InterfaceEndpoint {
        val builtJavaResource =
            com.pulumi.azurenative.network.InterfaceEndpoint(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return InterfaceEndpoint(builtJavaResource)
    }
}

/**
 * Interface endpoint resource.
 * Azure REST API version: 2019-02-01.
 * ## Example Usage
 * ### Create interface endpoint
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var interfaceEndpoint = new AzureNative.Network.InterfaceEndpoint("interfaceEndpoint", new()
 *     {
 *         EndpointService = new AzureNative.Network.Inputs.EndpointServiceArgs
 *         {
 *             Id = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Provider/resourceType/resourceName",
 *         },
 *         Fqdn = "uniqueIdentifier.fqdn.windows.net",
 *         InterfaceEndpointName = "testIe",
 *         ResourceGroupName = "rg1",
 *         Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *         {
 *             Id = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewInterfaceEndpoint(ctx, "interfaceEndpoint", &network.InterfaceEndpointArgs{
 * 			EndpointService: &network.EndpointServiceArgs{
 * 				Id: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Provider/resourceType/resourceName"),
 * 			},
 * 			Fqdn:                  pulumi.String("uniqueIdentifier.fqdn.windows.net"),
 * 			InterfaceEndpointName: pulumi.String("testIe"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			Subnet: &network.SubnetTypeArgs{
 * 				Id: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.InterfaceEndpoint;
 * import com.pulumi.azurenative.network.InterfaceEndpointArgs;
 * import com.pulumi.azurenative.network.inputs.EndpointServiceArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var interfaceEndpoint = new InterfaceEndpoint("interfaceEndpoint", InterfaceEndpointArgs.builder()
 *             .endpointService(EndpointServiceArgs.builder()
 *                 .id("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Provider/resourceType/resourceName")
 *                 .build())
 *             .fqdn("uniqueIdentifier.fqdn.windows.net")
 *             .interfaceEndpointName("testIe")
 *             .resourceGroupName("rg1")
 *             .subnet(SubnetArgs.builder()
 *                 .id("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:InterfaceEndpoint testIe /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/interfaceEndpoints/{interfaceEndpointName}
 * ```
 */
public class InterfaceEndpoint internal constructor(
    override val javaResource: com.pulumi.azurenative.network.InterfaceEndpoint,
) : KotlinCustomResource(javaResource, InterfaceEndpointMapper) {
    /**
     * A reference to the service being brought into the virtual network.
     */
    public val endpointService: Output<EndpointServiceResponse>?
        get() = javaResource.endpointService().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> endpointServiceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets a unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A first-party service's FQDN that is mapped to the private IP allocated via this interface endpoint.
     */
    public val fqdn: Output<String>?
        get() = javaResource.fqdn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets an array of references to the network interfaces created for this interface endpoint.
     */
    public val networkInterfaces: Output<List<NetworkInterfaceResponse>>
        get() = javaResource.networkInterfaces().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkInterfaceResponseToKotlin(args0) })
            })
        })

    /**
     * A read-only property that identifies who created this interface endpoint.
     */
    public val owner: Output<String>
        get() = javaResource.owner().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the interface endpoint. Possible values are: 'Updating', 'Deleting', and 'Failed'.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The ID of the subnet from which the private IP will be allocated.
     */
    public val subnet: Output<SubnetResponse>?
        get() = javaResource.subnet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subnetResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object InterfaceEndpointMapper : ResourceMapper<InterfaceEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.InterfaceEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): InterfaceEndpoint = InterfaceEndpoint(
        javaResource as
            com.pulumi.azurenative.network.InterfaceEndpoint,
    )
}

/**
 * @see [InterfaceEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InterfaceEndpoint].
 */
public suspend fun interfaceEndpoint(
    name: String,
    block: suspend InterfaceEndpointResourceBuilder.() -> Unit,
): InterfaceEndpoint {
    val builder = InterfaceEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InterfaceEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun interfaceEndpoint(name: String): InterfaceEndpoint {
    val builder = InterfaceEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
