@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.IpAllocationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.IPVersion
import com.pulumi.azurenative.network.kotlin.enums.IpAllocationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * IpAllocation resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create IpAllocation
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ipAllocation = new AzureNative.Network.IpAllocation("ipAllocation", new()
 *     {
 *         AllocationTags =
 *         {
 *             { "VNetID", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/HypernetVnet1" },
 *         },
 *         IpAllocationName = "test-ipallocation",
 *         Location = "centraluseuap",
 *         Prefix = "3.2.5.0/24",
 *         ResourceGroupName = "rg1",
 *         Type = AzureNative.Network.IpAllocationType.Hypernet,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewIpAllocation(ctx, "ipAllocation", &network.IpAllocationArgs{
 * 			AllocationTags: pulumi.StringMap{
 * 				"VNetID": pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/HypernetVnet1"),
 * 			},
 * 			IpAllocationName:  pulumi.String("test-ipallocation"),
 * 			Location:          pulumi.String("centraluseuap"),
 * 			Prefix:            pulumi.String("3.2.5.0/24"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Type:              pulumi.String(network.IpAllocationTypeHypernet),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.IpAllocation;
 * import com.pulumi.azurenative.network.IpAllocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipAllocation = new IpAllocation("ipAllocation", IpAllocationArgs.builder()
 *             .allocationTags(Map.of("VNetID", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/HypernetVnet1"))
 *             .ipAllocationName("test-ipallocation")
 *             .location("centraluseuap")
 *             .prefix("3.2.5.0/24")
 *             .resourceGroupName("rg1")
 *             .type("Hypernet")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:IpAllocation test-ipallocation /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/IpAllocations/{ipAllocationName}
 * ```
 * @property allocationTags IpAllocation tags.
 * @property id Resource ID.
 * @property ipAllocationName The name of the IpAllocation.
 * @property ipamAllocationId The IPAM allocation ID.
 * @property location Resource location.
 * @property prefix The address prefix for the IpAllocation.
 * @property prefixLength The address prefix length for the IpAllocation.
 * @property prefixType The address prefix Type for the IpAllocation.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 * @property type The type for the IpAllocation.
 */
public data class IpAllocationArgs(
    public val allocationTags: Output<Map<String, String>>? = null,
    public val id: Output<String>? = null,
    public val ipAllocationName: Output<String>? = null,
    public val ipamAllocationId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val prefix: Output<String>? = null,
    public val prefixLength: Output<Int>? = null,
    public val prefixType: Output<Either<String, IPVersion>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<Either<String, IpAllocationType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.IpAllocationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.IpAllocationArgs =
        com.pulumi.azurenative.network.IpAllocationArgs.builder()
            .allocationTags(
                allocationTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .ipAllocationName(ipAllocationName?.applyValue({ args0 -> args0 }))
            .ipamAllocationId(ipamAllocationId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .prefixLength(prefixLength?.applyValue({ args0 -> args0 }))
            .prefixType(
                prefixType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IpAllocationArgs].
 */
@PulumiTagMarker
public class IpAllocationArgsBuilder internal constructor() {
    private var allocationTags: Output<Map<String, String>>? = null

    private var id: Output<String>? = null

    private var ipAllocationName: Output<String>? = null

    private var ipamAllocationId: Output<String>? = null

    private var location: Output<String>? = null

    private var prefix: Output<String>? = null

    private var prefixLength: Output<Int>? = null

    private var prefixType: Output<Either<String, IPVersion>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<Either<String, IpAllocationType>>? = null

    /**
     * @param value IpAllocation tags.
     */
    @JvmName("hqqxraofoxjlwbio")
    public suspend fun allocationTags(`value`: Output<Map<String, String>>) {
        this.allocationTags = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("lxrcqiogeaysbvbh")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the IpAllocation.
     */
    @JvmName("xcwpwfjhrkmhnwuj")
    public suspend fun ipAllocationName(`value`: Output<String>) {
        this.ipAllocationName = value
    }

    /**
     * @param value The IPAM allocation ID.
     */
    @JvmName("lbliqbwjcfosiwjj")
    public suspend fun ipamAllocationId(`value`: Output<String>) {
        this.ipamAllocationId = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ymgrryuvfvxcdniv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The address prefix for the IpAllocation.
     */
    @JvmName("nhnddrkutamhnktl")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value The address prefix length for the IpAllocation.
     */
    @JvmName("idypvxrgopryvhfn")
    public suspend fun prefixLength(`value`: Output<Int>) {
        this.prefixLength = value
    }

    /**
     * @param value The address prefix Type for the IpAllocation.
     */
    @JvmName("lmcrdnrlhdggifno")
    public suspend fun prefixType(`value`: Output<Either<String, IPVersion>>) {
        this.prefixType = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ffhsrfxnglbjrudx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bubxhyxlanmdkney")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type for the IpAllocation.
     */
    @JvmName("ibwxwtxlbsggapve")
    public suspend fun type(`value`: Output<Either<String, IpAllocationType>>) {
        this.type = value
    }

    /**
     * @param value IpAllocation tags.
     */
    @JvmName("ffvvsjwssrjvgvlm")
    public suspend fun allocationTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationTags = mapped
    }

    /**
     * @param values IpAllocation tags.
     */
    @JvmName("owxidepwnkcftvks")
    public fun allocationTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allocationTags = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("kqhiqxsekmjwerns")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the IpAllocation.
     */
    @JvmName("lytjnfjecqewtdqk")
    public suspend fun ipAllocationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAllocationName = mapped
    }

    /**
     * @param value The IPAM allocation ID.
     */
    @JvmName("nmxanxeyyhgagbuq")
    public suspend fun ipamAllocationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipamAllocationId = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("vgmxdcuwnwhkjigk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The address prefix for the IpAllocation.
     */
    @JvmName("gwegvltntbylardv")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value The address prefix length for the IpAllocation.
     */
    @JvmName("antbjyvcekslimcb")
    public suspend fun prefixLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixLength = mapped
    }

    /**
     * @param value The address prefix Type for the IpAllocation.
     */
    @JvmName("kgqntrpdeioxiosb")
    public suspend fun prefixType(`value`: Either<String, IPVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixType = mapped
    }

    /**
     * @param value The address prefix Type for the IpAllocation.
     */
    @JvmName("cjjaophaayblcutl")
    public fun prefixType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixType = mapped
    }

    /**
     * @param value The address prefix Type for the IpAllocation.
     */
    @JvmName("qhigplsyrqeievvj")
    public fun prefixType(`value`: IPVersion) {
        val toBeMapped = Either.ofRight<String, IPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixType = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xwfrutdeyfodvkxq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ymqkkxigxgjcpjoy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("pdnedmsofxuksxaq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type for the IpAllocation.
     */
    @JvmName("xotipwkwtkwthxqw")
    public suspend fun type(`value`: Either<String, IpAllocationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type for the IpAllocation.
     */
    @JvmName("egakioulseyyodlw")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IpAllocationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type for the IpAllocation.
     */
    @JvmName("hxeibkcjgvfvdpxs")
    public fun type(`value`: IpAllocationType) {
        val toBeMapped = Either.ofRight<String, IpAllocationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IpAllocationArgs = IpAllocationArgs(
        allocationTags = allocationTags,
        id = id,
        ipAllocationName = ipAllocationName,
        ipamAllocationId = ipamAllocationId,
        location = location,
        prefix = prefix,
        prefixLength = prefixLength,
        prefixType = prefixType,
        resourceGroupName = resourceGroupName,
        tags = tags,
        type = type,
    )
}
