@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.BackendAddressPoolResponse
import com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.network.kotlin.outputs.FrontendIPConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.InboundNatPoolResponse
import com.pulumi.azurenative.network.kotlin.outputs.InboundNatRuleResponse
import com.pulumi.azurenative.network.kotlin.outputs.LoadBalancerSkuResponse
import com.pulumi.azurenative.network.kotlin.outputs.LoadBalancingRuleResponse
import com.pulumi.azurenative.network.kotlin.outputs.OutboundRuleResponse
import com.pulumi.azurenative.network.kotlin.outputs.ProbeResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.BackendAddressPoolResponse.Companion.toKotlin as backendAddressPoolResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.FrontendIPConfigurationResponse.Companion.toKotlin as frontendIPConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.InboundNatPoolResponse.Companion.toKotlin as inboundNatPoolResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.InboundNatRuleResponse.Companion.toKotlin as inboundNatRuleResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.LoadBalancerSkuResponse.Companion.toKotlin as loadBalancerSkuResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.LoadBalancingRuleResponse.Companion.toKotlin as loadBalancingRuleResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.OutboundRuleResponse.Companion.toKotlin as outboundRuleResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ProbeResponse.Companion.toKotlin as probeResponseToKotlin

/**
 * Builder for [LoadBalancer].
 */
@PulumiTagMarker
public class LoadBalancerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoadBalancerArgs = LoadBalancerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoadBalancerArgsBuilder.() -> Unit) {
        val builder = LoadBalancerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LoadBalancer {
        val builtJavaResource = com.pulumi.azurenative.network.LoadBalancer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LoadBalancer(builtJavaResource)
    }
}

/**
 * LoadBalancer resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2015-05-01-preview, 2018-06-01, 2019-06-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create load balancer
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb",
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *             },
 *         },
 *         InboundNatPools = new[] {},
 *         InboundNatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.InboundNatRuleArgs
 *             {
 *                 BackendPort = 3389,
 *                 EnableFloatingIP = true,
 *                 EnableTcpReset = false,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 3389,
 *                 IdleTimeoutInMinutes = 15,
 *                 Name = "in-nat-rule",
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                 },
 *                 BackendPort = 80,
 *                 EnableFloatingIP = true,
 *                 EnableTcpReset = false,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 80,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = AzureNative.Network.LoadDistribution.Default,
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         Location = "eastus",
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = AzureNative.Network.ProbeProtocol.Http,
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: network.BackendAddressPoolArray{
 * 				&network.BackendAddressPoolArgs{
 * 					Name: pulumi.String("be-lb"),
 * 				},
 * 			},
 * 			FrontendIPConfigurations: network.FrontendIPConfigurationArray{
 * 				&network.FrontendIPConfigurationArgs{
 * 					Name: pulumi.String("fe-lb"),
 * 					Subnet: &network.SubnetTypeArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 				},
 * 			},
 * 			InboundNatPools: network.InboundNatPoolArray{},
 * 			InboundNatRules: network.InboundNatRuleTypeArray{
 * 				&network.InboundNatRuleTypeArgs{
 * 					BackendPort:      pulumi.Int(3389),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					EnableTcpReset:   pulumi.Bool(false),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(3389),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					Name:                 pulumi.String("in-nat-rule"),
 * 					Protocol:             pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: network.LoadBalancingRuleArray{
 * 				&network.LoadBalancingRuleArgs{
 * 					BackendAddressPool: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 					},
 * 					BackendPort:      pulumi.Int(80),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					EnableTcpReset:   pulumi.Bool(false),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(80),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String(network.LoadDistributionDefault),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			Probes: network.ProbeArray{
 * 				&network.ProbeArgs{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String(network.ProbeProtocolHttp),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import com.pulumi.azurenative.network.inputs.BackendAddressPoolArgs;
 * import com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import com.pulumi.azurenative.network.inputs.InboundNatRuleArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancingRuleArgs;
 * import com.pulumi.azurenative.network.inputs.ProbeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(BackendAddressPoolArgs.builder()
 *                 .name("be-lb")
 *                 .build())
 *             .frontendIPConfigurations(FrontendIPConfigurationArgs.builder()
 *                 .name("fe-lb")
 *                 .subnet(SubnetArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb")
 *                     .build())
 *                 .build())
 *             .inboundNatPools()
 *             .inboundNatRules(InboundNatRuleArgs.builder()
 *                 .backendPort(3389)
 *                 .enableFloatingIP(true)
 *                 .enableTcpReset(false)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(3389)
 *                 .idleTimeoutInMinutes(15)
 *                 .name("in-nat-rule")
 *                 .protocol("Tcp")
 *                 .build())
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(LoadBalancingRuleArgs.builder()
 *                 .backendAddressPool(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")
 *                     .build())
 *                 .backendPort(80)
 *                 .enableFloatingIP(true)
 *                 .enableTcpReset(false)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(80)
 *                 .idleTimeoutInMinutes(15)
 *                 .loadDistribution("Default")
 *                 .name("rulelb")
 *                 .probe(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")
 *                     .build())
 *                 .protocol("Tcp")
 *                 .build())
 *             .location("eastus")
 *             .probes(ProbeArgs.builder()
 *                 .intervalInSeconds(15)
 *                 .name("probe-lb")
 *                 .numberOfProbes(2)
 *                 .port(80)
 *                 .probeThreshold(1)
 *                 .protocol("Http")
 *                 .requestPath("healthcheck.aspx")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with Frontend IP in Zone 1
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb",
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *                 Zones = new[]
 *                 {
 *                     "1",
 *                 },
 *             },
 *         },
 *         InboundNatPools = new[] {},
 *         InboundNatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.InboundNatRuleArgs
 *             {
 *                 BackendPort = 3389,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 3389,
 *                 IdleTimeoutInMinutes = 15,
 *                 Name = "in-nat-rule",
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                 },
 *                 BackendPort = 80,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 80,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = AzureNative.Network.LoadDistribution.Default,
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         Location = "eastus",
 *         OutboundRules = new[] {},
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = AzureNative.Network.ProbeProtocol.Http,
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = AzureNative.Network.LoadBalancerSkuName.Standard,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: network.BackendAddressPoolArray{
 * 				&network.BackendAddressPoolArgs{
 * 					Name: pulumi.String("be-lb"),
 * 				},
 * 			},
 * 			FrontendIPConfigurations: network.FrontendIPConfigurationArray{
 * 				&network.FrontendIPConfigurationArgs{
 * 					Name: pulumi.String("fe-lb"),
 * 					Subnet: &network.SubnetTypeArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 					Zones: pulumi.StringArray{
 * 						pulumi.String("1"),
 * 					},
 * 				},
 * 			},
 * 			InboundNatPools: network.InboundNatPoolArray{},
 * 			InboundNatRules: network.InboundNatRuleTypeArray{
 * 				&network.InboundNatRuleTypeArgs{
 * 					BackendPort:      pulumi.Int(3389),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(3389),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					Name:                 pulumi.String("in-nat-rule"),
 * 					Protocol:             pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: network.LoadBalancingRuleArray{
 * 				&network.LoadBalancingRuleArgs{
 * 					BackendAddressPool: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 					},
 * 					BackendPort:      pulumi.Int(80),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(80),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String(network.LoadDistributionDefault),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			Location:      pulumi.String("eastus"),
 * 			OutboundRules: network.OutboundRuleArray{},
 * 			Probes: network.ProbeArray{
 * 				&network.ProbeArgs{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String(network.ProbeProtocolHttp),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String(network.LoadBalancerSkuNameStandard),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import com.pulumi.azurenative.network.inputs.BackendAddressPoolArgs;
 * import com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import com.pulumi.azurenative.network.inputs.InboundNatRuleArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancingRuleArgs;
 * import com.pulumi.azurenative.network.inputs.ProbeArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancerSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(BackendAddressPoolArgs.builder()
 *                 .name("be-lb")
 *                 .build())
 *             .frontendIPConfigurations(FrontendIPConfigurationArgs.builder()
 *                 .name("fe-lb")
 *                 .subnet(SubnetArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb")
 *                     .build())
 *                 .zones("1")
 *                 .build())
 *             .inboundNatPools()
 *             .inboundNatRules(InboundNatRuleArgs.builder()
 *                 .backendPort(3389)
 *                 .enableFloatingIP(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(3389)
 *                 .idleTimeoutInMinutes(15)
 *                 .name("in-nat-rule")
 *                 .protocol("Tcp")
 *                 .build())
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(LoadBalancingRuleArgs.builder()
 *                 .backendAddressPool(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")
 *                     .build())
 *                 .backendPort(80)
 *                 .enableFloatingIP(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(80)
 *                 .idleTimeoutInMinutes(15)
 *                 .loadDistribution("Default")
 *                 .name("rulelb")
 *                 .probe(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")
 *                     .build())
 *                 .protocol("Tcp")
 *                 .build())
 *             .location("eastus")
 *             .outboundRules()
 *             .probes(ProbeArgs.builder()
 *                 .intervalInSeconds(15)
 *                 .name("probe-lb")
 *                 .numberOfProbes(2)
 *                 .port(80)
 *                 .probeThreshold(1)
 *                 .protocol("Http")
 *                 .requestPath("healthcheck.aspx")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .sku(LoadBalancerSkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with Gateway Load Balancer Consumer configured
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb",
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 GatewayLoadBalancer = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb-provider",
 *                 },
 *                 Name = "fe-lb",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *             },
 *         },
 *         InboundNatPools = new[] {},
 *         InboundNatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.InboundNatRuleArgs
 *             {
 *                 BackendPort = 3389,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 3389,
 *                 IdleTimeoutInMinutes = 15,
 *                 Name = "in-nat-rule",
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                 },
 *                 BackendPort = 80,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 80,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = AzureNative.Network.LoadDistribution.Default,
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         Location = "eastus",
 *         OutboundRules = new[] {},
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = AzureNative.Network.ProbeProtocol.Http,
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = AzureNative.Network.LoadBalancerSkuName.Standard,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: network.BackendAddressPoolArray{
 * 				&network.BackendAddressPoolArgs{
 * 					Name: pulumi.String("be-lb"),
 * 				},
 * 			},
 * 			FrontendIPConfigurations: network.FrontendIPConfigurationArray{
 * 				&network.FrontendIPConfigurationArgs{
 * 					GatewayLoadBalancer: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb-provider"),
 * 					},
 * 					Name: pulumi.String("fe-lb"),
 * 					Subnet: &network.SubnetTypeArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 				},
 * 			},
 * 			InboundNatPools: network.InboundNatPoolArray{},
 * 			InboundNatRules: network.InboundNatRuleTypeArray{
 * 				&network.InboundNatRuleTypeArgs{
 * 					BackendPort:      pulumi.Int(3389),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(3389),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					Name:                 pulumi.String("in-nat-rule"),
 * 					Protocol:             pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: network.LoadBalancingRuleArray{
 * 				&network.LoadBalancingRuleArgs{
 * 					BackendAddressPool: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 					},
 * 					BackendPort:      pulumi.Int(80),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(80),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String(network.LoadDistributionDefault),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			Location:      pulumi.String("eastus"),
 * 			OutboundRules: network.OutboundRuleArray{},
 * 			Probes: network.ProbeArray{
 * 				&network.ProbeArgs{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String(network.ProbeProtocolHttp),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String(network.LoadBalancerSkuNameStandard),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import com.pulumi.azurenative.network.inputs.BackendAddressPoolArgs;
 * import com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import com.pulumi.azurenative.network.inputs.InboundNatRuleArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancingRuleArgs;
 * import com.pulumi.azurenative.network.inputs.ProbeArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancerSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(BackendAddressPoolArgs.builder()
 *                 .name("be-lb")
 *                 .build())
 *             .frontendIPConfigurations(FrontendIPConfigurationArgs.builder()
 *                 .gatewayLoadBalancer(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb-provider")
 *                     .build())
 *                 .name("fe-lb")
 *                 .subnet(SubnetArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb")
 *                     .build())
 *                 .build())
 *             .inboundNatPools()
 *             .inboundNatRules(InboundNatRuleArgs.builder()
 *                 .backendPort(3389)
 *                 .enableFloatingIP(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(3389)
 *                 .idleTimeoutInMinutes(15)
 *                 .name("in-nat-rule")
 *                 .protocol("Tcp")
 *                 .build())
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(LoadBalancingRuleArgs.builder()
 *                 .backendAddressPool(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")
 *                     .build())
 *                 .backendPort(80)
 *                 .enableFloatingIP(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(80)
 *                 .idleTimeoutInMinutes(15)
 *                 .loadDistribution("Default")
 *                 .name("rulelb")
 *                 .probe(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")
 *                     .build())
 *                 .protocol("Tcp")
 *                 .build())
 *             .location("eastus")
 *             .outboundRules()
 *             .probes(ProbeArgs.builder()
 *                 .intervalInSeconds(15)
 *                 .name("probe-lb")
 *                 .numberOfProbes(2)
 *                 .port(80)
 *                 .probeThreshold(1)
 *                 .protocol("Http")
 *                 .requestPath("healthcheck.aspx")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .sku(LoadBalancerSkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with Gateway Load Balancer Provider configured with one Backend Pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb",
 *                 TunnelInterfaces = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.GatewayLoadBalancerTunnelInterfaceArgs
 *                     {
 *                         Identifier = 900,
 *                         Port = 15000,
 *                         Protocol = AzureNative.Network.GatewayLoadBalancerTunnelProtocol.VXLAN,
 *                         Type = AzureNative.Network.GatewayLoadBalancerTunnelInterfaceType.Internal,
 *                     },
 *                     new AzureNative.Network.Inputs.GatewayLoadBalancerTunnelInterfaceArgs
 *                     {
 *                         Identifier = 901,
 *                         Port = 15001,
 *                         Protocol = AzureNative.Network.GatewayLoadBalancerTunnelProtocol.VXLAN,
 *                         Type = AzureNative.Network.GatewayLoadBalancerTunnelInterfaceType.Internal,
 *                     },
 *                 },
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *             },
 *         },
 *         InboundNatPools = new[] {},
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPools = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                     },
 *                 },
 *                 BackendPort = 0,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 0,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = AzureNative.Network.LoadDistribution.Default,
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = AzureNative.Network.TransportProtocol.All,
 *             },
 *         },
 *         Location = "eastus",
 *         OutboundRules = new[] {},
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = AzureNative.Network.ProbeProtocol.Http,
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = "Premium",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: network.BackendAddressPoolArray{
 * 				&network.BackendAddressPoolArgs{
 * 					Name: pulumi.String("be-lb"),
 * 					TunnelInterfaces: network.GatewayLoadBalancerTunnelInterfaceArray{
 * 						&network.GatewayLoadBalancerTunnelInterfaceArgs{
 * 							Identifier: pulumi.Int(900),
 * 							Port:       pulumi.Int(15000),
 * 							Protocol:   pulumi.String(network.GatewayLoadBalancerTunnelProtocolVXLAN),
 * 							Type:       pulumi.String(network.GatewayLoadBalancerTunnelInterfaceTypeInternal),
 * 						},
 * 						&network.GatewayLoadBalancerTunnelInterfaceArgs{
 * 							Identifier: pulumi.Int(901),
 * 							Port:       pulumi.Int(15001),
 * 							Protocol:   pulumi.String(network.GatewayLoadBalancerTunnelProtocolVXLAN),
 * 							Type:       pulumi.String(network.GatewayLoadBalancerTunnelInterfaceTypeInternal),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			FrontendIPConfigurations: network.FrontendIPConfigurationArray{
 * 				&network.FrontendIPConfigurationArgs{
 * 					Name: pulumi.String("fe-lb"),
 * 					Subnet: &network.SubnetTypeArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 				},
 * 			},
 * 			InboundNatPools:  network.InboundNatPoolArray{},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: network.LoadBalancingRuleArray{
 * 				&network.LoadBalancingRuleArgs{
 * 					BackendAddressPools: network.SubResourceArray{
 * 						&network.SubResourceArgs{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 						},
 * 					},
 * 					BackendPort:      pulumi.Int(0),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(0),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String(network.LoadDistributionDefault),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String(network.TransportProtocolAll),
 * 				},
 * 			},
 * 			Location:      pulumi.String("eastus"),
 * 			OutboundRules: network.OutboundRuleArray{},
 * 			Probes: network.ProbeArray{
 * 				&network.ProbeArgs{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String(network.ProbeProtocolHttp),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String("Premium"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import com.pulumi.azurenative.network.inputs.BackendAddressPoolArgs;
 * import com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancingRuleArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.ProbeArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancerSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(BackendAddressPoolArgs.builder()
 *                 .name("be-lb")
 *                 .tunnelInterfaces(
 *                     GatewayLoadBalancerTunnelInterfaceArgs.builder()
 *                         .identifier(900)
 *                         .port(15000)
 *                         .protocol("VXLAN")
 *                         .type("Internal")
 *                         .build(),
 *                     GatewayLoadBalancerTunnelInterfaceArgs.builder()
 *                         .identifier(901)
 *                         .port(15001)
 *                         .protocol("VXLAN")
 *                         .type("Internal")
 *                         .build())
 *                 .build())
 *             .frontendIPConfigurations(FrontendIPConfigurationArgs.builder()
 *                 .name("fe-lb")
 *                 .subnet(SubnetArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb")
 *                     .build())
 *                 .build())
 *             .inboundNatPools()
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(LoadBalancingRuleArgs.builder()
 *                 .backendAddressPools(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")
 *                     .build())
 *                 .backendPort(0)
 *                 .enableFloatingIP(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(0)
 *                 .idleTimeoutInMinutes(15)
 *                 .loadDistribution("Default")
 *                 .name("rulelb")
 *                 .probe(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")
 *                     .build())
 *                 .protocol("All")
 *                 .build())
 *             .location("eastus")
 *             .outboundRules()
 *             .probes(ProbeArgs.builder()
 *                 .intervalInSeconds(15)
 *                 .name("probe-lb")
 *                 .numberOfProbes(2)
 *                 .port(80)
 *                 .probeThreshold(1)
 *                 .protocol("Http")
 *                 .requestPath("healthcheck.aspx")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .sku(LoadBalancerSkuArgs.builder()
 *                 .name("Premium")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with Gateway Load Balancer Provider configured with two Backend Pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb1",
 *             },
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb2",
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *             },
 *         },
 *         InboundNatPools = new[] {},
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPool = null,
 *                 BackendAddressPools = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb1",
 *                     },
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb2",
 *                     },
 *                 },
 *                 BackendPort = 0,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 0,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = AzureNative.Network.LoadDistribution.Default,
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = AzureNative.Network.TransportProtocol.All,
 *             },
 *         },
 *         Location = "eastus",
 *         OutboundRules = new[] {},
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = AzureNative.Network.ProbeProtocol.Http,
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = "Premium",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: network.BackendAddressPoolArray{
 * 				&network.BackendAddressPoolArgs{
 * 					Name: pulumi.String("be-lb1"),
 * 				},
 * 				&network.BackendAddressPoolArgs{
 * 					Name: pulumi.String("be-lb2"),
 * 				},
 * 			},
 * 			FrontendIPConfigurations: network.FrontendIPConfigurationArray{
 * 				&network.FrontendIPConfigurationArgs{
 * 					Name: pulumi.String("fe-lb"),
 * 					Subnet: &network.SubnetTypeArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 				},
 * 			},
 * 			InboundNatPools:  network.InboundNatPoolArray{},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: network.LoadBalancingRuleArray{
 * 				&network.LoadBalancingRuleArgs{
 * 					BackendAddressPool: nil,
 * 					BackendAddressPools: network.SubResourceArray{
 * 						&network.SubResourceArgs{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb1"),
 * 						},
 * 						&network.SubResourceArgs{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb2"),
 * 						},
 * 					},
 * 					BackendPort:      pulumi.Int(0),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(0),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String(network.LoadDistributionDefault),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String(network.TransportProtocolAll),
 * 				},
 * 			},
 * 			Location:      pulumi.String("eastus"),
 * 			OutboundRules: network.OutboundRuleArray{},
 * 			Probes: network.ProbeArray{
 * 				&network.ProbeArgs{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String(network.ProbeProtocolHttp),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String("Premium"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import com.pulumi.azurenative.network.inputs.BackendAddressPoolArgs;
 * import com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancingRuleArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.ProbeArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancerSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(
 *                 BackendAddressPoolArgs.builder()
 *                     .name("be-lb1")
 *                     .build(),
 *                 BackendAddressPoolArgs.builder()
 *                     .name("be-lb2")
 *                     .build())
 *             .frontendIPConfigurations(FrontendIPConfigurationArgs.builder()
 *                 .name("fe-lb")
 *                 .subnet(SubnetArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb")
 *                     .build())
 *                 .build())
 *             .inboundNatPools()
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(LoadBalancingRuleArgs.builder()
 *                 .backendAddressPool()
 *                 .backendAddressPools(
 *                     SubResourceArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb1")
 *                         .build(),
 *                     SubResourceArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb2")
 *                         .build())
 *                 .backendPort(0)
 *                 .enableFloatingIP(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(0)
 *                 .idleTimeoutInMinutes(15)
 *                 .loadDistribution("Default")
 *                 .name("rulelb")
 *                 .probe(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")
 *                     .build())
 *                 .protocol("All")
 *                 .build())
 *             .location("eastus")
 *             .outboundRules()
 *             .probes(ProbeArgs.builder()
 *                 .intervalInSeconds(15)
 *                 .name("probe-lb")
 *                 .numberOfProbes(2)
 *                 .port(80)
 *                 .probeThreshold(1)
 *                 .protocol("Http")
 *                 .requestPath("healthcheck.aspx")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .sku(LoadBalancerSkuArgs.builder()
 *                 .name("Premium")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with Global Tier and one regional load balancer in its backend pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 LoadBalancerBackendAddresses = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.LoadBalancerBackendAddressArgs
 *                     {
 *                         LoadBalancerFrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourceGroups/regional-lb-rg1/providers/Microsoft.Network/loadBalancers/regional-lb/frontendIPConfigurations/fe-rlb",
 *                         },
 *                         Name = "regional-lb1-address",
 *                     },
 *                 },
 *                 Name = "be-lb",
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *             },
 *         },
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                 },
 *                 BackendPort = 80,
 *                 EnableFloatingIP = false,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 80,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = AzureNative.Network.LoadDistribution.Default,
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         Location = "eastus",
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = AzureNative.Network.ProbeProtocol.Http,
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = AzureNative.Network.LoadBalancerSkuName.Standard,
 *             Tier = AzureNative.Network.LoadBalancerSkuTier.Global,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: network.BackendAddressPoolArray{
 * 				&network.BackendAddressPoolArgs{
 * 					LoadBalancerBackendAddresses: network.LoadBalancerBackendAddressArray{
 * 						&network.LoadBalancerBackendAddressArgs{
 * 							LoadBalancerFrontendIPConfiguration: &network.SubResourceArgs{
 * 								Id: pulumi.String("/subscriptions/subid/resourceGroups/regional-lb-rg1/providers/Microsoft.Network/loadBalancers/regional-lb/frontendIPConfigurations/fe-rlb"),
 * 							},
 * 							Name: pulumi.String("regional-lb1-address"),
 * 						},
 * 					},
 * 					Name: pulumi.String("be-lb"),
 * 				},
 * 			},
 * 			FrontendIPConfigurations: network.FrontendIPConfigurationArray{
 * 				&network.FrontendIPConfigurationArgs{
 * 					Name: pulumi.String("fe-lb"),
 * 					Subnet: &network.SubnetTypeArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 				},
 * 			},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: network.LoadBalancingRuleArray{
 * 				&network.LoadBalancingRuleArgs{
 * 					BackendAddressPool: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 					},
 * 					BackendPort:      pulumi.Int(80),
 * 					EnableFloatingIP: pulumi.Bool(false),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(80),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String(network.LoadDistributionDefault),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			Probes: network.ProbeArray{
 * 				&network.ProbeArgs{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String(network.ProbeProtocolHttp),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String(network.LoadBalancerSkuNameStandard),
 * 				Tier: pulumi.String(network.LoadBalancerSkuTierGlobal),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import com.pulumi.azurenative.network.inputs.BackendAddressPoolArgs;
 * import com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancingRuleArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.ProbeArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancerSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(BackendAddressPoolArgs.builder()
 *                 .loadBalancerBackendAddresses(LoadBalancerBackendAddressArgs.builder()
 *                     .loadBalancerFrontendIPConfiguration(SubResourceArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/regional-lb-rg1/providers/Microsoft.Network/loadBalancers/regional-lb/frontendIPConfigurations/fe-rlb")
 *                         .build())
 *                     .name("regional-lb1-address")
 *                     .build())
 *                 .name("be-lb")
 *                 .build())
 *             .frontendIPConfigurations(FrontendIPConfigurationArgs.builder()
 *                 .name("fe-lb")
 *                 .subnet(SubnetArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb")
 *                     .build())
 *                 .build())
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(LoadBalancingRuleArgs.builder()
 *                 .backendAddressPool(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")
 *                     .build())
 *                 .backendPort(80)
 *                 .enableFloatingIP(false)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(80)
 *                 .idleTimeoutInMinutes(15)
 *                 .loadDistribution("Default")
 *                 .name("rulelb")
 *                 .probe(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")
 *                     .build())
 *                 .protocol("Tcp")
 *                 .build())
 *             .location("eastus")
 *             .probes(ProbeArgs.builder()
 *                 .intervalInSeconds(15)
 *                 .name("probe-lb")
 *                 .numberOfProbes(2)
 *                 .port(80)
 *                 .probeThreshold(1)
 *                 .protocol("Http")
 *                 .requestPath("healthcheck.aspx")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .sku(LoadBalancerSkuArgs.builder()
 *                 .name("Standard")
 *                 .tier("Global")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with Standard SKU
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb",
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *             },
 *         },
 *         InboundNatPools = new[] {},
 *         InboundNatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.InboundNatRuleArgs
 *             {
 *                 BackendPort = 3389,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 3389,
 *                 IdleTimeoutInMinutes = 15,
 *                 Name = "in-nat-rule",
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                 },
 *                 BackendPort = 80,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 80,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = AzureNative.Network.LoadDistribution.Default,
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         Location = "eastus",
 *         OutboundRules = new[] {},
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = AzureNative.Network.ProbeProtocol.Http,
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = AzureNative.Network.LoadBalancerSkuName.Standard,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: network.BackendAddressPoolArray{
 * 				&network.BackendAddressPoolArgs{
 * 					Name: pulumi.String("be-lb"),
 * 				},
 * 			},
 * 			FrontendIPConfigurations: network.FrontendIPConfigurationArray{
 * 				&network.FrontendIPConfigurationArgs{
 * 					Name: pulumi.String("fe-lb"),
 * 					Subnet: &network.SubnetTypeArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 				},
 * 			},
 * 			InboundNatPools: network.InboundNatPoolArray{},
 * 			InboundNatRules: network.InboundNatRuleTypeArray{
 * 				&network.InboundNatRuleTypeArgs{
 * 					BackendPort:      pulumi.Int(3389),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(3389),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					Name:                 pulumi.String("in-nat-rule"),
 * 					Protocol:             pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: network.LoadBalancingRuleArray{
 * 				&network.LoadBalancingRuleArgs{
 * 					BackendAddressPool: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 					},
 * 					BackendPort:      pulumi.Int(80),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(80),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String(network.LoadDistributionDefault),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			Location:      pulumi.String("eastus"),
 * 			OutboundRules: network.OutboundRuleArray{},
 * 			Probes: network.ProbeArray{
 * 				&network.ProbeArgs{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String(network.ProbeProtocolHttp),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String(network.LoadBalancerSkuNameStandard),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import com.pulumi.azurenative.network.inputs.BackendAddressPoolArgs;
 * import com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import com.pulumi.azurenative.network.inputs.InboundNatRuleArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancingRuleArgs;
 * import com.pulumi.azurenative.network.inputs.ProbeArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancerSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(BackendAddressPoolArgs.builder()
 *                 .name("be-lb")
 *                 .build())
 *             .frontendIPConfigurations(FrontendIPConfigurationArgs.builder()
 *                 .name("fe-lb")
 *                 .subnet(SubnetArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb")
 *                     .build())
 *                 .build())
 *             .inboundNatPools()
 *             .inboundNatRules(InboundNatRuleArgs.builder()
 *                 .backendPort(3389)
 *                 .enableFloatingIP(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(3389)
 *                 .idleTimeoutInMinutes(15)
 *                 .name("in-nat-rule")
 *                 .protocol("Tcp")
 *                 .build())
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(LoadBalancingRuleArgs.builder()
 *                 .backendAddressPool(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")
 *                     .build())
 *                 .backendPort(80)
 *                 .enableFloatingIP(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(80)
 *                 .idleTimeoutInMinutes(15)
 *                 .loadDistribution("Default")
 *                 .name("rulelb")
 *                 .probe(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")
 *                     .build())
 *                 .protocol("Tcp")
 *                 .build())
 *             .location("eastus")
 *             .outboundRules()
 *             .probes(ProbeArgs.builder()
 *                 .intervalInSeconds(15)
 *                 .name("probe-lb")
 *                 .numberOfProbes(2)
 *                 .port(80)
 *                 .probeThreshold(1)
 *                 .protocol("Http")
 *                 .requestPath("healthcheck.aspx")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .sku(LoadBalancerSkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with inbound nat pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[] {},
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/test",
 *                 Name = "test",
 *                 PrivateIPAllocationMethod = AzureNative.Network.IPAllocationMethod.Dynamic,
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/lbvnet/subnets/lbsubnet",
 *                 },
 *                 Zones = new() { },
 *             },
 *         },
 *         InboundNatPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.InboundNatPoolArgs
 *             {
 *                 BackendPort = 8888,
 *                 EnableFloatingIP = true,
 *                 EnableTcpReset = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/test",
 *                 },
 *                 FrontendPortRangeEnd = 8085,
 *                 FrontendPortRangeStart = 8080,
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/inboundNatPools/test",
 *                 IdleTimeoutInMinutes = 10,
 *                 Name = "test",
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         InboundNatRules = new[] {},
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[] {},
 *         Location = "eastus",
 *         OutboundRules = new[] {},
 *         Probes = new[] {},
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = AzureNative.Network.LoadBalancerSkuName.Standard,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: network.BackendAddressPoolArray{},
 * 			FrontendIPConfigurations: network.FrontendIPConfigurationArray{
 * 				&network.FrontendIPConfigurationArgs{
 * 					Id:                        pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/test"),
 * 					Name:                      pulumi.String("test"),
 * 					PrivateIPAllocationMethod: pulumi.String(network.IPAllocationMethodDynamic),
 * 					Subnet: &network.SubnetTypeArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/lbvnet/subnets/lbsubnet"),
 * 					},
 * 					Zones: pulumi.StringArray{},
 * 				},
 * 			},
 * 			InboundNatPools: network.InboundNatPoolArray{
 * 				&network.InboundNatPoolArgs{
 * 					BackendPort:      pulumi.Int(8888),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					EnableTcpReset:   pulumi.Bool(true),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/test"),
 * 					},
 * 					FrontendPortRangeEnd:   pulumi.Int(8085),
 * 					FrontendPortRangeStart: pulumi.Int(8080),
 * 					Id:                     pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/inboundNatPools/test"),
 * 					IdleTimeoutInMinutes:   pulumi.Int(10),
 * 					Name:                   pulumi.String("test"),
 * 					Protocol:               pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			InboundNatRules:    network.InboundNatRuleTypeArray{},
 * 			LoadBalancerName:   pulumi.String("lb"),
 * 			LoadBalancingRules: network.LoadBalancingRuleArray{},
 * 			Location:           pulumi.String("eastus"),
 * 			OutboundRules:      network.OutboundRuleArray{},
 * 			Probes:             network.ProbeArray{},
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String(network.LoadBalancerSkuNameStandard),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import com.pulumi.azurenative.network.inputs.InboundNatPoolArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancerSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools()
 *             .frontendIPConfigurations(FrontendIPConfigurationArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/test")
 *                 .name("test")
 *                 .privateIPAllocationMethod("Dynamic")
 *                 .subnet(SubnetArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/lbvnet/subnets/lbsubnet")
 *                     .build())
 *                 .zones()
 *                 .build())
 *             .inboundNatPools(InboundNatPoolArgs.builder()
 *                 .backendPort(8888)
 *                 .enableFloatingIP(true)
 *                 .enableTcpReset(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/test")
 *                     .build())
 *                 .frontendPortRangeEnd(8085)
 *                 .frontendPortRangeStart(8080)
 *                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/inboundNatPools/test")
 *                 .idleTimeoutInMinutes(10)
 *                 .name("test")
 *                 .protocol("Tcp")
 *                 .build())
 *             .inboundNatRules()
 *             .loadBalancerName("lb")
 *             .loadBalancingRules()
 *             .location("eastus")
 *             .outboundRules()
 *             .probes()
 *             .resourceGroupName("rg1")
 *             .sku(LoadBalancerSkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with outbound rules
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb",
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 PublicIPAddress = new AzureNative.Network.Inputs.PublicIPAddressArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pip",
 *                 },
 *             },
 *         },
 *         InboundNatPools = new[] {},
 *         InboundNatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.InboundNatRuleArgs
 *             {
 *                 BackendPort = 3389,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 3389,
 *                 IdleTimeoutInMinutes = 15,
 *                 Name = "in-nat-rule",
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                 },
 *                 BackendPort = 80,
 *                 DisableOutboundSnat = true,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 80,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = AzureNative.Network.LoadDistribution.Default,
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         Location = "eastus",
 *         OutboundRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.OutboundRuleArgs
 *             {
 *                 BackendAddressPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                 },
 *                 FrontendIPConfigurations = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                     },
 *                 },
 *                 Name = "rule1",
 *                 Protocol = AzureNative.Network.LoadBalancerOutboundRuleProtocol.All,
 *             },
 *         },
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = AzureNative.Network.ProbeProtocol.Http,
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = AzureNative.Network.LoadBalancerSkuName.Standard,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: network.BackendAddressPoolArray{
 * 				&network.BackendAddressPoolArgs{
 * 					Name: pulumi.String("be-lb"),
 * 				},
 * 			},
 * 			FrontendIPConfigurations: network.FrontendIPConfigurationArray{
 * 				&network.FrontendIPConfigurationArgs{
 * 					Name: pulumi.String("fe-lb"),
 * 					PublicIPAddress: &network.PublicIPAddressTypeArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pip"),
 * 					},
 * 				},
 * 			},
 * 			InboundNatPools: network.InboundNatPoolArray{},
 * 			InboundNatRules: network.InboundNatRuleTypeArray{
 * 				&network.InboundNatRuleTypeArgs{
 * 					BackendPort:      pulumi.Int(3389),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(3389),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					Name:                 pulumi.String("in-nat-rule"),
 * 					Protocol:             pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: network.LoadBalancingRuleArray{
 * 				&network.LoadBalancingRuleArgs{
 * 					BackendAddressPool: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 					},
 * 					BackendPort:         pulumi.Int(80),
 * 					DisableOutboundSnat: pulumi.Bool(true),
 * 					EnableFloatingIP:    pulumi.Bool(true),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(80),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String(network.LoadDistributionDefault),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			OutboundRules: network.OutboundRuleArray{
 * 				&network.OutboundRuleArgs{
 * 					BackendAddressPool: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 					},
 * 					FrontendIPConfigurations: network.SubResourceArray{
 * 						&network.SubResourceArgs{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 						},
 * 					},
 * 					Name:     pulumi.String("rule1"),
 * 					Protocol: pulumi.String(network.LoadBalancerOutboundRuleProtocolAll),
 * 				},
 * 			},
 * 			Probes: network.ProbeArray{
 * 				&network.ProbeArgs{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String(network.ProbeProtocolHttp),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String(network.LoadBalancerSkuNameStandard),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import com.pulumi.azurenative.network.inputs.BackendAddressPoolArgs;
 * import com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.PublicIPAddressArgs;
 * import com.pulumi.azurenative.network.inputs.InboundNatRuleArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancingRuleArgs;
 * import com.pulumi.azurenative.network.inputs.OutboundRuleArgs;
 * import com.pulumi.azurenative.network.inputs.ProbeArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancerSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(BackendAddressPoolArgs.builder()
 *                 .name("be-lb")
 *                 .build())
 *             .frontendIPConfigurations(FrontendIPConfigurationArgs.builder()
 *                 .name("fe-lb")
 *                 .publicIPAddress(PublicIPAddressArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pip")
 *                     .build())
 *                 .build())
 *             .inboundNatPools()
 *             .inboundNatRules(InboundNatRuleArgs.builder()
 *                 .backendPort(3389)
 *                 .enableFloatingIP(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(3389)
 *                 .idleTimeoutInMinutes(15)
 *                 .name("in-nat-rule")
 *                 .protocol("Tcp")
 *                 .build())
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(LoadBalancingRuleArgs.builder()
 *                 .backendAddressPool(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")
 *                     .build())
 *                 .backendPort(80)
 *                 .disableOutboundSnat(true)
 *                 .enableFloatingIP(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(80)
 *                 .idleTimeoutInMinutes(15)
 *                 .loadDistribution("Default")
 *                 .name("rulelb")
 *                 .probe(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")
 *                     .build())
 *                 .protocol("Tcp")
 *                 .build())
 *             .location("eastus")
 *             .outboundRules(OutboundRuleArgs.builder()
 *                 .backendAddressPool(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")
 *                     .build())
 *                 .frontendIPConfigurations(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .name("rule1")
 *                 .protocol("All")
 *                 .build())
 *             .probes(ProbeArgs.builder()
 *                 .intervalInSeconds(15)
 *                 .name("probe-lb")
 *                 .numberOfProbes(2)
 *                 .port(80)
 *                 .probeThreshold(1)
 *                 .protocol("Http")
 *                 .requestPath("healthcheck.aspx")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .sku(LoadBalancerSkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:LoadBalancer lb /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}
 * ```
 */
public class LoadBalancer internal constructor(
    override val javaResource: com.pulumi.azurenative.network.LoadBalancer,
) : KotlinCustomResource(javaResource, LoadBalancerMapper) {
    /**
     * Collection of backend address pools used by a load balancer.
     */
    public val backendAddressPools: Output<List<BackendAddressPoolResponse>>?
        get() = javaResource.backendAddressPools().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        backendAddressPoolResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The extended location of the load balancer.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Object representing the frontend IPs to be used for the load balancer.
     */
    public val frontendIPConfigurations: Output<List<FrontendIPConfigurationResponse>>?
        get() = javaResource.frontendIPConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        frontendIPConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.
     */
    public val inboundNatPools: Output<List<InboundNatPoolResponse>>?
        get() = javaResource.inboundNatPools().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        inboundNatPoolResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.
     */
    public val inboundNatRules: Output<List<InboundNatRuleResponse>>?
        get() = javaResource.inboundNatRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        inboundNatRuleResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Object collection representing the load balancing rules Gets the provisioning.
     */
    public val loadBalancingRules: Output<List<LoadBalancingRuleResponse>>?
        get() = javaResource.loadBalancingRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        loadBalancingRuleResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The outbound rules.
     */
    public val outboundRules: Output<List<OutboundRuleResponse>>?
        get() = javaResource.outboundRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        outboundRuleResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Collection of probe objects used in the load balancer.
     */
    public val probes: Output<List<ProbeResponse>>?
        get() = javaResource.probes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> probeResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the load balancer resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resource GUID property of the load balancer resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * The load balancer SKU.
     */
    public val sku: Output<LoadBalancerSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    loadBalancerSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LoadBalancerMapper : ResourceMapper<LoadBalancer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.LoadBalancer::class == javaResource::class

    override fun map(javaResource: Resource): LoadBalancer = LoadBalancer(
        javaResource as
            com.pulumi.azurenative.network.LoadBalancer,
    )
}

/**
 * @see [LoadBalancer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LoadBalancer].
 */
public suspend fun loadBalancer(
    name: String,
    block: suspend LoadBalancerResourceBuilder.() -> Unit,
): LoadBalancer {
    val builder = LoadBalancerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LoadBalancer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun loadBalancer(name: String): LoadBalancer {
    val builder = LoadBalancerResourceBuilder()
    builder.name(name)
    return builder.build()
}
