@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.GatewayLoadBalancerTunnelInterfaceResponse
import com.pulumi.azurenative.network.kotlin.outputs.LoadBalancerBackendAddressResponse
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceIPConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.network.kotlin.outputs.GatewayLoadBalancerTunnelInterfaceResponse.Companion.toKotlin as gatewayLoadBalancerTunnelInterfaceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.LoadBalancerBackendAddressResponse.Companion.toKotlin as loadBalancerBackendAddressResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceIPConfigurationResponse.Companion.toKotlin as networkInterfaceIPConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin

/**
 * Builder for [LoadBalancerBackendAddressPool].
 */
@PulumiTagMarker
public class LoadBalancerBackendAddressPoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoadBalancerBackendAddressPoolArgs = LoadBalancerBackendAddressPoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoadBalancerBackendAddressPoolArgsBuilder.() -> Unit) {
        val builder = LoadBalancerBackendAddressPoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LoadBalancerBackendAddressPool {
        val builtJavaResource =
            com.pulumi.azurenative.network.LoadBalancerBackendAddressPool(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LoadBalancerBackendAddressPool(builtJavaResource)
    }
}

/**
 * Pool of backend IP addresses.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Update load balancer backend pool with backend addresses containing virtual network and  IP address.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancerBackendAddressPool = new AzureNative.Network.LoadBalancerBackendAddressPool("loadBalancerBackendAddressPool", new()
 *     {
 *         BackendAddressPoolName = "backend",
 *         LoadBalancerBackendAddresses = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancerBackendAddressArgs
 *             {
 *                 IpAddress = "10.0.0.4",
 *                 Name = "address1",
 *                 VirtualNetwork = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb",
 *                 },
 *             },
 *             new AzureNative.Network.Inputs.LoadBalancerBackendAddressArgs
 *             {
 *                 IpAddress = "10.0.0.5",
 *                 Name = "address2",
 *                 VirtualNetwork = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb",
 *                 },
 *             },
 *         },
 *         LoadBalancerName = "lb",
 *         ResourceGroupName = "testrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancerBackendAddressPool(ctx, "loadBalancerBackendAddressPool", &network.LoadBalancerBackendAddressPoolArgs{
 * 			BackendAddressPoolName: pulumi.String("backend"),
 * 			LoadBalancerBackendAddresses: network.LoadBalancerBackendAddressArray{
 * 				&network.LoadBalancerBackendAddressArgs{
 * 					IpAddress: pulumi.String("10.0.0.4"),
 * 					Name:      pulumi.String("address1"),
 * 					VirtualNetwork: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb"),
 * 					},
 * 				},
 * 				&network.LoadBalancerBackendAddressArgs{
 * 					IpAddress: pulumi.String("10.0.0.5"),
 * 					Name:      pulumi.String("address2"),
 * 					VirtualNetwork: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb"),
 * 					},
 * 				},
 * 			},
 * 			LoadBalancerName:  pulumi.String("lb"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancerBackendAddressPool;
 * import com.pulumi.azurenative.network.LoadBalancerBackendAddressPoolArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancerBackendAddressArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancerBackendAddressPool = new LoadBalancerBackendAddressPool("loadBalancerBackendAddressPool", LoadBalancerBackendAddressPoolArgs.builder()
 *             .backendAddressPoolName("backend")
 *             .loadBalancerBackendAddresses(
 *                 LoadBalancerBackendAddressArgs.builder()
 *                     .ipAddress("10.0.0.4")
 *                     .name("address1")
 *                     .virtualNetwork(SubResourceArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb")
 *                         .build())
 *                     .build(),
 *                 LoadBalancerBackendAddressArgs.builder()
 *                     .ipAddress("10.0.0.5")
 *                     .name("address2")
 *                     .virtualNetwork(SubResourceArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb")
 *                         .build())
 *                     .build())
 *             .loadBalancerName("lb")
 *             .resourceGroupName("testrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:LoadBalancerBackendAddressPool backend /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/backendAddressPools/{backendAddressPoolName}
 * ```
 */
public class LoadBalancerBackendAddressPool internal constructor(
    override val javaResource: com.pulumi.azurenative.network.LoadBalancerBackendAddressPool,
) : KotlinCustomResource(javaResource, LoadBalancerBackendAddressPoolMapper) {
    /**
     * An array of references to IP addresses defined in network interfaces.
     */
    public val backendIPConfigurations: Output<List<NetworkInterfaceIPConfigurationResponse>>
        get() = javaResource.backendIPConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkInterfaceIPConfigurationResponseToKotlin(args0) })
            })
        })

    /**
     * Amount of seconds Load Balancer waits for before sending RESET to client and backend address.
     */
    public val drainPeriodInSeconds: Output<Int>?
        get() = javaResource.drainPeriodInSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * An array of references to inbound NAT rules that use this backend address pool.
     */
    public val inboundNatRules: Output<List<SubResourceResponse>>
        get() = javaResource.inboundNatRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            })
        })

    /**
     * An array of backend addresses.
     */
    public val loadBalancerBackendAddresses: Output<List<LoadBalancerBackendAddressResponse>>?
        get() = javaResource.loadBalancerBackendAddresses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        loadBalancerBackendAddressResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * An array of references to load balancing rules that use this backend address pool.
     */
    public val loadBalancingRules: Output<List<SubResourceResponse>>
        get() = javaResource.loadBalancingRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            })
        })

    /**
     * The location of the backend address pool.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource that is unique within the set of backend address pools used by the load balancer. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A reference to an outbound rule that uses this backend address pool.
     */
    public val outboundRule: Output<SubResourceResponse>
        get() = javaResource.outboundRule().applyValue({ args0 ->
            args0.let({ args0 ->
                subResourceResponseToKotlin(args0)
            })
        })

    /**
     * An array of references to outbound rules that use this backend address pool.
     */
    public val outboundRules: Output<List<SubResourceResponse>>
        get() = javaResource.outboundRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            })
        })

    /**
     * The provisioning state of the backend address pool resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * An array of gateway load balancer tunnel interfaces.
     */
    public val tunnelInterfaces: Output<List<GatewayLoadBalancerTunnelInterfaceResponse>>?
        get() = javaResource.tunnelInterfaces().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        gatewayLoadBalancerTunnelInterfaceResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * A reference to a virtual network.
     */
    public val virtualNetwork: Output<SubResourceResponse>?
        get() = javaResource.virtualNetwork().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })
}

public object LoadBalancerBackendAddressPoolMapper : ResourceMapper<LoadBalancerBackendAddressPool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.LoadBalancerBackendAddressPool::class == javaResource::class

    override fun map(javaResource: Resource): LoadBalancerBackendAddressPool =
        LoadBalancerBackendAddressPool(
            javaResource as
                com.pulumi.azurenative.network.LoadBalancerBackendAddressPool,
        )
}

/**
 * @see [LoadBalancerBackendAddressPool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LoadBalancerBackendAddressPool].
 */
public suspend fun loadBalancerBackendAddressPool(
    name: String,
    block: suspend LoadBalancerBackendAddressPoolResourceBuilder.() -> Unit,
):
    LoadBalancerBackendAddressPool {
    val builder = LoadBalancerBackendAddressPoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LoadBalancerBackendAddressPool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun loadBalancerBackendAddressPool(name: String): LoadBalancerBackendAddressPool {
    val builder = LoadBalancerBackendAddressPoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
