@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.NatRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VpnNatRuleMode
import com.pulumi.azurenative.network.kotlin.enums.VpnNatRuleType
import com.pulumi.azurenative.network.kotlin.inputs.VpnNatRuleMappingArgs
import com.pulumi.azurenative.network.kotlin.inputs.VpnNatRuleMappingArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VpnGatewayNatRule Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### NatRulePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var natRule = new AzureNative.Network.NatRule("natRule", new()
 *     {
 *         ExternalMappings = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnNatRuleMappingArgs
 *             {
 *                 AddressSpace = "192.168.21.0/24",
 *             },
 *         },
 *         GatewayName = "gateway1",
 *         InternalMappings = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnNatRuleMappingArgs
 *             {
 *                 AddressSpace = "10.4.0.0/24",
 *             },
 *         },
 *         IpConfigurationId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/cloudnet1-VNG/ipConfigurations/default",
 *         Mode = AzureNative.Network.VpnNatRuleMode.EgressSnat,
 *         NatRuleName = "natRule1",
 *         ResourceGroupName = "rg1",
 *         Type = AzureNative.Network.VpnNatRuleType.Static,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNatRule(ctx, "natRule", &network.NatRuleArgs{
 * 			ExternalMappings: network.VpnNatRuleMappingArray{
 * 				&network.VpnNatRuleMappingArgs{
 * 					AddressSpace: pulumi.String("192.168.21.0/24"),
 * 				},
 * 			},
 * 			GatewayName: pulumi.String("gateway1"),
 * 			InternalMappings: network.VpnNatRuleMappingArray{
 * 				&network.VpnNatRuleMappingArgs{
 * 					AddressSpace: pulumi.String("10.4.0.0/24"),
 * 				},
 * 			},
 * 			IpConfigurationId: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/cloudnet1-VNG/ipConfigurations/default"),
 * 			Mode:              pulumi.String(network.VpnNatRuleModeEgressSnat),
 * 			NatRuleName:       pulumi.String("natRule1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Type:              pulumi.String(network.VpnNatRuleTypeStatic),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NatRule;
 * import com.pulumi.azurenative.network.NatRuleArgs;
 * import com.pulumi.azurenative.network.inputs.VpnNatRuleMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var natRule = new NatRule("natRule", NatRuleArgs.builder()
 *             .externalMappings(VpnNatRuleMappingArgs.builder()
 *                 .addressSpace("192.168.21.0/24")
 *                 .build())
 *             .gatewayName("gateway1")
 *             .internalMappings(VpnNatRuleMappingArgs.builder()
 *                 .addressSpace("10.4.0.0/24")
 *                 .build())
 *             .ipConfigurationId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/cloudnet1-VNG/ipConfigurations/default")
 *             .mode("EgressSnat")
 *             .natRuleName("natRule1")
 *             .resourceGroupName("rg1")
 *             .type("Static")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NatRule natRule1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}/natRules/{natRuleName}
 * ```
 * @property externalMappings The private IP address external mapping for NAT.
 * @property gatewayName The name of the gateway.
 * @property id Resource ID.
 * @property internalMappings The private IP address internal mapping for NAT.
 * @property ipConfigurationId The IP Configuration ID this NAT rule applies to.
 * @property mode The Source NAT direction of a VPN NAT.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property natRuleName The name of the nat rule.
 * @property resourceGroupName The resource group name of the VpnGateway.
 * @property type The type of NAT rule for VPN NAT.
 */
public data class NatRuleArgs(
    public val externalMappings: Output<List<VpnNatRuleMappingArgs>>? = null,
    public val gatewayName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val internalMappings: Output<List<VpnNatRuleMappingArgs>>? = null,
    public val ipConfigurationId: Output<String>? = null,
    public val mode: Output<Either<String, VpnNatRuleMode>>? = null,
    public val name: Output<String>? = null,
    public val natRuleName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val type: Output<Either<String, VpnNatRuleType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.NatRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.NatRuleArgs =
        com.pulumi.azurenative.network.NatRuleArgs.builder()
            .externalMappings(
                externalMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .gatewayName(gatewayName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .internalMappings(
                internalMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ipConfigurationId(ipConfigurationId?.applyValue({ args0 -> args0 }))
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .natRuleName(natRuleName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [NatRuleArgs].
 */
@PulumiTagMarker
public class NatRuleArgsBuilder internal constructor() {
    private var externalMappings: Output<List<VpnNatRuleMappingArgs>>? = null

    private var gatewayName: Output<String>? = null

    private var id: Output<String>? = null

    private var internalMappings: Output<List<VpnNatRuleMappingArgs>>? = null

    private var ipConfigurationId: Output<String>? = null

    private var mode: Output<Either<String, VpnNatRuleMode>>? = null

    private var name: Output<String>? = null

    private var natRuleName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var type: Output<Either<String, VpnNatRuleType>>? = null

    /**
     * @param value The private IP address external mapping for NAT.
     */
    @JvmName("agevsiaqbwtfiilb")
    public suspend fun externalMappings(`value`: Output<List<VpnNatRuleMappingArgs>>) {
        this.externalMappings = value
    }

    @JvmName("hgiocwrtveatkcun")
    public suspend fun externalMappings(vararg values: Output<VpnNatRuleMappingArgs>) {
        this.externalMappings = Output.all(values.asList())
    }

    /**
     * @param values The private IP address external mapping for NAT.
     */
    @JvmName("eikuxysiuoynabvl")
    public suspend fun externalMappings(values: List<Output<VpnNatRuleMappingArgs>>) {
        this.externalMappings = Output.all(values)
    }

    /**
     * @param value The name of the gateway.
     */
    @JvmName("kojogqrghwfrlwej")
    public suspend fun gatewayName(`value`: Output<String>) {
        this.gatewayName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("auujnnvxjvwjpqka")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The private IP address internal mapping for NAT.
     */
    @JvmName("rrwgqngoxfyyywqo")
    public suspend fun internalMappings(`value`: Output<List<VpnNatRuleMappingArgs>>) {
        this.internalMappings = value
    }

    @JvmName("djlgvafbxbyobndo")
    public suspend fun internalMappings(vararg values: Output<VpnNatRuleMappingArgs>) {
        this.internalMappings = Output.all(values.asList())
    }

    /**
     * @param values The private IP address internal mapping for NAT.
     */
    @JvmName("tenfofilwgyhvbrg")
    public suspend fun internalMappings(values: List<Output<VpnNatRuleMappingArgs>>) {
        this.internalMappings = Output.all(values)
    }

    /**
     * @param value The IP Configuration ID this NAT rule applies to.
     */
    @JvmName("qtsyiialdeldnnej")
    public suspend fun ipConfigurationId(`value`: Output<String>) {
        this.ipConfigurationId = value
    }

    /**
     * @param value The Source NAT direction of a VPN NAT.
     */
    @JvmName("iwvumubwhddomhlr")
    public suspend fun mode(`value`: Output<Either<String, VpnNatRuleMode>>) {
        this.mode = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("dnutciaqpmuhitru")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the nat rule.
     */
    @JvmName("yjqiruyrvsngwxll")
    public suspend fun natRuleName(`value`: Output<String>) {
        this.natRuleName = value
    }

    /**
     * @param value The resource group name of the VpnGateway.
     */
    @JvmName("wyhlqovbycgefxav")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The type of NAT rule for VPN NAT.
     */
    @JvmName("erblhdpjblgecvuj")
    public suspend fun type(`value`: Output<Either<String, VpnNatRuleType>>) {
        this.type = value
    }

    /**
     * @param value The private IP address external mapping for NAT.
     */
    @JvmName("hlchedtfgwubckdj")
    public suspend fun externalMappings(`value`: List<VpnNatRuleMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalMappings = mapped
    }

    /**
     * @param argument The private IP address external mapping for NAT.
     */
    @JvmName("eequyeckijmywijj")
    public suspend
    fun externalMappings(argument: List<suspend VpnNatRuleMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnNatRuleMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.externalMappings = mapped
    }

    /**
     * @param argument The private IP address external mapping for NAT.
     */
    @JvmName("aleigqgauprvvhgc")
    public suspend fun externalMappings(
        vararg
        argument: suspend VpnNatRuleMappingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VpnNatRuleMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.externalMappings = mapped
    }

    /**
     * @param argument The private IP address external mapping for NAT.
     */
    @JvmName("ohdjhclnlnrmchsa")
    public suspend fun externalMappings(argument: suspend VpnNatRuleMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VpnNatRuleMappingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.externalMappings = mapped
    }

    /**
     * @param values The private IP address external mapping for NAT.
     */
    @JvmName("jeookhclqewxmfvm")
    public suspend fun externalMappings(vararg values: VpnNatRuleMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalMappings = mapped
    }

    /**
     * @param value The name of the gateway.
     */
    @JvmName("bdejbbjydxpbmwfn")
    public suspend fun gatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("qotowtiuutldsldx")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The private IP address internal mapping for NAT.
     */
    @JvmName("trllhpnxxovocmnh")
    public suspend fun internalMappings(`value`: List<VpnNatRuleMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internalMappings = mapped
    }

    /**
     * @param argument The private IP address internal mapping for NAT.
     */
    @JvmName("drabacajjkhuoogv")
    public suspend
    fun internalMappings(argument: List<suspend VpnNatRuleMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnNatRuleMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.internalMappings = mapped
    }

    /**
     * @param argument The private IP address internal mapping for NAT.
     */
    @JvmName("yovyjacwtmpskmir")
    public suspend fun internalMappings(
        vararg
        argument: suspend VpnNatRuleMappingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VpnNatRuleMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.internalMappings = mapped
    }

    /**
     * @param argument The private IP address internal mapping for NAT.
     */
    @JvmName("vwghgpdmfwiddrbk")
    public suspend fun internalMappings(argument: suspend VpnNatRuleMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VpnNatRuleMappingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.internalMappings = mapped
    }

    /**
     * @param values The private IP address internal mapping for NAT.
     */
    @JvmName("frtukngrdaipggry")
    public suspend fun internalMappings(vararg values: VpnNatRuleMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.internalMappings = mapped
    }

    /**
     * @param value The IP Configuration ID this NAT rule applies to.
     */
    @JvmName("tcctxfhufvhuspwj")
    public suspend fun ipConfigurationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigurationId = mapped
    }

    /**
     * @param value The Source NAT direction of a VPN NAT.
     */
    @JvmName("qsabwjrblpkliorc")
    public suspend fun mode(`value`: Either<String, VpnNatRuleMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The Source NAT direction of a VPN NAT.
     */
    @JvmName("liwwcmfbifsbixyv")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VpnNatRuleMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The Source NAT direction of a VPN NAT.
     */
    @JvmName("tbniqbvcnsmvhvvb")
    public fun mode(`value`: VpnNatRuleMode) {
        val toBeMapped = Either.ofRight<String, VpnNatRuleMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("qropxitjsrxbouyi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the nat rule.
     */
    @JvmName("bllotgwbonfiftmy")
    public suspend fun natRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natRuleName = mapped
    }

    /**
     * @param value The resource group name of the VpnGateway.
     */
    @JvmName("jpsrfvtcfaupxsuo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The type of NAT rule for VPN NAT.
     */
    @JvmName("rlohwueeqnngmwxu")
    public suspend fun type(`value`: Either<String, VpnNatRuleType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of NAT rule for VPN NAT.
     */
    @JvmName("oeigkmbshsnppbps")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VpnNatRuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of NAT rule for VPN NAT.
     */
    @JvmName("behdkvyapyoxjjlh")
    public fun type(`value`: VpnNatRuleType) {
        val toBeMapped = Either.ofRight<String, VpnNatRuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): NatRuleArgs = NatRuleArgs(
        externalMappings = externalMappings,
        gatewayName = gatewayName,
        id = id,
        internalMappings = internalMappings,
        ipConfigurationId = ipConfigurationId,
        mode = mode,
        name = name,
        natRuleName = natRuleName,
        resourceGroupName = resourceGroupName,
        type = type,
    )
}
