@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.FlowLogResponse
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceResponse
import com.pulumi.azurenative.network.kotlin.outputs.SecurityRuleResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.FlowLogResponse.Companion.toKotlin as flowLogResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceResponse.Companion.toKotlin as networkInterfaceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SecurityRuleResponse.Companion.toKotlin as securityRuleResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse.Companion.toKotlin as subnetResponseToKotlin

/**
 * Builder for [NetworkSecurityGroup].
 */
@PulumiTagMarker
public class NetworkSecurityGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkSecurityGroupArgs = NetworkSecurityGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkSecurityGroupArgsBuilder.() -> Unit) {
        val builder = NetworkSecurityGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkSecurityGroup {
        val builtJavaResource =
            com.pulumi.azurenative.network.NetworkSecurityGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NetworkSecurityGroup(builtJavaResource)
    }
}

/**
 * NetworkSecurityGroup resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2015-05-01-preview, 2016-03-30, 2019-06-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create network security group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkSecurityGroup = new AzureNative.Network.NetworkSecurityGroup("networkSecurityGroup", new()
 *     {
 *         Location = "eastus",
 *         NetworkSecurityGroupName = "testnsg",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkSecurityGroup(ctx, "networkSecurityGroup", &network.NetworkSecurityGroupArgs{
 * 			Location:                 pulumi.String("eastus"),
 * 			NetworkSecurityGroupName: pulumi.String("testnsg"),
 * 			ResourceGroupName:        pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkSecurityGroup;
 * import com.pulumi.azurenative.network.NetworkSecurityGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkSecurityGroup = new NetworkSecurityGroup("networkSecurityGroup", NetworkSecurityGroupArgs.builder()
 *             .location("eastus")
 *             .networkSecurityGroupName("testnsg")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create network security group with rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkSecurityGroup = new AzureNative.Network.NetworkSecurityGroup("networkSecurityGroup", new()
 *     {
 *         Location = "eastus",
 *         NetworkSecurityGroupName = "testnsg",
 *         ResourceGroupName = "rg1",
 *         SecurityRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.SecurityRuleArgs
 *             {
 *                 Access = AzureNative.Network.SecurityRuleAccess.Allow,
 *                 DestinationAddressPrefix = "*",
 *                 DestinationPortRange = "80",
 *                 Direction = AzureNative.Network.SecurityRuleDirection.Inbound,
 *                 Name = "rule1",
 *                 Priority = 130,
 *                 Protocol = AzureNative.Network.SecurityRuleProtocol.Asterisk,
 *                 SourceAddressPrefix = "*",
 *                 SourcePortRange = "*",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkSecurityGroup(ctx, "networkSecurityGroup", &network.NetworkSecurityGroupArgs{
 * 			Location:                 pulumi.String("eastus"),
 * 			NetworkSecurityGroupName: pulumi.String("testnsg"),
 * 			ResourceGroupName:        pulumi.String("rg1"),
 * 			SecurityRules: network.SecurityRuleTypeArray{
 * 				&network.SecurityRuleTypeArgs{
 * 					Access:                   pulumi.String(network.SecurityRuleAccessAllow),
 * 					DestinationAddressPrefix: pulumi.String("*"),
 * 					DestinationPortRange:     pulumi.String("80"),
 * 					Direction:                pulumi.String(network.SecurityRuleDirectionInbound),
 * 					Name:                     pulumi.String("rule1"),
 * 					Priority:                 pulumi.Int(130),
 * 					Protocol:                 pulumi.String(network.SecurityRuleProtocolAsterisk),
 * 					SourceAddressPrefix:      pulumi.String("*"),
 * 					SourcePortRange:          pulumi.String("*"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkSecurityGroup;
 * import com.pulumi.azurenative.network.NetworkSecurityGroupArgs;
 * import com.pulumi.azurenative.network.inputs.SecurityRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkSecurityGroup = new NetworkSecurityGroup("networkSecurityGroup", NetworkSecurityGroupArgs.builder()
 *             .location("eastus")
 *             .networkSecurityGroupName("testnsg")
 *             .resourceGroupName("rg1")
 *             .securityRules(SecurityRuleArgs.builder()
 *                 .access("Allow")
 *                 .destinationAddressPrefix("*")
 *                 .destinationPortRange("80")
 *                 .direction("Inbound")
 *                 .name("rule1")
 *                 .priority(130)
 *                 .protocol("*")
 *                 .sourceAddressPrefix("*")
 *                 .sourcePortRange("*")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NetworkSecurityGroup testnsg /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityGroups/{networkSecurityGroupName}
 * ```
 */
public class NetworkSecurityGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.network.NetworkSecurityGroup,
) : KotlinCustomResource(javaResource, NetworkSecurityGroupMapper) {
    /**
     * The default security rules of network security group.
     */
    public val defaultSecurityRules: Output<List<SecurityRuleResponse>>
        get() = javaResource.defaultSecurityRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> securityRuleResponseToKotlin(args0) })
            })
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * A collection of references to flow log resources.
     */
    public val flowLogs: Output<List<FlowLogResponse>>
        get() = javaResource.flowLogs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    flowLogResponseToKotlin(args0)
                })
            })
        })

    /**
     * When enabled, flows created from Network Security Group connections will be re-evaluated when rules are updates. Initial enablement will trigger re-evaluation.
     */
    public val flushConnection: Output<Boolean>?
        get() = javaResource.flushConnection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A collection of references to network interfaces.
     */
    public val networkInterfaces: Output<List<NetworkInterfaceResponse>>
        get() = javaResource.networkInterfaces().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkInterfaceResponseToKotlin(args0) })
            })
        })

    /**
     * The provisioning state of the network security group resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resource GUID property of the network security group resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * A collection of security rules of the network security group.
     */
    public val securityRules: Output<List<SecurityRuleResponse>>?
        get() = javaResource.securityRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        securityRuleResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A collection of references to subnets.
     */
    public val subnets: Output<List<SubnetResponse>>
        get() = javaResource.subnets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subnetResponseToKotlin(args0)
                })
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NetworkSecurityGroupMapper : ResourceMapper<NetworkSecurityGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.NetworkSecurityGroup::class == javaResource::class

    override fun map(javaResource: Resource): NetworkSecurityGroup = NetworkSecurityGroup(
        javaResource
            as com.pulumi.azurenative.network.NetworkSecurityGroup,
    )
}

/**
 * @see [NetworkSecurityGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkSecurityGroup].
 */
public suspend fun networkSecurityGroup(
    name: String,
    block: suspend NetworkSecurityGroupResourceBuilder.() -> Unit,
): NetworkSecurityGroup {
    val builder = NetworkSecurityGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkSecurityGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkSecurityGroup(name: String): NetworkSecurityGroup {
    val builder = NetworkSecurityGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
