@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.NetworkSecurityGroupArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.SecurityRuleArgs
import com.pulumi.azurenative.network.kotlin.inputs.SecurityRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * NetworkSecurityGroup resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2015-05-01-preview, 2016-03-30, 2019-06-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create network security group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkSecurityGroup = new AzureNative.Network.NetworkSecurityGroup("networkSecurityGroup", new()
 *     {
 *         Location = "eastus",
 *         NetworkSecurityGroupName = "testnsg",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkSecurityGroup(ctx, "networkSecurityGroup", &network.NetworkSecurityGroupArgs{
 * 			Location:                 pulumi.String("eastus"),
 * 			NetworkSecurityGroupName: pulumi.String("testnsg"),
 * 			ResourceGroupName:        pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkSecurityGroup;
 * import com.pulumi.azurenative.network.NetworkSecurityGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkSecurityGroup = new NetworkSecurityGroup("networkSecurityGroup", NetworkSecurityGroupArgs.builder()
 *             .location("eastus")
 *             .networkSecurityGroupName("testnsg")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create network security group with rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkSecurityGroup = new AzureNative.Network.NetworkSecurityGroup("networkSecurityGroup", new()
 *     {
 *         Location = "eastus",
 *         NetworkSecurityGroupName = "testnsg",
 *         ResourceGroupName = "rg1",
 *         SecurityRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.SecurityRuleArgs
 *             {
 *                 Access = AzureNative.Network.SecurityRuleAccess.Allow,
 *                 DestinationAddressPrefix = "*",
 *                 DestinationPortRange = "80",
 *                 Direction = AzureNative.Network.SecurityRuleDirection.Inbound,
 *                 Name = "rule1",
 *                 Priority = 130,
 *                 Protocol = AzureNative.Network.SecurityRuleProtocol.Asterisk,
 *                 SourceAddressPrefix = "*",
 *                 SourcePortRange = "*",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkSecurityGroup(ctx, "networkSecurityGroup", &network.NetworkSecurityGroupArgs{
 * 			Location:                 pulumi.String("eastus"),
 * 			NetworkSecurityGroupName: pulumi.String("testnsg"),
 * 			ResourceGroupName:        pulumi.String("rg1"),
 * 			SecurityRules: network.SecurityRuleTypeArray{
 * 				&network.SecurityRuleTypeArgs{
 * 					Access:                   pulumi.String(network.SecurityRuleAccessAllow),
 * 					DestinationAddressPrefix: pulumi.String("*"),
 * 					DestinationPortRange:     pulumi.String("80"),
 * 					Direction:                pulumi.String(network.SecurityRuleDirectionInbound),
 * 					Name:                     pulumi.String("rule1"),
 * 					Priority:                 pulumi.Int(130),
 * 					Protocol:                 pulumi.String(network.SecurityRuleProtocolAsterisk),
 * 					SourceAddressPrefix:      pulumi.String("*"),
 * 					SourcePortRange:          pulumi.String("*"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkSecurityGroup;
 * import com.pulumi.azurenative.network.NetworkSecurityGroupArgs;
 * import com.pulumi.azurenative.network.inputs.SecurityRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkSecurityGroup = new NetworkSecurityGroup("networkSecurityGroup", NetworkSecurityGroupArgs.builder()
 *             .location("eastus")
 *             .networkSecurityGroupName("testnsg")
 *             .resourceGroupName("rg1")
 *             .securityRules(SecurityRuleArgs.builder()
 *                 .access("Allow")
 *                 .destinationAddressPrefix("*")
 *                 .destinationPortRange("80")
 *                 .direction("Inbound")
 *                 .name("rule1")
 *                 .priority(130)
 *                 .protocol("*")
 *                 .sourceAddressPrefix("*")
 *                 .sourcePortRange("*")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NetworkSecurityGroup testnsg /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityGroups/{networkSecurityGroupName}
 * ```
 * @property flushConnection When enabled, flows created from Network Security Group connections will be re-evaluated when rules are updates. Initial enablement will trigger re-evaluation.
 * @property id Resource ID.
 * @property location Resource location.
 * @property networkSecurityGroupName The name of the network security group.
 * @property resourceGroupName The name of the resource group.
 * @property securityRules A collection of security rules of the network security group.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property tags Resource tags.
 */
public data class NetworkSecurityGroupArgs(
    public val flushConnection: Output<Boolean>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val networkSecurityGroupName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val securityRules: Output<List<SecurityRuleArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.NetworkSecurityGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.network.NetworkSecurityGroupArgs =
        com.pulumi.azurenative.network.NetworkSecurityGroupArgs.builder()
            .flushConnection(flushConnection?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkSecurityGroupName(networkSecurityGroupName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .securityRules(
                securityRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NetworkSecurityGroupArgs].
 */
@PulumiTagMarker
public class NetworkSecurityGroupArgsBuilder internal constructor() {
    private var flushConnection: Output<Boolean>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var networkSecurityGroupName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var securityRules: Output<List<SecurityRuleArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value When enabled, flows created from Network Security Group connections will be re-evaluated when rules are updates. Initial enablement will trigger re-evaluation.
     */
    @JvmName("uwanwytkehwaamlg")
    public suspend fun flushConnection(`value`: Output<Boolean>) {
        this.flushConnection = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("osrswrxdkhubdpgy")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("dmsfcaghjlplwybd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the network security group.
     */
    @JvmName("ewbdcxpknvexogfw")
    public suspend fun networkSecurityGroupName(`value`: Output<String>) {
        this.networkSecurityGroupName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pkijvabikxhedrds")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value A collection of security rules of the network security group.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("mouscdxjqospncww")
    public suspend fun securityRules(`value`: Output<List<SecurityRuleArgs>>) {
        this.securityRules = value
    }

    @JvmName("qdleccdhpxrdwtdw")
    public suspend fun securityRules(vararg values: Output<SecurityRuleArgs>) {
        this.securityRules = Output.all(values.asList())
    }

    /**
     * @param values A collection of security rules of the network security group.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("uojtcjnecnklxcsn")
    public suspend fun securityRules(values: List<Output<SecurityRuleArgs>>) {
        this.securityRules = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("auwcqmihohgegddp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value When enabled, flows created from Network Security Group connections will be re-evaluated when rules are updates. Initial enablement will trigger re-evaluation.
     */
    @JvmName("iytjtkjnjxdiybnu")
    public suspend fun flushConnection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flushConnection = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ctgevjnqvwgpttpd")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("rsftgcmiljbvuwdi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the network security group.
     */
    @JvmName("lyabmkojntjteugj")
    public suspend fun networkSecurityGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSecurityGroupName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("tldwngdqdunmuivf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value A collection of security rules of the network security group.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("gaknutkydgdmvkri")
    public suspend fun securityRules(`value`: List<SecurityRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityRules = mapped
    }

    /**
     * @param argument A collection of security rules of the network security group.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("aoixfruvwyvyihpl")
    public suspend fun securityRules(argument: List<suspend SecurityRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SecurityRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.securityRules = mapped
    }

    /**
     * @param argument A collection of security rules of the network security group.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("hfrbmjypfgehnqnh")
    public suspend fun securityRules(vararg argument: suspend SecurityRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SecurityRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.securityRules = mapped
    }

    /**
     * @param argument A collection of security rules of the network security group.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("jjbntllrdtquaocg")
    public suspend fun securityRules(argument: suspend SecurityRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SecurityRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.securityRules = mapped
    }

    /**
     * @param values A collection of security rules of the network security group.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("mlqdgaeujkibrtjq")
    public suspend fun securityRules(vararg values: SecurityRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityRules = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fnkuodcsoflgqrtp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jojvvodaepyuwooy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NetworkSecurityGroupArgs = NetworkSecurityGroupArgs(
        flushConnection = flushConnection,
        id = id,
        location = location,
        networkSecurityGroupName = networkSecurityGroupName,
        resourceGroupName = resourceGroupName,
        securityRules = securityRules,
        tags = tags,
    )
}
