@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [NetworkSecurityPerimeter].
 */
@PulumiTagMarker
public class NetworkSecurityPerimeterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkSecurityPerimeterArgs = NetworkSecurityPerimeterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkSecurityPerimeterArgsBuilder.() -> Unit) {
        val builder = NetworkSecurityPerimeterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkSecurityPerimeter {
        val builtJavaResource =
            com.pulumi.azurenative.network.NetworkSecurityPerimeter(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NetworkSecurityPerimeter(builtJavaResource)
    }
}

/**
 * The Network Security Perimeter resource
 * Azure REST API version: 2021-03-01-preview. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2021-02-01-preview, 2023-07-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Put Network Security Perimeter
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkSecurityPerimeter = new AzureNative.Network.NetworkSecurityPerimeter("networkSecurityPerimeter", new()
 *     {
 *         Description = "Description of TestNetworkSecurityPerimeter",
 *         DisplayName = "TestNetworkSecurityPerimeter",
 *         NetworkSecurityPerimeterName = "nsp1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkSecurityPerimeter(ctx, "networkSecurityPerimeter", &network.NetworkSecurityPerimeterArgs{
 * 			Description:                  pulumi.String("Description of TestNetworkSecurityPerimeter"),
 * 			DisplayName:                  pulumi.String("TestNetworkSecurityPerimeter"),
 * 			NetworkSecurityPerimeterName: pulumi.String("nsp1"),
 * 			ResourceGroupName:            pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkSecurityPerimeter;
 * import com.pulumi.azurenative.network.NetworkSecurityPerimeterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkSecurityPerimeter = new NetworkSecurityPerimeter("networkSecurityPerimeter", NetworkSecurityPerimeterArgs.builder()
 *             .description("Description of TestNetworkSecurityPerimeter")
 *             .displayName("TestNetworkSecurityPerimeter")
 *             .networkSecurityPerimeterName("nsp1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NetworkSecurityPerimeter TestNetworkSecurityPerimeter /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}
 * ```
 */
public class NetworkSecurityPerimeter internal constructor(
    override val javaResource: com.pulumi.azurenative.network.NetworkSecurityPerimeter,
) : KotlinCustomResource(javaResource, NetworkSecurityPerimeterMapper) {
    /**
     * A description of the network security perimeter.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A friendly name for the network security perimeter.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the scope assignment resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NetworkSecurityPerimeterMapper : ResourceMapper<NetworkSecurityPerimeter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.NetworkSecurityPerimeter::class == javaResource::class

    override fun map(javaResource: Resource): NetworkSecurityPerimeter =
        NetworkSecurityPerimeter(
            javaResource as
                com.pulumi.azurenative.network.NetworkSecurityPerimeter,
        )
}

/**
 * @see [NetworkSecurityPerimeter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkSecurityPerimeter].
 */
public suspend fun networkSecurityPerimeter(
    name: String,
    block: suspend NetworkSecurityPerimeterResourceBuilder.() -> Unit,
): NetworkSecurityPerimeter {
    val builder = NetworkSecurityPerimeterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkSecurityPerimeter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkSecurityPerimeter(name: String): NetworkSecurityPerimeter {
    val builder = NetworkSecurityPerimeterResourceBuilder()
    builder.name(name)
    return builder.build()
}
