@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.DelegationPropertiesResponse
import com.pulumi.azurenative.network.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.network.kotlin.outputs.PartnerManagedResourcePropertiesResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.VirtualApplianceAdditionalNicPropertiesResponse
import com.pulumi.azurenative.network.kotlin.outputs.VirtualApplianceNicPropertiesResponse
import com.pulumi.azurenative.network.kotlin.outputs.VirtualApplianceSkuPropertiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.DelegationPropertiesResponse.Companion.toKotlin as delegationPropertiesResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PartnerManagedResourcePropertiesResponse.Companion.toKotlin as partnerManagedResourcePropertiesResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VirtualApplianceAdditionalNicPropertiesResponse.Companion.toKotlin as virtualApplianceAdditionalNicPropertiesResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VirtualApplianceNicPropertiesResponse.Companion.toKotlin as virtualApplianceNicPropertiesResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VirtualApplianceSkuPropertiesResponse.Companion.toKotlin as virtualApplianceSkuPropertiesResponseToKotlin

/**
 * Builder for [NetworkVirtualAppliance].
 */
@PulumiTagMarker
public class NetworkVirtualApplianceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkVirtualApplianceArgs = NetworkVirtualApplianceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkVirtualApplianceArgsBuilder.() -> Unit) {
        val builder = NetworkVirtualApplianceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkVirtualAppliance {
        val builtJavaResource =
            com.pulumi.azurenative.network.NetworkVirtualAppliance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NetworkVirtualAppliance(builtJavaResource)
    }
}

/**
 * NetworkVirtualAppliance Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2020-04-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create SaaS NetworkVirtualAppliance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkVirtualAppliance = new AzureNative.Network.NetworkVirtualAppliance("networkVirtualAppliance", new()
 *     {
 *         Delegation = new AzureNative.Network.Inputs.DelegationPropertiesArgs
 *         {
 *             ServiceName = "PaloAltoNetworks.Cloudngfw/firewalls",
 *         },
 *         Location = "West US",
 *         NetworkVirtualApplianceName = "nva",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         VirtualHub = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkVirtualAppliance(ctx, "networkVirtualAppliance", &network.NetworkVirtualApplianceArgs{
 * 			Delegation: &network.DelegationPropertiesArgs{
 * 				ServiceName: pulumi.String("PaloAltoNetworks.Cloudngfw/firewalls"),
 * 			},
 * 			Location:                    pulumi.String("West US"),
 * 			NetworkVirtualApplianceName: pulumi.String("nva"),
 * 			ResourceGroupName:           pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			VirtualHub: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkVirtualAppliance;
 * import com.pulumi.azurenative.network.NetworkVirtualApplianceArgs;
 * import com.pulumi.azurenative.network.inputs.DelegationPropertiesArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkVirtualAppliance = new NetworkVirtualAppliance("networkVirtualAppliance", NetworkVirtualApplianceArgs.builder()
 *             .delegation(DelegationPropertiesArgs.builder()
 *                 .serviceName("PaloAltoNetworks.Cloudngfw/firewalls")
 *                 .build())
 *             .location("West US")
 *             .networkVirtualApplianceName("nva")
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "value1"))
 *             .virtualHub(SubResourceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NetworkVirtualAppliance nva /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkVirtualAppliances/{networkVirtualApplianceName}
 * ```
 */
public class NetworkVirtualAppliance internal constructor(
    override val javaResource: com.pulumi.azurenative.network.NetworkVirtualAppliance,
) : KotlinCustomResource(javaResource, NetworkVirtualApplianceMapper) {
    /**
     * Details required for Additional Network Interface.
     */
    public val additionalNics: Output<List<VirtualApplianceAdditionalNicPropertiesResponse>>?
        get() = javaResource.additionalNics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        virtualApplianceAdditionalNicPropertiesResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Address Prefix.
     */
    public val addressPrefix: Output<String>
        get() = javaResource.addressPrefix().applyValue({ args0 -> args0 })

    /**
     * BootStrapConfigurationBlobs storage URLs.
     */
    public val bootStrapConfigurationBlobs: Output<List<String>>?
        get() = javaResource.bootStrapConfigurationBlobs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * CloudInitConfiguration string in plain text.
     */
    public val cloudInitConfiguration: Output<String>?
        get() = javaResource.cloudInitConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * CloudInitConfigurationBlob storage URLs.
     */
    public val cloudInitConfigurationBlobs: Output<List<String>>?
        get() = javaResource.cloudInitConfigurationBlobs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The delegation for the Virtual Appliance
     */
    public val delegation: Output<DelegationPropertiesResponse>?
        get() = javaResource.delegation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    delegationPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The deployment type. PartnerManaged for the SaaS NVA
     */
    public val deploymentType: Output<String>
        get() = javaResource.deploymentType().applyValue({ args0 -> args0 })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The service principal that has read access to cloud-init and config blob.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of references to InboundSecurityRules.
     */
    public val inboundSecurityRules: Output<List<SubResourceResponse>>
        get() = javaResource.inboundSecurityRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            })
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network Virtual Appliance SKU.
     */
    public val nvaSku: Output<VirtualApplianceSkuPropertiesResponse>?
        get() = javaResource.nvaSku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualApplianceSkuPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The delegation for the Virtual Appliance
     */
    public val partnerManagedResource: Output<PartnerManagedResourcePropertiesResponse>?
        get() = javaResource.partnerManagedResource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    partnerManagedResourcePropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Public key for SSH login.
     */
    public val sshPublicKey: Output<String>?
        get() = javaResource.sshPublicKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * VirtualAppliance ASN. Microsoft private, public and IANA reserved ASN are not supported.
     */
    public val virtualApplianceAsn: Output<Double>?
        get() = javaResource.virtualApplianceAsn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of Virtual Appliance Network Interfaces.
     */
    public val virtualApplianceNics: Output<List<VirtualApplianceNicPropertiesResponse>>
        get() = javaResource.virtualApplianceNics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> virtualApplianceNicPropertiesResponseToKotlin(args0) })
            })
        })

    /**
     * List of references to VirtualApplianceSite.
     */
    public val virtualApplianceSites: Output<List<SubResourceResponse>>
        get() = javaResource.virtualApplianceSites().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            })
        })

    /**
     * The Virtual Hub where Network Virtual Appliance is being deployed.
     */
    public val virtualHub: Output<SubResourceResponse>?
        get() = javaResource.virtualHub().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subResourceResponseToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object NetworkVirtualApplianceMapper : ResourceMapper<NetworkVirtualAppliance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.NetworkVirtualAppliance::class == javaResource::class

    override fun map(javaResource: Resource): NetworkVirtualAppliance =
        NetworkVirtualAppliance(
            javaResource as
                com.pulumi.azurenative.network.NetworkVirtualAppliance,
        )
}

/**
 * @see [NetworkVirtualAppliance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkVirtualAppliance].
 */
public suspend fun networkVirtualAppliance(
    name: String,
    block: suspend NetworkVirtualApplianceResourceBuilder.() -> Unit,
): NetworkVirtualAppliance {
    val builder = NetworkVirtualApplianceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkVirtualAppliance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkVirtualAppliance(name: String): NetworkVirtualAppliance {
    val builder = NetworkVirtualApplianceResourceBuilder()
    builder.name(name)
    return builder.build()
}
