@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [NetworkWatcher].
 */
@PulumiTagMarker
public class NetworkWatcherResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkWatcherArgs = NetworkWatcherArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkWatcherArgsBuilder.() -> Unit) {
        val builder = NetworkWatcherArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkWatcher {
        val builtJavaResource = com.pulumi.azurenative.network.NetworkWatcher(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NetworkWatcher(builtJavaResource)
    }
}

/**
 * Network watcher in a resource group.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2018-01-01, 2022-05-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create network watcher
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkWatcher = new AzureNative.Network.NetworkWatcher("networkWatcher", new()
 *     {
 *         Location = "eastus",
 *         NetworkWatcherName = "nw1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkWatcher(ctx, "networkWatcher", &network.NetworkWatcherArgs{
 * 			Location:           pulumi.String("eastus"),
 * 			NetworkWatcherName: pulumi.String("nw1"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkWatcher;
 * import com.pulumi.azurenative.network.NetworkWatcherArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkWatcher = new NetworkWatcher("networkWatcher", NetworkWatcherArgs.builder()
 *             .location("eastus")
 *             .networkWatcherName("nw1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NetworkWatcher nw1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}
 * ```
 */
public class NetworkWatcher internal constructor(
    override val javaResource: com.pulumi.azurenative.network.NetworkWatcher,
) : KotlinCustomResource(javaResource, NetworkWatcherMapper) {
    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the network watcher resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NetworkWatcherMapper : ResourceMapper<NetworkWatcher> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.NetworkWatcher::class == javaResource::class

    override fun map(javaResource: Resource): NetworkWatcher = NetworkWatcher(
        javaResource as
            com.pulumi.azurenative.network.NetworkWatcher,
    )
}

/**
 * @see [NetworkWatcher].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkWatcher].
 */
public suspend fun networkWatcher(
    name: String,
    block: suspend NetworkWatcherResourceBuilder.() -> Unit,
): NetworkWatcher {
    val builder = NetworkWatcherResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkWatcher].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkWatcher(name: String): NetworkWatcher {
    val builder = NetworkWatcherResourceBuilder()
    builder.name(name)
    return builder.build()
}
