@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [NspAssociation].
 */
@PulumiTagMarker
public class NspAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NspAssociationArgs = NspAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NspAssociationArgsBuilder.() -> Unit) {
        val builder = NspAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NspAssociation {
        val builtJavaResource = com.pulumi.azurenative.network.NspAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NspAssociation(builtJavaResource)
    }
}

/**
 * The NSP resource association resource
 * Azure REST API version: 2021-02-01-preview. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### NspAssociationPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nspAssociation = new AzureNative.Network.NspAssociation("nspAssociation", new()
 *     {
 *         AccessMode = AzureNative.Network.AssociationAccessMode.Enforced,
 *         AssociationName = "association1",
 *         NetworkSecurityPerimeterName = "nsp1",
 *         PrivateLinkResource = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/{paasSubscriptionId}/resourceGroups/{paasResourceGroupName}/providers/{providerName}/{resourceType}/{resourceName}",
 *         },
 *         Profile = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityPerimeters/nsp1/profiles/{profileName}",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNspAssociation(ctx, "nspAssociation", &network.NspAssociationArgs{
 * 			AccessMode:                   pulumi.String(network.AssociationAccessModeEnforced),
 * 			AssociationName:              pulumi.String("association1"),
 * 			NetworkSecurityPerimeterName: pulumi.String("nsp1"),
 * 			PrivateLinkResource: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/{paasSubscriptionId}/resourceGroups/{paasResourceGroupName}/providers/{providerName}/{resourceType}/{resourceName}"),
 * 			},
 * 			Profile: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityPerimeters/nsp1/profiles/{profileName}"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NspAssociation;
 * import com.pulumi.azurenative.network.NspAssociationArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nspAssociation = new NspAssociation("nspAssociation", NspAssociationArgs.builder()
 *             .accessMode("Enforced")
 *             .associationName("association1")
 *             .networkSecurityPerimeterName("nsp1")
 *             .privateLinkResource(SubResourceArgs.builder()
 *                 .id("/subscriptions/{paasSubscriptionId}/resourceGroups/{paasResourceGroupName}/providers/{providerName}/{resourceType}/{resourceName}")
 *                 .build())
 *             .profile(SubResourceArgs.builder()
 *                 .id("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityPerimeters/nsp1/profiles/{profileName}")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NspAssociation association1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}/resourceAssociations/{associationName}
 * ```
 */
public class NspAssociation internal constructor(
    override val javaResource: com.pulumi.azurenative.network.NspAssociation,
) : KotlinCustomResource(javaResource, NspAssociationMapper) {
    /**
     * Access mode on the association.
     */
    public val accessMode: Output<String>?
        get() = javaResource.accessMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies if there are provisioning issues
     */
    public val hasProvisioningIssues: Output<String>
        get() = javaResource.hasProvisioningIssues().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The PaaS resource to be associated.
     */
    public val privateLinkResource: Output<SubResourceResponse>?
        get() = javaResource.privateLinkResource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Profile id to which the PaaS resource is associated.
     */
    public val profile: Output<SubResourceResponse>?
        get() = javaResource.profile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the resource  association resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NspAssociationMapper : ResourceMapper<NspAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.NspAssociation::class == javaResource::class

    override fun map(javaResource: Resource): NspAssociation = NspAssociation(
        javaResource as
            com.pulumi.azurenative.network.NspAssociation,
    )
}

/**
 * @see [NspAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NspAssociation].
 */
public suspend fun nspAssociation(
    name: String,
    block: suspend NspAssociationResourceBuilder.() -> Unit,
): NspAssociation {
    val builder = NspAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NspAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun nspAssociation(name: String): NspAssociation {
    val builder = NspAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
