@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.NspAssociationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.AssociationAccessMode
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The NSP resource association resource
 * Azure REST API version: 2021-02-01-preview. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### NspAssociationPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nspAssociation = new AzureNative.Network.NspAssociation("nspAssociation", new()
 *     {
 *         AccessMode = AzureNative.Network.AssociationAccessMode.Enforced,
 *         AssociationName = "association1",
 *         NetworkSecurityPerimeterName = "nsp1",
 *         PrivateLinkResource = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/{paasSubscriptionId}/resourceGroups/{paasResourceGroupName}/providers/{providerName}/{resourceType}/{resourceName}",
 *         },
 *         Profile = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityPerimeters/nsp1/profiles/{profileName}",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNspAssociation(ctx, "nspAssociation", &network.NspAssociationArgs{
 * 			AccessMode:                   pulumi.String(network.AssociationAccessModeEnforced),
 * 			AssociationName:              pulumi.String("association1"),
 * 			NetworkSecurityPerimeterName: pulumi.String("nsp1"),
 * 			PrivateLinkResource: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/{paasSubscriptionId}/resourceGroups/{paasResourceGroupName}/providers/{providerName}/{resourceType}/{resourceName}"),
 * 			},
 * 			Profile: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityPerimeters/nsp1/profiles/{profileName}"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NspAssociation;
 * import com.pulumi.azurenative.network.NspAssociationArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nspAssociation = new NspAssociation("nspAssociation", NspAssociationArgs.builder()
 *             .accessMode("Enforced")
 *             .associationName("association1")
 *             .networkSecurityPerimeterName("nsp1")
 *             .privateLinkResource(SubResourceArgs.builder()
 *                 .id("/subscriptions/{paasSubscriptionId}/resourceGroups/{paasResourceGroupName}/providers/{providerName}/{resourceType}/{resourceName}")
 *                 .build())
 *             .profile(SubResourceArgs.builder()
 *                 .id("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityPerimeters/nsp1/profiles/{profileName}")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NspAssociation association1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}/resourceAssociations/{associationName}
 * ```
 * @property accessMode Access mode on the association.
 * @property associationName The name of the NSP association.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property networkSecurityPerimeterName The name of the network security perimeter.
 * @property privateLinkResource The PaaS resource to be associated.
 * @property profile Profile id to which the PaaS resource is associated.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 */
public data class NspAssociationArgs(
    public val accessMode: Output<Either<String, AssociationAccessMode>>? = null,
    public val associationName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val networkSecurityPerimeterName: Output<String>? = null,
    public val privateLinkResource: Output<SubResourceArgs>? = null,
    public val profile: Output<SubResourceArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.NspAssociationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.NspAssociationArgs =
        com.pulumi.azurenative.network.NspAssociationArgs.builder()
            .accessMode(
                accessMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .associationName(associationName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkSecurityPerimeterName(networkSecurityPerimeterName?.applyValue({ args0 -> args0 }))
            .privateLinkResource(
                privateLinkResource?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .profile(profile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NspAssociationArgs].
 */
@PulumiTagMarker
public class NspAssociationArgsBuilder internal constructor() {
    private var accessMode: Output<Either<String, AssociationAccessMode>>? = null

    private var associationName: Output<String>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var networkSecurityPerimeterName: Output<String>? = null

    private var privateLinkResource: Output<SubResourceArgs>? = null

    private var profile: Output<SubResourceArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Access mode on the association.
     */
    @JvmName("teihghkxhcwaswyh")
    public suspend fun accessMode(`value`: Output<Either<String, AssociationAccessMode>>) {
        this.accessMode = value
    }

    /**
     * @param value The name of the NSP association.
     */
    @JvmName("cbqfkqhjicjcjher")
    public suspend fun associationName(`value`: Output<String>) {
        this.associationName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("drujpyccaaeakxdf")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("oywidqkvrqrdbmuo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("dlebovumdjbmwecr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the network security perimeter.
     */
    @JvmName("ypokhidciwpmncom")
    public suspend fun networkSecurityPerimeterName(`value`: Output<String>) {
        this.networkSecurityPerimeterName = value
    }

    /**
     * @param value The PaaS resource to be associated.
     */
    @JvmName("xldxnuarbtniaxuj")
    public suspend fun privateLinkResource(`value`: Output<SubResourceArgs>) {
        this.privateLinkResource = value
    }

    /**
     * @param value Profile id to which the PaaS resource is associated.
     */
    @JvmName("gxyaiajakiqcbedk")
    public suspend fun profile(`value`: Output<SubResourceArgs>) {
        this.profile = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("obqmnqjukaukunun")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("auacjjhplqxoiakl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Access mode on the association.
     */
    @JvmName("jdcccxohcfbjbawx")
    public suspend fun accessMode(`value`: Either<String, AssociationAccessMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessMode = mapped
    }

    /**
     * @param value Access mode on the association.
     */
    @JvmName("kjdpdkndpuynottj")
    public fun accessMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssociationAccessMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessMode = mapped
    }

    /**
     * @param value Access mode on the association.
     */
    @JvmName("snactfceepxjcwhe")
    public fun accessMode(`value`: AssociationAccessMode) {
        val toBeMapped = Either.ofRight<String, AssociationAccessMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessMode = mapped
    }

    /**
     * @param value The name of the NSP association.
     */
    @JvmName("uopxqoiwadqtldlg")
    public suspend fun associationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associationName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("jualrwiqmqolobdh")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("tkbighonxahmgehj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("fvdxgbjqqgjhywyf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the network security perimeter.
     */
    @JvmName("lpbelgjknbtuuvcx")
    public suspend fun networkSecurityPerimeterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSecurityPerimeterName = mapped
    }

    /**
     * @param value The PaaS resource to be associated.
     */
    @JvmName("mrrhxbuyrbojlvjv")
    public suspend fun privateLinkResource(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkResource = mapped
    }

    /**
     * @param argument The PaaS resource to be associated.
     */
    @JvmName("xgqsqwvnfxvtfdfw")
    public suspend fun privateLinkResource(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateLinkResource = mapped
    }

    /**
     * @param value Profile id to which the PaaS resource is associated.
     */
    @JvmName("wtubnuvqicgxbfor")
    public suspend fun profile(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profile = mapped
    }

    /**
     * @param argument Profile id to which the PaaS resource is associated.
     */
    @JvmName("ucoxdbnqnwrtilbd")
    public suspend fun profile(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.profile = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("uwxwhghnmolpnnfx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("giuskosbuhndhtkg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("mlojptgkhnxgkkki")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NspAssociationArgs = NspAssociationArgs(
        accessMode = accessMode,
        associationName = associationName,
        id = id,
        location = location,
        name = name,
        networkSecurityPerimeterName = networkSecurityPerimeterName,
        privateLinkResource = privateLinkResource,
        profile = profile,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
