@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.NspLinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The network security perimeter link resource
 * Azure REST API version: 2021-02-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### NspLinksPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nspLink = new AzureNative.Network.NspLink("nspLink", new()
 *     {
 *         AutoApprovedRemotePerimeterResourceId = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityPerimeters/nsp2",
 *         LinkName = "link1",
 *         NetworkSecurityPerimeterName = "nsp1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNspLink(ctx, "nspLink", &network.NspLinkArgs{
 * 			AutoApprovedRemotePerimeterResourceId: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityPerimeters/nsp2"),
 * 			LinkName:                              pulumi.String("link1"),
 * 			NetworkSecurityPerimeterName:          pulumi.String("nsp1"),
 * 			ResourceGroupName:                     pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NspLink;
 * import com.pulumi.azurenative.network.NspLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nspLink = new NspLink("nspLink", NspLinkArgs.builder()
 *             .autoApprovedRemotePerimeterResourceId("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityPerimeters/nsp2")
 *             .linkName("link1")
 *             .networkSecurityPerimeterName("nsp1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NspLink link1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}/links/{linkName}
 * ```
 * @property autoApprovedRemotePerimeterResourceId Perimeter ARM Id for the remote NSP with which the link gets created in Auto-approval mode. It should be used when the NSP admin have Microsoft.Network/networkSecurityPerimeters/linkPerimeter/action permission on the remote NSP resource.
 * @property description A message passed to the owner of the remote NSP link resource with this connection request. In case of Auto-approved flow, it is default to 'Auto Approved'. Restricted to 140 chars.
 * @property linkName The name of the NSP link.
 * @property localInboundProfiles Local Inbound profile names to which Inbound is allowed. Use ['*'] to allow inbound to all profiles&#46; It's default value is ['*'].
 * @property networkSecurityPerimeterName The name of the network security perimeter.
 * @property remoteInboundProfiles Remote Inbound profile names to which Inbound is allowed. Use ['*'] to allow inbound to all profiles&#46; This property can only be updated in auto-approval mode&#46; It's default value is ['*'].
 * @property resourceGroupName The name of the resource group.
 */
public data class NspLinkArgs(
    public val autoApprovedRemotePerimeterResourceId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val linkName: Output<String>? = null,
    public val localInboundProfiles: Output<List<String>>? = null,
    public val networkSecurityPerimeterName: Output<String>? = null,
    public val remoteInboundProfiles: Output<List<String>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.NspLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.network.NspLinkArgs =
        com.pulumi.azurenative.network.NspLinkArgs.builder()
            .autoApprovedRemotePerimeterResourceId(
                autoApprovedRemotePerimeterResourceId?.applyValue({ args0 ->
                    args0
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .linkName(linkName?.applyValue({ args0 -> args0 }))
            .localInboundProfiles(localInboundProfiles?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .networkSecurityPerimeterName(networkSecurityPerimeterName?.applyValue({ args0 -> args0 }))
            .remoteInboundProfiles(remoteInboundProfiles?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NspLinkArgs].
 */
@PulumiTagMarker
public class NspLinkArgsBuilder internal constructor() {
    private var autoApprovedRemotePerimeterResourceId: Output<String>? = null

    private var description: Output<String>? = null

    private var linkName: Output<String>? = null

    private var localInboundProfiles: Output<List<String>>? = null

    private var networkSecurityPerimeterName: Output<String>? = null

    private var remoteInboundProfiles: Output<List<String>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Perimeter ARM Id for the remote NSP with which the link gets created in Auto-approval mode. It should be used when the NSP admin have Microsoft.Network/networkSecurityPerimeters/linkPerimeter/action permission on the remote NSP resource.
     */
    @JvmName("qhwpmupuyjesafkq")
    public suspend fun autoApprovedRemotePerimeterResourceId(`value`: Output<String>) {
        this.autoApprovedRemotePerimeterResourceId = value
    }

    /**
     * @param value A message passed to the owner of the remote NSP link resource with this connection request. In case of Auto-approved flow, it is default to 'Auto Approved'. Restricted to 140 chars.
     */
    @JvmName("yabwljhtmnelgueb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the NSP link.
     */
    @JvmName("yyfodvdvfnnlcaxn")
    public suspend fun linkName(`value`: Output<String>) {
        this.linkName = value
    }

    /**
     * @param value Local Inbound profile names to which Inbound is allowed. Use ['*'] to allow inbound to all profiles&#46; It's default value is ['*'].
     */
    @JvmName("nqpvgpeaqisehoxb")
    public suspend fun localInboundProfiles(`value`: Output<List<String>>) {
        this.localInboundProfiles = value
    }

    @JvmName("ndbpcgssxvbllgkv")
    public suspend fun localInboundProfiles(vararg values: Output<String>) {
        this.localInboundProfiles = Output.all(values.asList())
    }

    /**
     * @param values Local Inbound profile names to which Inbound is allowed. Use ['*'] to allow inbound to all profiles&#46; It's default value is ['*'].
     */
    @JvmName("gfelwiavnurxfsjr")
    public suspend fun localInboundProfiles(values: List<Output<String>>) {
        this.localInboundProfiles = Output.all(values)
    }

    /**
     * @param value The name of the network security perimeter.
     */
    @JvmName("ybathmqvkjigbwiv")
    public suspend fun networkSecurityPerimeterName(`value`: Output<String>) {
        this.networkSecurityPerimeterName = value
    }

    /**
     * @param value Remote Inbound profile names to which Inbound is allowed. Use ['*'] to allow inbound to all profiles&#46; This property can only be updated in auto-approval mode&#46; It's default value is ['*'].
     */
    @JvmName("uwtoyceyfdcxgtuh")
    public suspend fun remoteInboundProfiles(`value`: Output<List<String>>) {
        this.remoteInboundProfiles = value
    }

    @JvmName("wecgjxnhsegrxjix")
    public suspend fun remoteInboundProfiles(vararg values: Output<String>) {
        this.remoteInboundProfiles = Output.all(values.asList())
    }

    /**
     * @param values Remote Inbound profile names to which Inbound is allowed. Use ['*'] to allow inbound to all profiles&#46; This property can only be updated in auto-approval mode&#46; It's default value is ['*'].
     */
    @JvmName("egqbxbjgqewkiniu")
    public suspend fun remoteInboundProfiles(values: List<Output<String>>) {
        this.remoteInboundProfiles = Output.all(values)
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ekmpocjxrslesmpe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Perimeter ARM Id for the remote NSP with which the link gets created in Auto-approval mode. It should be used when the NSP admin have Microsoft.Network/networkSecurityPerimeters/linkPerimeter/action permission on the remote NSP resource.
     */
    @JvmName("rgkxxibwkctqylpd")
    public suspend fun autoApprovedRemotePerimeterResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoApprovedRemotePerimeterResourceId = mapped
    }

    /**
     * @param value A message passed to the owner of the remote NSP link resource with this connection request. In case of Auto-approved flow, it is default to 'Auto Approved'. Restricted to 140 chars.
     */
    @JvmName("rgtdbsxtvehogyag")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the NSP link.
     */
    @JvmName("dcwejhbtaqmhjksk")
    public suspend fun linkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkName = mapped
    }

    /**
     * @param value Local Inbound profile names to which Inbound is allowed. Use ['*'] to allow inbound to all profiles&#46; It's default value is ['*'].
     */
    @JvmName("amftwiucwohinnfa")
    public suspend fun localInboundProfiles(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localInboundProfiles = mapped
    }

    /**
     * @param values Local Inbound profile names to which Inbound is allowed. Use ['*'] to allow inbound to all profiles&#46; It's default value is ['*'].
     */
    @JvmName("crymmelbgylotlik")
    public suspend fun localInboundProfiles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localInboundProfiles = mapped
    }

    /**
     * @param value The name of the network security perimeter.
     */
    @JvmName("aocxhrdjkegoeohn")
    public suspend fun networkSecurityPerimeterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSecurityPerimeterName = mapped
    }

    /**
     * @param value Remote Inbound profile names to which Inbound is allowed. Use ['*'] to allow inbound to all profiles&#46; This property can only be updated in auto-approval mode&#46; It's default value is ['*'].
     */
    @JvmName("enrlgraligdjvkrc")
    public suspend fun remoteInboundProfiles(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteInboundProfiles = mapped
    }

    /**
     * @param values Remote Inbound profile names to which Inbound is allowed. Use ['*'] to allow inbound to all profiles&#46; This property can only be updated in auto-approval mode&#46; It's default value is ['*'].
     */
    @JvmName("atajohomefaouvmv")
    public suspend fun remoteInboundProfiles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.remoteInboundProfiles = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("gtbyedkytknshduv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): NspLinkArgs = NspLinkArgs(
        autoApprovedRemotePerimeterResourceId = autoApprovedRemotePerimeterResourceId,
        description = description,
        linkName = linkName,
        localInboundProfiles = localInboundProfiles,
        networkSecurityPerimeterName = networkSecurityPerimeterName,
        remoteInboundProfiles = remoteInboundProfiles,
        resourceGroupName = resourceGroupName,
    )
}
