@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [NspProfile].
 */
@PulumiTagMarker
public class NspProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NspProfileArgs = NspProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NspProfileArgsBuilder.() -> Unit) {
        val builder = NspProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NspProfile {
        val builtJavaResource = com.pulumi.azurenative.network.NspProfile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NspProfile(builtJavaResource)
    }
}

/**
 * The network security perimeter profile resource
 * Azure REST API version: 2021-02-01-preview. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### NspProfilesPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nspProfile = new AzureNative.Network.NspProfile("nspProfile", new()
 *     {
 *         NetworkSecurityPerimeterName = "nsp1",
 *         ProfileName = "profile1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNspProfile(ctx, "nspProfile", &network.NspProfileArgs{
 * 			NetworkSecurityPerimeterName: pulumi.String("nsp1"),
 * 			ProfileName:                  pulumi.String("profile1"),
 * 			ResourceGroupName:            pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NspProfile;
 * import com.pulumi.azurenative.network.NspProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nspProfile = new NspProfile("nspProfile", NspProfileArgs.builder()
 *             .networkSecurityPerimeterName("nsp1")
 *             .profileName("profile1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NspProfile profile1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}/profiles/{profileName}
 * ```
 */
public class NspProfile internal constructor(
    override val javaResource: com.pulumi.azurenative.network.NspProfile,
) : KotlinCustomResource(javaResource, NspProfileMapper) {
    /**
     * Version number that increases with every update to access rules within the profile.
     */
    public val accessRulesVersion: Output<String>
        get() = javaResource.accessRulesVersion().applyValue({ args0 -> args0 })

    /**
     * Version number that increases with every update to diagnostic settings within the profile.
     */
    public val diagnosticSettingsVersion: Output<String>
        get() = javaResource.diagnosticSettingsVersion().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NspProfileMapper : ResourceMapper<NspProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.NspProfile::class == javaResource::class

    override fun map(javaResource: Resource): NspProfile = NspProfile(
        javaResource as
            com.pulumi.azurenative.network.NspProfile,
    )
}

/**
 * @see [NspProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NspProfile].
 */
public suspend fun nspProfile(name: String, block: suspend NspProfileResourceBuilder.() -> Unit):
    NspProfile {
    val builder = NspProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NspProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun nspProfile(name: String): NspProfile {
    val builder = NspProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
