@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [OutboundEndpoint].
 */
@PulumiTagMarker
public class OutboundEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OutboundEndpointArgs = OutboundEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OutboundEndpointArgsBuilder.() -> Unit) {
        val builder = OutboundEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OutboundEndpoint {
        val builtJavaResource = com.pulumi.azurenative.network.OutboundEndpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OutboundEndpoint(builtJavaResource)
    }
}

/**
 * Describes an outbound endpoint for a DNS resolver.
 * Azure REST API version: 2022-07-01. Prior API version in Azure Native 1.x: 2020-04-01-preview.
 * Other available API versions: 2020-04-01-preview.
 * ## Example Usage
 * ### Upsert outbound endpoint for DNS resolver
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var outboundEndpoint = new AzureNative.Network.OutboundEndpoint("outboundEndpoint", new()
 *     {
 *         DnsResolverName = "sampleDnsResolver",
 *         Location = "westus2",
 *         OutboundEndpointName = "sampleOutboundEndpoint",
 *         ResourceGroupName = "sampleResourceGroup",
 *         Subnet = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/0403cfa9-9659-4f33-9f30-1f191c51d111/resourceGroups/sampleVnetResourceGroupName/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork/subnets/sampleSubnet",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewOutboundEndpoint(ctx, "outboundEndpoint", &network.OutboundEndpointArgs{
 * 			DnsResolverName:      pulumi.String("sampleDnsResolver"),
 * 			Location:             pulumi.String("westus2"),
 * 			OutboundEndpointName: pulumi.String("sampleOutboundEndpoint"),
 * 			ResourceGroupName:    pulumi.String("sampleResourceGroup"),
 * 			Subnet: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/0403cfa9-9659-4f33-9f30-1f191c51d111/resourceGroups/sampleVnetResourceGroupName/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork/subnets/sampleSubnet"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.OutboundEndpoint;
 * import com.pulumi.azurenative.network.OutboundEndpointArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var outboundEndpoint = new OutboundEndpoint("outboundEndpoint", OutboundEndpointArgs.builder()
 *             .dnsResolverName("sampleDnsResolver")
 *             .location("westus2")
 *             .outboundEndpointName("sampleOutboundEndpoint")
 *             .resourceGroupName("sampleResourceGroup")
 *             .subnet(SubResourceArgs.builder()
 *                 .id("/subscriptions/0403cfa9-9659-4f33-9f30-1f191c51d111/resourceGroups/sampleVnetResourceGroupName/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork/subnets/sampleSubnet")
 *                 .build())
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:OutboundEndpoint sampleOutboundEndpoint /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}/outboundEndpoints/{outboundEndpointName}
 * ```
 */
public class OutboundEndpoint internal constructor(
    override val javaResource: com.pulumi.azurenative.network.OutboundEndpoint,
) : KotlinCustomResource(javaResource, OutboundEndpointMapper) {
    /**
     * ETag of the outbound endpoint.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The current provisioning state of the outbound endpoint. This is a read-only property and any attempt to set this value will be ignored.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resourceGuid property of the outbound endpoint resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * The reference to the subnet used for the outbound endpoint.
     */
    public val subnet: Output<SubResourceResponse>
        get() = javaResource.subnet().applyValue({ args0 ->
            args0.let({ args0 ->
                subResourceResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object OutboundEndpointMapper : ResourceMapper<OutboundEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.OutboundEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): OutboundEndpoint = OutboundEndpoint(
        javaResource as
            com.pulumi.azurenative.network.OutboundEndpoint,
    )
}

/**
 * @see [OutboundEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OutboundEndpoint].
 */
public suspend fun outboundEndpoint(
    name: String,
    block: suspend OutboundEndpointResourceBuilder.() -> Unit,
): OutboundEndpoint {
    val builder = OutboundEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OutboundEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun outboundEndpoint(name: String): OutboundEndpoint {
    val builder = OutboundEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
