@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.P2sVpnServerConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VpnGatewayTunnelingProtocol
import com.pulumi.azurenative.network.kotlin.inputs.IpsecPolicyArgs
import com.pulumi.azurenative.network.kotlin.inputs.IpsecPolicyArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.P2SVpnServerConfigRadiusClientRootCertificateArgs
import com.pulumi.azurenative.network.kotlin.inputs.P2SVpnServerConfigRadiusClientRootCertificateArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.P2SVpnServerConfigRadiusServerRootCertificateArgs
import com.pulumi.azurenative.network.kotlin.inputs.P2SVpnServerConfigRadiusServerRootCertificateArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.P2SVpnServerConfigVpnClientRevokedCertificateArgs
import com.pulumi.azurenative.network.kotlin.inputs.P2SVpnServerConfigVpnClientRevokedCertificateArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.P2SVpnServerConfigVpnClientRootCertificateArgs
import com.pulumi.azurenative.network.kotlin.inputs.P2SVpnServerConfigVpnClientRootCertificateArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * P2SVpnServerConfiguration Resource.
 * Azure REST API version: 2019-07-01. Prior API version in Azure Native 1.x: 2019-07-01.
 * ## Example Usage
 * ### P2SVpnServerConfigurationPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var p2sVpnServerConfiguration = new AzureNative.Network.P2sVpnServerConfiguration("p2sVpnServerConfiguration", new()
 *     {
 *         P2SVpnServerConfigRadiusClientRootCertificates = new[]
 *         {
 *             new AzureNative.Network.Inputs.P2SVpnServerConfigRadiusClientRootCertificateArgs
 *             {
 *                 Name = "p2sVpnServerConfigRadiusClientRootCert1",
 *                 Thumbprint = "83FFBFC8848B5A5836C94D0112367E16148A286F",
 *             },
 *         },
 *         P2SVpnServerConfigRadiusServerRootCertificates = new[]
 *         {
 *             new AzureNative.Network.Inputs.P2SVpnServerConfigRadiusServerRootCertificateArgs
 *             {
 *                 Name = "p2sVpnServerConfigRadiusServerRootCert1",
 *                 PublicCertData = "MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM",
 *             },
 *         },
 *         P2SVpnServerConfigVpnClientRevokedCertificates = new[]
 *         {
 *             new AzureNative.Network.Inputs.P2SVpnServerConfigVpnClientRevokedCertificateArgs
 *             {
 *                 Name = "p2sVpnServerConfigVpnClientRevokedCert1",
 *                 Thumbprint = "83FFBFC8848B5A5836C94D0112367E16148A286F",
 *             },
 *         },
 *         P2SVpnServerConfigVpnClientRootCertificates = new[]
 *         {
 *             new AzureNative.Network.Inputs.P2SVpnServerConfigVpnClientRootCertificateArgs
 *             {
 *                 Name = "p2sVpnServerConfigVpnClientRootCert1",
 *                 PublicCertData = "MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN",
 *             },
 *         },
 *         P2SVpnServerConfigurationName = "p2sVpnServerConfiguration1",
 *         RadiusServerAddress = "8.9.9.9",
 *         RadiusServerSecret = "<radiusServerSecret>",
 *         ResourceGroupName = "rg1",
 *         VirtualWanName = "virtualWan1",
 *         VpnClientIpsecPolicies = new[]
 *         {
 *             new AzureNative.Network.Inputs.IpsecPolicyArgs
 *             {
 *                 DhGroup = AzureNative.Network.DhGroup.DHGroup14,
 *                 IkeEncryption = AzureNative.Network.IkeEncryption.AES256,
 *                 IkeIntegrity = AzureNative.Network.IkeIntegrity.SHA384,
 *                 IpsecEncryption = AzureNative.Network.IpsecEncryption.AES256,
 *                 IpsecIntegrity = AzureNative.Network.IpsecIntegrity.SHA256,
 *                 PfsGroup = AzureNative.Network.PfsGroup.PFS14,
 *                 SaDataSizeKilobytes = 429497,
 *                 SaLifeTimeSeconds = 86472,
 *             },
 *         },
 *         VpnProtocols = new[]
 *         {
 *             AzureNative.Network.VpnGatewayTunnelingProtocol.IkeV2,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewP2sVpnServerConfiguration(ctx, "p2sVpnServerConfiguration", &network.P2sVpnServerConfigurationArgs{
 * 			P2SVpnServerConfigRadiusClientRootCertificates: network.P2SVpnServerConfigRadiusClientRootCertificateArray{
 * 				&network.P2SVpnServerConfigRadiusClientRootCertificateArgs{
 * 					Name:       pulumi.String("p2sVpnServerConfigRadiusClientRootCert1"),
 * 					Thumbprint: pulumi.String("83FFBFC8848B5A5836C94D0112367E16148A286F"),
 * 				},
 * 			},
 * 			P2SVpnServerConfigRadiusServerRootCertificates: network.P2SVpnServerConfigRadiusServerRootCertificateArray{
 * 				&network.P2SVpnServerConfigRadiusServerRootCertificateArgs{
 * 					Name:           pulumi.String("p2sVpnServerConfigRadiusServerRootCert1"),
 * 					PublicCertData: pulumi.String("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM"),
 * 				},
 * 			},
 * 			P2SVpnServerConfigVpnClientRevokedCertificates: network.P2SVpnServerConfigVpnClientRevokedCertificateArray{
 * 				&network.P2SVpnServerConfigVpnClientRevokedCertificateArgs{
 * 					Name:       pulumi.String("p2sVpnServerConfigVpnClientRevokedCert1"),
 * 					Thumbprint: pulumi.String("83FFBFC8848B5A5836C94D0112367E16148A286F"),
 * 				},
 * 			},
 * 			P2SVpnServerConfigVpnClientRootCertificates: network.P2SVpnServerConfigVpnClientRootCertificateArray{
 * 				&network.P2SVpnServerConfigVpnClientRootCertificateArgs{
 * 					Name:           pulumi.String("p2sVpnServerConfigVpnClientRootCert1"),
 * 					PublicCertData: pulumi.String("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN"),
 * 				},
 * 			},
 * 			P2SVpnServerConfigurationName: pulumi.String("p2sVpnServerConfiguration1"),
 * 			RadiusServerAddress:           pulumi.String("8.9.9.9"),
 * 			RadiusServerSecret:            pulumi.String("<radiusServerSecret>"),
 * 			ResourceGroupName:             pulumi.String("rg1"),
 * 			VirtualWanName:                pulumi.String("virtualWan1"),
 * 			VpnClientIpsecPolicies: network.IpsecPolicyArray{
 * 				&network.IpsecPolicyArgs{
 * 					DhGroup:             pulumi.String(network.DhGroupDHGroup14),
 * 					IkeEncryption:       pulumi.String(network.IkeEncryptionAES256),
 * 					IkeIntegrity:        pulumi.String(network.IkeIntegritySHA384),
 * 					IpsecEncryption:     pulumi.String(network.IpsecEncryptionAES256),
 * 					IpsecIntegrity:      pulumi.String(network.IpsecIntegritySHA256),
 * 					PfsGroup:            pulumi.String(network.PfsGroupPFS14),
 * 					SaDataSizeKilobytes: pulumi.Int(429497),
 * 					SaLifeTimeSeconds:   pulumi.Int(86472),
 * 				},
 * 			},
 * 			VpnProtocols: pulumi.StringArray{
 * 				pulumi.String(network.VpnGatewayTunnelingProtocolIkeV2),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.P2sVpnServerConfiguration;
 * import com.pulumi.azurenative.network.P2sVpnServerConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.P2SVpnServerConfigRadiusClientRootCertificateArgs;
 * import com.pulumi.azurenative.network.inputs.P2SVpnServerConfigRadiusServerRootCertificateArgs;
 * import com.pulumi.azurenative.network.inputs.P2SVpnServerConfigVpnClientRevokedCertificateArgs;
 * import com.pulumi.azurenative.network.inputs.P2SVpnServerConfigVpnClientRootCertificateArgs;
 * import com.pulumi.azurenative.network.inputs.IpsecPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var p2sVpnServerConfiguration = new P2sVpnServerConfiguration("p2sVpnServerConfiguration", P2sVpnServerConfigurationArgs.builder()
 *             .p2SVpnServerConfigRadiusClientRootCertificates(P2SVpnServerConfigRadiusClientRootCertificateArgs.builder()
 *                 .name("p2sVpnServerConfigRadiusClientRootCert1")
 *                 .thumbprint("83FFBFC8848B5A5836C94D0112367E16148A286F")
 *                 .build())
 *             .p2SVpnServerConfigRadiusServerRootCertificates(P2SVpnServerConfigRadiusServerRootCertificateArgs.builder()
 *                 .name("p2sVpnServerConfigRadiusServerRootCert1")
 *                 .publicCertData("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM")
 *                 .build())
 *             .p2SVpnServerConfigVpnClientRevokedCertificates(P2SVpnServerConfigVpnClientRevokedCertificateArgs.builder()
 *                 .name("p2sVpnServerConfigVpnClientRevokedCert1")
 *                 .thumbprint("83FFBFC8848B5A5836C94D0112367E16148A286F")
 *                 .build())
 *             .p2SVpnServerConfigVpnClientRootCertificates(P2SVpnServerConfigVpnClientRootCertificateArgs.builder()
 *                 .name("p2sVpnServerConfigVpnClientRootCert1")
 *                 .publicCertData("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN")
 *                 .build())
 *             .p2SVpnServerConfigurationName("p2sVpnServerConfiguration1")
 *             .radiusServerAddress("8.9.9.9")
 *             .radiusServerSecret("<radiusServerSecret>")
 *             .resourceGroupName("rg1")
 *             .virtualWanName("virtualWan1")
 *             .vpnClientIpsecPolicies(IpsecPolicyArgs.builder()
 *                 .dhGroup("DHGroup14")
 *                 .ikeEncryption("AES256")
 *                 .ikeIntegrity("SHA384")
 *                 .ipsecEncryption("AES256")
 *                 .ipsecIntegrity("SHA256")
 *                 .pfsGroup("PFS14")
 *                 .saDataSizeKilobytes(429497)
 *                 .saLifeTimeSeconds(86472)
 *                 .build())
 *             .vpnProtocols("IkeV2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:P2sVpnServerConfiguration p2sVpnServerConfiguration1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWanName}/p2sVpnServerConfigurations/{p2SVpnServerConfigurationName}
 * ```
 * @property id Resource ID.
 * @property name The name of the P2SVpnServerConfiguration that is unique within a VirtualWan in a resource group. This name can be used to access the resource along with Paren VirtualWan resource name.
 * @property p2SVpnServerConfigRadiusClientRootCertificates Radius client root certificate of P2SVpnServerConfiguration.
 * @property p2SVpnServerConfigRadiusServerRootCertificates Radius Server root certificate of P2SVpnServerConfiguration.
 * @property p2SVpnServerConfigVpnClientRevokedCertificates VPN client revoked certificate of P2SVpnServerConfiguration.
 * @property p2SVpnServerConfigVpnClientRootCertificates VPN client root certificate of P2SVpnServerConfiguration.
 * @property p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
 * @property radiusServerAddress The radius server address property of the P2SVpnServerConfiguration resource for point to site client connection.
 * @property radiusServerSecret The radius secret property of the P2SVpnServerConfiguration resource for point to site client connection.
 * @property resourceGroupName The resource group name of the VirtualWan.
 * @property virtualWanName The name of the VirtualWan.
 * @property vpnClientIpsecPolicies VpnClientIpsecPolicies for P2SVpnServerConfiguration.
 * @property vpnProtocols VPN protocols for the P2SVpnServerConfiguration.
 */
public data class P2sVpnServerConfigurationArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val p2SVpnServerConfigRadiusClientRootCertificates:
    Output<List<P2SVpnServerConfigRadiusClientRootCertificateArgs>>? = null,
    public val p2SVpnServerConfigRadiusServerRootCertificates:
    Output<List<P2SVpnServerConfigRadiusServerRootCertificateArgs>>? = null,
    public val p2SVpnServerConfigVpnClientRevokedCertificates:
    Output<List<P2SVpnServerConfigVpnClientRevokedCertificateArgs>>? = null,
    public val p2SVpnServerConfigVpnClientRootCertificates:
    Output<List<P2SVpnServerConfigVpnClientRootCertificateArgs>>? = null,
    public val p2SVpnServerConfigurationName: Output<String>? = null,
    public val radiusServerAddress: Output<String>? = null,
    public val radiusServerSecret: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val virtualWanName: Output<String>? = null,
    public val vpnClientIpsecPolicies: Output<List<IpsecPolicyArgs>>? = null,
    public val vpnProtocols: Output<List<Either<String, VpnGatewayTunnelingProtocol>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.P2sVpnServerConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.P2sVpnServerConfigurationArgs =
        com.pulumi.azurenative.network.P2sVpnServerConfigurationArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .p2SVpnServerConfigRadiusClientRootCertificates(
                p2SVpnServerConfigRadiusClientRootCertificates?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .p2SVpnServerConfigRadiusServerRootCertificates(
                p2SVpnServerConfigRadiusServerRootCertificates?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .p2SVpnServerConfigVpnClientRevokedCertificates(
                p2SVpnServerConfigVpnClientRevokedCertificates?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .p2SVpnServerConfigVpnClientRootCertificates(
                p2SVpnServerConfigVpnClientRootCertificates?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .p2SVpnServerConfigurationName(p2SVpnServerConfigurationName?.applyValue({ args0 -> args0 }))
            .radiusServerAddress(radiusServerAddress?.applyValue({ args0 -> args0 }))
            .radiusServerSecret(radiusServerSecret?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .virtualWanName(virtualWanName?.applyValue({ args0 -> args0 }))
            .vpnClientIpsecPolicies(
                vpnClientIpsecPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .vpnProtocols(
                vpnProtocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            ).build()
}

/**
 * Builder for [P2sVpnServerConfigurationArgs].
 */
@PulumiTagMarker
public class P2sVpnServerConfigurationArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var p2SVpnServerConfigRadiusClientRootCertificates:
        Output<List<P2SVpnServerConfigRadiusClientRootCertificateArgs>>? = null

    private var p2SVpnServerConfigRadiusServerRootCertificates:
        Output<List<P2SVpnServerConfigRadiusServerRootCertificateArgs>>? = null

    private var p2SVpnServerConfigVpnClientRevokedCertificates:
        Output<List<P2SVpnServerConfigVpnClientRevokedCertificateArgs>>? = null

    private var p2SVpnServerConfigVpnClientRootCertificates:
        Output<List<P2SVpnServerConfigVpnClientRootCertificateArgs>>? = null

    private var p2SVpnServerConfigurationName: Output<String>? = null

    private var radiusServerAddress: Output<String>? = null

    private var radiusServerSecret: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var virtualWanName: Output<String>? = null

    private var vpnClientIpsecPolicies: Output<List<IpsecPolicyArgs>>? = null

    private var vpnProtocols: Output<List<Either<String, VpnGatewayTunnelingProtocol>>>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("tqkkgnatxmccwuwr")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the P2SVpnServerConfiguration that is unique within a VirtualWan in a resource group. This name can be used to access the resource along with Paren VirtualWan resource name.
     */
    @JvmName("lcbtpuyuukvpvmas")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Radius client root certificate of P2SVpnServerConfiguration.
     */
    @JvmName("omjqyfeltglqdfam")
    public suspend
    fun p2SVpnServerConfigRadiusClientRootCertificates(`value`: Output<List<P2SVpnServerConfigRadiusClientRootCertificateArgs>>) {
        this.p2SVpnServerConfigRadiusClientRootCertificates = value
    }

    @JvmName("bxahpwutjkulmvpe")
    public suspend fun p2SVpnServerConfigRadiusClientRootCertificates(
        vararg
        values: Output<P2SVpnServerConfigRadiusClientRootCertificateArgs>,
    ) {
        this.p2SVpnServerConfigRadiusClientRootCertificates = Output.all(values.asList())
    }

    /**
     * @param values Radius client root certificate of P2SVpnServerConfiguration.
     */
    @JvmName("bixcgngyngevlsdm")
    public suspend
    fun p2SVpnServerConfigRadiusClientRootCertificates(values: List<Output<P2SVpnServerConfigRadiusClientRootCertificateArgs>>) {
        this.p2SVpnServerConfigRadiusClientRootCertificates = Output.all(values)
    }

    /**
     * @param value Radius Server root certificate of P2SVpnServerConfiguration.
     */
    @JvmName("tmvlklucswdutnhp")
    public suspend
    fun p2SVpnServerConfigRadiusServerRootCertificates(`value`: Output<List<P2SVpnServerConfigRadiusServerRootCertificateArgs>>) {
        this.p2SVpnServerConfigRadiusServerRootCertificates = value
    }

    @JvmName("jskangnnggstofqh")
    public suspend fun p2SVpnServerConfigRadiusServerRootCertificates(
        vararg
        values: Output<P2SVpnServerConfigRadiusServerRootCertificateArgs>,
    ) {
        this.p2SVpnServerConfigRadiusServerRootCertificates = Output.all(values.asList())
    }

    /**
     * @param values Radius Server root certificate of P2SVpnServerConfiguration.
     */
    @JvmName("dmedtqhmadsddmsk")
    public suspend
    fun p2SVpnServerConfigRadiusServerRootCertificates(values: List<Output<P2SVpnServerConfigRadiusServerRootCertificateArgs>>) {
        this.p2SVpnServerConfigRadiusServerRootCertificates = Output.all(values)
    }

    /**
     * @param value VPN client revoked certificate of P2SVpnServerConfiguration.
     */
    @JvmName("dlqqsihogwnwvate")
    public suspend
    fun p2SVpnServerConfigVpnClientRevokedCertificates(`value`: Output<List<P2SVpnServerConfigVpnClientRevokedCertificateArgs>>) {
        this.p2SVpnServerConfigVpnClientRevokedCertificates = value
    }

    @JvmName("sjvujhdwolcyvmky")
    public suspend fun p2SVpnServerConfigVpnClientRevokedCertificates(
        vararg
        values: Output<P2SVpnServerConfigVpnClientRevokedCertificateArgs>,
    ) {
        this.p2SVpnServerConfigVpnClientRevokedCertificates = Output.all(values.asList())
    }

    /**
     * @param values VPN client revoked certificate of P2SVpnServerConfiguration.
     */
    @JvmName("bdvwuiljayavlyyg")
    public suspend
    fun p2SVpnServerConfigVpnClientRevokedCertificates(values: List<Output<P2SVpnServerConfigVpnClientRevokedCertificateArgs>>) {
        this.p2SVpnServerConfigVpnClientRevokedCertificates = Output.all(values)
    }

    /**
     * @param value VPN client root certificate of P2SVpnServerConfiguration.
     */
    @JvmName("cwioqnvkwjfkoeoi")
    public suspend
    fun p2SVpnServerConfigVpnClientRootCertificates(`value`: Output<List<P2SVpnServerConfigVpnClientRootCertificateArgs>>) {
        this.p2SVpnServerConfigVpnClientRootCertificates = value
    }

    @JvmName("jkssgrtylcpdmoml")
    public suspend fun p2SVpnServerConfigVpnClientRootCertificates(
        vararg
        values: Output<P2SVpnServerConfigVpnClientRootCertificateArgs>,
    ) {
        this.p2SVpnServerConfigVpnClientRootCertificates = Output.all(values.asList())
    }

    /**
     * @param values VPN client root certificate of P2SVpnServerConfiguration.
     */
    @JvmName("yipkykjvmfqurfam")
    public suspend
    fun p2SVpnServerConfigVpnClientRootCertificates(values: List<Output<P2SVpnServerConfigVpnClientRootCertificateArgs>>) {
        this.p2SVpnServerConfigVpnClientRootCertificates = Output.all(values)
    }

    /**
     * @param value The name of the P2SVpnServerConfiguration.
     */
    @JvmName("toqfocsllnmmfcya")
    public suspend fun p2SVpnServerConfigurationName(`value`: Output<String>) {
        this.p2SVpnServerConfigurationName = value
    }

    /**
     * @param value The radius server address property of the P2SVpnServerConfiguration resource for point to site client connection.
     */
    @JvmName("jbwsdaltvyiyvexh")
    public suspend fun radiusServerAddress(`value`: Output<String>) {
        this.radiusServerAddress = value
    }

    /**
     * @param value The radius secret property of the P2SVpnServerConfiguration resource for point to site client connection.
     */
    @JvmName("nkvdsmtkdvdafnic")
    public suspend fun radiusServerSecret(`value`: Output<String>) {
        this.radiusServerSecret = value
    }

    /**
     * @param value The resource group name of the VirtualWan.
     */
    @JvmName("unseujggdvrfnqhr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the VirtualWan.
     */
    @JvmName("aupofuowdmtjjkqc")
    public suspend fun virtualWanName(`value`: Output<String>) {
        this.virtualWanName = value
    }

    /**
     * @param value VpnClientIpsecPolicies for P2SVpnServerConfiguration.
     */
    @JvmName("qwvndjbuusesdajo")
    public suspend fun vpnClientIpsecPolicies(`value`: Output<List<IpsecPolicyArgs>>) {
        this.vpnClientIpsecPolicies = value
    }

    @JvmName("tugiuoguyavklrhb")
    public suspend fun vpnClientIpsecPolicies(vararg values: Output<IpsecPolicyArgs>) {
        this.vpnClientIpsecPolicies = Output.all(values.asList())
    }

    /**
     * @param values VpnClientIpsecPolicies for P2SVpnServerConfiguration.
     */
    @JvmName("gdgpjecncvmwxkrr")
    public suspend fun vpnClientIpsecPolicies(values: List<Output<IpsecPolicyArgs>>) {
        this.vpnClientIpsecPolicies = Output.all(values)
    }

    /**
     * @param value VPN protocols for the P2SVpnServerConfiguration.
     */
    @JvmName("jsdeoublgfbvdtar")
    public suspend
    fun vpnProtocols(`value`: Output<List<Either<String, VpnGatewayTunnelingProtocol>>>) {
        this.vpnProtocols = value
    }

    @JvmName("hmrbcrvdwlhvayvl")
    public suspend fun vpnProtocols(
        vararg
        values: Output<Either<String, VpnGatewayTunnelingProtocol>>,
    ) {
        this.vpnProtocols = Output.all(values.asList())
    }

    /**
     * @param values VPN protocols for the P2SVpnServerConfiguration.
     */
    @JvmName("iibicvwpqicidiln")
    public suspend
    fun vpnProtocols(values: List<Output<Either<String, VpnGatewayTunnelingProtocol>>>) {
        this.vpnProtocols = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("yuxtosmacainbcrx")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the P2SVpnServerConfiguration that is unique within a VirtualWan in a resource group. This name can be used to access the resource along with Paren VirtualWan resource name.
     */
    @JvmName("jhhpsfiqujjvnavm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Radius client root certificate of P2SVpnServerConfiguration.
     */
    @JvmName("ggpvcyjggjbbsduq")
    public suspend
    fun p2SVpnServerConfigRadiusClientRootCertificates(`value`: List<P2SVpnServerConfigRadiusClientRootCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.p2SVpnServerConfigRadiusClientRootCertificates = mapped
    }

    /**
     * @param argument Radius client root certificate of P2SVpnServerConfiguration.
     */
    @JvmName("mbbsjacrtbslcyyj")
    public suspend
    fun p2SVpnServerConfigRadiusClientRootCertificates(argument: List<suspend P2SVpnServerConfigRadiusClientRootCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            P2SVpnServerConfigRadiusClientRootCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.p2SVpnServerConfigRadiusClientRootCertificates = mapped
    }

    /**
     * @param argument Radius client root certificate of P2SVpnServerConfiguration.
     */
    @JvmName("tkcqvfhclspplbsc")
    public suspend fun p2SVpnServerConfigRadiusClientRootCertificates(
        vararg
        argument: suspend P2SVpnServerConfigRadiusClientRootCertificateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            P2SVpnServerConfigRadiusClientRootCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.p2SVpnServerConfigRadiusClientRootCertificates = mapped
    }

    /**
     * @param argument Radius client root certificate of P2SVpnServerConfiguration.
     */
    @JvmName("wrxnktiogujgbshi")
    public suspend
    fun p2SVpnServerConfigRadiusClientRootCertificates(argument: suspend P2SVpnServerConfigRadiusClientRootCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            P2SVpnServerConfigRadiusClientRootCertificateArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.p2SVpnServerConfigRadiusClientRootCertificates = mapped
    }

    /**
     * @param values Radius client root certificate of P2SVpnServerConfiguration.
     */
    @JvmName("pkqjskngklyiokdi")
    public suspend fun p2SVpnServerConfigRadiusClientRootCertificates(
        vararg
        values: P2SVpnServerConfigRadiusClientRootCertificateArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.p2SVpnServerConfigRadiusClientRootCertificates = mapped
    }

    /**
     * @param value Radius Server root certificate of P2SVpnServerConfiguration.
     */
    @JvmName("qpijhbauiooxfjat")
    public suspend
    fun p2SVpnServerConfigRadiusServerRootCertificates(`value`: List<P2SVpnServerConfigRadiusServerRootCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.p2SVpnServerConfigRadiusServerRootCertificates = mapped
    }

    /**
     * @param argument Radius Server root certificate of P2SVpnServerConfiguration.
     */
    @JvmName("jpppnjqweyejiyta")
    public suspend
    fun p2SVpnServerConfigRadiusServerRootCertificates(argument: List<suspend P2SVpnServerConfigRadiusServerRootCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            P2SVpnServerConfigRadiusServerRootCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.p2SVpnServerConfigRadiusServerRootCertificates = mapped
    }

    /**
     * @param argument Radius Server root certificate of P2SVpnServerConfiguration.
     */
    @JvmName("wystvmolayauccfu")
    public suspend fun p2SVpnServerConfigRadiusServerRootCertificates(
        vararg
        argument: suspend P2SVpnServerConfigRadiusServerRootCertificateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            P2SVpnServerConfigRadiusServerRootCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.p2SVpnServerConfigRadiusServerRootCertificates = mapped
    }

    /**
     * @param argument Radius Server root certificate of P2SVpnServerConfiguration.
     */
    @JvmName("jgbclxmaoddrvmif")
    public suspend
    fun p2SVpnServerConfigRadiusServerRootCertificates(argument: suspend P2SVpnServerConfigRadiusServerRootCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            P2SVpnServerConfigRadiusServerRootCertificateArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.p2SVpnServerConfigRadiusServerRootCertificates = mapped
    }

    /**
     * @param values Radius Server root certificate of P2SVpnServerConfiguration.
     */
    @JvmName("flwpthehrglrghnl")
    public suspend fun p2SVpnServerConfigRadiusServerRootCertificates(
        vararg
        values: P2SVpnServerConfigRadiusServerRootCertificateArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.p2SVpnServerConfigRadiusServerRootCertificates = mapped
    }

    /**
     * @param value VPN client revoked certificate of P2SVpnServerConfiguration.
     */
    @JvmName("hccnuynanwrqirwh")
    public suspend
    fun p2SVpnServerConfigVpnClientRevokedCertificates(`value`: List<P2SVpnServerConfigVpnClientRevokedCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.p2SVpnServerConfigVpnClientRevokedCertificates = mapped
    }

    /**
     * @param argument VPN client revoked certificate of P2SVpnServerConfiguration.
     */
    @JvmName("ijifokwanarwnolw")
    public suspend
    fun p2SVpnServerConfigVpnClientRevokedCertificates(argument: List<suspend P2SVpnServerConfigVpnClientRevokedCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            P2SVpnServerConfigVpnClientRevokedCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.p2SVpnServerConfigVpnClientRevokedCertificates = mapped
    }

    /**
     * @param argument VPN client revoked certificate of P2SVpnServerConfiguration.
     */
    @JvmName("rjnrjpbqjwbgeysj")
    public suspend fun p2SVpnServerConfigVpnClientRevokedCertificates(
        vararg
        argument: suspend P2SVpnServerConfigVpnClientRevokedCertificateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            P2SVpnServerConfigVpnClientRevokedCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.p2SVpnServerConfigVpnClientRevokedCertificates = mapped
    }

    /**
     * @param argument VPN client revoked certificate of P2SVpnServerConfiguration.
     */
    @JvmName("clrpbfegyjopvicx")
    public suspend
    fun p2SVpnServerConfigVpnClientRevokedCertificates(argument: suspend P2SVpnServerConfigVpnClientRevokedCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            P2SVpnServerConfigVpnClientRevokedCertificateArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.p2SVpnServerConfigVpnClientRevokedCertificates = mapped
    }

    /**
     * @param values VPN client revoked certificate of P2SVpnServerConfiguration.
     */
    @JvmName("uokwdeirmmosfgqy")
    public suspend fun p2SVpnServerConfigVpnClientRevokedCertificates(
        vararg
        values: P2SVpnServerConfigVpnClientRevokedCertificateArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.p2SVpnServerConfigVpnClientRevokedCertificates = mapped
    }

    /**
     * @param value VPN client root certificate of P2SVpnServerConfiguration.
     */
    @JvmName("oiaywetiuufhhhjf")
    public suspend
    fun p2SVpnServerConfigVpnClientRootCertificates(`value`: List<P2SVpnServerConfigVpnClientRootCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.p2SVpnServerConfigVpnClientRootCertificates = mapped
    }

    /**
     * @param argument VPN client root certificate of P2SVpnServerConfiguration.
     */
    @JvmName("srdcwdfvddmpexwa")
    public suspend
    fun p2SVpnServerConfigVpnClientRootCertificates(argument: List<suspend P2SVpnServerConfigVpnClientRootCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            P2SVpnServerConfigVpnClientRootCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.p2SVpnServerConfigVpnClientRootCertificates = mapped
    }

    /**
     * @param argument VPN client root certificate of P2SVpnServerConfiguration.
     */
    @JvmName("luhbpxeriewajgsc")
    public suspend fun p2SVpnServerConfigVpnClientRootCertificates(
        vararg
        argument: suspend P2SVpnServerConfigVpnClientRootCertificateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            P2SVpnServerConfigVpnClientRootCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.p2SVpnServerConfigVpnClientRootCertificates = mapped
    }

    /**
     * @param argument VPN client root certificate of P2SVpnServerConfiguration.
     */
    @JvmName("agwafbunphaxfutg")
    public suspend
    fun p2SVpnServerConfigVpnClientRootCertificates(argument: suspend P2SVpnServerConfigVpnClientRootCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            P2SVpnServerConfigVpnClientRootCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.p2SVpnServerConfigVpnClientRootCertificates = mapped
    }

    /**
     * @param values VPN client root certificate of P2SVpnServerConfiguration.
     */
    @JvmName("komehsxmetggvuxq")
    public suspend fun p2SVpnServerConfigVpnClientRootCertificates(
        vararg
        values: P2SVpnServerConfigVpnClientRootCertificateArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.p2SVpnServerConfigVpnClientRootCertificates = mapped
    }

    /**
     * @param value The name of the P2SVpnServerConfiguration.
     */
    @JvmName("pkpawrxtjoruqovd")
    public suspend fun p2SVpnServerConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.p2SVpnServerConfigurationName = mapped
    }

    /**
     * @param value The radius server address property of the P2SVpnServerConfiguration resource for point to site client connection.
     */
    @JvmName("iwlycgnhuvuryfbk")
    public suspend fun radiusServerAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServerAddress = mapped
    }

    /**
     * @param value The radius secret property of the P2SVpnServerConfiguration resource for point to site client connection.
     */
    @JvmName("ndsojpaomrqosvdi")
    public suspend fun radiusServerSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServerSecret = mapped
    }

    /**
     * @param value The resource group name of the VirtualWan.
     */
    @JvmName("alqnargkxnrdysvf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the VirtualWan.
     */
    @JvmName("tjjbarvosywmlsvg")
    public suspend fun virtualWanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualWanName = mapped
    }

    /**
     * @param value VpnClientIpsecPolicies for P2SVpnServerConfiguration.
     */
    @JvmName("xbkqbpcbualifbwg")
    public suspend fun vpnClientIpsecPolicies(`value`: List<IpsecPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param argument VpnClientIpsecPolicies for P2SVpnServerConfiguration.
     */
    @JvmName("bsfgkcnkedrfwerj")
    public suspend
    fun vpnClientIpsecPolicies(argument: List<suspend IpsecPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param argument VpnClientIpsecPolicies for P2SVpnServerConfiguration.
     */
    @JvmName("qditynudhcxjqqpu")
    public suspend fun vpnClientIpsecPolicies(
        vararg
        argument: suspend IpsecPolicyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param argument VpnClientIpsecPolicies for P2SVpnServerConfiguration.
     */
    @JvmName("geteidjjdghvnrso")
    public suspend fun vpnClientIpsecPolicies(argument: suspend IpsecPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpsecPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param values VpnClientIpsecPolicies for P2SVpnServerConfiguration.
     */
    @JvmName("akpvnngbxsxtocsh")
    public suspend fun vpnClientIpsecPolicies(vararg values: IpsecPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param value VPN protocols for the P2SVpnServerConfiguration.
     */
    @JvmName("rhbjnbcchckwlbay")
    public suspend fun vpnProtocols(`value`: List<Either<String, VpnGatewayTunnelingProtocol>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnProtocols = mapped
    }

    /**
     * @param values VPN protocols for the P2SVpnServerConfiguration.
     */
    @JvmName("javfuvidqjruodee")
    public suspend fun vpnProtocols(vararg values: Either<String, VpnGatewayTunnelingProtocol>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnProtocols = mapped
    }

    internal fun build(): P2sVpnServerConfigurationArgs = P2sVpnServerConfigurationArgs(
        id = id,
        name = name,
        p2SVpnServerConfigRadiusClientRootCertificates = p2SVpnServerConfigRadiusClientRootCertificates,
        p2SVpnServerConfigRadiusServerRootCertificates = p2SVpnServerConfigRadiusServerRootCertificates,
        p2SVpnServerConfigVpnClientRevokedCertificates = p2SVpnServerConfigVpnClientRevokedCertificates,
        p2SVpnServerConfigVpnClientRootCertificates = p2SVpnServerConfigVpnClientRootCertificates,
        p2SVpnServerConfigurationName = p2SVpnServerConfigurationName,
        radiusServerAddress = radiusServerAddress,
        radiusServerSecret = radiusServerSecret,
        resourceGroupName = resourceGroupName,
        virtualWanName = virtualWanName,
        vpnClientIpsecPolicies = vpnClientIpsecPolicies,
        vpnProtocols = vpnProtocols,
    )
}
