@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.CustomRuleListResponse
import com.pulumi.azurenative.network.kotlin.outputs.FrontDoorPolicySettingsResponse
import com.pulumi.azurenative.network.kotlin.outputs.FrontendEndpointLinkResponse
import com.pulumi.azurenative.network.kotlin.outputs.ManagedRuleSetListResponse
import com.pulumi.azurenative.network.kotlin.outputs.RoutingRuleLinkResponse
import com.pulumi.azurenative.network.kotlin.outputs.SecurityPolicyLinkResponse
import com.pulumi.azurenative.network.kotlin.outputs.SkuResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.CustomRuleListResponse.Companion.toKotlin as customRuleListResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.FrontDoorPolicySettingsResponse.Companion.toKotlin as frontDoorPolicySettingsResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.FrontendEndpointLinkResponse.Companion.toKotlin as frontendEndpointLinkResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ManagedRuleSetListResponse.Companion.toKotlin as managedRuleSetListResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.RoutingRuleLinkResponse.Companion.toKotlin as routingRuleLinkResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SecurityPolicyLinkResponse.Companion.toKotlin as securityPolicyLinkResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin

/**
 * Builder for [Policy].
 */
@PulumiTagMarker
public class PolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyArgs = PolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyArgsBuilder.() -> Unit) {
        val builder = PolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Policy {
        val builtJavaResource = com.pulumi.azurenative.network.Policy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Policy(builtJavaResource)
    }
}

/**
 * Defines web application firewall policy.
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2021-06-01, 2024-02-01.
 * ## Example Usage
 * ### Creates specific policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policy = new AzureNative.Network.Policy("policy", new()
 *     {
 *         CustomRules = new AzureNative.Network.Inputs.CustomRuleListArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Network.Inputs.CustomRuleArgs
 *                 {
 *                     Action = AzureNative.Network.ActionType.Block,
 *                     MatchConditions = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.FrontDoorMatchConditionArgs
 *                         {
 *                             MatchValue = new[]
 *                             {
 *                                 "192.168.1.0/24",
 *                                 "10.0.0.0/24",
 *                             },
 *                             MatchVariable = AzureNative.Network.FrontDoorMatchVariable.RemoteAddr,
 *                             Operator = AzureNative.Network.Operator.IPMatch,
 *                         },
 *                     },
 *                     Name = "Rule1",
 *                     Priority = 1,
 *                     RateLimitThreshold = 1000,
 *                     RuleType = AzureNative.Network.RuleType.RateLimitRule,
 *                 },
 *                 new AzureNative.Network.Inputs.CustomRuleArgs
 *                 {
 *                     Action = AzureNative.Network.ActionType.Block,
 *                     MatchConditions = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.FrontDoorMatchConditionArgs
 *                         {
 *                             MatchValue = new[]
 *                             {
 *                                 "CH",
 *                             },
 *                             MatchVariable = AzureNative.Network.FrontDoorMatchVariable.RemoteAddr,
 *                             Operator = AzureNative.Network.Operator.GeoMatch,
 *                         },
 *                         new AzureNative.Network.Inputs.FrontDoorMatchConditionArgs
 *                         {
 *                             MatchValue = new[]
 *                             {
 *                                 "windows",
 *                             },
 *                             MatchVariable = AzureNative.Network.FrontDoorMatchVariable.RequestHeader,
 *                             Operator = AzureNative.Network.Operator.Contains,
 *                             Selector = "UserAgent",
 *                             Transforms = new[]
 *                             {
 *                                 AzureNative.Network.TransformType.Lowercase,
 *                             },
 *                         },
 *                     },
 *                     Name = "Rule2",
 *                     Priority = 2,
 *                     RuleType = AzureNative.Network.RuleType.MatchRule,
 *                 },
 *             },
 *         },
 *         Location = "WestUs",
 *         ManagedRules = new AzureNative.Network.Inputs.ManagedRuleSetListArgs
 *         {
 *             ManagedRuleSets = new[]
 *             {
 *                 new AzureNative.Network.Inputs.FrontDoorManagedRuleSetArgs
 *                 {
 *                     Exclusions = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.ManagedRuleExclusionArgs
 *                         {
 *                             MatchVariable = AzureNative.Network.ManagedRuleExclusionMatchVariable.RequestHeaderNames,
 *                             Selector = "User-Agent",
 *                             SelectorMatchOperator = AzureNative.Network.ManagedRuleExclusionSelectorMatchOperator.EqualsValue,
 *                         },
 *                     },
 *                     RuleGroupOverrides = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.FrontDoorManagedRuleGroupOverrideArgs
 *                         {
 *                             Exclusions = new[]
 *                             {
 *                                 new AzureNative.Network.Inputs.ManagedRuleExclusionArgs
 *                                 {
 *                                     MatchVariable = AzureNative.Network.ManagedRuleExclusionMatchVariable.RequestCookieNames,
 *                                     Selector = "token",
 *                                     SelectorMatchOperator = AzureNative.Network.ManagedRuleExclusionSelectorMatchOperator.StartsWith,
 *                                 },
 *                             },
 *                             RuleGroupName = "SQLI",
 *                             Rules = new[]
 *                             {
 *                                 new AzureNative.Network.Inputs.FrontDoorManagedRuleOverrideArgs
 *                                 {
 *                                     Action = "Redirect",
 *                                     EnabledState = AzureNative.Network.ManagedRuleEnabledState.Enabled,
 *                                     Exclusions = new[]
 *                                     {
 *                                         new AzureNative.Network.Inputs.ManagedRuleExclusionArgs
 *                                         {
 *                                             MatchVariable = AzureNative.Network.ManagedRuleExclusionMatchVariable.QueryStringArgNames,
 *                                             Selector = "query",
 *                                             SelectorMatchOperator = AzureNative.Network.ManagedRuleExclusionSelectorMatchOperator.EqualsValue,
 *                                         },
 *                                     },
 *                                     RuleId = "942100",
 *                                 },
 *                                 new AzureNative.Network.Inputs.FrontDoorManagedRuleOverrideArgs
 *                                 {
 *                                     EnabledState = AzureNative.Network.ManagedRuleEnabledState.Disabled,
 *                                     RuleId = "942110",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     RuleSetAction = AzureNative.Network.ManagedRuleSetActionType.Block,
 *                     RuleSetType = "DefaultRuleSet",
 *                     RuleSetVersion = "1.0",
 *                 },
 *             },
 *         },
 *         PolicyName = "Policy1",
 *         PolicySettings = new AzureNative.Network.Inputs.FrontDoorPolicySettingsArgs
 *         {
 *             CustomBlockResponseBody = "PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg==",
 *             CustomBlockResponseStatusCode = 429,
 *             EnabledState = AzureNative.Network.PolicyEnabledState.Enabled,
 *             Mode = AzureNative.Network.PolicyMode.Prevention,
 *             RedirectUrl = "http://www.bing.com",
 *             RequestBodyCheck = AzureNative.Network.PolicyRequestBodyCheck.Disabled,
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Network.SkuName.Classic_AzureFrontDoor,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPolicy(ctx, "policy", &network.PolicyArgs{
 * 			CustomRules: &network.CustomRuleListArgs{
 * 				Rules: network.CustomRuleArray{
 * 					&network.CustomRuleArgs{
 * 						Action: pulumi.String(network.ActionTypeBlock),
 * 						MatchConditions: network.FrontDoorMatchConditionArray{
 * 							&network.FrontDoorMatchConditionArgs{
 * 								MatchValue: pulumi.StringArray{
 * 									pulumi.String("192.168.1.0/24"),
 * 									pulumi.String("10.0.0.0/24"),
 * 								},
 * 								MatchVariable: pulumi.String(network.FrontDoorMatchVariableRemoteAddr),
 * 								Operator:      pulumi.String(network.OperatorIPMatch),
 * 							},
 * 						},
 * 						Name:               pulumi.String("Rule1"),
 * 						Priority:           pulumi.Int(1),
 * 						RateLimitThreshold: pulumi.Int(1000),
 * 						RuleType:           pulumi.String(network.RuleTypeRateLimitRule),
 * 					},
 * 					&network.CustomRuleArgs{
 * 						Action: pulumi.String(network.ActionTypeBlock),
 * 						MatchConditions: network.FrontDoorMatchConditionArray{
 * 							&network.FrontDoorMatchConditionArgs{
 * 								MatchValue: pulumi.StringArray{
 * 									pulumi.String("CH"),
 * 								},
 * 								MatchVariable: pulumi.String(network.FrontDoorMatchVariableRemoteAddr),
 * 								Operator:      pulumi.String(network.OperatorGeoMatch),
 * 							},
 * 							&network.FrontDoorMatchConditionArgs{
 * 								MatchValue: pulumi.StringArray{
 * 									pulumi.String("windows"),
 * 								},
 * 								MatchVariable: pulumi.String(network.FrontDoorMatchVariableRequestHeader),
 * 								Operator:      pulumi.String(network.OperatorContains),
 * 								Selector:      pulumi.String("UserAgent"),
 * 								Transforms: pulumi.StringArray{
 * 									pulumi.String(network.TransformTypeLowercase),
 * 								},
 * 							},
 * 						},
 * 						Name:     pulumi.String("Rule2"),
 * 						Priority: pulumi.Int(2),
 * 						RuleType: pulumi.String(network.RuleTypeMatchRule),
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("WestUs"),
 * 			ManagedRules: &network.ManagedRuleSetListArgs{
 * 				ManagedRuleSets: network.FrontDoorManagedRuleSetArray{
 * 					&network.FrontDoorManagedRuleSetArgs{
 * 						Exclusions: network.ManagedRuleExclusionArray{
 * 							&network.ManagedRuleExclusionArgs{
 * 								MatchVariable:         pulumi.String(network.ManagedRuleExclusionMatchVariableRequestHeaderNames),
 * 								Selector:              pulumi.String("User-Agent"),
 * 								SelectorMatchOperator: pulumi.String(network.ManagedRuleExclusionSelectorMatchOperatorEquals),
 * 							},
 * 						},
 * 						RuleGroupOverrides: network.FrontDoorManagedRuleGroupOverrideArray{
 * 							&network.FrontDoorManagedRuleGroupOverrideArgs{
 * 								Exclusions: network.ManagedRuleExclusionArray{
 * 									&network.ManagedRuleExclusionArgs{
 * 										MatchVariable:         pulumi.String(network.ManagedRuleExclusionMatchVariableRequestCookieNames),
 * 										Selector:              pulumi.String("token"),
 * 										SelectorMatchOperator: pulumi.String(network.ManagedRuleExclusionSelectorMatchOperatorStartsWith),
 * 									},
 * 								},
 * 								RuleGroupName: pulumi.String("SQLI"),
 * 								Rules: network.FrontDoorManagedRuleOverrideArray{
 * 									&network.FrontDoorManagedRuleOverrideArgs{
 * 										Action:       pulumi.String("Redirect"),
 * 										EnabledState: pulumi.String(network.ManagedRuleEnabledStateEnabled),
 * 										Exclusions: network.ManagedRuleExclusionArray{
 * 											&network.ManagedRuleExclusionArgs{
 * 												MatchVariable:         pulumi.String(network.ManagedRuleExclusionMatchVariableQueryStringArgNames),
 * 												Selector:              pulumi.String("query"),
 * 												SelectorMatchOperator: pulumi.String(network.ManagedRuleExclusionSelectorMatchOperatorEquals),
 * 											},
 * 										},
 * 										RuleId: pulumi.String("942100"),
 * 									},
 * 									&network.FrontDoorManagedRuleOverrideArgs{
 * 										EnabledState: pulumi.String(network.ManagedRuleEnabledStateDisabled),
 * 										RuleId:       pulumi.String("942110"),
 * 									},
 * 								},
 * 							},
 * 						},
 * 						RuleSetAction:  pulumi.String(network.ManagedRuleSetActionTypeBlock),
 * 						RuleSetType:    pulumi.String("DefaultRuleSet"),
 * 						RuleSetVersion: pulumi.String("1.0"),
 * 					},
 * 				},
 * 			},
 * 			PolicyName: pulumi.String("Policy1"),
 * 			PolicySettings: &network.FrontDoorPolicySettingsArgs{
 * 				CustomBlockResponseBody:       pulumi.String("PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg=="),
 * 				CustomBlockResponseStatusCode: pulumi.Int(429),
 * 				EnabledState:                  pulumi.String(network.PolicyEnabledStateEnabled),
 * 				Mode:                          pulumi.String(network.PolicyModePrevention),
 * 				RedirectUrl:                   pulumi.String("http://www.bing.com"),
 * 				RequestBodyCheck:              pulumi.String(network.PolicyRequestBodyCheckDisabled),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.SkuArgs{
 * 				Name: pulumi.String(network.SkuName_Classic_AzureFrontDoor),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Policy;
 * import com.pulumi.azurenative.network.PolicyArgs;
 * import com.pulumi.azurenative.network.inputs.CustomRuleListArgs;
 * import com.pulumi.azurenative.network.inputs.ManagedRuleSetListArgs;
 * import com.pulumi.azurenative.network.inputs.FrontDoorPolicySettingsArgs;
 * import com.pulumi.azurenative.network.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .customRules(CustomRuleListArgs.builder()
 *                 .rules(
 *                     CustomRuleArgs.builder()
 *                         .action("Block")
 *                         .matchConditions(FrontDoorMatchConditionArgs.builder()
 *                             .matchValue(
 *                                 "192.168.1.0/24",
 *                                 "10.0.0.0/24")
 *                             .matchVariable("RemoteAddr")
 *                             .operator("IPMatch")
 *                             .build())
 *                         .name("Rule1")
 *                         .priority(1)
 *                         .rateLimitThreshold(1000)
 *                         .ruleType("RateLimitRule")
 *                         .build(),
 *                     CustomRuleArgs.builder()
 *                         .action("Block")
 *                         .matchConditions(
 *                             FrontDoorMatchConditionArgs.builder()
 *                                 .matchValue("CH")
 *                                 .matchVariable("RemoteAddr")
 *                                 .operator("GeoMatch")
 *                                 .build(),
 *                             FrontDoorMatchConditionArgs.builder()
 *                                 .matchValue("windows")
 *                                 .matchVariable("RequestHeader")
 *                                 .operator("Contains")
 *                                 .selector("UserAgent")
 *                                 .transforms("Lowercase")
 *                                 .build())
 *                         .name("Rule2")
 *                         .priority(2)
 *                         .ruleType("MatchRule")
 *                         .build())
 *                 .build())
 *             .location("WestUs")
 *             .managedRules(ManagedRuleSetListArgs.builder()
 *                 .managedRuleSets(FrontDoorManagedRuleSetArgs.builder()
 *                     .exclusions(ManagedRuleExclusionArgs.builder()
 *                         .matchVariable("RequestHeaderNames")
 *                         .selector("User-Agent")
 *                         .selectorMatchOperator("Equals")
 *                         .build())
 *                     .ruleGroupOverrides(FrontDoorManagedRuleGroupOverrideArgs.builder()
 *                         .exclusions(ManagedRuleExclusionArgs.builder()
 *                             .matchVariable("RequestCookieNames")
 *                             .selector("token")
 *                             .selectorMatchOperator("StartsWith")
 *                             .build())
 *                         .ruleGroupName("SQLI")
 *                         .rules(
 *                             FrontDoorManagedRuleOverrideArgs.builder()
 *                                 .action("Redirect")
 *                                 .enabledState("Enabled")
 *                                 .exclusions(ManagedRuleExclusionArgs.builder()
 *                                     .matchVariable("QueryStringArgNames")
 *                                     .selector("query")
 *                                     .selectorMatchOperator("Equals")
 *                                     .build())
 *                                 .ruleId("942100")
 *                                 .build(),
 *                             FrontDoorManagedRuleOverrideArgs.builder()
 *                                 .enabledState("Disabled")
 *                                 .ruleId("942110")
 *                                 .build())
 *                         .build())
 *                     .ruleSetAction("Block")
 *                     .ruleSetType("DefaultRuleSet")
 *                     .ruleSetVersion("1.0")
 *                     .build())
 *                 .build())
 *             .policyName("Policy1")
 *             .policySettings(FrontDoorPolicySettingsArgs.builder()
 *                 .customBlockResponseBody("PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg==")
 *                 .customBlockResponseStatusCode(429)
 *                 .enabledState("Enabled")
 *                 .mode("Prevention")
 *                 .redirectUrl("http://www.bing.com")
 *                 .requestBodyCheck("Disabled")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .sku(SkuArgs.builder()
 *                 .name("Classic_AzureFrontDoor")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:Policy Policy1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/FrontDoorWebApplicationFirewallPolicies/{policyName}
 * ```
 */
public class Policy internal constructor(
    override val javaResource: com.pulumi.azurenative.network.Policy,
) : KotlinCustomResource(javaResource, PolicyMapper) {
    /**
     * Describes custom rules inside the policy.
     */
    public val customRules: Output<CustomRuleListResponse>?
        get() = javaResource.customRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    customRuleListResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets a unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Describes Frontend Endpoints associated with this Web Application Firewall policy.
     */
    public val frontendEndpointLinks: Output<List<FrontendEndpointLinkResponse>>
        get() = javaResource.frontendEndpointLinks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> frontendEndpointLinkResponseToKotlin(args0) })
            })
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Describes managed rules inside the policy.
     */
    public val managedRules: Output<ManagedRuleSetListResponse>?
        get() = javaResource.managedRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedRuleSetListResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Describes settings for the policy.
     */
    public val policySettings: Output<FrontDoorPolicySettingsResponse>?
        get() = javaResource.policySettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> frontDoorPolicySettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Provisioning state of the policy.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    public val resourceState: Output<String>
        get() = javaResource.resourceState().applyValue({ args0 -> args0 })

    /**
     * Describes Routing Rules associated with this Web Application Firewall policy.
     */
    public val routingRuleLinks: Output<List<RoutingRuleLinkResponse>>
        get() = javaResource.routingRuleLinks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> routingRuleLinkResponseToKotlin(args0) })
            })
        })

    /**
     * Describes Security Policy associated with this Web Application Firewall policy.
     */
    public val securityPolicyLinks: Output<List<SecurityPolicyLinkResponse>>
        get() = javaResource.securityPolicyLinks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> securityPolicyLinkResponseToKotlin(args0) })
            })
        })

    /**
     * The pricing tier of web application firewall policy. Defaults to Classic_AzureFrontDoor if not specified.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PolicyMapper : ResourceMapper<Policy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.Policy::class == javaResource::class

    override fun map(javaResource: Resource): Policy = Policy(
        javaResource as
            com.pulumi.azurenative.network.Policy,
    )
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Policy].
 */
public suspend fun policy(name: String, block: suspend PolicyResourceBuilder.() -> Unit): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policy(name: String): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
