@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ARecordResponse
import com.pulumi.azurenative.network.kotlin.outputs.AaaaRecordResponse
import com.pulumi.azurenative.network.kotlin.outputs.CnameRecordResponse
import com.pulumi.azurenative.network.kotlin.outputs.MxRecordResponse
import com.pulumi.azurenative.network.kotlin.outputs.PtrRecordResponse
import com.pulumi.azurenative.network.kotlin.outputs.SoaRecordResponse
import com.pulumi.azurenative.network.kotlin.outputs.SrvRecordResponse
import com.pulumi.azurenative.network.kotlin.outputs.TxtRecordResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.ARecordResponse.Companion.toKotlin as aRecordResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.AaaaRecordResponse.Companion.toKotlin as aaaaRecordResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.CnameRecordResponse.Companion.toKotlin as cnameRecordResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.MxRecordResponse.Companion.toKotlin as mxRecordResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PtrRecordResponse.Companion.toKotlin as ptrRecordResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SoaRecordResponse.Companion.toKotlin as soaRecordResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SrvRecordResponse.Companion.toKotlin as srvRecordResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.TxtRecordResponse.Companion.toKotlin as txtRecordResponseToKotlin

/**
 * Builder for [PrivateRecordSet].
 */
@PulumiTagMarker
public class PrivateRecordSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateRecordSetArgs = PrivateRecordSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateRecordSetArgsBuilder.() -> Unit) {
        val builder = PrivateRecordSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrivateRecordSet {
        val builtJavaResource = com.pulumi.azurenative.network.PrivateRecordSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PrivateRecordSet(builtJavaResource)
    }
}

/**
 * Describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS zone.
 * Azure REST API version: 2020-06-01. Prior API version in Azure Native 1.x: 2020-06-01.
 * ## Example Usage
 * ### PUT Private DNS Zone A Record Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateRecordSet = new AzureNative.Network.PrivateRecordSet("privateRecordSet", new()
 *     {
 *         ARecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.ARecordArgs
 *             {
 *                 Ipv4Address = "1.2.3.4",
 *             },
 *         },
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         PrivateZoneName = "privatezone1.com",
 *         RecordType = "A",
 *         RelativeRecordSetName = "recordA",
 *         ResourceGroupName = "resourceGroup1",
 *         Ttl = 3600,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateRecordSet(ctx, "privateRecordSet", &network.PrivateRecordSetArgs{
 * 			ARecords: network.ARecordArray{
 * 				&network.ARecordArgs{
 * 					Ipv4Address: pulumi.String("1.2.3.4"),
 * 				},
 * 			},
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			PrivateZoneName:       pulumi.String("privatezone1.com"),
 * 			RecordType:            pulumi.String("A"),
 * 			RelativeRecordSetName: pulumi.String("recordA"),
 * 			ResourceGroupName:     pulumi.String("resourceGroup1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateRecordSet;
 * import com.pulumi.azurenative.network.PrivateRecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.ARecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateRecordSet = new PrivateRecordSet("privateRecordSet", PrivateRecordSetArgs.builder()
 *             .aRecords(ARecordArgs.builder()
 *                 .ipv4Address("1.2.3.4")
 *                 .build())
 *             .metadata(Map.of("key1", "value1"))
 *             .privateZoneName("privatezone1.com")
 *             .recordType("A")
 *             .relativeRecordSetName("recordA")
 *             .resourceGroupName("resourceGroup1")
 *             .ttl(3600)
 *             .build());
 *     }
 * }
 * ```
 * ### PUT Private DNS Zone AAAA Record Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateRecordSet = new AzureNative.Network.PrivateRecordSet("privateRecordSet", new()
 *     {
 *         AaaaRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.AaaaRecordArgs
 *             {
 *                 Ipv6Address = "::1",
 *             },
 *         },
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         PrivateZoneName = "privatezone1.com",
 *         RecordType = "AAAA",
 *         RelativeRecordSetName = "recordAAAA",
 *         ResourceGroupName = "resourceGroup1",
 *         Ttl = 3600,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateRecordSet(ctx, "privateRecordSet", &network.PrivateRecordSetArgs{
 * 			AaaaRecords: network.AaaaRecordArray{
 * 				&network.AaaaRecordArgs{
 * 					Ipv6Address: pulumi.String("::1"),
 * 				},
 * 			},
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			PrivateZoneName:       pulumi.String("privatezone1.com"),
 * 			RecordType:            pulumi.String("AAAA"),
 * 			RelativeRecordSetName: pulumi.String("recordAAAA"),
 * 			ResourceGroupName:     pulumi.String("resourceGroup1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateRecordSet;
 * import com.pulumi.azurenative.network.PrivateRecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.AaaaRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateRecordSet = new PrivateRecordSet("privateRecordSet", PrivateRecordSetArgs.builder()
 *             .aaaaRecords(AaaaRecordArgs.builder()
 *                 .ipv6Address("::1")
 *                 .build())
 *             .metadata(Map.of("key1", "value1"))
 *             .privateZoneName("privatezone1.com")
 *             .recordType("AAAA")
 *             .relativeRecordSetName("recordAAAA")
 *             .resourceGroupName("resourceGroup1")
 *             .ttl(3600)
 *             .build());
 *     }
 * }
 * ```
 * ### PUT Private DNS Zone CNAME Record Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateRecordSet = new AzureNative.Network.PrivateRecordSet("privateRecordSet", new()
 *     {
 *         CnameRecord = new AzureNative.Network.Inputs.CnameRecordArgs
 *         {
 *             Cname = "contoso.com",
 *         },
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         PrivateZoneName = "privatezone1.com",
 *         RecordType = "CNAME",
 *         RelativeRecordSetName = "recordCNAME",
 *         ResourceGroupName = "resourceGroup1",
 *         Ttl = 3600,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateRecordSet(ctx, "privateRecordSet", &network.PrivateRecordSetArgs{
 * 			CnameRecord: &network.CnameRecordArgs{
 * 				Cname: pulumi.String("contoso.com"),
 * 			},
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			PrivateZoneName:       pulumi.String("privatezone1.com"),
 * 			RecordType:            pulumi.String("CNAME"),
 * 			RelativeRecordSetName: pulumi.String("recordCNAME"),
 * 			ResourceGroupName:     pulumi.String("resourceGroup1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateRecordSet;
 * import com.pulumi.azurenative.network.PrivateRecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.CnameRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateRecordSet = new PrivateRecordSet("privateRecordSet", PrivateRecordSetArgs.builder()
 *             .cnameRecord(CnameRecordArgs.builder()
 *                 .cname("contoso.com")
 *                 .build())
 *             .metadata(Map.of("key1", "value1"))
 *             .privateZoneName("privatezone1.com")
 *             .recordType("CNAME")
 *             .relativeRecordSetName("recordCNAME")
 *             .resourceGroupName("resourceGroup1")
 *             .ttl(3600)
 *             .build());
 *     }
 * }
 * ```
 * ### PUT Private DNS Zone MX Record Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateRecordSet = new AzureNative.Network.PrivateRecordSet("privateRecordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         MxRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.MxRecordArgs
 *             {
 *                 Exchange = "mail.privatezone1.com",
 *                 Preference = 0,
 *             },
 *         },
 *         PrivateZoneName = "privatezone1.com",
 *         RecordType = "MX",
 *         RelativeRecordSetName = "recordMX",
 *         ResourceGroupName = "resourceGroup1",
 *         Ttl = 3600,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateRecordSet(ctx, "privateRecordSet", &network.PrivateRecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			MxRecords: network.MxRecordArray{
 * 				&network.MxRecordArgs{
 * 					Exchange:   pulumi.String("mail.privatezone1.com"),
 * 					Preference: pulumi.Int(0),
 * 				},
 * 			},
 * 			PrivateZoneName:       pulumi.String("privatezone1.com"),
 * 			RecordType:            pulumi.String("MX"),
 * 			RelativeRecordSetName: pulumi.String("recordMX"),
 * 			ResourceGroupName:     pulumi.String("resourceGroup1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateRecordSet;
 * import com.pulumi.azurenative.network.PrivateRecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.MxRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateRecordSet = new PrivateRecordSet("privateRecordSet", PrivateRecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .mxRecords(MxRecordArgs.builder()
 *                 .exchange("mail.privatezone1.com")
 *                 .preference(0)
 *                 .build())
 *             .privateZoneName("privatezone1.com")
 *             .recordType("MX")
 *             .relativeRecordSetName("recordMX")
 *             .resourceGroupName("resourceGroup1")
 *             .ttl(3600)
 *             .build());
 *     }
 * }
 * ```
 * ### PUT Private DNS Zone PTR Record Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateRecordSet = new AzureNative.Network.PrivateRecordSet("privateRecordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         PrivateZoneName = "0.0.127.in-addr.arpa",
 *         PtrRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.PtrRecordArgs
 *             {
 *                 Ptrdname = "localhost",
 *             },
 *         },
 *         RecordType = "PTR",
 *         RelativeRecordSetName = "1",
 *         ResourceGroupName = "resourceGroup1",
 *         Ttl = 3600,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateRecordSet(ctx, "privateRecordSet", &network.PrivateRecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			PrivateZoneName: pulumi.String("0.0.127.in-addr.arpa"),
 * 			PtrRecords: network.PtrRecordArray{
 * 				&network.PtrRecordArgs{
 * 					Ptrdname: pulumi.String("localhost"),
 * 				},
 * 			},
 * 			RecordType:            pulumi.String("PTR"),
 * 			RelativeRecordSetName: pulumi.String("1"),
 * 			ResourceGroupName:     pulumi.String("resourceGroup1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateRecordSet;
 * import com.pulumi.azurenative.network.PrivateRecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.PtrRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateRecordSet = new PrivateRecordSet("privateRecordSet", PrivateRecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .privateZoneName("0.0.127.in-addr.arpa")
 *             .ptrRecords(PtrRecordArgs.builder()
 *                 .ptrdname("localhost")
 *                 .build())
 *             .recordType("PTR")
 *             .relativeRecordSetName("1")
 *             .resourceGroupName("resourceGroup1")
 *             .ttl(3600)
 *             .build());
 *     }
 * }
 * ```
 * ### PUT Private DNS Zone SOA Record Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateRecordSet = new AzureNative.Network.PrivateRecordSet("privateRecordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         PrivateZoneName = "privatezone1.com",
 *         RecordType = "SOA",
 *         RelativeRecordSetName = "@",
 *         ResourceGroupName = "resourceGroup1",
 *         SoaRecord = new AzureNative.Network.Inputs.SoaRecordArgs
 *         {
 *             Email = "azureprivatedns-hostmaster.microsoft.com",
 *             ExpireTime = 2419200,
 *             Host = "azureprivatedns.net",
 *             MinimumTtl = 300,
 *             RefreshTime = 3600,
 *             RetryTime = 300,
 *             SerialNumber = 1,
 *         },
 *         Ttl = 3600,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateRecordSet(ctx, "privateRecordSet", &network.PrivateRecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			PrivateZoneName:       pulumi.String("privatezone1.com"),
 * 			RecordType:            pulumi.String("SOA"),
 * 			RelativeRecordSetName: pulumi.String("@"),
 * 			ResourceGroupName:     pulumi.String("resourceGroup1"),
 * 			SoaRecord: &network.SoaRecordArgs{
 * 				Email:        pulumi.String("azureprivatedns-hostmaster.microsoft.com"),
 * 				ExpireTime:   pulumi.Float64(2419200),
 * 				Host:         pulumi.String("azureprivatedns.net"),
 * 				MinimumTtl:   pulumi.Float64(300),
 * 				RefreshTime:  pulumi.Float64(3600),
 * 				RetryTime:    pulumi.Float64(300),
 * 				SerialNumber: pulumi.Float64(1),
 * 			},
 * 			Ttl: pulumi.Float64(3600),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateRecordSet;
 * import com.pulumi.azurenative.network.PrivateRecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.SoaRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateRecordSet = new PrivateRecordSet("privateRecordSet", PrivateRecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .privateZoneName("privatezone1.com")
 *             .recordType("SOA")
 *             .relativeRecordSetName("@")
 *             .resourceGroupName("resourceGroup1")
 *             .soaRecord(SoaRecordArgs.builder()
 *                 .email("azureprivatedns-hostmaster.microsoft.com")
 *                 .expireTime(2419200)
 *                 .host("azureprivatedns.net")
 *                 .minimumTtl(300)
 *                 .refreshTime(3600)
 *                 .retryTime(300)
 *                 .serialNumber(1)
 *                 .build())
 *             .ttl(3600)
 *             .build());
 *     }
 * }
 * ```
 * ### PUT Private DNS Zone SRV Record Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateRecordSet = new AzureNative.Network.PrivateRecordSet("privateRecordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         PrivateZoneName = "privatezone1.com",
 *         RecordType = "SRV",
 *         RelativeRecordSetName = "recordSRV",
 *         ResourceGroupName = "resourceGroup1",
 *         SrvRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.SrvRecordArgs
 *             {
 *                 Port = 80,
 *                 Priority = 0,
 *                 Target = "contoso.com",
 *                 Weight = 10,
 *             },
 *         },
 *         Ttl = 3600,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateRecordSet(ctx, "privateRecordSet", &network.PrivateRecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			PrivateZoneName:       pulumi.String("privatezone1.com"),
 * 			RecordType:            pulumi.String("SRV"),
 * 			RelativeRecordSetName: pulumi.String("recordSRV"),
 * 			ResourceGroupName:     pulumi.String("resourceGroup1"),
 * 			SrvRecords: network.SrvRecordArray{
 * 				&network.SrvRecordArgs{
 * 					Port:     pulumi.Int(80),
 * 					Priority: pulumi.Int(0),
 * 					Target:   pulumi.String("contoso.com"),
 * 					Weight:   pulumi.Int(10),
 * 				},
 * 			},
 * 			Ttl: pulumi.Float64(3600),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateRecordSet;
 * import com.pulumi.azurenative.network.PrivateRecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.SrvRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateRecordSet = new PrivateRecordSet("privateRecordSet", PrivateRecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .privateZoneName("privatezone1.com")
 *             .recordType("SRV")
 *             .relativeRecordSetName("recordSRV")
 *             .resourceGroupName("resourceGroup1")
 *             .srvRecords(SrvRecordArgs.builder()
 *                 .port(80)
 *                 .priority(0)
 *                 .target("contoso.com")
 *                 .weight(10)
 *                 .build())
 *             .ttl(3600)
 *             .build());
 *     }
 * }
 * ```
 * ### PUT Private DNS Zone TXT Record Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateRecordSet = new AzureNative.Network.PrivateRecordSet("privateRecordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         PrivateZoneName = "privatezone1.com",
 *         RecordType = "TXT",
 *         RelativeRecordSetName = "recordTXT",
 *         ResourceGroupName = "resourceGroup1",
 *         Ttl = 3600,
 *         TxtRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.TxtRecordArgs
 *             {
 *                 Value = new[]
 *                 {
 *                     "string1",
 *                     "string2",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateRecordSet(ctx, "privateRecordSet", &network.PrivateRecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			PrivateZoneName:       pulumi.String("privatezone1.com"),
 * 			RecordType:            pulumi.String("TXT"),
 * 			RelativeRecordSetName: pulumi.String("recordTXT"),
 * 			ResourceGroupName:     pulumi.String("resourceGroup1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 			TxtRecords: network.TxtRecordArray{
 * 				&network.TxtRecordArgs{
 * 					Value: pulumi.StringArray{
 * 						pulumi.String("string1"),
 * 						pulumi.String("string2"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateRecordSet;
 * import com.pulumi.azurenative.network.PrivateRecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.TxtRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateRecordSet = new PrivateRecordSet("privateRecordSet", PrivateRecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .privateZoneName("privatezone1.com")
 *             .recordType("TXT")
 *             .relativeRecordSetName("recordTXT")
 *             .resourceGroupName("resourceGroup1")
 *             .ttl(3600)
 *             .txtRecords(TxtRecordArgs.builder()
 *                 .value(
 *                     "string1",
 *                     "string2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:PrivateRecordSet recordtxt /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateZoneName}/{recordType}/{relativeRecordSetName}
 * ```
 */
public class PrivateRecordSet internal constructor(
    override val javaResource: com.pulumi.azurenative.network.PrivateRecordSet,
) : KotlinCustomResource(javaResource, PrivateRecordSetMapper) {
    /**
     * The list of A records in the record set.
     */
    public val aRecords: Output<List<ARecordResponse>>?
        get() = javaResource.aRecords().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> aRecordResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The list of AAAA records in the record set.
     */
    public val aaaaRecords: Output<List<AaaaRecordResponse>>?
        get() = javaResource.aaaaRecords().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> aaaaRecordResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The CNAME record in the record set.
     */
    public val cnameRecord: Output<CnameRecordResponse>?
        get() = javaResource.cnameRecord().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    cnameRecordResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The ETag of the record set.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Fully qualified domain name of the record set.
     */
    public val fqdn: Output<String>
        get() = javaResource.fqdn().applyValue({ args0 -> args0 })

    /**
     * Is the record set auto-registered in the Private DNS zone through a virtual network link?
     */
    public val isAutoRegistered: Output<Boolean>
        get() = javaResource.isAutoRegistered().applyValue({ args0 -> args0 })

    /**
     * The metadata attached to the record set.
     */
    public val metadata: Output<Map<String, String>>?
        get() = javaResource.metadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The list of MX records in the record set.
     */
    public val mxRecords: Output<List<MxRecordResponse>>?
        get() = javaResource.mxRecords().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> mxRecordResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The list of PTR records in the record set.
     */
    public val ptrRecords: Output<List<PtrRecordResponse>>?
        get() = javaResource.ptrRecords().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> ptrRecordResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The SOA record in the record set.
     */
    public val soaRecord: Output<SoaRecordResponse>?
        get() = javaResource.soaRecord().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    soaRecordResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The list of SRV records in the record set.
     */
    public val srvRecords: Output<List<SrvRecordResponse>>?
        get() = javaResource.srvRecords().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> srvRecordResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The TTL (time-to-live) of the records in the record set.
     */
    public val ttl: Output<Double>?
        get() = javaResource.ttl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The list of TXT records in the record set.
     */
    public val txtRecords: Output<List<TxtRecordResponse>>?
        get() = javaResource.txtRecords().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> txtRecordResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. Example - 'Microsoft.Network/privateDnsZones'.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateRecordSetMapper : ResourceMapper<PrivateRecordSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.PrivateRecordSet::class == javaResource::class

    override fun map(javaResource: Resource): PrivateRecordSet = PrivateRecordSet(
        javaResource as
            com.pulumi.azurenative.network.PrivateRecordSet,
    )
}

/**
 * @see [PrivateRecordSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateRecordSet].
 */
public suspend fun privateRecordSet(
    name: String,
    block: suspend PrivateRecordSetResourceBuilder.() -> Unit,
): PrivateRecordSet {
    val builder = PrivateRecordSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateRecordSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateRecordSet(name: String): PrivateRecordSet {
    val builder = PrivateRecordSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
