@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.PrivateRecordSetArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.ARecordArgs
import com.pulumi.azurenative.network.kotlin.inputs.ARecordArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.AaaaRecordArgs
import com.pulumi.azurenative.network.kotlin.inputs.AaaaRecordArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.CnameRecordArgs
import com.pulumi.azurenative.network.kotlin.inputs.CnameRecordArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.MxRecordArgs
import com.pulumi.azurenative.network.kotlin.inputs.MxRecordArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.PtrRecordArgs
import com.pulumi.azurenative.network.kotlin.inputs.PtrRecordArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SoaRecordArgs
import com.pulumi.azurenative.network.kotlin.inputs.SoaRecordArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SrvRecordArgs
import com.pulumi.azurenative.network.kotlin.inputs.SrvRecordArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.TxtRecordArgs
import com.pulumi.azurenative.network.kotlin.inputs.TxtRecordArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS zone.
 * Azure REST API version: 2020-06-01. Prior API version in Azure Native 1.x: 2020-06-01.
 * ## Example Usage
 * ### PUT Private DNS Zone A Record Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateRecordSet = new AzureNative.Network.PrivateRecordSet("privateRecordSet", new()
 *     {
 *         ARecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.ARecordArgs
 *             {
 *                 Ipv4Address = "1.2.3.4",
 *             },
 *         },
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         PrivateZoneName = "privatezone1.com",
 *         RecordType = "A",
 *         RelativeRecordSetName = "recordA",
 *         ResourceGroupName = "resourceGroup1",
 *         Ttl = 3600,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateRecordSet(ctx, "privateRecordSet", &network.PrivateRecordSetArgs{
 * 			ARecords: network.ARecordArray{
 * 				&network.ARecordArgs{
 * 					Ipv4Address: pulumi.String("1.2.3.4"),
 * 				},
 * 			},
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			PrivateZoneName:       pulumi.String("privatezone1.com"),
 * 			RecordType:            pulumi.String("A"),
 * 			RelativeRecordSetName: pulumi.String("recordA"),
 * 			ResourceGroupName:     pulumi.String("resourceGroup1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateRecordSet;
 * import com.pulumi.azurenative.network.PrivateRecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.ARecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateRecordSet = new PrivateRecordSet("privateRecordSet", PrivateRecordSetArgs.builder()
 *             .aRecords(ARecordArgs.builder()
 *                 .ipv4Address("1.2.3.4")
 *                 .build())
 *             .metadata(Map.of("key1", "value1"))
 *             .privateZoneName("privatezone1.com")
 *             .recordType("A")
 *             .relativeRecordSetName("recordA")
 *             .resourceGroupName("resourceGroup1")
 *             .ttl(3600)
 *             .build());
 *     }
 * }
 * ```
 * ### PUT Private DNS Zone AAAA Record Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateRecordSet = new AzureNative.Network.PrivateRecordSet("privateRecordSet", new()
 *     {
 *         AaaaRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.AaaaRecordArgs
 *             {
 *                 Ipv6Address = "::1",
 *             },
 *         },
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         PrivateZoneName = "privatezone1.com",
 *         RecordType = "AAAA",
 *         RelativeRecordSetName = "recordAAAA",
 *         ResourceGroupName = "resourceGroup1",
 *         Ttl = 3600,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateRecordSet(ctx, "privateRecordSet", &network.PrivateRecordSetArgs{
 * 			AaaaRecords: network.AaaaRecordArray{
 * 				&network.AaaaRecordArgs{
 * 					Ipv6Address: pulumi.String("::1"),
 * 				},
 * 			},
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			PrivateZoneName:       pulumi.String("privatezone1.com"),
 * 			RecordType:            pulumi.String("AAAA"),
 * 			RelativeRecordSetName: pulumi.String("recordAAAA"),
 * 			ResourceGroupName:     pulumi.String("resourceGroup1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateRecordSet;
 * import com.pulumi.azurenative.network.PrivateRecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.AaaaRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateRecordSet = new PrivateRecordSet("privateRecordSet", PrivateRecordSetArgs.builder()
 *             .aaaaRecords(AaaaRecordArgs.builder()
 *                 .ipv6Address("::1")
 *                 .build())
 *             .metadata(Map.of("key1", "value1"))
 *             .privateZoneName("privatezone1.com")
 *             .recordType("AAAA")
 *             .relativeRecordSetName("recordAAAA")
 *             .resourceGroupName("resourceGroup1")
 *             .ttl(3600)
 *             .build());
 *     }
 * }
 * ```
 * ### PUT Private DNS Zone CNAME Record Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateRecordSet = new AzureNative.Network.PrivateRecordSet("privateRecordSet", new()
 *     {
 *         CnameRecord = new AzureNative.Network.Inputs.CnameRecordArgs
 *         {
 *             Cname = "contoso.com",
 *         },
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         PrivateZoneName = "privatezone1.com",
 *         RecordType = "CNAME",
 *         RelativeRecordSetName = "recordCNAME",
 *         ResourceGroupName = "resourceGroup1",
 *         Ttl = 3600,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateRecordSet(ctx, "privateRecordSet", &network.PrivateRecordSetArgs{
 * 			CnameRecord: &network.CnameRecordArgs{
 * 				Cname: pulumi.String("contoso.com"),
 * 			},
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			PrivateZoneName:       pulumi.String("privatezone1.com"),
 * 			RecordType:            pulumi.String("CNAME"),
 * 			RelativeRecordSetName: pulumi.String("recordCNAME"),
 * 			ResourceGroupName:     pulumi.String("resourceGroup1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateRecordSet;
 * import com.pulumi.azurenative.network.PrivateRecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.CnameRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateRecordSet = new PrivateRecordSet("privateRecordSet", PrivateRecordSetArgs.builder()
 *             .cnameRecord(CnameRecordArgs.builder()
 *                 .cname("contoso.com")
 *                 .build())
 *             .metadata(Map.of("key1", "value1"))
 *             .privateZoneName("privatezone1.com")
 *             .recordType("CNAME")
 *             .relativeRecordSetName("recordCNAME")
 *             .resourceGroupName("resourceGroup1")
 *             .ttl(3600)
 *             .build());
 *     }
 * }
 * ```
 * ### PUT Private DNS Zone MX Record Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateRecordSet = new AzureNative.Network.PrivateRecordSet("privateRecordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         MxRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.MxRecordArgs
 *             {
 *                 Exchange = "mail.privatezone1.com",
 *                 Preference = 0,
 *             },
 *         },
 *         PrivateZoneName = "privatezone1.com",
 *         RecordType = "MX",
 *         RelativeRecordSetName = "recordMX",
 *         ResourceGroupName = "resourceGroup1",
 *         Ttl = 3600,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateRecordSet(ctx, "privateRecordSet", &network.PrivateRecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			MxRecords: network.MxRecordArray{
 * 				&network.MxRecordArgs{
 * 					Exchange:   pulumi.String("mail.privatezone1.com"),
 * 					Preference: pulumi.Int(0),
 * 				},
 * 			},
 * 			PrivateZoneName:       pulumi.String("privatezone1.com"),
 * 			RecordType:            pulumi.String("MX"),
 * 			RelativeRecordSetName: pulumi.String("recordMX"),
 * 			ResourceGroupName:     pulumi.String("resourceGroup1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateRecordSet;
 * import com.pulumi.azurenative.network.PrivateRecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.MxRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateRecordSet = new PrivateRecordSet("privateRecordSet", PrivateRecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .mxRecords(MxRecordArgs.builder()
 *                 .exchange("mail.privatezone1.com")
 *                 .preference(0)
 *                 .build())
 *             .privateZoneName("privatezone1.com")
 *             .recordType("MX")
 *             .relativeRecordSetName("recordMX")
 *             .resourceGroupName("resourceGroup1")
 *             .ttl(3600)
 *             .build());
 *     }
 * }
 * ```
 * ### PUT Private DNS Zone PTR Record Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateRecordSet = new AzureNative.Network.PrivateRecordSet("privateRecordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         PrivateZoneName = "0.0.127.in-addr.arpa",
 *         PtrRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.PtrRecordArgs
 *             {
 *                 Ptrdname = "localhost",
 *             },
 *         },
 *         RecordType = "PTR",
 *         RelativeRecordSetName = "1",
 *         ResourceGroupName = "resourceGroup1",
 *         Ttl = 3600,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateRecordSet(ctx, "privateRecordSet", &network.PrivateRecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			PrivateZoneName: pulumi.String("0.0.127.in-addr.arpa"),
 * 			PtrRecords: network.PtrRecordArray{
 * 				&network.PtrRecordArgs{
 * 					Ptrdname: pulumi.String("localhost"),
 * 				},
 * 			},
 * 			RecordType:            pulumi.String("PTR"),
 * 			RelativeRecordSetName: pulumi.String("1"),
 * 			ResourceGroupName:     pulumi.String("resourceGroup1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateRecordSet;
 * import com.pulumi.azurenative.network.PrivateRecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.PtrRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateRecordSet = new PrivateRecordSet("privateRecordSet", PrivateRecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .privateZoneName("0.0.127.in-addr.arpa")
 *             .ptrRecords(PtrRecordArgs.builder()
 *                 .ptrdname("localhost")
 *                 .build())
 *             .recordType("PTR")
 *             .relativeRecordSetName("1")
 *             .resourceGroupName("resourceGroup1")
 *             .ttl(3600)
 *             .build());
 *     }
 * }
 * ```
 * ### PUT Private DNS Zone SOA Record Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateRecordSet = new AzureNative.Network.PrivateRecordSet("privateRecordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         PrivateZoneName = "privatezone1.com",
 *         RecordType = "SOA",
 *         RelativeRecordSetName = "@",
 *         ResourceGroupName = "resourceGroup1",
 *         SoaRecord = new AzureNative.Network.Inputs.SoaRecordArgs
 *         {
 *             Email = "azureprivatedns-hostmaster.microsoft.com",
 *             ExpireTime = 2419200,
 *             Host = "azureprivatedns.net",
 *             MinimumTtl = 300,
 *             RefreshTime = 3600,
 *             RetryTime = 300,
 *             SerialNumber = 1,
 *         },
 *         Ttl = 3600,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateRecordSet(ctx, "privateRecordSet", &network.PrivateRecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			PrivateZoneName:       pulumi.String("privatezone1.com"),
 * 			RecordType:            pulumi.String("SOA"),
 * 			RelativeRecordSetName: pulumi.String("@"),
 * 			ResourceGroupName:     pulumi.String("resourceGroup1"),
 * 			SoaRecord: &network.SoaRecordArgs{
 * 				Email:        pulumi.String("azureprivatedns-hostmaster.microsoft.com"),
 * 				ExpireTime:   pulumi.Float64(2419200),
 * 				Host:         pulumi.String("azureprivatedns.net"),
 * 				MinimumTtl:   pulumi.Float64(300),
 * 				RefreshTime:  pulumi.Float64(3600),
 * 				RetryTime:    pulumi.Float64(300),
 * 				SerialNumber: pulumi.Float64(1),
 * 			},
 * 			Ttl: pulumi.Float64(3600),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateRecordSet;
 * import com.pulumi.azurenative.network.PrivateRecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.SoaRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateRecordSet = new PrivateRecordSet("privateRecordSet", PrivateRecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .privateZoneName("privatezone1.com")
 *             .recordType("SOA")
 *             .relativeRecordSetName("@")
 *             .resourceGroupName("resourceGroup1")
 *             .soaRecord(SoaRecordArgs.builder()
 *                 .email("azureprivatedns-hostmaster.microsoft.com")
 *                 .expireTime(2419200)
 *                 .host("azureprivatedns.net")
 *                 .minimumTtl(300)
 *                 .refreshTime(3600)
 *                 .retryTime(300)
 *                 .serialNumber(1)
 *                 .build())
 *             .ttl(3600)
 *             .build());
 *     }
 * }
 * ```
 * ### PUT Private DNS Zone SRV Record Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateRecordSet = new AzureNative.Network.PrivateRecordSet("privateRecordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         PrivateZoneName = "privatezone1.com",
 *         RecordType = "SRV",
 *         RelativeRecordSetName = "recordSRV",
 *         ResourceGroupName = "resourceGroup1",
 *         SrvRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.SrvRecordArgs
 *             {
 *                 Port = 80,
 *                 Priority = 0,
 *                 Target = "contoso.com",
 *                 Weight = 10,
 *             },
 *         },
 *         Ttl = 3600,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateRecordSet(ctx, "privateRecordSet", &network.PrivateRecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			PrivateZoneName:       pulumi.String("privatezone1.com"),
 * 			RecordType:            pulumi.String("SRV"),
 * 			RelativeRecordSetName: pulumi.String("recordSRV"),
 * 			ResourceGroupName:     pulumi.String("resourceGroup1"),
 * 			SrvRecords: network.SrvRecordArray{
 * 				&network.SrvRecordArgs{
 * 					Port:     pulumi.Int(80),
 * 					Priority: pulumi.Int(0),
 * 					Target:   pulumi.String("contoso.com"),
 * 					Weight:   pulumi.Int(10),
 * 				},
 * 			},
 * 			Ttl: pulumi.Float64(3600),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateRecordSet;
 * import com.pulumi.azurenative.network.PrivateRecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.SrvRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateRecordSet = new PrivateRecordSet("privateRecordSet", PrivateRecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .privateZoneName("privatezone1.com")
 *             .recordType("SRV")
 *             .relativeRecordSetName("recordSRV")
 *             .resourceGroupName("resourceGroup1")
 *             .srvRecords(SrvRecordArgs.builder()
 *                 .port(80)
 *                 .priority(0)
 *                 .target("contoso.com")
 *                 .weight(10)
 *                 .build())
 *             .ttl(3600)
 *             .build());
 *     }
 * }
 * ```
 * ### PUT Private DNS Zone TXT Record Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateRecordSet = new AzureNative.Network.PrivateRecordSet("privateRecordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         PrivateZoneName = "privatezone1.com",
 *         RecordType = "TXT",
 *         RelativeRecordSetName = "recordTXT",
 *         ResourceGroupName = "resourceGroup1",
 *         Ttl = 3600,
 *         TxtRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.TxtRecordArgs
 *             {
 *                 Value = new[]
 *                 {
 *                     "string1",
 *                     "string2",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateRecordSet(ctx, "privateRecordSet", &network.PrivateRecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			PrivateZoneName:       pulumi.String("privatezone1.com"),
 * 			RecordType:            pulumi.String("TXT"),
 * 			RelativeRecordSetName: pulumi.String("recordTXT"),
 * 			ResourceGroupName:     pulumi.String("resourceGroup1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 			TxtRecords: network.TxtRecordArray{
 * 				&network.TxtRecordArgs{
 * 					Value: pulumi.StringArray{
 * 						pulumi.String("string1"),
 * 						pulumi.String("string2"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateRecordSet;
 * import com.pulumi.azurenative.network.PrivateRecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.TxtRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateRecordSet = new PrivateRecordSet("privateRecordSet", PrivateRecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .privateZoneName("privatezone1.com")
 *             .recordType("TXT")
 *             .relativeRecordSetName("recordTXT")
 *             .resourceGroupName("resourceGroup1")
 *             .ttl(3600)
 *             .txtRecords(TxtRecordArgs.builder()
 *                 .value(
 *                     "string1",
 *                     "string2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:PrivateRecordSet recordtxt /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateZoneName}/{recordType}/{relativeRecordSetName}
 * ```
 * @property aRecords The list of A records in the record set.
 * @property aaaaRecords The list of AAAA records in the record set.
 * @property cnameRecord The CNAME record in the record set.
 * @property metadata The metadata attached to the record set.
 * @property mxRecords The list of MX records in the record set.
 * @property privateZoneName The name of the Private DNS zone (without a terminating dot).
 * @property ptrRecords The list of PTR records in the record set.
 * @property recordType The type of DNS record in this record set. Record sets of type SOA can be updated but not created (they are created when the Private DNS zone is created).
 * @property relativeRecordSetName The name of the record set, relative to the name of the zone.
 * @property resourceGroupName The name of the resource group.
 * @property soaRecord The SOA record in the record set.
 * @property srvRecords The list of SRV records in the record set.
 * @property ttl The TTL (time-to-live) of the records in the record set.
 * @property txtRecords The list of TXT records in the record set.
 */
public data class PrivateRecordSetArgs(
    public val aRecords: Output<List<ARecordArgs>>? = null,
    public val aaaaRecords: Output<List<AaaaRecordArgs>>? = null,
    public val cnameRecord: Output<CnameRecordArgs>? = null,
    public val metadata: Output<Map<String, String>>? = null,
    public val mxRecords: Output<List<MxRecordArgs>>? = null,
    public val privateZoneName: Output<String>? = null,
    public val ptrRecords: Output<List<PtrRecordArgs>>? = null,
    public val recordType: Output<String>? = null,
    public val relativeRecordSetName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val soaRecord: Output<SoaRecordArgs>? = null,
    public val srvRecords: Output<List<SrvRecordArgs>>? = null,
    public val ttl: Output<Double>? = null,
    public val txtRecords: Output<List<TxtRecordArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.PrivateRecordSetArgs> {
    override fun toJava(): com.pulumi.azurenative.network.PrivateRecordSetArgs =
        com.pulumi.azurenative.network.PrivateRecordSetArgs.builder()
            .aRecords(
                aRecords?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .aaaaRecords(
                aaaaRecords?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .cnameRecord(cnameRecord?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .mxRecords(
                mxRecords?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .privateZoneName(privateZoneName?.applyValue({ args0 -> args0 }))
            .ptrRecords(
                ptrRecords?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .recordType(recordType?.applyValue({ args0 -> args0 }))
            .relativeRecordSetName(relativeRecordSetName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .soaRecord(soaRecord?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .srvRecords(
                srvRecords?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ttl(ttl?.applyValue({ args0 -> args0 }))
            .txtRecords(
                txtRecords?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PrivateRecordSetArgs].
 */
@PulumiTagMarker
public class PrivateRecordSetArgsBuilder internal constructor() {
    private var aRecords: Output<List<ARecordArgs>>? = null

    private var aaaaRecords: Output<List<AaaaRecordArgs>>? = null

    private var cnameRecord: Output<CnameRecordArgs>? = null

    private var metadata: Output<Map<String, String>>? = null

    private var mxRecords: Output<List<MxRecordArgs>>? = null

    private var privateZoneName: Output<String>? = null

    private var ptrRecords: Output<List<PtrRecordArgs>>? = null

    private var recordType: Output<String>? = null

    private var relativeRecordSetName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var soaRecord: Output<SoaRecordArgs>? = null

    private var srvRecords: Output<List<SrvRecordArgs>>? = null

    private var ttl: Output<Double>? = null

    private var txtRecords: Output<List<TxtRecordArgs>>? = null

    /**
     * @param value The list of A records in the record set.
     */
    @JvmName("xphmlswxukxidsnx")
    public suspend fun aRecords(`value`: Output<List<ARecordArgs>>) {
        this.aRecords = value
    }

    @JvmName("frwbbgbyhsxinqef")
    public suspend fun aRecords(vararg values: Output<ARecordArgs>) {
        this.aRecords = Output.all(values.asList())
    }

    /**
     * @param values The list of A records in the record set.
     */
    @JvmName("vwxuwkijuxvmkaat")
    public suspend fun aRecords(values: List<Output<ARecordArgs>>) {
        this.aRecords = Output.all(values)
    }

    /**
     * @param value The list of AAAA records in the record set.
     */
    @JvmName("eqmdficwsjserucv")
    public suspend fun aaaaRecords(`value`: Output<List<AaaaRecordArgs>>) {
        this.aaaaRecords = value
    }

    @JvmName("fowbbvmfmjwyyrka")
    public suspend fun aaaaRecords(vararg values: Output<AaaaRecordArgs>) {
        this.aaaaRecords = Output.all(values.asList())
    }

    /**
     * @param values The list of AAAA records in the record set.
     */
    @JvmName("vvmnedbdrxsjhcjg")
    public suspend fun aaaaRecords(values: List<Output<AaaaRecordArgs>>) {
        this.aaaaRecords = Output.all(values)
    }

    /**
     * @param value The CNAME record in the record set.
     */
    @JvmName("rxlvvbeqdfmrvpky")
    public suspend fun cnameRecord(`value`: Output<CnameRecordArgs>) {
        this.cnameRecord = value
    }

    /**
     * @param value The metadata attached to the record set.
     */
    @JvmName("isoyihnmujttcemd")
    public suspend fun metadata(`value`: Output<Map<String, String>>) {
        this.metadata = value
    }

    /**
     * @param value The list of MX records in the record set.
     */
    @JvmName("jnocturdyhvfjqiq")
    public suspend fun mxRecords(`value`: Output<List<MxRecordArgs>>) {
        this.mxRecords = value
    }

    @JvmName("kegodgyepnbuwmub")
    public suspend fun mxRecords(vararg values: Output<MxRecordArgs>) {
        this.mxRecords = Output.all(values.asList())
    }

    /**
     * @param values The list of MX records in the record set.
     */
    @JvmName("ebhhiajoeiduacio")
    public suspend fun mxRecords(values: List<Output<MxRecordArgs>>) {
        this.mxRecords = Output.all(values)
    }

    /**
     * @param value The name of the Private DNS zone (without a terminating dot).
     */
    @JvmName("wnputmpviesrtuft")
    public suspend fun privateZoneName(`value`: Output<String>) {
        this.privateZoneName = value
    }

    /**
     * @param value The list of PTR records in the record set.
     */
    @JvmName("jsgygxebmbositfu")
    public suspend fun ptrRecords(`value`: Output<List<PtrRecordArgs>>) {
        this.ptrRecords = value
    }

    @JvmName("ltmsbwwaledwhmci")
    public suspend fun ptrRecords(vararg values: Output<PtrRecordArgs>) {
        this.ptrRecords = Output.all(values.asList())
    }

    /**
     * @param values The list of PTR records in the record set.
     */
    @JvmName("ximcldcorqdvibsb")
    public suspend fun ptrRecords(values: List<Output<PtrRecordArgs>>) {
        this.ptrRecords = Output.all(values)
    }

    /**
     * @param value The type of DNS record in this record set. Record sets of type SOA can be updated but not created (they are created when the Private DNS zone is created).
     */
    @JvmName("ndceftnseaimuole")
    public suspend fun recordType(`value`: Output<String>) {
        this.recordType = value
    }

    /**
     * @param value The name of the record set, relative to the name of the zone.
     */
    @JvmName("vfqokveawdsaguic")
    public suspend fun relativeRecordSetName(`value`: Output<String>) {
        this.relativeRecordSetName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("nlbouckwaqielkqe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The SOA record in the record set.
     */
    @JvmName("opwrqrahfnrwmlyn")
    public suspend fun soaRecord(`value`: Output<SoaRecordArgs>) {
        this.soaRecord = value
    }

    /**
     * @param value The list of SRV records in the record set.
     */
    @JvmName("bwwmixnkbabcudrq")
    public suspend fun srvRecords(`value`: Output<List<SrvRecordArgs>>) {
        this.srvRecords = value
    }

    @JvmName("qdbexashjqnyiviw")
    public suspend fun srvRecords(vararg values: Output<SrvRecordArgs>) {
        this.srvRecords = Output.all(values.asList())
    }

    /**
     * @param values The list of SRV records in the record set.
     */
    @JvmName("bbxyvhkopbtsondo")
    public suspend fun srvRecords(values: List<Output<SrvRecordArgs>>) {
        this.srvRecords = Output.all(values)
    }

    /**
     * @param value The TTL (time-to-live) of the records in the record set.
     */
    @JvmName("eihckkqcloiwakmv")
    public suspend fun ttl(`value`: Output<Double>) {
        this.ttl = value
    }

    /**
     * @param value The list of TXT records in the record set.
     */
    @JvmName("bqvntayadypvsddb")
    public suspend fun txtRecords(`value`: Output<List<TxtRecordArgs>>) {
        this.txtRecords = value
    }

    @JvmName("fmlogixymptbaqhh")
    public suspend fun txtRecords(vararg values: Output<TxtRecordArgs>) {
        this.txtRecords = Output.all(values.asList())
    }

    /**
     * @param values The list of TXT records in the record set.
     */
    @JvmName("mgywmkhajwrsguqd")
    public suspend fun txtRecords(values: List<Output<TxtRecordArgs>>) {
        this.txtRecords = Output.all(values)
    }

    /**
     * @param value The list of A records in the record set.
     */
    @JvmName("ftbrxvrjmupvijmh")
    public suspend fun aRecords(`value`: List<ARecordArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aRecords = mapped
    }

    /**
     * @param argument The list of A records in the record set.
     */
    @JvmName("qmaegfrbwnvbmixf")
    public suspend fun aRecords(argument: List<suspend ARecordArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ARecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.aRecords = mapped
    }

    /**
     * @param argument The list of A records in the record set.
     */
    @JvmName("ubumygovjcssmtsa")
    public suspend fun aRecords(vararg argument: suspend ARecordArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ARecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.aRecords = mapped
    }

    /**
     * @param argument The list of A records in the record set.
     */
    @JvmName("pfhuvbojntdxcins")
    public suspend fun aRecords(argument: suspend ARecordArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ARecordArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.aRecords = mapped
    }

    /**
     * @param values The list of A records in the record set.
     */
    @JvmName("qlniyrenunxgwypg")
    public suspend fun aRecords(vararg values: ARecordArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aRecords = mapped
    }

    /**
     * @param value The list of AAAA records in the record set.
     */
    @JvmName("amlcscgjmmetromk")
    public suspend fun aaaaRecords(`value`: List<AaaaRecordArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aaaaRecords = mapped
    }

    /**
     * @param argument The list of AAAA records in the record set.
     */
    @JvmName("gocqyqneuomvatjj")
    public suspend fun aaaaRecords(argument: List<suspend AaaaRecordArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { AaaaRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.aaaaRecords = mapped
    }

    /**
     * @param argument The list of AAAA records in the record set.
     */
    @JvmName("mjjrcyswyixlsdur")
    public suspend fun aaaaRecords(vararg argument: suspend AaaaRecordArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { AaaaRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.aaaaRecords = mapped
    }

    /**
     * @param argument The list of AAAA records in the record set.
     */
    @JvmName("xdpwimxnvenxlvkp")
    public suspend fun aaaaRecords(argument: suspend AaaaRecordArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AaaaRecordArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.aaaaRecords = mapped
    }

    /**
     * @param values The list of AAAA records in the record set.
     */
    @JvmName("pgdsynoxwdkqxsgi")
    public suspend fun aaaaRecords(vararg values: AaaaRecordArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aaaaRecords = mapped
    }

    /**
     * @param value The CNAME record in the record set.
     */
    @JvmName("bqscbiypdbuelhmn")
    public suspend fun cnameRecord(`value`: CnameRecordArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cnameRecord = mapped
    }

    /**
     * @param argument The CNAME record in the record set.
     */
    @JvmName("xphkpxhprdkeefql")
    public suspend fun cnameRecord(argument: suspend CnameRecordArgsBuilder.() -> Unit) {
        val toBeMapped = CnameRecordArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cnameRecord = mapped
    }

    /**
     * @param value The metadata attached to the record set.
     */
    @JvmName("sudqmcxnlugcpuhq")
    public suspend fun metadata(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param values The metadata attached to the record set.
     */
    @JvmName("srfpuvdhdcdbjlth")
    public fun metadata(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The list of MX records in the record set.
     */
    @JvmName("apfidxnjnkhydcts")
    public suspend fun mxRecords(`value`: List<MxRecordArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mxRecords = mapped
    }

    /**
     * @param argument The list of MX records in the record set.
     */
    @JvmName("srepfptunjyonyob")
    public suspend fun mxRecords(argument: List<suspend MxRecordArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { MxRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.mxRecords = mapped
    }

    /**
     * @param argument The list of MX records in the record set.
     */
    @JvmName("ultnytnfsjocctoq")
    public suspend fun mxRecords(vararg argument: suspend MxRecordArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { MxRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.mxRecords = mapped
    }

    /**
     * @param argument The list of MX records in the record set.
     */
    @JvmName("wwsxtqcvsmnopeph")
    public suspend fun mxRecords(argument: suspend MxRecordArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MxRecordArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.mxRecords = mapped
    }

    /**
     * @param values The list of MX records in the record set.
     */
    @JvmName("hrljbfmupmfgaatd")
    public suspend fun mxRecords(vararg values: MxRecordArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mxRecords = mapped
    }

    /**
     * @param value The name of the Private DNS zone (without a terminating dot).
     */
    @JvmName("ftheumhhdvnldlim")
    public suspend fun privateZoneName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateZoneName = mapped
    }

    /**
     * @param value The list of PTR records in the record set.
     */
    @JvmName("hvqggghixwpgxnmv")
    public suspend fun ptrRecords(`value`: List<PtrRecordArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ptrRecords = mapped
    }

    /**
     * @param argument The list of PTR records in the record set.
     */
    @JvmName("kpdvplwyperobbyh")
    public suspend fun ptrRecords(argument: List<suspend PtrRecordArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { PtrRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ptrRecords = mapped
    }

    /**
     * @param argument The list of PTR records in the record set.
     */
    @JvmName("oqvcmbqhyxliewvp")
    public suspend fun ptrRecords(vararg argument: suspend PtrRecordArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { PtrRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ptrRecords = mapped
    }

    /**
     * @param argument The list of PTR records in the record set.
     */
    @JvmName("sfqolxcyealcmawn")
    public suspend fun ptrRecords(argument: suspend PtrRecordArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PtrRecordArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ptrRecords = mapped
    }

    /**
     * @param values The list of PTR records in the record set.
     */
    @JvmName("vochyibsaaqbubno")
    public suspend fun ptrRecords(vararg values: PtrRecordArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ptrRecords = mapped
    }

    /**
     * @param value The type of DNS record in this record set. Record sets of type SOA can be updated but not created (they are created when the Private DNS zone is created).
     */
    @JvmName("jpuslgcwaqxlopxj")
    public suspend fun recordType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordType = mapped
    }

    /**
     * @param value The name of the record set, relative to the name of the zone.
     */
    @JvmName("ajjiextrtakgfauo")
    public suspend fun relativeRecordSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relativeRecordSetName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("mdulgovjgbyeluhv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The SOA record in the record set.
     */
    @JvmName("qgdbxprmcbwdnkqc")
    public suspend fun soaRecord(`value`: SoaRecordArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.soaRecord = mapped
    }

    /**
     * @param argument The SOA record in the record set.
     */
    @JvmName("hntwthjbrtoxuwda")
    public suspend fun soaRecord(argument: suspend SoaRecordArgsBuilder.() -> Unit) {
        val toBeMapped = SoaRecordArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.soaRecord = mapped
    }

    /**
     * @param value The list of SRV records in the record set.
     */
    @JvmName("inwyslhjscsbnihc")
    public suspend fun srvRecords(`value`: List<SrvRecordArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.srvRecords = mapped
    }

    /**
     * @param argument The list of SRV records in the record set.
     */
    @JvmName("jilsambtxrtfnwne")
    public suspend fun srvRecords(argument: List<suspend SrvRecordArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SrvRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.srvRecords = mapped
    }

    /**
     * @param argument The list of SRV records in the record set.
     */
    @JvmName("vttkhjugjqpyltli")
    public suspend fun srvRecords(vararg argument: suspend SrvRecordArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SrvRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.srvRecords = mapped
    }

    /**
     * @param argument The list of SRV records in the record set.
     */
    @JvmName("qposeftpedjkcipx")
    public suspend fun srvRecords(argument: suspend SrvRecordArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SrvRecordArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.srvRecords = mapped
    }

    /**
     * @param values The list of SRV records in the record set.
     */
    @JvmName("mlkcfcscyypydglr")
    public suspend fun srvRecords(vararg values: SrvRecordArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.srvRecords = mapped
    }

    /**
     * @param value The TTL (time-to-live) of the records in the record set.
     */
    @JvmName("ubncomtauatkuumy")
    public suspend fun ttl(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttl = mapped
    }

    /**
     * @param value The list of TXT records in the record set.
     */
    @JvmName("gukqwaemiswapktv")
    public suspend fun txtRecords(`value`: List<TxtRecordArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.txtRecords = mapped
    }

    /**
     * @param argument The list of TXT records in the record set.
     */
    @JvmName("jnptpxlahbyahqcs")
    public suspend fun txtRecords(argument: List<suspend TxtRecordArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { TxtRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.txtRecords = mapped
    }

    /**
     * @param argument The list of TXT records in the record set.
     */
    @JvmName("eespggounfocobfh")
    public suspend fun txtRecords(vararg argument: suspend TxtRecordArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { TxtRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.txtRecords = mapped
    }

    /**
     * @param argument The list of TXT records in the record set.
     */
    @JvmName("hkjnswqubtcbbray")
    public suspend fun txtRecords(argument: suspend TxtRecordArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TxtRecordArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.txtRecords = mapped
    }

    /**
     * @param values The list of TXT records in the record set.
     */
    @JvmName("oifujwvygkfqncfw")
    public suspend fun txtRecords(vararg values: TxtRecordArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.txtRecords = mapped
    }

    internal fun build(): PrivateRecordSetArgs = PrivateRecordSetArgs(
        aRecords = aRecords,
        aaaaRecords = aaaaRecords,
        cnameRecord = cnameRecord,
        metadata = metadata,
        mxRecords = mxRecords,
        privateZoneName = privateZoneName,
        ptrRecords = ptrRecords,
        recordType = recordType,
        relativeRecordSetName = relativeRecordSetName,
        resourceGroupName = resourceGroupName,
        soaRecord = soaRecord,
        srvRecords = srvRecords,
        ttl = ttl,
        txtRecords = txtRecords,
    )
}
