@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [PrivateZone].
 */
@PulumiTagMarker
public class PrivateZoneResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateZoneArgs = PrivateZoneArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateZoneArgsBuilder.() -> Unit) {
        val builder = PrivateZoneArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrivateZone {
        val builtJavaResource = com.pulumi.azurenative.network.PrivateZone(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PrivateZone(builtJavaResource)
    }
}

/**
 * Describes a Private DNS zone.
 * Azure REST API version: 2020-06-01. Prior API version in Azure Native 1.x: 2020-06-01.
 * ## Example Usage
 * ### PUT Private DNS Zone
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateZone = new AzureNative.Network.PrivateZone("privateZone", new()
 *     {
 *         Location = "Global",
 *         PrivateZoneName = "privatezone1.com",
 *         ResourceGroupName = "resourceGroup1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateZone(ctx, "privateZone", &network.PrivateZoneArgs{
 * 			Location:          pulumi.String("Global"),
 * 			PrivateZoneName:   pulumi.String("privatezone1.com"),
 * 			ResourceGroupName: pulumi.String("resourceGroup1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateZone;
 * import com.pulumi.azurenative.network.PrivateZoneArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateZone = new PrivateZone("privateZone", PrivateZoneArgs.builder()
 *             .location("Global")
 *             .privateZoneName("privatezone1.com")
 *             .resourceGroupName("resourceGroup1")
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:PrivateZone privatezone1.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateZoneName}
 * ```
 */
public class PrivateZone internal constructor(
    override val javaResource: com.pulumi.azurenative.network.PrivateZone,
) : KotlinCustomResource(javaResource, PrivateZoneMapper) {
    /**
     * The ETag of the zone.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Private zone internal Id
     */
    public val internalId: Output<String>
        get() = javaResource.internalId().applyValue({ args0 -> args0 })

    /**
     * The Azure Region where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The maximum number of record sets that can be created in this Private DNS zone. This is a read-only property and any attempt to set this value will be ignored.
     */
    public val maxNumberOfRecordSets: Output<Double>
        get() = javaResource.maxNumberOfRecordSets().applyValue({ args0 -> args0 })

    /**
     * The maximum number of virtual networks that can be linked to this Private DNS zone. This is a read-only property and any attempt to set this value will be ignored.
     */
    public val maxNumberOfVirtualNetworkLinks: Output<Double>
        get() = javaResource.maxNumberOfVirtualNetworkLinks().applyValue({ args0 -> args0 })

    /**
     * The maximum number of virtual networks that can be linked to this Private DNS zone with registration enabled. This is a read-only property and any attempt to set this value will be ignored.
     */
    public val maxNumberOfVirtualNetworkLinksWithRegistration: Output<Double>
        get() = javaResource.maxNumberOfVirtualNetworkLinksWithRegistration().applyValue({ args0 ->
            args0
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The current number of record sets in this Private DNS zone. This is a read-only property and any attempt to set this value will be ignored.
     */
    public val numberOfRecordSets: Output<Double>
        get() = javaResource.numberOfRecordSets().applyValue({ args0 -> args0 })

    /**
     * The current number of virtual networks that are linked to this Private DNS zone. This is a read-only property and any attempt to set this value will be ignored.
     */
    public val numberOfVirtualNetworkLinks: Output<Double>
        get() = javaResource.numberOfVirtualNetworkLinks().applyValue({ args0 -> args0 })

    /**
     * The current number of virtual networks that are linked to this Private DNS zone with registration enabled. This is a read-only property and any attempt to set this value will be ignored.
     */
    public val numberOfVirtualNetworkLinksWithRegistration: Output<Double>
        get() = javaResource.numberOfVirtualNetworkLinksWithRegistration().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource. This is a read-only property and any attempt to set this value will be ignored.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. Example - 'Microsoft.Network/privateDnsZones'.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateZoneMapper : ResourceMapper<PrivateZone> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.PrivateZone::class == javaResource::class

    override fun map(javaResource: Resource): PrivateZone = PrivateZone(
        javaResource as
            com.pulumi.azurenative.network.PrivateZone,
    )
}

/**
 * @see [PrivateZone].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateZone].
 */
public suspend fun privateZone(name: String, block: suspend PrivateZoneResourceBuilder.() -> Unit):
    PrivateZone {
    val builder = PrivateZoneResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateZone].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateZone(name: String): PrivateZone {
    val builder = PrivateZoneResourceBuilder()
    builder.name(name)
    return builder.build()
}
