@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.ProfileArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.AllowedEndpointRecordType
import com.pulumi.azurenative.network.kotlin.enums.ProfileStatus
import com.pulumi.azurenative.network.kotlin.enums.TrafficRoutingMethod
import com.pulumi.azurenative.network.kotlin.enums.TrafficViewEnrollmentStatus
import com.pulumi.azurenative.network.kotlin.inputs.DnsConfigArgs
import com.pulumi.azurenative.network.kotlin.inputs.DnsConfigArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.EndpointArgs
import com.pulumi.azurenative.network.kotlin.inputs.EndpointArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.MonitorConfigArgs
import com.pulumi.azurenative.network.kotlin.inputs.MonitorConfigArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Class representing a Traffic Manager profile.
 * Azure REST API version: 2022-04-01. Prior API version in Azure Native 1.x: 2018-08-01.
 * Other available API versions: 2017-03-01, 2018-02-01, 2022-04-01-preview.
 * ## Example Usage
 * ### Profile-PUT-MultiValue
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var profile = new AzureNative.Network.Profile("profile", new()
 *     {
 *         DnsConfig = new AzureNative.Network.Inputs.DnsConfigArgs
 *         {
 *             RelativeName = "azsmnet6386",
 *             Ttl = 35,
 *         },
 *         Location = "global",
 *         MaxReturn = 2,
 *         MonitorConfig = new AzureNative.Network.Inputs.MonitorConfigArgs
 *         {
 *             Path = "/testpath.aspx",
 *             Port = 80,
 *             Protocol = AzureNative.Network.MonitorProtocol.HTTP,
 *         },
 *         ProfileName = "azsmnet6386",
 *         ProfileStatus = AzureNative.Network.ProfileStatus.Enabled,
 *         ResourceGroupName = "azuresdkfornetautoresttrafficmanager1421",
 *         TrafficRoutingMethod = AzureNative.Network.TrafficRoutingMethod.MultiValue,
 *         TrafficViewEnrollmentStatus = AzureNative.Network.TrafficViewEnrollmentStatus.Disabled,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewProfile(ctx, "profile", &network.ProfileArgs{
 * 			DnsConfig: &network.DnsConfigArgs{
 * 				RelativeName: pulumi.String("azsmnet6386"),
 * 				Ttl:          pulumi.Float64(35),
 * 			},
 * 			Location:  pulumi.String("global"),
 * 			MaxReturn: pulumi.Float64(2),
 * 			MonitorConfig: &network.MonitorConfigArgs{
 * 				Path:     pulumi.String("/testpath.aspx"),
 * 				Port:     pulumi.Float64(80),
 * 				Protocol: pulumi.String(network.MonitorProtocolHTTP),
 * 			},
 * 			ProfileName:                 pulumi.String("azsmnet6386"),
 * 			ProfileStatus:               pulumi.String(network.ProfileStatusEnabled),
 * 			ResourceGroupName:           pulumi.String("azuresdkfornetautoresttrafficmanager1421"),
 * 			TrafficRoutingMethod:        pulumi.String(network.TrafficRoutingMethodMultiValue),
 * 			TrafficViewEnrollmentStatus: pulumi.String(network.TrafficViewEnrollmentStatusDisabled),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Profile;
 * import com.pulumi.azurenative.network.ProfileArgs;
 * import com.pulumi.azurenative.network.inputs.DnsConfigArgs;
 * import com.pulumi.azurenative.network.inputs.MonitorConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var profile = new Profile("profile", ProfileArgs.builder()
 *             .dnsConfig(DnsConfigArgs.builder()
 *                 .relativeName("azsmnet6386")
 *                 .ttl(35)
 *                 .build())
 *             .location("global")
 *             .maxReturn(2)
 *             .monitorConfig(MonitorConfigArgs.builder()
 *                 .path("/testpath.aspx")
 *                 .port(80)
 *                 .protocol("HTTP")
 *                 .build())
 *             .profileName("azsmnet6386")
 *             .profileStatus("Enabled")
 *             .resourceGroupName("azuresdkfornetautoresttrafficmanager1421")
 *             .trafficRoutingMethod("MultiValue")
 *             .trafficViewEnrollmentStatus("Disabled")
 *             .build());
 *     }
 * }
 * ```
 * ### Profile-PUT-NoEndpoints
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var profile = new AzureNative.Network.Profile("profile", new()
 *     {
 *         DnsConfig = new AzureNative.Network.Inputs.DnsConfigArgs
 *         {
 *             RelativeName = "azsmnet6386",
 *             Ttl = 35,
 *         },
 *         Location = "global",
 *         MonitorConfig = new AzureNative.Network.Inputs.MonitorConfigArgs
 *         {
 *             Path = "/testpath.aspx",
 *             Port = 80,
 *             Protocol = AzureNative.Network.MonitorProtocol.HTTP,
 *         },
 *         ProfileName = "azsmnet6386",
 *         ProfileStatus = AzureNative.Network.ProfileStatus.Enabled,
 *         ResourceGroupName = "azuresdkfornetautoresttrafficmanager1421",
 *         TrafficRoutingMethod = AzureNative.Network.TrafficRoutingMethod.Performance,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewProfile(ctx, "profile", &network.ProfileArgs{
 * 			DnsConfig: &network.DnsConfigArgs{
 * 				RelativeName: pulumi.String("azsmnet6386"),
 * 				Ttl:          pulumi.Float64(35),
 * 			},
 * 			Location: pulumi.String("global"),
 * 			MonitorConfig: &network.MonitorConfigArgs{
 * 				Path:     pulumi.String("/testpath.aspx"),
 * 				Port:     pulumi.Float64(80),
 * 				Protocol: pulumi.String(network.MonitorProtocolHTTP),
 * 			},
 * 			ProfileName:          pulumi.String("azsmnet6386"),
 * 			ProfileStatus:        pulumi.String(network.ProfileStatusEnabled),
 * 			ResourceGroupName:    pulumi.String("azuresdkfornetautoresttrafficmanager1421"),
 * 			TrafficRoutingMethod: pulumi.String(network.TrafficRoutingMethodPerformance),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Profile;
 * import com.pulumi.azurenative.network.ProfileArgs;
 * import com.pulumi.azurenative.network.inputs.DnsConfigArgs;
 * import com.pulumi.azurenative.network.inputs.MonitorConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var profile = new Profile("profile", ProfileArgs.builder()
 *             .dnsConfig(DnsConfigArgs.builder()
 *                 .relativeName("azsmnet6386")
 *                 .ttl(35)
 *                 .build())
 *             .location("global")
 *             .monitorConfig(MonitorConfigArgs.builder()
 *                 .path("/testpath.aspx")
 *                 .port(80)
 *                 .protocol("HTTP")
 *                 .build())
 *             .profileName("azsmnet6386")
 *             .profileStatus("Enabled")
 *             .resourceGroupName("azuresdkfornetautoresttrafficmanager1421")
 *             .trafficRoutingMethod("Performance")
 *             .build());
 *     }
 * }
 * ```
 * ### Profile-PUT-WithAliasing
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var profile = new AzureNative.Network.Profile("profile", new()
 *     {
 *         AllowedEndpointRecordTypes = new[]
 *         {
 *             AzureNative.Network.AllowedEndpointRecordType.DomainName,
 *         },
 *         DnsConfig = new AzureNative.Network.Inputs.DnsConfigArgs
 *         {
 *             RelativeName = "azuresdkfornetautoresttrafficmanager6192",
 *             Ttl = 35,
 *         },
 *         Endpoints = new[]
 *         {
 *             new AzureNative.Network.Inputs.EndpointArgs
 *             {
 *                 EndpointLocation = "North Europe",
 *                 EndpointStatus = AzureNative.Network.EndpointStatus.Enabled,
 *                 Name = "My external endpoint",
 *                 Target = "foobar.contoso.com",
 *                 Type = "Microsoft.network/TrafficManagerProfiles/ExternalEndpoints",
 *             },
 *         },
 *         Location = "global",
 *         MonitorConfig = new AzureNative.Network.Inputs.MonitorConfigArgs
 *         {
 *             IntervalInSeconds = 10,
 *             Path = "/testpath.aspx",
 *             Port = 80,
 *             Protocol = AzureNative.Network.MonitorProtocol.HTTP,
 *             TimeoutInSeconds = 5,
 *             ToleratedNumberOfFailures = 2,
 *         },
 *         ProfileName = "azuresdkfornetautoresttrafficmanager6192",
 *         ProfileStatus = AzureNative.Network.ProfileStatus.Enabled,
 *         ResourceGroupName = "azuresdkfornetautoresttrafficmanager2583",
 *         TrafficRoutingMethod = AzureNative.Network.TrafficRoutingMethod.Performance,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewProfile(ctx, "profile", &network.ProfileArgs{
 * 			AllowedEndpointRecordTypes: pulumi.StringArray{
 * 				pulumi.String(network.AllowedEndpointRecordTypeDomainName),
 * 			},
 * 			DnsConfig: &network.DnsConfigArgs{
 * 				RelativeName: pulumi.String("azuresdkfornetautoresttrafficmanager6192"),
 * 				Ttl:          pulumi.Float64(35),
 * 			},
 * 			Endpoints: network.EndpointTypeArray{
 * 				&network.EndpointTypeArgs{
 * 					EndpointLocation: pulumi.String("North Europe"),
 * 					EndpointStatus:   pulumi.String(network.EndpointStatusEnabled),
 * 					Name:             pulumi.String("My external endpoint"),
 * 					Target:           pulumi.String("foobar.contoso.com"),
 * 					Type:             pulumi.String("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints"),
 * 				},
 * 			},
 * 			Location: pulumi.String("global"),
 * 			MonitorConfig: &network.MonitorConfigArgs{
 * 				IntervalInSeconds:         pulumi.Float64(10),
 * 				Path:                      pulumi.String("/testpath.aspx"),
 * 				Port:                      pulumi.Float64(80),
 * 				Protocol:                  pulumi.String(network.MonitorProtocolHTTP),
 * 				TimeoutInSeconds:          pulumi.Float64(5),
 * 				ToleratedNumberOfFailures: pulumi.Float64(2),
 * 			},
 * 			ProfileName:          pulumi.String("azuresdkfornetautoresttrafficmanager6192"),
 * 			ProfileStatus:        pulumi.String(network.ProfileStatusEnabled),
 * 			ResourceGroupName:    pulumi.String("azuresdkfornetautoresttrafficmanager2583"),
 * 			TrafficRoutingMethod: pulumi.String(network.TrafficRoutingMethodPerformance),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Profile;
 * import com.pulumi.azurenative.network.ProfileArgs;
 * import com.pulumi.azurenative.network.inputs.DnsConfigArgs;
 * import com.pulumi.azurenative.network.inputs.EndpointArgs;
 * import com.pulumi.azurenative.network.inputs.MonitorConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var profile = new Profile("profile", ProfileArgs.builder()
 *             .allowedEndpointRecordTypes("DomainName")
 *             .dnsConfig(DnsConfigArgs.builder()
 *                 .relativeName("azuresdkfornetautoresttrafficmanager6192")
 *                 .ttl(35)
 *                 .build())
 *             .endpoints(EndpointArgs.builder()
 *                 .endpointLocation("North Europe")
 *                 .endpointStatus("Enabled")
 *                 .name("My external endpoint")
 *                 .target("foobar.contoso.com")
 *                 .type("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints")
 *                 .build())
 *             .location("global")
 *             .monitorConfig(MonitorConfigArgs.builder()
 *                 .intervalInSeconds(10)
 *                 .path("/testpath.aspx")
 *                 .port(80)
 *                 .protocol("HTTP")
 *                 .timeoutInSeconds(5)
 *                 .toleratedNumberOfFailures(2)
 *                 .build())
 *             .profileName("azuresdkfornetautoresttrafficmanager6192")
 *             .profileStatus("Enabled")
 *             .resourceGroupName("azuresdkfornetautoresttrafficmanager2583")
 *             .trafficRoutingMethod("Performance")
 *             .build());
 *     }
 * }
 * ```
 * ### Profile-PUT-WithCustomHeaders
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var profile = new AzureNative.Network.Profile("profile", new()
 *     {
 *         DnsConfig = new AzureNative.Network.Inputs.DnsConfigArgs
 *         {
 *             RelativeName = "azuresdkfornetautoresttrafficmanager6192",
 *             Ttl = 35,
 *         },
 *         Endpoints = new[]
 *         {
 *             new AzureNative.Network.Inputs.EndpointArgs
 *             {
 *                 CustomHeaders = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.EndpointPropertiesCustomHeadersArgs
 *                     {
 *                         Name = "header-2",
 *                         Value = "value-2-overridden",
 *                     },
 *                 },
 *                 EndpointLocation = "North Europe",
 *                 EndpointStatus = AzureNative.Network.EndpointStatus.Enabled,
 *                 Name = "My external endpoint",
 *                 Target = "foobar.contoso.com",
 *                 Type = "Microsoft.network/TrafficManagerProfiles/ExternalEndpoints",
 *             },
 *         },
 *         Location = "global",
 *         MonitorConfig = new AzureNative.Network.Inputs.MonitorConfigArgs
 *         {
 *             CustomHeaders = new[]
 *             {
 *                 new AzureNative.Network.Inputs.MonitorConfigCustomHeadersArgs
 *                 {
 *                     Name = "header-1",
 *                     Value = "value-1",
 *                 },
 *                 new AzureNative.Network.Inputs.MonitorConfigCustomHeadersArgs
 *                 {
 *                     Name = "header-2",
 *                     Value = "value-2",
 *                 },
 *             },
 *             ExpectedStatusCodeRanges = new[]
 *             {
 *                 new AzureNative.Network.Inputs.MonitorConfigExpectedStatusCodeRangesArgs
 *                 {
 *                     Max = 205,
 *                     Min = 200,
 *                 },
 *                 new AzureNative.Network.Inputs.MonitorConfigExpectedStatusCodeRangesArgs
 *                 {
 *                     Max = 410,
 *                     Min = 400,
 *                 },
 *             },
 *             IntervalInSeconds = 10,
 *             Path = "/testpath.aspx",
 *             Port = 80,
 *             Protocol = AzureNative.Network.MonitorProtocol.HTTP,
 *             TimeoutInSeconds = 5,
 *             ToleratedNumberOfFailures = 2,
 *         },
 *         ProfileName = "azuresdkfornetautoresttrafficmanager6192",
 *         ProfileStatus = AzureNative.Network.ProfileStatus.Enabled,
 *         ResourceGroupName = "azuresdkfornetautoresttrafficmanager2583",
 *         TrafficRoutingMethod = AzureNative.Network.TrafficRoutingMethod.Performance,
 *         TrafficViewEnrollmentStatus = AzureNative.Network.TrafficViewEnrollmentStatus.Disabled,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewProfile(ctx, "profile", &network.ProfileArgs{
 * 			DnsConfig: &network.DnsConfigArgs{
 * 				RelativeName: pulumi.String("azuresdkfornetautoresttrafficmanager6192"),
 * 				Ttl:          pulumi.Float64(35),
 * 			},
 * 			Endpoints: network.EndpointTypeArray{
 * 				&network.EndpointTypeArgs{
 * 					CustomHeaders: network.EndpointPropertiesCustomHeadersArray{
 * 						&network.EndpointPropertiesCustomHeadersArgs{
 * 							Name:  pulumi.String("header-2"),
 * 							Value: pulumi.String("value-2-overridden"),
 * 						},
 * 					},
 * 					EndpointLocation: pulumi.String("North Europe"),
 * 					EndpointStatus:   pulumi.String(network.EndpointStatusEnabled),
 * 					Name:             pulumi.String("My external endpoint"),
 * 					Target:           pulumi.String("foobar.contoso.com"),
 * 					Type:             pulumi.String("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints"),
 * 				},
 * 			},
 * 			Location: pulumi.String("global"),
 * 			MonitorConfig: &network.MonitorConfigArgs{
 * 				CustomHeaders: network.MonitorConfigCustomHeadersArray{
 * 					&network.MonitorConfigCustomHeadersArgs{
 * 						Name:  pulumi.String("header-1"),
 * 						Value: pulumi.String("value-1"),
 * 					},
 * 					&network.MonitorConfigCustomHeadersArgs{
 * 						Name:  pulumi.String("header-2"),
 * 						Value: pulumi.String("value-2"),
 * 					},
 * 				},
 * 				ExpectedStatusCodeRanges: network.MonitorConfigExpectedStatusCodeRangesArray{
 * 					&network.MonitorConfigExpectedStatusCodeRangesArgs{
 * 						Max: pulumi.Int(205),
 * 						Min: pulumi.Int(200),
 * 					},
 * 					&network.MonitorConfigExpectedStatusCodeRangesArgs{
 * 						Max: pulumi.Int(410),
 * 						Min: pulumi.Int(400),
 * 					},
 * 				},
 * 				IntervalInSeconds:         pulumi.Float64(10),
 * 				Path:                      pulumi.String("/testpath.aspx"),
 * 				Port:                      pulumi.Float64(80),
 * 				Protocol:                  pulumi.String(network.MonitorProtocolHTTP),
 * 				TimeoutInSeconds:          pulumi.Float64(5),
 * 				ToleratedNumberOfFailures: pulumi.Float64(2),
 * 			},
 * 			ProfileName:                 pulumi.String("azuresdkfornetautoresttrafficmanager6192"),
 * 			ProfileStatus:               pulumi.String(network.ProfileStatusEnabled),
 * 			ResourceGroupName:           pulumi.String("azuresdkfornetautoresttrafficmanager2583"),
 * 			TrafficRoutingMethod:        pulumi.String(network.TrafficRoutingMethodPerformance),
 * 			TrafficViewEnrollmentStatus: pulumi.String(network.TrafficViewEnrollmentStatusDisabled),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Profile;
 * import com.pulumi.azurenative.network.ProfileArgs;
 * import com.pulumi.azurenative.network.inputs.DnsConfigArgs;
 * import com.pulumi.azurenative.network.inputs.EndpointArgs;
 * import com.pulumi.azurenative.network.inputs.MonitorConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var profile = new Profile("profile", ProfileArgs.builder()
 *             .dnsConfig(DnsConfigArgs.builder()
 *                 .relativeName("azuresdkfornetautoresttrafficmanager6192")
 *                 .ttl(35)
 *                 .build())
 *             .endpoints(EndpointArgs.builder()
 *                 .customHeaders(EndpointPropertiesCustomHeadersArgs.builder()
 *                     .name("header-2")
 *                     .value("value-2-overridden")
 *                     .build())
 *                 .endpointLocation("North Europe")
 *                 .endpointStatus("Enabled")
 *                 .name("My external endpoint")
 *                 .target("foobar.contoso.com")
 *                 .type("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints")
 *                 .build())
 *             .location("global")
 *             .monitorConfig(MonitorConfigArgs.builder()
 *                 .customHeaders(
 *                     MonitorConfigCustomHeadersArgs.builder()
 *                         .name("header-1")
 *                         .value("value-1")
 *                         .build(),
 *                     MonitorConfigCustomHeadersArgs.builder()
 *                         .name("header-2")
 *                         .value("value-2")
 *                         .build())
 *                 .expectedStatusCodeRanges(
 *                     MonitorConfigExpectedStatusCodeRangesArgs.builder()
 *                         .max(205)
 *                         .min(200)
 *                         .build(),
 *                     MonitorConfigExpectedStatusCodeRangesArgs.builder()
 *                         .max(410)
 *                         .min(400)
 *                         .build())
 *                 .intervalInSeconds(10)
 *                 .path("/testpath.aspx")
 *                 .port(80)
 *                 .protocol("HTTP")
 *                 .timeoutInSeconds(5)
 *                 .toleratedNumberOfFailures(2)
 *                 .build())
 *             .profileName("azuresdkfornetautoresttrafficmanager6192")
 *             .profileStatus("Enabled")
 *             .resourceGroupName("azuresdkfornetautoresttrafficmanager2583")
 *             .trafficRoutingMethod("Performance")
 *             .trafficViewEnrollmentStatus("Disabled")
 *             .build());
 *     }
 * }
 * ```
 * ### Profile-PUT-WithEndpoints
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var profile = new AzureNative.Network.Profile("profile", new()
 *     {
 *         DnsConfig = new AzureNative.Network.Inputs.DnsConfigArgs
 *         {
 *             RelativeName = "azuresdkfornetautoresttrafficmanager6192",
 *             Ttl = 35,
 *         },
 *         Endpoints = new[]
 *         {
 *             new AzureNative.Network.Inputs.EndpointArgs
 *             {
 *                 EndpointLocation = "North Europe",
 *                 EndpointStatus = AzureNative.Network.EndpointStatus.Enabled,
 *                 Name = "My external endpoint",
 *                 Target = "foobar.contoso.com",
 *                 Type = "Microsoft.network/TrafficManagerProfiles/ExternalEndpoints",
 *             },
 *         },
 *         Location = "global",
 *         MonitorConfig = new AzureNative.Network.Inputs.MonitorConfigArgs
 *         {
 *             IntervalInSeconds = 10,
 *             Path = "/testpath.aspx",
 *             Port = 80,
 *             Protocol = AzureNative.Network.MonitorProtocol.HTTP,
 *             TimeoutInSeconds = 5,
 *             ToleratedNumberOfFailures = 2,
 *         },
 *         ProfileName = "azuresdkfornetautoresttrafficmanager6192",
 *         ProfileStatus = AzureNative.Network.ProfileStatus.Enabled,
 *         ResourceGroupName = "azuresdkfornetautoresttrafficmanager2583",
 *         TrafficRoutingMethod = AzureNative.Network.TrafficRoutingMethod.Performance,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewProfile(ctx, "profile", &network.ProfileArgs{
 * 			DnsConfig: &network.DnsConfigArgs{
 * 				RelativeName: pulumi.String("azuresdkfornetautoresttrafficmanager6192"),
 * 				Ttl:          pulumi.Float64(35),
 * 			},
 * 			Endpoints: network.EndpointTypeArray{
 * 				&network.EndpointTypeArgs{
 * 					EndpointLocation: pulumi.String("North Europe"),
 * 					EndpointStatus:   pulumi.String(network.EndpointStatusEnabled),
 * 					Name:             pulumi.String("My external endpoint"),
 * 					Target:           pulumi.String("foobar.contoso.com"),
 * 					Type:             pulumi.String("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints"),
 * 				},
 * 			},
 * 			Location: pulumi.String("global"),
 * 			MonitorConfig: &network.MonitorConfigArgs{
 * 				IntervalInSeconds:         pulumi.Float64(10),
 * 				Path:                      pulumi.String("/testpath.aspx"),
 * 				Port:                      pulumi.Float64(80),
 * 				Protocol:                  pulumi.String(network.MonitorProtocolHTTP),
 * 				TimeoutInSeconds:          pulumi.Float64(5),
 * 				ToleratedNumberOfFailures: pulumi.Float64(2),
 * 			},
 * 			ProfileName:          pulumi.String("azuresdkfornetautoresttrafficmanager6192"),
 * 			ProfileStatus:        pulumi.String(network.ProfileStatusEnabled),
 * 			ResourceGroupName:    pulumi.String("azuresdkfornetautoresttrafficmanager2583"),
 * 			TrafficRoutingMethod: pulumi.String(network.TrafficRoutingMethodPerformance),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Profile;
 * import com.pulumi.azurenative.network.ProfileArgs;
 * import com.pulumi.azurenative.network.inputs.DnsConfigArgs;
 * import com.pulumi.azurenative.network.inputs.EndpointArgs;
 * import com.pulumi.azurenative.network.inputs.MonitorConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var profile = new Profile("profile", ProfileArgs.builder()
 *             .dnsConfig(DnsConfigArgs.builder()
 *                 .relativeName("azuresdkfornetautoresttrafficmanager6192")
 *                 .ttl(35)
 *                 .build())
 *             .endpoints(EndpointArgs.builder()
 *                 .endpointLocation("North Europe")
 *                 .endpointStatus("Enabled")
 *                 .name("My external endpoint")
 *                 .target("foobar.contoso.com")
 *                 .type("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints")
 *                 .build())
 *             .location("global")
 *             .monitorConfig(MonitorConfigArgs.builder()
 *                 .intervalInSeconds(10)
 *                 .path("/testpath.aspx")
 *                 .port(80)
 *                 .protocol("HTTP")
 *                 .timeoutInSeconds(5)
 *                 .toleratedNumberOfFailures(2)
 *                 .build())
 *             .profileName("azuresdkfornetautoresttrafficmanager6192")
 *             .profileStatus("Enabled")
 *             .resourceGroupName("azuresdkfornetautoresttrafficmanager2583")
 *             .trafficRoutingMethod("Performance")
 *             .build());
 *     }
 * }
 * ```
 * ### Profile-PUT-WithNestedEndpoints
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var profile = new AzureNative.Network.Profile("profile", new()
 *     {
 *         DnsConfig = new AzureNative.Network.Inputs.DnsConfigArgs
 *         {
 *             RelativeName = "parentprofile",
 *             Ttl = 35,
 *         },
 *         Endpoints = new[]
 *         {
 *             new AzureNative.Network.Inputs.EndpointArgs
 *             {
 *                 EndpointStatus = AzureNative.Network.EndpointStatus.Enabled,
 *                 MinChildEndpoints = 2,
 *                 MinChildEndpointsIPv4 = 1,
 *                 MinChildEndpointsIPv6 = 2,
 *                 Name = "MyFirstNestedEndpoint",
 *                 Priority = 1,
 *                 Target = "firstnestedprofile.tmpreview.watmtest.azure-test.net",
 *                 Type = "Microsoft.Network/trafficManagerProfiles/nestedEndpoints",
 *                 Weight = 1,
 *             },
 *             new AzureNative.Network.Inputs.EndpointArgs
 *             {
 *                 EndpointStatus = AzureNative.Network.EndpointStatus.Enabled,
 *                 MinChildEndpoints = 2,
 *                 MinChildEndpointsIPv4 = 2,
 *                 MinChildEndpointsIPv6 = 1,
 *                 Name = "MySecondNestedEndpoint",
 *                 Priority = 2,
 *                 Target = "secondnestedprofile.tmpreview.watmtest.azure-test.net",
 *                 Type = "Microsoft.Network/trafficManagerProfiles/nestedEndpoints",
 *                 Weight = 1,
 *             },
 *         },
 *         Location = "global",
 *         MonitorConfig = new AzureNative.Network.Inputs.MonitorConfigArgs
 *         {
 *             IntervalInSeconds = 10,
 *             Path = "/testpath.aspx",
 *             Port = 80,
 *             Protocol = AzureNative.Network.MonitorProtocol.HTTP,
 *             TimeoutInSeconds = 5,
 *             ToleratedNumberOfFailures = 2,
 *         },
 *         ProfileName = "parentprofile",
 *         ProfileStatus = AzureNative.Network.ProfileStatus.Enabled,
 *         ResourceGroupName = "myresourcegroup",
 *         TrafficRoutingMethod = AzureNative.Network.TrafficRoutingMethod.Priority,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewProfile(ctx, "profile", &network.ProfileArgs{
 * 			DnsConfig: &network.DnsConfigArgs{
 * 				RelativeName: pulumi.String("parentprofile"),
 * 				Ttl:          pulumi.Float64(35),
 * 			},
 * 			Endpoints: network.EndpointTypeArray{
 * 				&network.EndpointTypeArgs{
 * 					EndpointStatus:        pulumi.String(network.EndpointStatusEnabled),
 * 					MinChildEndpoints:     pulumi.Float64(2),
 * 					MinChildEndpointsIPv4: pulumi.Float64(1),
 * 					MinChildEndpointsIPv6: pulumi.Float64(2),
 * 					Name:                  pulumi.String("MyFirstNestedEndpoint"),
 * 					Priority:              pulumi.Float64(1),
 * 					Target:                pulumi.String("firstnestedprofile.tmpreview.watmtest.azure-test.net"),
 * 					Type:                  pulumi.String("Microsoft.Network/trafficManagerProfiles/nestedEndpoints"),
 * 					Weight:                pulumi.Float64(1),
 * 				},
 * 				&network.EndpointTypeArgs{
 * 					EndpointStatus:        pulumi.String(network.EndpointStatusEnabled),
 * 					MinChildEndpoints:     pulumi.Float64(2),
 * 					MinChildEndpointsIPv4: pulumi.Float64(2),
 * 					MinChildEndpointsIPv6: pulumi.Float64(1),
 * 					Name:                  pulumi.String("MySecondNestedEndpoint"),
 * 					Priority:              pulumi.Float64(2),
 * 					Target:                pulumi.String("secondnestedprofile.tmpreview.watmtest.azure-test.net"),
 * 					Type:                  pulumi.String("Microsoft.Network/trafficManagerProfiles/nestedEndpoints"),
 * 					Weight:                pulumi.Float64(1),
 * 				},
 * 			},
 * 			Location: pulumi.String("global"),
 * 			MonitorConfig: &network.MonitorConfigArgs{
 * 				IntervalInSeconds:         pulumi.Float64(10),
 * 				Path:                      pulumi.String("/testpath.aspx"),
 * 				Port:                      pulumi.Float64(80),
 * 				Protocol:                  pulumi.String(network.MonitorProtocolHTTP),
 * 				TimeoutInSeconds:          pulumi.Float64(5),
 * 				ToleratedNumberOfFailures: pulumi.Float64(2),
 * 			},
 * 			ProfileName:          pulumi.String("parentprofile"),
 * 			ProfileStatus:        pulumi.String(network.ProfileStatusEnabled),
 * 			ResourceGroupName:    pulumi.String("myresourcegroup"),
 * 			TrafficRoutingMethod: pulumi.String(network.TrafficRoutingMethodPriority),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Profile;
 * import com.pulumi.azurenative.network.ProfileArgs;
 * import com.pulumi.azurenative.network.inputs.DnsConfigArgs;
 * import com.pulumi.azurenative.network.inputs.EndpointArgs;
 * import com.pulumi.azurenative.network.inputs.MonitorConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var profile = new Profile("profile", ProfileArgs.builder()
 *             .dnsConfig(DnsConfigArgs.builder()
 *                 .relativeName("parentprofile")
 *                 .ttl(35)
 *                 .build())
 *             .endpoints(
 *                 EndpointArgs.builder()
 *                     .endpointStatus("Enabled")
 *                     .minChildEndpoints(2)
 *                     .minChildEndpointsIPv4(1)
 *                     .minChildEndpointsIPv6(2)
 *                     .name("MyFirstNestedEndpoint")
 *                     .priority(1)
 *                     .target("firstnestedprofile.tmpreview.watmtest.azure-test.net")
 *                     .type("Microsoft.Network/trafficManagerProfiles/nestedEndpoints")
 *                     .weight(1)
 *                     .build(),
 *                 EndpointArgs.builder()
 *                     .endpointStatus("Enabled")
 *                     .minChildEndpoints(2)
 *                     .minChildEndpointsIPv4(2)
 *                     .minChildEndpointsIPv6(1)
 *                     .name("MySecondNestedEndpoint")
 *                     .priority(2)
 *                     .target("secondnestedprofile.tmpreview.watmtest.azure-test.net")
 *                     .type("Microsoft.Network/trafficManagerProfiles/nestedEndpoints")
 *                     .weight(1)
 *                     .build())
 *             .location("global")
 *             .monitorConfig(MonitorConfigArgs.builder()
 *                 .intervalInSeconds(10)
 *                 .path("/testpath.aspx")
 *                 .port(80)
 *                 .protocol("HTTP")
 *                 .timeoutInSeconds(5)
 *                 .toleratedNumberOfFailures(2)
 *                 .build())
 *             .profileName("parentprofile")
 *             .profileStatus("Enabled")
 *             .resourceGroupName("myresourcegroup")
 *             .trafficRoutingMethod("Priority")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:Profile parentprofile /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}
 * ```
 * @property allowedEndpointRecordTypes The list of allowed endpoint record types.
 * @property dnsConfig The DNS settings of the Traffic Manager profile.
 * @property endpoints The list of endpoints in the Traffic Manager profile.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property id Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
 * @property location The Azure Region where the resource lives
 * @property maxReturn Maximum number of endpoints to be returned for MultiValue routing type.
 * @property monitorConfig The endpoint monitoring settings of the Traffic Manager profile.
 * @property name The name of the resource
 * @property profileName The name of the Traffic Manager profile.
 * @property profileStatus The status of the Traffic Manager profile.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property trafficRoutingMethod The traffic routing method of the Traffic Manager profile.
 * @property trafficViewEnrollmentStatus Indicates whether Traffic View is 'Enabled' or 'Disabled' for the Traffic Manager profile. Null, indicates 'Disabled'. Enabling this feature will increase the cost of the Traffic Manage profile.
 * @property type The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
 */
public data class ProfileArgs(
    public val allowedEndpointRecordTypes: Output<List<Either<String, AllowedEndpointRecordType>>>? =
        null,
    public val dnsConfig: Output<DnsConfigArgs>? = null,
    public val endpoints: Output<List<EndpointArgs>>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val maxReturn: Output<Double>? = null,
    public val monitorConfig: Output<MonitorConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val profileName: Output<String>? = null,
    public val profileStatus: Output<Either<String, ProfileStatus>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trafficRoutingMethod: Output<Either<String, TrafficRoutingMethod>>? = null,
    public val trafficViewEnrollmentStatus: Output<Either<String, TrafficViewEnrollmentStatus>>? =
        null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.ProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.network.ProfileArgs =
        com.pulumi.azurenative.network.ProfileArgs.builder()
            .allowedEndpointRecordTypes(
                allowedEndpointRecordTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .dnsConfig(dnsConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .endpoints(
                endpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .maxReturn(maxReturn?.applyValue({ args0 -> args0 }))
            .monitorConfig(monitorConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .profileStatus(
                profileStatus?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trafficRoutingMethod(
                trafficRoutingMethod?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .trafficViewEnrollmentStatus(
                trafficViewEnrollmentStatus?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProfileArgs].
 */
@PulumiTagMarker
public class ProfileArgsBuilder internal constructor() {
    private var allowedEndpointRecordTypes: Output<List<Either<String, AllowedEndpointRecordType>>>? =
        null

    private var dnsConfig: Output<DnsConfigArgs>? = null

    private var endpoints: Output<List<EndpointArgs>>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var maxReturn: Output<Double>? = null

    private var monitorConfig: Output<MonitorConfigArgs>? = null

    private var name: Output<String>? = null

    private var profileName: Output<String>? = null

    private var profileStatus: Output<Either<String, ProfileStatus>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trafficRoutingMethod: Output<Either<String, TrafficRoutingMethod>>? = null

    private var trafficViewEnrollmentStatus: Output<Either<String, TrafficViewEnrollmentStatus>>? =
        null

    private var type: Output<String>? = null

    /**
     * @param value The list of allowed endpoint record types.
     */
    @JvmName("toktlopkbljnyxah")
    public suspend
    fun allowedEndpointRecordTypes(`value`: Output<List<Either<String, AllowedEndpointRecordType>>>) {
        this.allowedEndpointRecordTypes = value
    }

    @JvmName("rokhwgyejkavxkbd")
    public suspend fun allowedEndpointRecordTypes(
        vararg
        values: Output<Either<String, AllowedEndpointRecordType>>,
    ) {
        this.allowedEndpointRecordTypes = Output.all(values.asList())
    }

    /**
     * @param values The list of allowed endpoint record types.
     */
    @JvmName("vhgjmlaekqxkmggs")
    public suspend
    fun allowedEndpointRecordTypes(values: List<Output<Either<String, AllowedEndpointRecordType>>>) {
        this.allowedEndpointRecordTypes = Output.all(values)
    }

    /**
     * @param value The DNS settings of the Traffic Manager profile.
     */
    @JvmName("nnsmakchjceftcci")
    public suspend fun dnsConfig(`value`: Output<DnsConfigArgs>) {
        this.dnsConfig = value
    }

    /**
     * @param value The list of endpoints in the Traffic Manager profile.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("juhwokqgowamojva")
    public suspend fun endpoints(`value`: Output<List<EndpointArgs>>) {
        this.endpoints = value
    }

    @JvmName("twlxuyevarljasnc")
    public suspend fun endpoints(vararg values: Output<EndpointArgs>) {
        this.endpoints = Output.all(values.asList())
    }

    /**
     * @param values The list of endpoints in the Traffic Manager profile.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("cpqsspemhyggnmgb")
    public suspend fun endpoints(values: List<Output<EndpointArgs>>) {
        this.endpoints = Output.all(values)
    }

    /**
     * @param value Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
     */
    @JvmName("beffcbntrlwoxxeo")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The Azure Region where the resource lives
     */
    @JvmName("suenhldltwjithvb")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Maximum number of endpoints to be returned for MultiValue routing type.
     */
    @JvmName("fyxuyvmoyucbgigy")
    public suspend fun maxReturn(`value`: Output<Double>) {
        this.maxReturn = value
    }

    /**
     * @param value The endpoint monitoring settings of the Traffic Manager profile.
     */
    @JvmName("myicdlvfquoqatrj")
    public suspend fun monitorConfig(`value`: Output<MonitorConfigArgs>) {
        this.monitorConfig = value
    }

    /**
     * @param value The name of the resource
     */
    @JvmName("rxqairxofutemwpw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the Traffic Manager profile.
     */
    @JvmName("mbcojyljxjbhyrqk")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value The status of the Traffic Manager profile.
     */
    @JvmName("fcauupvjeqdxlrbg")
    public suspend fun profileStatus(`value`: Output<Either<String, ProfileStatus>>) {
        this.profileStatus = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ojubsbmklkgoiaqd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("keutmkgrpvvloojg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The traffic routing method of the Traffic Manager profile.
     */
    @JvmName("mnlbaiecqskvregj")
    public suspend fun trafficRoutingMethod(`value`: Output<Either<String, TrafficRoutingMethod>>) {
        this.trafficRoutingMethod = value
    }

    /**
     * @param value Indicates whether Traffic View is 'Enabled' or 'Disabled' for the Traffic Manager profile. Null, indicates 'Disabled'. Enabling this feature will increase the cost of the Traffic Manage profile.
     */
    @JvmName("udkjahutuwgwtxxy")
    public suspend
    fun trafficViewEnrollmentStatus(`value`: Output<Either<String, TrafficViewEnrollmentStatus>>) {
        this.trafficViewEnrollmentStatus = value
    }

    /**
     * @param value The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
     */
    @JvmName("ohsubwluutukmati")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The list of allowed endpoint record types.
     */
    @JvmName("lfbodfwvadvcoohr")
    public suspend
    fun allowedEndpointRecordTypes(`value`: List<Either<String, AllowedEndpointRecordType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedEndpointRecordTypes = mapped
    }

    /**
     * @param values The list of allowed endpoint record types.
     */
    @JvmName("bqdjvwglusarukum")
    public suspend fun allowedEndpointRecordTypes(
        vararg
        values: Either<String, AllowedEndpointRecordType>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedEndpointRecordTypes = mapped
    }

    /**
     * @param value The DNS settings of the Traffic Manager profile.
     */
    @JvmName("ddlgdurwkjbpdhfd")
    public suspend fun dnsConfig(`value`: DnsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsConfig = mapped
    }

    /**
     * @param argument The DNS settings of the Traffic Manager profile.
     */
    @JvmName("klnkvcweufftgnfl")
    public suspend fun dnsConfig(argument: suspend DnsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DnsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dnsConfig = mapped
    }

    /**
     * @param value The list of endpoints in the Traffic Manager profile.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("nfgdirmjstuhrphu")
    public suspend fun endpoints(`value`: List<EndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param argument The list of endpoints in the Traffic Manager profile.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("hpsevnplafraypkj")
    public suspend fun endpoints(argument: List<suspend EndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { EndpointArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument The list of endpoints in the Traffic Manager profile.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("drkcfmkxpxhnuhqh")
    public suspend fun endpoints(vararg argument: suspend EndpointArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { EndpointArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument The list of endpoints in the Traffic Manager profile.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("smwtfyqonxbvimus")
    public suspend fun endpoints(argument: suspend EndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EndpointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param values The list of endpoints in the Traffic Manager profile.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("bmrsxlktxelmbguq")
    public suspend fun endpoints(vararg values: EndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param value Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
     */
    @JvmName("yxqvhwuqaoefkfdv")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The Azure Region where the resource lives
     */
    @JvmName("rrqjsfounvxudqdf")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Maximum number of endpoints to be returned for MultiValue routing type.
     */
    @JvmName("juefgomqnvjwxqrk")
    public suspend fun maxReturn(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxReturn = mapped
    }

    /**
     * @param value The endpoint monitoring settings of the Traffic Manager profile.
     */
    @JvmName("jttkbfbgftckfvlu")
    public suspend fun monitorConfig(`value`: MonitorConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorConfig = mapped
    }

    /**
     * @param argument The endpoint monitoring settings of the Traffic Manager profile.
     */
    @JvmName("kjhyqaqlggxncxtk")
    public suspend fun monitorConfig(argument: suspend MonitorConfigArgsBuilder.() -> Unit) {
        val toBeMapped = MonitorConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.monitorConfig = mapped
    }

    /**
     * @param value The name of the resource
     */
    @JvmName("fbwjfpbxeaggjhpp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the Traffic Manager profile.
     */
    @JvmName("qfjjgohrtnusxwba")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value The status of the Traffic Manager profile.
     */
    @JvmName("ijtgxjkqaaajrpxm")
    public suspend fun profileStatus(`value`: Either<String, ProfileStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileStatus = mapped
    }

    /**
     * @param value The status of the Traffic Manager profile.
     */
    @JvmName("jtcanigtslipqmhf")
    public fun profileStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProfileStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.profileStatus = mapped
    }

    /**
     * @param value The status of the Traffic Manager profile.
     */
    @JvmName("aexbkdiaajawhdko")
    public fun profileStatus(`value`: ProfileStatus) {
        val toBeMapped = Either.ofRight<String, ProfileStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.profileStatus = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qxemcnegvhshfbrx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dmdjydivascjdxmi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("manebfcsoctqtiia")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The traffic routing method of the Traffic Manager profile.
     */
    @JvmName("rbxuitgkqdlilvbr")
    public suspend fun trafficRoutingMethod(`value`: Either<String, TrafficRoutingMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficRoutingMethod = mapped
    }

    /**
     * @param value The traffic routing method of the Traffic Manager profile.
     */
    @JvmName("kuvfkhyslgiwiwua")
    public fun trafficRoutingMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TrafficRoutingMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trafficRoutingMethod = mapped
    }

    /**
     * @param value The traffic routing method of the Traffic Manager profile.
     */
    @JvmName("rpohyfhqhwbemqfm")
    public fun trafficRoutingMethod(`value`: TrafficRoutingMethod) {
        val toBeMapped = Either.ofRight<String, TrafficRoutingMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trafficRoutingMethod = mapped
    }

    /**
     * @param value Indicates whether Traffic View is 'Enabled' or 'Disabled' for the Traffic Manager profile. Null, indicates 'Disabled'. Enabling this feature will increase the cost of the Traffic Manage profile.
     */
    @JvmName("rexxsphegopndied")
    public suspend
    fun trafficViewEnrollmentStatus(`value`: Either<String, TrafficViewEnrollmentStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficViewEnrollmentStatus = mapped
    }

    /**
     * @param value Indicates whether Traffic View is 'Enabled' or 'Disabled' for the Traffic Manager profile. Null, indicates 'Disabled'. Enabling this feature will increase the cost of the Traffic Manage profile.
     */
    @JvmName("yjhthnwsamjqvdng")
    public fun trafficViewEnrollmentStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TrafficViewEnrollmentStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trafficViewEnrollmentStatus = mapped
    }

    /**
     * @param value Indicates whether Traffic View is 'Enabled' or 'Disabled' for the Traffic Manager profile. Null, indicates 'Disabled'. Enabling this feature will increase the cost of the Traffic Manage profile.
     */
    @JvmName("hosiepqxlorcxlrv")
    public fun trafficViewEnrollmentStatus(`value`: TrafficViewEnrollmentStatus) {
        val toBeMapped = Either.ofRight<String, TrafficViewEnrollmentStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trafficViewEnrollmentStatus = mapped
    }

    /**
     * @param value The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
     */
    @JvmName("nqiuxadduuxfvfjr")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ProfileArgs = ProfileArgs(
        allowedEndpointRecordTypes = allowedEndpointRecordTypes,
        dnsConfig = dnsConfig,
        endpoints = endpoints,
        id = id,
        location = location,
        maxReturn = maxReturn,
        monitorConfig = monitorConfig,
        name = name,
        profileName = profileName,
        profileStatus = profileStatus,
        resourceGroupName = resourceGroupName,
        tags = tags,
        trafficRoutingMethod = trafficRoutingMethod,
        trafficViewEnrollmentStatus = trafficViewEnrollmentStatus,
        type = type,
    )
}
