@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.DdosSettingsResponse
import com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.network.kotlin.outputs.IPConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.IpTagResponse
import com.pulumi.azurenative.network.kotlin.outputs.NatGatewayResponse
import com.pulumi.azurenative.network.kotlin.outputs.PublicIPAddressDnsSettingsResponse
import com.pulumi.azurenative.network.kotlin.outputs.PublicIPAddressResponse
import com.pulumi.azurenative.network.kotlin.outputs.PublicIPAddressSkuResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.DdosSettingsResponse.Companion.toKotlin as ddosSettingsResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.IPConfigurationResponse.Companion.toKotlin as iPConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.IpTagResponse.Companion.toKotlin as ipTagResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.NatGatewayResponse.Companion.toKotlin as natGatewayResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PublicIPAddressDnsSettingsResponse.Companion.toKotlin as publicIPAddressDnsSettingsResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PublicIPAddressResponse.Companion.toKotlin as publicIPAddressResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PublicIPAddressSkuResponse.Companion.toKotlin as publicIPAddressSkuResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin

/**
 * Builder for [PublicIPAddress].
 */
@PulumiTagMarker
public class PublicIPAddressResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PublicIPAddressArgs = PublicIPAddressArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PublicIPAddressArgsBuilder.() -> Unit) {
        val builder = PublicIPAddressArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PublicIPAddress {
        val builtJavaResource = com.pulumi.azurenative.network.PublicIPAddress(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PublicIPAddress(builtJavaResource)
    }
}

/**
 * Public IP address resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2016-03-30, 2019-06-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create public IP address DNS
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var publicIPAddress = new AzureNative.Network.PublicIPAddress("publicIPAddress", new()
 *     {
 *         DnsSettings = new AzureNative.Network.Inputs.PublicIPAddressDnsSettingsArgs
 *         {
 *             DomainNameLabel = "dnslbl",
 *         },
 *         Location = "eastus",
 *         PublicIpAddressName = "test-ip",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPublicIPAddress(ctx, "publicIPAddress", &network.PublicIPAddressArgs{
 * 			DnsSettings: &network.PublicIPAddressDnsSettingsArgs{
 * 				DomainNameLabel: pulumi.String("dnslbl"),
 * 			},
 * 			Location:            pulumi.String("eastus"),
 * 			PublicIpAddressName: pulumi.String("test-ip"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PublicIPAddress;
 * import com.pulumi.azurenative.network.PublicIPAddressArgs;
 * import com.pulumi.azurenative.network.inputs.PublicIPAddressDnsSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var publicIPAddress = new PublicIPAddress("publicIPAddress", PublicIPAddressArgs.builder()
 *             .dnsSettings(PublicIPAddressDnsSettingsArgs.builder()
 *                 .domainNameLabel("dnslbl")
 *                 .build())
 *             .location("eastus")
 *             .publicIpAddressName("test-ip")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create public IP address DNS with Domain Name Label Scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var publicIPAddress = new AzureNative.Network.PublicIPAddress("publicIPAddress", new()
 *     {
 *         DnsSettings = new AzureNative.Network.Inputs.PublicIPAddressDnsSettingsArgs
 *         {
 *             DomainNameLabel = "dnslbl",
 *             DomainNameLabelScope = AzureNative.Network.PublicIpAddressDnsSettingsDomainNameLabelScope.TenantReuse,
 *         },
 *         Location = "eastus",
 *         PublicIpAddressName = "test-ip",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPublicIPAddress(ctx, "publicIPAddress", &network.PublicIPAddressArgs{
 * 			DnsSettings: &network.PublicIPAddressDnsSettingsArgs{
 * 				DomainNameLabel:      pulumi.String("dnslbl"),
 * 				DomainNameLabelScope: network.PublicIpAddressDnsSettingsDomainNameLabelScopeTenantReuse,
 * 			},
 * 			Location:            pulumi.String("eastus"),
 * 			PublicIpAddressName: pulumi.String("test-ip"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PublicIPAddress;
 * import com.pulumi.azurenative.network.PublicIPAddressArgs;
 * import com.pulumi.azurenative.network.inputs.PublicIPAddressDnsSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var publicIPAddress = new PublicIPAddress("publicIPAddress", PublicIPAddressArgs.builder()
 *             .dnsSettings(PublicIPAddressDnsSettingsArgs.builder()
 *                 .domainNameLabel("dnslbl")
 *                 .domainNameLabelScope("TenantReuse")
 *                 .build())
 *             .location("eastus")
 *             .publicIpAddressName("test-ip")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create public IP address allocation method
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var publicIPAddress = new AzureNative.Network.PublicIPAddress("publicIPAddress", new()
 *     {
 *         IdleTimeoutInMinutes = 10,
 *         Location = "eastus",
 *         PublicIPAddressVersion = AzureNative.Network.IPVersion.IPv4,
 *         PublicIPAllocationMethod = AzureNative.Network.IPAllocationMethod.Static,
 *         PublicIpAddressName = "test-ip",
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.PublicIPAddressSkuArgs
 *         {
 *             Name = AzureNative.Network.PublicIPAddressSkuName.Standard,
 *             Tier = AzureNative.Network.PublicIPAddressSkuTier.Global,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPublicIPAddress(ctx, "publicIPAddress", &network.PublicIPAddressArgs{
 * 			IdleTimeoutInMinutes:     pulumi.Int(10),
 * 			Location:                 pulumi.String("eastus"),
 * 			PublicIPAddressVersion:   pulumi.String(network.IPVersionIPv4),
 * 			PublicIPAllocationMethod: pulumi.String(network.IPAllocationMethodStatic),
 * 			PublicIpAddressName:      pulumi.String("test-ip"),
 * 			ResourceGroupName:        pulumi.String("rg1"),
 * 			Sku: &network.PublicIPAddressSkuArgs{
 * 				Name: pulumi.String(network.PublicIPAddressSkuNameStandard),
 * 				Tier: pulumi.String(network.PublicIPAddressSkuTierGlobal),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PublicIPAddress;
 * import com.pulumi.azurenative.network.PublicIPAddressArgs;
 * import com.pulumi.azurenative.network.inputs.PublicIPAddressSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var publicIPAddress = new PublicIPAddress("publicIPAddress", PublicIPAddressArgs.builder()
 *             .idleTimeoutInMinutes(10)
 *             .location("eastus")
 *             .publicIPAddressVersion("IPv4")
 *             .publicIPAllocationMethod("Static")
 *             .publicIpAddressName("test-ip")
 *             .resourceGroupName("rg1")
 *             .sku(PublicIPAddressSkuArgs.builder()
 *                 .name("Standard")
 *                 .tier("Global")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create public IP address defaults
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var publicIPAddress = new AzureNative.Network.PublicIPAddress("publicIPAddress", new()
 *     {
 *         Location = "eastus",
 *         PublicIpAddressName = "test-ip",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPublicIPAddress(ctx, "publicIPAddress", &network.PublicIPAddressArgs{
 * 			Location:            pulumi.String("eastus"),
 * 			PublicIpAddressName: pulumi.String("test-ip"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PublicIPAddress;
 * import com.pulumi.azurenative.network.PublicIPAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var publicIPAddress = new PublicIPAddress("publicIPAddress", PublicIPAddressArgs.builder()
 *             .location("eastus")
 *             .publicIpAddressName("test-ip")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:PublicIPAddress testDNS-ip /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses/{publicIpAddressName}
 * ```
 */
public class PublicIPAddress internal constructor(
    override val javaResource: com.pulumi.azurenative.network.PublicIPAddress,
) : KotlinCustomResource(javaResource, PublicIPAddressMapper) {
    /**
     * The DDoS protection custom policy associated with the public IP address.
     */
    public val ddosSettings: Output<DdosSettingsResponse>?
        get() = javaResource.ddosSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    ddosSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specify what happens to the public IP address when the VM using it is deleted
     */
    public val deleteOption: Output<String>?
        get() = javaResource.deleteOption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The FQDN of the DNS record associated with the public IP address.
     */
    public val dnsSettings: Output<PublicIPAddressDnsSettingsResponse>?
        get() = javaResource.dnsSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    publicIPAddressDnsSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The extended location of the public ip address.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The idle timeout of the public IP address.
     */
    public val idleTimeoutInMinutes: Output<Int>?
        get() = javaResource.idleTimeoutInMinutes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IP address associated with the public IP address resource.
     */
    public val ipAddress: Output<String>?
        get() = javaResource.ipAddress().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The IP configuration associated with the public IP address.
     */
    public val ipConfiguration: Output<IPConfigurationResponse>
        get() = javaResource.ipConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                iPConfigurationResponseToKotlin(args0)
            })
        })

    /**
     * The list of tags associated with the public IP address.
     */
    public val ipTags: Output<List<IpTagResponse>>?
        get() = javaResource.ipTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> ipTagResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The linked public IP address of the public IP address resource.
     */
    public val linkedPublicIPAddress: Output<PublicIPAddressResponse>?
        get() = javaResource.linkedPublicIPAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> publicIPAddressResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Migration phase of Public IP Address.
     */
    public val migrationPhase: Output<String>?
        get() = javaResource.migrationPhase().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The NatGateway for the Public IP address.
     */
    public val natGateway: Output<NatGatewayResponse>?
        get() = javaResource.natGateway().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    natGatewayResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the public IP address resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The public IP address version.
     */
    public val publicIPAddressVersion: Output<String>?
        get() = javaResource.publicIPAddressVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The public IP address allocation method.
     */
    public val publicIPAllocationMethod: Output<String>?
        get() = javaResource.publicIPAllocationMethod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Public IP Prefix this Public IP Address should be allocated from.
     */
    public val publicIPPrefix: Output<SubResourceResponse>?
        get() = javaResource.publicIPPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The resource GUID property of the public IP address resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * The service public IP address of the public IP address resource.
     */
    public val servicePublicIPAddress: Output<PublicIPAddressResponse>?
        get() = javaResource.servicePublicIPAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> publicIPAddressResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The public IP address SKU.
     */
    public val sku: Output<PublicIPAddressSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    publicIPAddressSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object PublicIPAddressMapper : ResourceMapper<PublicIPAddress> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.PublicIPAddress::class == javaResource::class

    override fun map(javaResource: Resource): PublicIPAddress = PublicIPAddress(
        javaResource as
            com.pulumi.azurenative.network.PublicIPAddress,
    )
}

/**
 * @see [PublicIPAddress].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PublicIPAddress].
 */
public suspend fun publicIPAddress(
    name: String,
    block: suspend PublicIPAddressResourceBuilder.() -> Unit,
): PublicIPAddress {
    val builder = PublicIPAddressResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PublicIPAddress].
 * @param name The _unique_ name of the resulting resource.
 */
public fun publicIPAddress(name: String): PublicIPAddress {
    val builder = PublicIPAddressResourceBuilder()
    builder.name(name)
    return builder.build()
}
