@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.network.kotlin.outputs.IpTagResponse
import com.pulumi.azurenative.network.kotlin.outputs.NatGatewayResponse
import com.pulumi.azurenative.network.kotlin.outputs.PublicIPPrefixSkuResponse
import com.pulumi.azurenative.network.kotlin.outputs.ReferencedPublicIpAddressResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.IpTagResponse.Companion.toKotlin as ipTagResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.NatGatewayResponse.Companion.toKotlin as natGatewayResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PublicIPPrefixSkuResponse.Companion.toKotlin as publicIPPrefixSkuResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ReferencedPublicIpAddressResponse.Companion.toKotlin as referencedPublicIpAddressResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin

/**
 * Builder for [PublicIPPrefix].
 */
@PulumiTagMarker
public class PublicIPPrefixResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PublicIPPrefixArgs = PublicIPPrefixArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PublicIPPrefixArgsBuilder.() -> Unit) {
        val builder = PublicIPPrefixArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PublicIPPrefix {
        val builtJavaResource = com.pulumi.azurenative.network.PublicIPPrefix(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PublicIPPrefix(builtJavaResource)
    }
}

/**
 * Public IP prefix resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-06-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create public IP prefix allocation method
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var publicIPPrefix = new AzureNative.Network.PublicIPPrefix("publicIPPrefix", new()
 *     {
 *         Location = "westus",
 *         PrefixLength = 30,
 *         PublicIPAddressVersion = AzureNative.Network.IPVersion.IPv4,
 *         PublicIpPrefixName = "test-ipprefix",
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.PublicIPPrefixSkuArgs
 *         {
 *             Name = AzureNative.Network.PublicIPPrefixSkuName.Standard,
 *             Tier = AzureNative.Network.PublicIPPrefixSkuTier.Regional,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPublicIPPrefix(ctx, "publicIPPrefix", &network.PublicIPPrefixArgs{
 * 			Location:               pulumi.String("westus"),
 * 			PrefixLength:           pulumi.Int(30),
 * 			PublicIPAddressVersion: pulumi.String(network.IPVersionIPv4),
 * 			PublicIpPrefixName:     pulumi.String("test-ipprefix"),
 * 			ResourceGroupName:      pulumi.String("rg1"),
 * 			Sku: &network.PublicIPPrefixSkuArgs{
 * 				Name: pulumi.String(network.PublicIPPrefixSkuNameStandard),
 * 				Tier: pulumi.String(network.PublicIPPrefixSkuTierRegional),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PublicIPPrefix;
 * import com.pulumi.azurenative.network.PublicIPPrefixArgs;
 * import com.pulumi.azurenative.network.inputs.PublicIPPrefixSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var publicIPPrefix = new PublicIPPrefix("publicIPPrefix", PublicIPPrefixArgs.builder()
 *             .location("westus")
 *             .prefixLength(30)
 *             .publicIPAddressVersion("IPv4")
 *             .publicIpPrefixName("test-ipprefix")
 *             .resourceGroupName("rg1")
 *             .sku(PublicIPPrefixSkuArgs.builder()
 *                 .name("Standard")
 *                 .tier("Regional")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create public IP prefix defaults
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var publicIPPrefix = new AzureNative.Network.PublicIPPrefix("publicIPPrefix", new()
 *     {
 *         Location = "westus",
 *         PrefixLength = 30,
 *         PublicIpPrefixName = "test-ipprefix",
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.PublicIPPrefixSkuArgs
 *         {
 *             Name = AzureNative.Network.PublicIPPrefixSkuName.Standard,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPublicIPPrefix(ctx, "publicIPPrefix", &network.PublicIPPrefixArgs{
 * 			Location:           pulumi.String("westus"),
 * 			PrefixLength:       pulumi.Int(30),
 * 			PublicIpPrefixName: pulumi.String("test-ipprefix"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			Sku: &network.PublicIPPrefixSkuArgs{
 * 				Name: pulumi.String(network.PublicIPPrefixSkuNameStandard),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PublicIPPrefix;
 * import com.pulumi.azurenative.network.PublicIPPrefixArgs;
 * import com.pulumi.azurenative.network.inputs.PublicIPPrefixSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var publicIPPrefix = new PublicIPPrefix("publicIPPrefix", PublicIPPrefixArgs.builder()
 *             .location("westus")
 *             .prefixLength(30)
 *             .publicIpPrefixName("test-ipprefix")
 *             .resourceGroupName("rg1")
 *             .sku(PublicIPPrefixSkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:PublicIPPrefix test-ipprefix /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIpPrefixName}
 * ```
 */
public class PublicIPPrefix internal constructor(
    override val javaResource: com.pulumi.azurenative.network.PublicIPPrefix,
) : KotlinCustomResource(javaResource, PublicIPPrefixMapper) {
    /**
     * The customIpPrefix that this prefix is associated with.
     */
    public val customIPPrefix: Output<SubResourceResponse>?
        get() = javaResource.customIPPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The extended location of the public ip address.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The allocated Prefix.
     */
    public val ipPrefix: Output<String>
        get() = javaResource.ipPrefix().applyValue({ args0 -> args0 })

    /**
     * The list of tags associated with the public IP prefix.
     */
    public val ipTags: Output<List<IpTagResponse>>?
        get() = javaResource.ipTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> ipTagResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The reference to load balancer frontend IP configuration associated with the public IP prefix.
     */
    public val loadBalancerFrontendIpConfiguration: Output<SubResourceResponse>
        get() = javaResource.loadBalancerFrontendIpConfiguration().applyValue({ args0 ->
            args0.let({ args0 -> subResourceResponseToKotlin(args0) })
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * NatGateway of Public IP Prefix.
     */
    public val natGateway: Output<NatGatewayResponse>?
        get() = javaResource.natGateway().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    natGatewayResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The Length of the Public IP Prefix.
     */
    public val prefixLength: Output<Int>?
        get() = javaResource.prefixLength().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provisioning state of the public IP prefix resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The public IP address version.
     */
    public val publicIPAddressVersion: Output<String>?
        get() = javaResource.publicIPAddressVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of all referenced PublicIPAddresses.
     */
    public val publicIPAddresses: Output<List<ReferencedPublicIpAddressResponse>>
        get() = javaResource.publicIPAddresses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> referencedPublicIpAddressResponseToKotlin(args0) })
            })
        })

    /**
     * The resource GUID property of the public IP prefix resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * The public IP prefix SKU.
     */
    public val sku: Output<PublicIPPrefixSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    publicIPPrefixSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object PublicIPPrefixMapper : ResourceMapper<PublicIPPrefix> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.PublicIPPrefix::class == javaResource::class

    override fun map(javaResource: Resource): PublicIPPrefix = PublicIPPrefix(
        javaResource as
            com.pulumi.azurenative.network.PublicIPPrefix,
    )
}

/**
 * @see [PublicIPPrefix].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PublicIPPrefix].
 */
public suspend fun publicIPPrefix(
    name: String,
    block: suspend PublicIPPrefixResourceBuilder.() -> Unit,
): PublicIPPrefix {
    val builder = PublicIPPrefixResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PublicIPPrefix].
 * @param name The _unique_ name of the resulting resource.
 */
public fun publicIPPrefix(name: String): PublicIPPrefix {
    val builder = PublicIPPrefixResourceBuilder()
    builder.name(name)
    return builder.build()
}
