@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ARecordResponse
import com.pulumi.azurenative.network.kotlin.outputs.AaaaRecordResponse
import com.pulumi.azurenative.network.kotlin.outputs.CaaRecordResponse
import com.pulumi.azurenative.network.kotlin.outputs.CnameRecordResponse
import com.pulumi.azurenative.network.kotlin.outputs.MxRecordResponse
import com.pulumi.azurenative.network.kotlin.outputs.NsRecordResponse
import com.pulumi.azurenative.network.kotlin.outputs.PtrRecordResponse
import com.pulumi.azurenative.network.kotlin.outputs.SoaRecordResponse
import com.pulumi.azurenative.network.kotlin.outputs.SrvRecordResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.TxtRecordResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.ARecordResponse.Companion.toKotlin as aRecordResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.AaaaRecordResponse.Companion.toKotlin as aaaaRecordResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.CaaRecordResponse.Companion.toKotlin as caaRecordResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.CnameRecordResponse.Companion.toKotlin as cnameRecordResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.MxRecordResponse.Companion.toKotlin as mxRecordResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.NsRecordResponse.Companion.toKotlin as nsRecordResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PtrRecordResponse.Companion.toKotlin as ptrRecordResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SoaRecordResponse.Companion.toKotlin as soaRecordResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SrvRecordResponse.Companion.toKotlin as srvRecordResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.TxtRecordResponse.Companion.toKotlin as txtRecordResponseToKotlin

/**
 * Builder for [RecordSet].
 */
@PulumiTagMarker
public class RecordSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RecordSetArgs = RecordSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RecordSetArgsBuilder.() -> Unit) {
        val builder = RecordSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RecordSet {
        val builtJavaResource = com.pulumi.azurenative.network.RecordSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RecordSet(builtJavaResource)
    }
}

/**
 * Describes a DNS record set (a collection of DNS records with the same name and type).
 * Azure REST API version: 2018-05-01. Prior API version in Azure Native 1.x: 2018-05-01.
 * Other available API versions: 2015-05-04-preview, 2016-04-01, 2023-07-01-preview.
 * ## Example Usage
 * ### Create A recordset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         ARecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.ARecordArgs
 *             {
 *                 Ipv4Address = "127.0.0.1",
 *             },
 *         },
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         RecordType = "A",
 *         RelativeRecordSetName = "record1",
 *         ResourceGroupName = "rg1",
 *         Ttl = 3600,
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			ARecords: network.ARecordArray{
 * 				&network.ARecordArgs{
 * 					Ipv4Address: pulumi.String("127.0.0.1"),
 * 				},
 * 			},
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			RecordType:            pulumi.String("A"),
 * 			RelativeRecordSetName: pulumi.String("record1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 			ZoneName:              pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.ARecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .aRecords(ARecordArgs.builder()
 *                 .ipv4Address("127.0.0.1")
 *                 .build())
 *             .metadata(Map.of("key1", "value1"))
 *             .recordType("A")
 *             .relativeRecordSetName("record1")
 *             .resourceGroupName("rg1")
 *             .ttl(3600)
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create A recordset with alias target resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         RecordType = "A",
 *         RelativeRecordSetName = "record1",
 *         ResourceGroupName = "rg1",
 *         TargetResource = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/726f8cd6-6459-4db4-8e6d-2cd2716904e2/resourceGroups/test/providers/Microsoft.Network/trafficManagerProfiles/testpp2",
 *         },
 *         Ttl = 3600,
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			RecordType:            pulumi.String("A"),
 * 			RelativeRecordSetName: pulumi.String("record1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			TargetResource: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/726f8cd6-6459-4db4-8e6d-2cd2716904e2/resourceGroups/test/providers/Microsoft.Network/trafficManagerProfiles/testpp2"),
 * 			},
 * 			Ttl:      pulumi.Float64(3600),
 * 			ZoneName: pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .recordType("A")
 *             .relativeRecordSetName("record1")
 *             .resourceGroupName("rg1")
 *             .targetResource(SubResourceArgs.builder()
 *                 .id("/subscriptions/726f8cd6-6459-4db4-8e6d-2cd2716904e2/resourceGroups/test/providers/Microsoft.Network/trafficManagerProfiles/testpp2")
 *                 .build())
 *             .ttl(3600)
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create AAAA recordset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         AaaaRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.AaaaRecordArgs
 *             {
 *                 Ipv6Address = "::1",
 *             },
 *         },
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         RecordType = "AAAA",
 *         RelativeRecordSetName = "record1",
 *         ResourceGroupName = "rg1",
 *         Ttl = 3600,
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			AaaaRecords: network.AaaaRecordArray{
 * 				&network.AaaaRecordArgs{
 * 					Ipv6Address: pulumi.String("::1"),
 * 				},
 * 			},
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			RecordType:            pulumi.String("AAAA"),
 * 			RelativeRecordSetName: pulumi.String("record1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 			ZoneName:              pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.AaaaRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .aaaaRecords(AaaaRecordArgs.builder()
 *                 .ipv6Address("::1")
 *                 .build())
 *             .metadata(Map.of("key1", "value1"))
 *             .recordType("AAAA")
 *             .relativeRecordSetName("record1")
 *             .resourceGroupName("rg1")
 *             .ttl(3600)
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create CAA recordset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         CaaRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.CaaRecordArgs
 *             {
 *                 Flags = 0,
 *                 Tag = "issue",
 *                 Value = "ca.contoso.com",
 *             },
 *         },
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         RecordType = "CAA",
 *         RelativeRecordSetName = "record1",
 *         ResourceGroupName = "rg1",
 *         Ttl = 3600,
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			CaaRecords: network.CaaRecordArray{
 * 				&network.CaaRecordArgs{
 * 					Flags: pulumi.Int(0),
 * 					Tag:   pulumi.String("issue"),
 * 					Value: pulumi.String("ca.contoso.com"),
 * 				},
 * 			},
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			RecordType:            pulumi.String("CAA"),
 * 			RelativeRecordSetName: pulumi.String("record1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 			ZoneName:              pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.CaaRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .caaRecords(CaaRecordArgs.builder()
 *                 .flags(0)
 *                 .tag("issue")
 *                 .value("ca.contoso.com")
 *                 .build())
 *             .metadata(Map.of("key1", "value1"))
 *             .recordType("CAA")
 *             .relativeRecordSetName("record1")
 *             .resourceGroupName("rg1")
 *             .ttl(3600)
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create CNAME recordset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         CnameRecord = new AzureNative.Network.Inputs.CnameRecordArgs
 *         {
 *             Cname = "contoso.com",
 *         },
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         RecordType = "CNAME",
 *         RelativeRecordSetName = "record1",
 *         ResourceGroupName = "rg1",
 *         Ttl = 3600,
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			CnameRecord: &network.CnameRecordArgs{
 * 				Cname: pulumi.String("contoso.com"),
 * 			},
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			RecordType:            pulumi.String("CNAME"),
 * 			RelativeRecordSetName: pulumi.String("record1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 			ZoneName:              pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.CnameRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .cnameRecord(CnameRecordArgs.builder()
 *                 .cname("contoso.com")
 *                 .build())
 *             .metadata(Map.of("key1", "value1"))
 *             .recordType("CNAME")
 *             .relativeRecordSetName("record1")
 *             .resourceGroupName("rg1")
 *             .ttl(3600)
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create MX recordset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         MxRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.MxRecordArgs
 *             {
 *                 Exchange = "mail.contoso.com",
 *                 Preference = 0,
 *             },
 *         },
 *         RecordType = "MX",
 *         RelativeRecordSetName = "record1",
 *         ResourceGroupName = "rg1",
 *         Ttl = 3600,
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			MxRecords: network.MxRecordArray{
 * 				&network.MxRecordArgs{
 * 					Exchange:   pulumi.String("mail.contoso.com"),
 * 					Preference: pulumi.Int(0),
 * 				},
 * 			},
 * 			RecordType:            pulumi.String("MX"),
 * 			RelativeRecordSetName: pulumi.String("record1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 			ZoneName:              pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.MxRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .mxRecords(MxRecordArgs.builder()
 *                 .exchange("mail.contoso.com")
 *                 .preference(0)
 *                 .build())
 *             .recordType("MX")
 *             .relativeRecordSetName("record1")
 *             .resourceGroupName("rg1")
 *             .ttl(3600)
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create NS recordset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         NsRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.NsRecordArgs
 *             {
 *                 Nsdname = "ns1.contoso.com",
 *             },
 *         },
 *         RecordType = "NS",
 *         RelativeRecordSetName = "record1",
 *         ResourceGroupName = "rg1",
 *         Ttl = 3600,
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			NsRecords: network.NsRecordArray{
 * 				&network.NsRecordArgs{
 * 					Nsdname: pulumi.String("ns1.contoso.com"),
 * 				},
 * 			},
 * 			RecordType:            pulumi.String("NS"),
 * 			RelativeRecordSetName: pulumi.String("record1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 			ZoneName:              pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.NsRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .nsRecords(NsRecordArgs.builder()
 *                 .nsdname("ns1.contoso.com")
 *                 .build())
 *             .recordType("NS")
 *             .relativeRecordSetName("record1")
 *             .resourceGroupName("rg1")
 *             .ttl(3600)
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create PTR recordset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         PtrRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.PtrRecordArgs
 *             {
 *                 Ptrdname = "localhost",
 *             },
 *         },
 *         RecordType = "PTR",
 *         RelativeRecordSetName = "1",
 *         ResourceGroupName = "rg1",
 *         Ttl = 3600,
 *         ZoneName = "0.0.127.in-addr.arpa",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			PtrRecords: network.PtrRecordArray{
 * 				&network.PtrRecordArgs{
 * 					Ptrdname: pulumi.String("localhost"),
 * 				},
 * 			},
 * 			RecordType:            pulumi.String("PTR"),
 * 			RelativeRecordSetName: pulumi.String("1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 			ZoneName:              pulumi.String("0.0.127.in-addr.arpa"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.PtrRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .ptrRecords(PtrRecordArgs.builder()
 *                 .ptrdname("localhost")
 *                 .build())
 *             .recordType("PTR")
 *             .relativeRecordSetName("1")
 *             .resourceGroupName("rg1")
 *             .ttl(3600)
 *             .zoneName("0.0.127.in-addr.arpa")
 *             .build());
 *     }
 * }
 * ```
 * ### Create SOA recordset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         RecordType = "SOA",
 *         RelativeRecordSetName = "@",
 *         ResourceGroupName = "rg1",
 *         SoaRecord = new AzureNative.Network.Inputs.SoaRecordArgs
 *         {
 *             Email = "hostmaster.contoso.com",
 *             ExpireTime = 2419200,
 *             Host = "ns1.contoso.com",
 *             MinimumTtl = 300,
 *             RefreshTime = 3600,
 *             RetryTime = 300,
 *             SerialNumber = 1,
 *         },
 *         Ttl = 3600,
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			RecordType:            pulumi.String("SOA"),
 * 			RelativeRecordSetName: pulumi.String("@"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			SoaRecord: &network.SoaRecordArgs{
 * 				Email:        pulumi.String("hostmaster.contoso.com"),
 * 				ExpireTime:   pulumi.Float64(2419200),
 * 				Host:         pulumi.String("ns1.contoso.com"),
 * 				MinimumTtl:   pulumi.Float64(300),
 * 				RefreshTime:  pulumi.Float64(3600),
 * 				RetryTime:    pulumi.Float64(300),
 * 				SerialNumber: pulumi.Float64(1),
 * 			},
 * 			Ttl:      pulumi.Float64(3600),
 * 			ZoneName: pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.SoaRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .recordType("SOA")
 *             .relativeRecordSetName("@")
 *             .resourceGroupName("rg1")
 *             .soaRecord(SoaRecordArgs.builder()
 *                 .email("hostmaster.contoso.com")
 *                 .expireTime(2419200)
 *                 .host("ns1.contoso.com")
 *                 .minimumTtl(300)
 *                 .refreshTime(3600)
 *                 .retryTime(300)
 *                 .serialNumber(1)
 *                 .build())
 *             .ttl(3600)
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create SRV recordset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         RecordType = "SRV",
 *         RelativeRecordSetName = "record1",
 *         ResourceGroupName = "rg1",
 *         SrvRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.SrvRecordArgs
 *             {
 *                 Port = 80,
 *                 Priority = 0,
 *                 Target = "contoso.com",
 *                 Weight = 10,
 *             },
 *         },
 *         Ttl = 3600,
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			RecordType:            pulumi.String("SRV"),
 * 			RelativeRecordSetName: pulumi.String("record1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			SrvRecords: network.SrvRecordArray{
 * 				&network.SrvRecordArgs{
 * 					Port:     pulumi.Int(80),
 * 					Priority: pulumi.Int(0),
 * 					Target:   pulumi.String("contoso.com"),
 * 					Weight:   pulumi.Int(10),
 * 				},
 * 			},
 * 			Ttl:      pulumi.Float64(3600),
 * 			ZoneName: pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.SrvRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .recordType("SRV")
 *             .relativeRecordSetName("record1")
 *             .resourceGroupName("rg1")
 *             .srvRecords(SrvRecordArgs.builder()
 *                 .port(80)
 *                 .priority(0)
 *                 .target("contoso.com")
 *                 .weight(10)
 *                 .build())
 *             .ttl(3600)
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create TXT recordset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         RecordType = "TXT",
 *         RelativeRecordSetName = "record1",
 *         ResourceGroupName = "rg1",
 *         Ttl = 3600,
 *         TxtRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.TxtRecordArgs
 *             {
 *                 Value = new[]
 *                 {
 *                     "string1",
 *                     "string2",
 *                 },
 *             },
 *         },
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			RecordType:            pulumi.String("TXT"),
 * 			RelativeRecordSetName: pulumi.String("record1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 			TxtRecords: network.TxtRecordArray{
 * 				&network.TxtRecordArgs{
 * 					Value: pulumi.StringArray{
 * 						pulumi.String("string1"),
 * 						pulumi.String("string2"),
 * 					},
 * 				},
 * 			},
 * 			ZoneName: pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.TxtRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .recordType("TXT")
 *             .relativeRecordSetName("record1")
 *             .resourceGroupName("rg1")
 *             .ttl(3600)
 *             .txtRecords(TxtRecordArgs.builder()
 *                 .value(
 *                     "string1",
 *                     "string2")
 *                 .build())
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:RecordSet record1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}
 * ```
 */
public class RecordSet internal constructor(
    override val javaResource: com.pulumi.azurenative.network.RecordSet,
) : KotlinCustomResource(javaResource, RecordSetMapper) {
    /**
     * The list of A records in the record set.
     */
    public val aRecords: Output<List<ARecordResponse>>?
        get() = javaResource.aRecords().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> aRecordResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The list of AAAA records in the record set.
     */
    public val aaaaRecords: Output<List<AaaaRecordResponse>>?
        get() = javaResource.aaaaRecords().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> aaaaRecordResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The list of CAA records in the record set.
     */
    public val caaRecords: Output<List<CaaRecordResponse>>?
        get() = javaResource.caaRecords().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> caaRecordResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The CNAME record in the  record set.
     */
    public val cnameRecord: Output<CnameRecordResponse>?
        get() = javaResource.cnameRecord().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    cnameRecordResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The etag of the record set.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Fully qualified domain name of the record set.
     */
    public val fqdn: Output<String>
        get() = javaResource.fqdn().applyValue({ args0 -> args0 })

    /**
     * The metadata attached to the record set.
     */
    public val metadata: Output<Map<String, String>>?
        get() = javaResource.metadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The list of MX records in the record set.
     */
    public val mxRecords: Output<List<MxRecordResponse>>?
        get() = javaResource.mxRecords().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> mxRecordResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The name of the record set.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The list of NS records in the record set.
     */
    public val nsRecords: Output<List<NsRecordResponse>>?
        get() = javaResource.nsRecords().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> nsRecordResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * provisioning State of the record set.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The list of PTR records in the record set.
     */
    public val ptrRecords: Output<List<PtrRecordResponse>>?
        get() = javaResource.ptrRecords().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> ptrRecordResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The SOA record in the record set.
     */
    public val soaRecord: Output<SoaRecordResponse>?
        get() = javaResource.soaRecord().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    soaRecordResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The list of SRV records in the record set.
     */
    public val srvRecords: Output<List<SrvRecordResponse>>?
        get() = javaResource.srvRecords().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> srvRecordResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A reference to an azure resource from where the dns resource value is taken.
     */
    public val targetResource: Output<SubResourceResponse>?
        get() = javaResource.targetResource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The TTL (time-to-live) of the records in the record set.
     */
    public val ttl: Output<Double>?
        get() = javaResource.ttl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The list of TXT records in the record set.
     */
    public val txtRecords: Output<List<TxtRecordResponse>>?
        get() = javaResource.txtRecords().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> txtRecordResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The type of the record set.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RecordSetMapper : ResourceMapper<RecordSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.RecordSet::class == javaResource::class

    override fun map(javaResource: Resource): RecordSet = RecordSet(
        javaResource as
            com.pulumi.azurenative.network.RecordSet,
    )
}

/**
 * @see [RecordSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RecordSet].
 */
public suspend fun recordSet(name: String, block: suspend RecordSetResourceBuilder.() -> Unit):
    RecordSet {
    val builder = RecordSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RecordSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun recordSet(name: String): RecordSet {
    val builder = RecordSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
