@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.RecordSetArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.ARecordArgs
import com.pulumi.azurenative.network.kotlin.inputs.ARecordArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.AaaaRecordArgs
import com.pulumi.azurenative.network.kotlin.inputs.AaaaRecordArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.CaaRecordArgs
import com.pulumi.azurenative.network.kotlin.inputs.CaaRecordArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.CnameRecordArgs
import com.pulumi.azurenative.network.kotlin.inputs.CnameRecordArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.MxRecordArgs
import com.pulumi.azurenative.network.kotlin.inputs.MxRecordArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.NsRecordArgs
import com.pulumi.azurenative.network.kotlin.inputs.NsRecordArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.PtrRecordArgs
import com.pulumi.azurenative.network.kotlin.inputs.PtrRecordArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SoaRecordArgs
import com.pulumi.azurenative.network.kotlin.inputs.SoaRecordArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SrvRecordArgs
import com.pulumi.azurenative.network.kotlin.inputs.SrvRecordArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.TxtRecordArgs
import com.pulumi.azurenative.network.kotlin.inputs.TxtRecordArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a DNS record set (a collection of DNS records with the same name and type).
 * Azure REST API version: 2018-05-01. Prior API version in Azure Native 1.x: 2018-05-01.
 * Other available API versions: 2015-05-04-preview, 2016-04-01, 2023-07-01-preview.
 * ## Example Usage
 * ### Create A recordset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         ARecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.ARecordArgs
 *             {
 *                 Ipv4Address = "127.0.0.1",
 *             },
 *         },
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         RecordType = "A",
 *         RelativeRecordSetName = "record1",
 *         ResourceGroupName = "rg1",
 *         Ttl = 3600,
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			ARecords: network.ARecordArray{
 * 				&network.ARecordArgs{
 * 					Ipv4Address: pulumi.String("127.0.0.1"),
 * 				},
 * 			},
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			RecordType:            pulumi.String("A"),
 * 			RelativeRecordSetName: pulumi.String("record1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 			ZoneName:              pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.ARecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .aRecords(ARecordArgs.builder()
 *                 .ipv4Address("127.0.0.1")
 *                 .build())
 *             .metadata(Map.of("key1", "value1"))
 *             .recordType("A")
 *             .relativeRecordSetName("record1")
 *             .resourceGroupName("rg1")
 *             .ttl(3600)
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create A recordset with alias target resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         RecordType = "A",
 *         RelativeRecordSetName = "record1",
 *         ResourceGroupName = "rg1",
 *         TargetResource = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/726f8cd6-6459-4db4-8e6d-2cd2716904e2/resourceGroups/test/providers/Microsoft.Network/trafficManagerProfiles/testpp2",
 *         },
 *         Ttl = 3600,
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			RecordType:            pulumi.String("A"),
 * 			RelativeRecordSetName: pulumi.String("record1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			TargetResource: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/726f8cd6-6459-4db4-8e6d-2cd2716904e2/resourceGroups/test/providers/Microsoft.Network/trafficManagerProfiles/testpp2"),
 * 			},
 * 			Ttl:      pulumi.Float64(3600),
 * 			ZoneName: pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .recordType("A")
 *             .relativeRecordSetName("record1")
 *             .resourceGroupName("rg1")
 *             .targetResource(SubResourceArgs.builder()
 *                 .id("/subscriptions/726f8cd6-6459-4db4-8e6d-2cd2716904e2/resourceGroups/test/providers/Microsoft.Network/trafficManagerProfiles/testpp2")
 *                 .build())
 *             .ttl(3600)
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create AAAA recordset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         AaaaRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.AaaaRecordArgs
 *             {
 *                 Ipv6Address = "::1",
 *             },
 *         },
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         RecordType = "AAAA",
 *         RelativeRecordSetName = "record1",
 *         ResourceGroupName = "rg1",
 *         Ttl = 3600,
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			AaaaRecords: network.AaaaRecordArray{
 * 				&network.AaaaRecordArgs{
 * 					Ipv6Address: pulumi.String("::1"),
 * 				},
 * 			},
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			RecordType:            pulumi.String("AAAA"),
 * 			RelativeRecordSetName: pulumi.String("record1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 			ZoneName:              pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.AaaaRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .aaaaRecords(AaaaRecordArgs.builder()
 *                 .ipv6Address("::1")
 *                 .build())
 *             .metadata(Map.of("key1", "value1"))
 *             .recordType("AAAA")
 *             .relativeRecordSetName("record1")
 *             .resourceGroupName("rg1")
 *             .ttl(3600)
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create CAA recordset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         CaaRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.CaaRecordArgs
 *             {
 *                 Flags = 0,
 *                 Tag = "issue",
 *                 Value = "ca.contoso.com",
 *             },
 *         },
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         RecordType = "CAA",
 *         RelativeRecordSetName = "record1",
 *         ResourceGroupName = "rg1",
 *         Ttl = 3600,
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			CaaRecords: network.CaaRecordArray{
 * 				&network.CaaRecordArgs{
 * 					Flags: pulumi.Int(0),
 * 					Tag:   pulumi.String("issue"),
 * 					Value: pulumi.String("ca.contoso.com"),
 * 				},
 * 			},
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			RecordType:            pulumi.String("CAA"),
 * 			RelativeRecordSetName: pulumi.String("record1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 			ZoneName:              pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.CaaRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .caaRecords(CaaRecordArgs.builder()
 *                 .flags(0)
 *                 .tag("issue")
 *                 .value("ca.contoso.com")
 *                 .build())
 *             .metadata(Map.of("key1", "value1"))
 *             .recordType("CAA")
 *             .relativeRecordSetName("record1")
 *             .resourceGroupName("rg1")
 *             .ttl(3600)
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create CNAME recordset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         CnameRecord = new AzureNative.Network.Inputs.CnameRecordArgs
 *         {
 *             Cname = "contoso.com",
 *         },
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         RecordType = "CNAME",
 *         RelativeRecordSetName = "record1",
 *         ResourceGroupName = "rg1",
 *         Ttl = 3600,
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			CnameRecord: &network.CnameRecordArgs{
 * 				Cname: pulumi.String("contoso.com"),
 * 			},
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			RecordType:            pulumi.String("CNAME"),
 * 			RelativeRecordSetName: pulumi.String("record1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 			ZoneName:              pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.CnameRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .cnameRecord(CnameRecordArgs.builder()
 *                 .cname("contoso.com")
 *                 .build())
 *             .metadata(Map.of("key1", "value1"))
 *             .recordType("CNAME")
 *             .relativeRecordSetName("record1")
 *             .resourceGroupName("rg1")
 *             .ttl(3600)
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create MX recordset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         MxRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.MxRecordArgs
 *             {
 *                 Exchange = "mail.contoso.com",
 *                 Preference = 0,
 *             },
 *         },
 *         RecordType = "MX",
 *         RelativeRecordSetName = "record1",
 *         ResourceGroupName = "rg1",
 *         Ttl = 3600,
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			MxRecords: network.MxRecordArray{
 * 				&network.MxRecordArgs{
 * 					Exchange:   pulumi.String("mail.contoso.com"),
 * 					Preference: pulumi.Int(0),
 * 				},
 * 			},
 * 			RecordType:            pulumi.String("MX"),
 * 			RelativeRecordSetName: pulumi.String("record1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 			ZoneName:              pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.MxRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .mxRecords(MxRecordArgs.builder()
 *                 .exchange("mail.contoso.com")
 *                 .preference(0)
 *                 .build())
 *             .recordType("MX")
 *             .relativeRecordSetName("record1")
 *             .resourceGroupName("rg1")
 *             .ttl(3600)
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create NS recordset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         NsRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.NsRecordArgs
 *             {
 *                 Nsdname = "ns1.contoso.com",
 *             },
 *         },
 *         RecordType = "NS",
 *         RelativeRecordSetName = "record1",
 *         ResourceGroupName = "rg1",
 *         Ttl = 3600,
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			NsRecords: network.NsRecordArray{
 * 				&network.NsRecordArgs{
 * 					Nsdname: pulumi.String("ns1.contoso.com"),
 * 				},
 * 			},
 * 			RecordType:            pulumi.String("NS"),
 * 			RelativeRecordSetName: pulumi.String("record1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 			ZoneName:              pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.NsRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .nsRecords(NsRecordArgs.builder()
 *                 .nsdname("ns1.contoso.com")
 *                 .build())
 *             .recordType("NS")
 *             .relativeRecordSetName("record1")
 *             .resourceGroupName("rg1")
 *             .ttl(3600)
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create PTR recordset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         PtrRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.PtrRecordArgs
 *             {
 *                 Ptrdname = "localhost",
 *             },
 *         },
 *         RecordType = "PTR",
 *         RelativeRecordSetName = "1",
 *         ResourceGroupName = "rg1",
 *         Ttl = 3600,
 *         ZoneName = "0.0.127.in-addr.arpa",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			PtrRecords: network.PtrRecordArray{
 * 				&network.PtrRecordArgs{
 * 					Ptrdname: pulumi.String("localhost"),
 * 				},
 * 			},
 * 			RecordType:            pulumi.String("PTR"),
 * 			RelativeRecordSetName: pulumi.String("1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 			ZoneName:              pulumi.String("0.0.127.in-addr.arpa"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.PtrRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .ptrRecords(PtrRecordArgs.builder()
 *                 .ptrdname("localhost")
 *                 .build())
 *             .recordType("PTR")
 *             .relativeRecordSetName("1")
 *             .resourceGroupName("rg1")
 *             .ttl(3600)
 *             .zoneName("0.0.127.in-addr.arpa")
 *             .build());
 *     }
 * }
 * ```
 * ### Create SOA recordset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         RecordType = "SOA",
 *         RelativeRecordSetName = "@",
 *         ResourceGroupName = "rg1",
 *         SoaRecord = new AzureNative.Network.Inputs.SoaRecordArgs
 *         {
 *             Email = "hostmaster.contoso.com",
 *             ExpireTime = 2419200,
 *             Host = "ns1.contoso.com",
 *             MinimumTtl = 300,
 *             RefreshTime = 3600,
 *             RetryTime = 300,
 *             SerialNumber = 1,
 *         },
 *         Ttl = 3600,
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			RecordType:            pulumi.String("SOA"),
 * 			RelativeRecordSetName: pulumi.String("@"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			SoaRecord: &network.SoaRecordArgs{
 * 				Email:        pulumi.String("hostmaster.contoso.com"),
 * 				ExpireTime:   pulumi.Float64(2419200),
 * 				Host:         pulumi.String("ns1.contoso.com"),
 * 				MinimumTtl:   pulumi.Float64(300),
 * 				RefreshTime:  pulumi.Float64(3600),
 * 				RetryTime:    pulumi.Float64(300),
 * 				SerialNumber: pulumi.Float64(1),
 * 			},
 * 			Ttl:      pulumi.Float64(3600),
 * 			ZoneName: pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.SoaRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .recordType("SOA")
 *             .relativeRecordSetName("@")
 *             .resourceGroupName("rg1")
 *             .soaRecord(SoaRecordArgs.builder()
 *                 .email("hostmaster.contoso.com")
 *                 .expireTime(2419200)
 *                 .host("ns1.contoso.com")
 *                 .minimumTtl(300)
 *                 .refreshTime(3600)
 *                 .retryTime(300)
 *                 .serialNumber(1)
 *                 .build())
 *             .ttl(3600)
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create SRV recordset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         RecordType = "SRV",
 *         RelativeRecordSetName = "record1",
 *         ResourceGroupName = "rg1",
 *         SrvRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.SrvRecordArgs
 *             {
 *                 Port = 80,
 *                 Priority = 0,
 *                 Target = "contoso.com",
 *                 Weight = 10,
 *             },
 *         },
 *         Ttl = 3600,
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			RecordType:            pulumi.String("SRV"),
 * 			RelativeRecordSetName: pulumi.String("record1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			SrvRecords: network.SrvRecordArray{
 * 				&network.SrvRecordArgs{
 * 					Port:     pulumi.Int(80),
 * 					Priority: pulumi.Int(0),
 * 					Target:   pulumi.String("contoso.com"),
 * 					Weight:   pulumi.Int(10),
 * 				},
 * 			},
 * 			Ttl:      pulumi.Float64(3600),
 * 			ZoneName: pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.SrvRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .recordType("SRV")
 *             .relativeRecordSetName("record1")
 *             .resourceGroupName("rg1")
 *             .srvRecords(SrvRecordArgs.builder()
 *                 .port(80)
 *                 .priority(0)
 *                 .target("contoso.com")
 *                 .weight(10)
 *                 .build())
 *             .ttl(3600)
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create TXT recordset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var recordSet = new AzureNative.Network.RecordSet("recordSet", new()
 *     {
 *         Metadata =
 *         {
 *             { "key1", "value1" },
 *         },
 *         RecordType = "TXT",
 *         RelativeRecordSetName = "record1",
 *         ResourceGroupName = "rg1",
 *         Ttl = 3600,
 *         TxtRecords = new[]
 *         {
 *             new AzureNative.Network.Inputs.TxtRecordArgs
 *             {
 *                 Value = new[]
 *                 {
 *                     "string1",
 *                     "string2",
 *                 },
 *             },
 *         },
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRecordSet(ctx, "recordSet", &network.RecordSetArgs{
 * 			Metadata: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			RecordType:            pulumi.String("TXT"),
 * 			RelativeRecordSetName: pulumi.String("record1"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			Ttl:                   pulumi.Float64(3600),
 * 			TxtRecords: network.TxtRecordArray{
 * 				&network.TxtRecordArgs{
 * 					Value: pulumi.StringArray{
 * 						pulumi.String("string1"),
 * 						pulumi.String("string2"),
 * 					},
 * 				},
 * 			},
 * 			ZoneName: pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RecordSet;
 * import com.pulumi.azurenative.network.RecordSetArgs;
 * import com.pulumi.azurenative.network.inputs.TxtRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var recordSet = new RecordSet("recordSet", RecordSetArgs.builder()
 *             .metadata(Map.of("key1", "value1"))
 *             .recordType("TXT")
 *             .relativeRecordSetName("record1")
 *             .resourceGroupName("rg1")
 *             .ttl(3600)
 *             .txtRecords(TxtRecordArgs.builder()
 *                 .value(
 *                     "string1",
 *                     "string2")
 *                 .build())
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:RecordSet record1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}
 * ```
 * @property aRecords The list of A records in the record set.
 * @property aaaaRecords The list of AAAA records in the record set.
 * @property caaRecords The list of CAA records in the record set.
 * @property cnameRecord The CNAME record in the  record set.
 * @property metadata The metadata attached to the record set.
 * @property mxRecords The list of MX records in the record set.
 * @property nsRecords The list of NS records in the record set.
 * @property ptrRecords The list of PTR records in the record set.
 * @property recordType The type of DNS record in this record set. Record sets of type SOA can be updated but not created (they are created when the DNS zone is created).
 * @property relativeRecordSetName The name of the record set, relative to the name of the zone.
 * @property resourceGroupName The name of the resource group.
 * @property soaRecord The SOA record in the record set.
 * @property srvRecords The list of SRV records in the record set.
 * @property targetResource A reference to an azure resource from where the dns resource value is taken.
 * @property ttl The TTL (time-to-live) of the records in the record set.
 * @property txtRecords The list of TXT records in the record set.
 * @property zoneName The name of the DNS zone (without a terminating dot).
 */
public data class RecordSetArgs(
    public val aRecords: Output<List<ARecordArgs>>? = null,
    public val aaaaRecords: Output<List<AaaaRecordArgs>>? = null,
    public val caaRecords: Output<List<CaaRecordArgs>>? = null,
    public val cnameRecord: Output<CnameRecordArgs>? = null,
    public val metadata: Output<Map<String, String>>? = null,
    public val mxRecords: Output<List<MxRecordArgs>>? = null,
    public val nsRecords: Output<List<NsRecordArgs>>? = null,
    public val ptrRecords: Output<List<PtrRecordArgs>>? = null,
    public val recordType: Output<String>? = null,
    public val relativeRecordSetName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val soaRecord: Output<SoaRecordArgs>? = null,
    public val srvRecords: Output<List<SrvRecordArgs>>? = null,
    public val targetResource: Output<SubResourceArgs>? = null,
    public val ttl: Output<Double>? = null,
    public val txtRecords: Output<List<TxtRecordArgs>>? = null,
    public val zoneName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.RecordSetArgs> {
    override fun toJava(): com.pulumi.azurenative.network.RecordSetArgs =
        com.pulumi.azurenative.network.RecordSetArgs.builder()
            .aRecords(
                aRecords?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .aaaaRecords(
                aaaaRecords?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .caaRecords(
                caaRecords?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .cnameRecord(cnameRecord?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .mxRecords(
                mxRecords?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .nsRecords(
                nsRecords?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ptrRecords(
                ptrRecords?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .recordType(recordType?.applyValue({ args0 -> args0 }))
            .relativeRecordSetName(relativeRecordSetName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .soaRecord(soaRecord?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .srvRecords(
                srvRecords?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .targetResource(targetResource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ttl(ttl?.applyValue({ args0 -> args0 }))
            .txtRecords(
                txtRecords?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .zoneName(zoneName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecordSetArgs].
 */
@PulumiTagMarker
public class RecordSetArgsBuilder internal constructor() {
    private var aRecords: Output<List<ARecordArgs>>? = null

    private var aaaaRecords: Output<List<AaaaRecordArgs>>? = null

    private var caaRecords: Output<List<CaaRecordArgs>>? = null

    private var cnameRecord: Output<CnameRecordArgs>? = null

    private var metadata: Output<Map<String, String>>? = null

    private var mxRecords: Output<List<MxRecordArgs>>? = null

    private var nsRecords: Output<List<NsRecordArgs>>? = null

    private var ptrRecords: Output<List<PtrRecordArgs>>? = null

    private var recordType: Output<String>? = null

    private var relativeRecordSetName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var soaRecord: Output<SoaRecordArgs>? = null

    private var srvRecords: Output<List<SrvRecordArgs>>? = null

    private var targetResource: Output<SubResourceArgs>? = null

    private var ttl: Output<Double>? = null

    private var txtRecords: Output<List<TxtRecordArgs>>? = null

    private var zoneName: Output<String>? = null

    /**
     * @param value The list of A records in the record set.
     */
    @JvmName("grjqxwdkdnabjmmr")
    public suspend fun aRecords(`value`: Output<List<ARecordArgs>>) {
        this.aRecords = value
    }

    @JvmName("eouwftaykaerlomj")
    public suspend fun aRecords(vararg values: Output<ARecordArgs>) {
        this.aRecords = Output.all(values.asList())
    }

    /**
     * @param values The list of A records in the record set.
     */
    @JvmName("klmeysptkbcojbrs")
    public suspend fun aRecords(values: List<Output<ARecordArgs>>) {
        this.aRecords = Output.all(values)
    }

    /**
     * @param value The list of AAAA records in the record set.
     */
    @JvmName("vbpfmeffepexqjob")
    public suspend fun aaaaRecords(`value`: Output<List<AaaaRecordArgs>>) {
        this.aaaaRecords = value
    }

    @JvmName("vevkslejuralelte")
    public suspend fun aaaaRecords(vararg values: Output<AaaaRecordArgs>) {
        this.aaaaRecords = Output.all(values.asList())
    }

    /**
     * @param values The list of AAAA records in the record set.
     */
    @JvmName("buhjnraejbgniwyv")
    public suspend fun aaaaRecords(values: List<Output<AaaaRecordArgs>>) {
        this.aaaaRecords = Output.all(values)
    }

    /**
     * @param value The list of CAA records in the record set.
     */
    @JvmName("agfxnboaobptswmr")
    public suspend fun caaRecords(`value`: Output<List<CaaRecordArgs>>) {
        this.caaRecords = value
    }

    @JvmName("frfnhourrltercty")
    public suspend fun caaRecords(vararg values: Output<CaaRecordArgs>) {
        this.caaRecords = Output.all(values.asList())
    }

    /**
     * @param values The list of CAA records in the record set.
     */
    @JvmName("kkurymkgrbefxcjh")
    public suspend fun caaRecords(values: List<Output<CaaRecordArgs>>) {
        this.caaRecords = Output.all(values)
    }

    /**
     * @param value The CNAME record in the  record set.
     */
    @JvmName("mnsfyjkxkkoevypo")
    public suspend fun cnameRecord(`value`: Output<CnameRecordArgs>) {
        this.cnameRecord = value
    }

    /**
     * @param value The metadata attached to the record set.
     */
    @JvmName("kndqvmjcyqyvtgid")
    public suspend fun metadata(`value`: Output<Map<String, String>>) {
        this.metadata = value
    }

    /**
     * @param value The list of MX records in the record set.
     */
    @JvmName("swpseoriswcayaet")
    public suspend fun mxRecords(`value`: Output<List<MxRecordArgs>>) {
        this.mxRecords = value
    }

    @JvmName("ospkwskilyrtchgu")
    public suspend fun mxRecords(vararg values: Output<MxRecordArgs>) {
        this.mxRecords = Output.all(values.asList())
    }

    /**
     * @param values The list of MX records in the record set.
     */
    @JvmName("gdjmltuxfpcvrswq")
    public suspend fun mxRecords(values: List<Output<MxRecordArgs>>) {
        this.mxRecords = Output.all(values)
    }

    /**
     * @param value The list of NS records in the record set.
     */
    @JvmName("xsqyvhxmubphiyml")
    public suspend fun nsRecords(`value`: Output<List<NsRecordArgs>>) {
        this.nsRecords = value
    }

    @JvmName("glvxdhuplefraidw")
    public suspend fun nsRecords(vararg values: Output<NsRecordArgs>) {
        this.nsRecords = Output.all(values.asList())
    }

    /**
     * @param values The list of NS records in the record set.
     */
    @JvmName("qirioqahbbxwncvx")
    public suspend fun nsRecords(values: List<Output<NsRecordArgs>>) {
        this.nsRecords = Output.all(values)
    }

    /**
     * @param value The list of PTR records in the record set.
     */
    @JvmName("jjtvakxomnjsbfsk")
    public suspend fun ptrRecords(`value`: Output<List<PtrRecordArgs>>) {
        this.ptrRecords = value
    }

    @JvmName("fjftvdrkfqbdmkya")
    public suspend fun ptrRecords(vararg values: Output<PtrRecordArgs>) {
        this.ptrRecords = Output.all(values.asList())
    }

    /**
     * @param values The list of PTR records in the record set.
     */
    @JvmName("yoctwqixhxrsaact")
    public suspend fun ptrRecords(values: List<Output<PtrRecordArgs>>) {
        this.ptrRecords = Output.all(values)
    }

    /**
     * @param value The type of DNS record in this record set. Record sets of type SOA can be updated but not created (they are created when the DNS zone is created).
     */
    @JvmName("ldhqxpxuadqqkffi")
    public suspend fun recordType(`value`: Output<String>) {
        this.recordType = value
    }

    /**
     * @param value The name of the record set, relative to the name of the zone.
     */
    @JvmName("rfanfejgheiuqmcg")
    public suspend fun relativeRecordSetName(`value`: Output<String>) {
        this.relativeRecordSetName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("fiyjqyeofkktdnof")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The SOA record in the record set.
     */
    @JvmName("uehhmmkfreasffeg")
    public suspend fun soaRecord(`value`: Output<SoaRecordArgs>) {
        this.soaRecord = value
    }

    /**
     * @param value The list of SRV records in the record set.
     */
    @JvmName("emennxqbmcqjpxmt")
    public suspend fun srvRecords(`value`: Output<List<SrvRecordArgs>>) {
        this.srvRecords = value
    }

    @JvmName("boheboklxnhfwola")
    public suspend fun srvRecords(vararg values: Output<SrvRecordArgs>) {
        this.srvRecords = Output.all(values.asList())
    }

    /**
     * @param values The list of SRV records in the record set.
     */
    @JvmName("ypykailfnuwdfnkq")
    public suspend fun srvRecords(values: List<Output<SrvRecordArgs>>) {
        this.srvRecords = Output.all(values)
    }

    /**
     * @param value A reference to an azure resource from where the dns resource value is taken.
     */
    @JvmName("wlofnemsesalsctm")
    public suspend fun targetResource(`value`: Output<SubResourceArgs>) {
        this.targetResource = value
    }

    /**
     * @param value The TTL (time-to-live) of the records in the record set.
     */
    @JvmName("tantlyvmwqiiqbmc")
    public suspend fun ttl(`value`: Output<Double>) {
        this.ttl = value
    }

    /**
     * @param value The list of TXT records in the record set.
     */
    @JvmName("tibkuisouhffdnxp")
    public suspend fun txtRecords(`value`: Output<List<TxtRecordArgs>>) {
        this.txtRecords = value
    }

    @JvmName("hasxvkoyibjykrag")
    public suspend fun txtRecords(vararg values: Output<TxtRecordArgs>) {
        this.txtRecords = Output.all(values.asList())
    }

    /**
     * @param values The list of TXT records in the record set.
     */
    @JvmName("vylmrprtekohqdjo")
    public suspend fun txtRecords(values: List<Output<TxtRecordArgs>>) {
        this.txtRecords = Output.all(values)
    }

    /**
     * @param value The name of the DNS zone (without a terminating dot).
     */
    @JvmName("qjfcnjcqsjsjmcfl")
    public suspend fun zoneName(`value`: Output<String>) {
        this.zoneName = value
    }

    /**
     * @param value The list of A records in the record set.
     */
    @JvmName("crdfcqqxfxeipujo")
    public suspend fun aRecords(`value`: List<ARecordArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aRecords = mapped
    }

    /**
     * @param argument The list of A records in the record set.
     */
    @JvmName("wydotwgofjtnuhkg")
    public suspend fun aRecords(argument: List<suspend ARecordArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ARecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.aRecords = mapped
    }

    /**
     * @param argument The list of A records in the record set.
     */
    @JvmName("daaxsfpvttjphqko")
    public suspend fun aRecords(vararg argument: suspend ARecordArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ARecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.aRecords = mapped
    }

    /**
     * @param argument The list of A records in the record set.
     */
    @JvmName("kvsacynhawqkghck")
    public suspend fun aRecords(argument: suspend ARecordArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ARecordArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.aRecords = mapped
    }

    /**
     * @param values The list of A records in the record set.
     */
    @JvmName("lfsbklelsknbbknc")
    public suspend fun aRecords(vararg values: ARecordArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aRecords = mapped
    }

    /**
     * @param value The list of AAAA records in the record set.
     */
    @JvmName("wnpumbuyfpcjfwno")
    public suspend fun aaaaRecords(`value`: List<AaaaRecordArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aaaaRecords = mapped
    }

    /**
     * @param argument The list of AAAA records in the record set.
     */
    @JvmName("cwqmydfbfhdovtfb")
    public suspend fun aaaaRecords(argument: List<suspend AaaaRecordArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { AaaaRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.aaaaRecords = mapped
    }

    /**
     * @param argument The list of AAAA records in the record set.
     */
    @JvmName("radasejgwfabgjdp")
    public suspend fun aaaaRecords(vararg argument: suspend AaaaRecordArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { AaaaRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.aaaaRecords = mapped
    }

    /**
     * @param argument The list of AAAA records in the record set.
     */
    @JvmName("yokwadixmilccwpu")
    public suspend fun aaaaRecords(argument: suspend AaaaRecordArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AaaaRecordArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.aaaaRecords = mapped
    }

    /**
     * @param values The list of AAAA records in the record set.
     */
    @JvmName("xtxwynyoweysfrlm")
    public suspend fun aaaaRecords(vararg values: AaaaRecordArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aaaaRecords = mapped
    }

    /**
     * @param value The list of CAA records in the record set.
     */
    @JvmName("wllydbjdpxnpycyk")
    public suspend fun caaRecords(`value`: List<CaaRecordArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caaRecords = mapped
    }

    /**
     * @param argument The list of CAA records in the record set.
     */
    @JvmName("wmlqedqppldonuhc")
    public suspend fun caaRecords(argument: List<suspend CaaRecordArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { CaaRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.caaRecords = mapped
    }

    /**
     * @param argument The list of CAA records in the record set.
     */
    @JvmName("lwlckvhwkidjkpfb")
    public suspend fun caaRecords(vararg argument: suspend CaaRecordArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { CaaRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.caaRecords = mapped
    }

    /**
     * @param argument The list of CAA records in the record set.
     */
    @JvmName("hqxcrwjwysvjwbfs")
    public suspend fun caaRecords(argument: suspend CaaRecordArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CaaRecordArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.caaRecords = mapped
    }

    /**
     * @param values The list of CAA records in the record set.
     */
    @JvmName("dyjvqgmtqikrxbet")
    public suspend fun caaRecords(vararg values: CaaRecordArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.caaRecords = mapped
    }

    /**
     * @param value The CNAME record in the  record set.
     */
    @JvmName("inpscfrsbkrtlujr")
    public suspend fun cnameRecord(`value`: CnameRecordArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cnameRecord = mapped
    }

    /**
     * @param argument The CNAME record in the  record set.
     */
    @JvmName("ibccncgckwtwtgam")
    public suspend fun cnameRecord(argument: suspend CnameRecordArgsBuilder.() -> Unit) {
        val toBeMapped = CnameRecordArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cnameRecord = mapped
    }

    /**
     * @param value The metadata attached to the record set.
     */
    @JvmName("fbyhweokpynbabfd")
    public suspend fun metadata(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param values The metadata attached to the record set.
     */
    @JvmName("fhiarmqymfewdaxt")
    public fun metadata(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The list of MX records in the record set.
     */
    @JvmName("htuukcrmyanmqfoy")
    public suspend fun mxRecords(`value`: List<MxRecordArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mxRecords = mapped
    }

    /**
     * @param argument The list of MX records in the record set.
     */
    @JvmName("ghqxakfmlomewugi")
    public suspend fun mxRecords(argument: List<suspend MxRecordArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { MxRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.mxRecords = mapped
    }

    /**
     * @param argument The list of MX records in the record set.
     */
    @JvmName("blvxinrslymtlgin")
    public suspend fun mxRecords(vararg argument: suspend MxRecordArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { MxRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.mxRecords = mapped
    }

    /**
     * @param argument The list of MX records in the record set.
     */
    @JvmName("pyfbhymictavmnra")
    public suspend fun mxRecords(argument: suspend MxRecordArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MxRecordArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.mxRecords = mapped
    }

    /**
     * @param values The list of MX records in the record set.
     */
    @JvmName("nlceguhaushsnoqu")
    public suspend fun mxRecords(vararg values: MxRecordArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mxRecords = mapped
    }

    /**
     * @param value The list of NS records in the record set.
     */
    @JvmName("xoaerscmeqnicctg")
    public suspend fun nsRecords(`value`: List<NsRecordArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nsRecords = mapped
    }

    /**
     * @param argument The list of NS records in the record set.
     */
    @JvmName("qbwcjydeddyvcgfe")
    public suspend fun nsRecords(argument: List<suspend NsRecordArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { NsRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.nsRecords = mapped
    }

    /**
     * @param argument The list of NS records in the record set.
     */
    @JvmName("ukafwvbfxiiovxoh")
    public suspend fun nsRecords(vararg argument: suspend NsRecordArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { NsRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.nsRecords = mapped
    }

    /**
     * @param argument The list of NS records in the record set.
     */
    @JvmName("oxhxheamesbexgnx")
    public suspend fun nsRecords(argument: suspend NsRecordArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NsRecordArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.nsRecords = mapped
    }

    /**
     * @param values The list of NS records in the record set.
     */
    @JvmName("uqyogcxstlkvdmcj")
    public suspend fun nsRecords(vararg values: NsRecordArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nsRecords = mapped
    }

    /**
     * @param value The list of PTR records in the record set.
     */
    @JvmName("pegmdnrowkiomilf")
    public suspend fun ptrRecords(`value`: List<PtrRecordArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ptrRecords = mapped
    }

    /**
     * @param argument The list of PTR records in the record set.
     */
    @JvmName("nroyjflmvyppqrid")
    public suspend fun ptrRecords(argument: List<suspend PtrRecordArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { PtrRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ptrRecords = mapped
    }

    /**
     * @param argument The list of PTR records in the record set.
     */
    @JvmName("hdfrbcjaoubyuxtx")
    public suspend fun ptrRecords(vararg argument: suspend PtrRecordArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { PtrRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ptrRecords = mapped
    }

    /**
     * @param argument The list of PTR records in the record set.
     */
    @JvmName("vwxuramffogxtnua")
    public suspend fun ptrRecords(argument: suspend PtrRecordArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PtrRecordArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ptrRecords = mapped
    }

    /**
     * @param values The list of PTR records in the record set.
     */
    @JvmName("cqoqyafbwqlxilrv")
    public suspend fun ptrRecords(vararg values: PtrRecordArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ptrRecords = mapped
    }

    /**
     * @param value The type of DNS record in this record set. Record sets of type SOA can be updated but not created (they are created when the DNS zone is created).
     */
    @JvmName("aqufcpktlbeksmkh")
    public suspend fun recordType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordType = mapped
    }

    /**
     * @param value The name of the record set, relative to the name of the zone.
     */
    @JvmName("untnrmifpudyvdhl")
    public suspend fun relativeRecordSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relativeRecordSetName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("gxlkcfpbifaanloq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The SOA record in the record set.
     */
    @JvmName("itwnejmltjmrwyll")
    public suspend fun soaRecord(`value`: SoaRecordArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.soaRecord = mapped
    }

    /**
     * @param argument The SOA record in the record set.
     */
    @JvmName("dyhasbxvxkywwppw")
    public suspend fun soaRecord(argument: suspend SoaRecordArgsBuilder.() -> Unit) {
        val toBeMapped = SoaRecordArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.soaRecord = mapped
    }

    /**
     * @param value The list of SRV records in the record set.
     */
    @JvmName("elinxwyxpxwhoumg")
    public suspend fun srvRecords(`value`: List<SrvRecordArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.srvRecords = mapped
    }

    /**
     * @param argument The list of SRV records in the record set.
     */
    @JvmName("wuktqwdralhhpnaf")
    public suspend fun srvRecords(argument: List<suspend SrvRecordArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SrvRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.srvRecords = mapped
    }

    /**
     * @param argument The list of SRV records in the record set.
     */
    @JvmName("csujrqxiltsyhdcq")
    public suspend fun srvRecords(vararg argument: suspend SrvRecordArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SrvRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.srvRecords = mapped
    }

    /**
     * @param argument The list of SRV records in the record set.
     */
    @JvmName("tqsqlfgogonpnuoj")
    public suspend fun srvRecords(argument: suspend SrvRecordArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SrvRecordArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.srvRecords = mapped
    }

    /**
     * @param values The list of SRV records in the record set.
     */
    @JvmName("txhbokuncxduwgye")
    public suspend fun srvRecords(vararg values: SrvRecordArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.srvRecords = mapped
    }

    /**
     * @param value A reference to an azure resource from where the dns resource value is taken.
     */
    @JvmName("wkkccxiigrgvhtik")
    public suspend fun targetResource(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResource = mapped
    }

    /**
     * @param argument A reference to an azure resource from where the dns resource value is taken.
     */
    @JvmName("xjehtagoqbnopeek")
    public suspend fun targetResource(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetResource = mapped
    }

    /**
     * @param value The TTL (time-to-live) of the records in the record set.
     */
    @JvmName("ltcyfmeswhgpsbwd")
    public suspend fun ttl(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttl = mapped
    }

    /**
     * @param value The list of TXT records in the record set.
     */
    @JvmName("uwvkoimryemqlskk")
    public suspend fun txtRecords(`value`: List<TxtRecordArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.txtRecords = mapped
    }

    /**
     * @param argument The list of TXT records in the record set.
     */
    @JvmName("xjfqhbuyklmohioh")
    public suspend fun txtRecords(argument: List<suspend TxtRecordArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { TxtRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.txtRecords = mapped
    }

    /**
     * @param argument The list of TXT records in the record set.
     */
    @JvmName("jouwhxlonfrbtipt")
    public suspend fun txtRecords(vararg argument: suspend TxtRecordArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { TxtRecordArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.txtRecords = mapped
    }

    /**
     * @param argument The list of TXT records in the record set.
     */
    @JvmName("qeixrgaahntgcgvt")
    public suspend fun txtRecords(argument: suspend TxtRecordArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TxtRecordArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.txtRecords = mapped
    }

    /**
     * @param values The list of TXT records in the record set.
     */
    @JvmName("jymxbhdlcrtdhnoy")
    public suspend fun txtRecords(vararg values: TxtRecordArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.txtRecords = mapped
    }

    /**
     * @param value The name of the DNS zone (without a terminating dot).
     */
    @JvmName("chodjinledrsuosu")
    public suspend fun zoneName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneName = mapped
    }

    internal fun build(): RecordSetArgs = RecordSetArgs(
        aRecords = aRecords,
        aaaaRecords = aaaaRecords,
        caaRecords = caaRecords,
        cnameRecord = cnameRecord,
        metadata = metadata,
        mxRecords = mxRecords,
        nsRecords = nsRecords,
        ptrRecords = ptrRecords,
        recordType = recordType,
        relativeRecordSetName = relativeRecordSetName,
        resourceGroupName = resourceGroupName,
        soaRecord = soaRecord,
        srvRecords = srvRecords,
        targetResource = targetResource,
        ttl = ttl,
        txtRecords = txtRecords,
        zoneName = zoneName,
    )
}
