@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.RouteArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.RouteNextHopType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Route resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-06-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create route
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var route = new AzureNative.Network.Route("route", new()
 *     {
 *         AddressPrefix = "10.0.3.0/24",
 *         NextHopType = AzureNative.Network.RouteNextHopType.VirtualNetworkGateway,
 *         ResourceGroupName = "rg1",
 *         RouteName = "route1",
 *         RouteTableName = "testrt",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRoute(ctx, "route", &network.RouteArgs{
 * 			AddressPrefix:     pulumi.String("10.0.3.0/24"),
 * 			NextHopType:       pulumi.String(network.RouteNextHopTypeVirtualNetworkGateway),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			RouteName:         pulumi.String("route1"),
 * 			RouteTableName:    pulumi.String("testrt"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Route;
 * import com.pulumi.azurenative.network.RouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var route = new Route("route", RouteArgs.builder()
 *             .addressPrefix("10.0.3.0/24")
 *             .nextHopType("VirtualNetworkGateway")
 *             .resourceGroupName("rg1")
 *             .routeName("route1")
 *             .routeTableName("testrt")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:Route route1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeTables/{routeTableName}/routes/{routeName}
 * ```
 * @property addressPrefix The destination CIDR to which the route applies.
 * @property hasBgpOverride A value indicating whether this route overrides overlapping BGP routes regardless of LPM.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property nextHopIpAddress The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
 * @property nextHopType The type of Azure hop the packet should be sent to.
 * @property resourceGroupName The name of the resource group.
 * @property routeName The name of the route.
 * @property routeTableName The name of the route table.
 * @property type The type of the resource.
 */
public data class RouteArgs(
    public val addressPrefix: Output<String>? = null,
    public val hasBgpOverride: Output<Boolean>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val nextHopIpAddress: Output<String>? = null,
    public val nextHopType: Output<Either<String, RouteNextHopType>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routeName: Output<String>? = null,
    public val routeTableName: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.RouteArgs> {
    override fun toJava(): com.pulumi.azurenative.network.RouteArgs =
        com.pulumi.azurenative.network.RouteArgs.builder()
            .addressPrefix(addressPrefix?.applyValue({ args0 -> args0 }))
            .hasBgpOverride(hasBgpOverride?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .nextHopIpAddress(nextHopIpAddress?.applyValue({ args0 -> args0 }))
            .nextHopType(
                nextHopType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routeName(routeName?.applyValue({ args0 -> args0 }))
            .routeTableName(routeTableName?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteArgs].
 */
@PulumiTagMarker
public class RouteArgsBuilder internal constructor() {
    private var addressPrefix: Output<String>? = null

    private var hasBgpOverride: Output<Boolean>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var nextHopIpAddress: Output<String>? = null

    private var nextHopType: Output<Either<String, RouteNextHopType>>? = null

    private var resourceGroupName: Output<String>? = null

    private var routeName: Output<String>? = null

    private var routeTableName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The destination CIDR to which the route applies.
     */
    @JvmName("fedpvhqoaqxecwxx")
    public suspend fun addressPrefix(`value`: Output<String>) {
        this.addressPrefix = value
    }

    /**
     * @param value A value indicating whether this route overrides overlapping BGP routes regardless of LPM.
     */
    @JvmName("crfsmrjgayuatbes")
    public suspend fun hasBgpOverride(`value`: Output<Boolean>) {
        this.hasBgpOverride = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("pxsjhgcrnihuljdf")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("kurlecvwsrlexmcc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
     */
    @JvmName("gvhdqqjmtsomojfd")
    public suspend fun nextHopIpAddress(`value`: Output<String>) {
        this.nextHopIpAddress = value
    }

    /**
     * @param value The type of Azure hop the packet should be sent to.
     */
    @JvmName("aynhomxtreldbcug")
    public suspend fun nextHopType(`value`: Output<Either<String, RouteNextHopType>>) {
        this.nextHopType = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ufwuejenkdgxixmi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the route.
     */
    @JvmName("eubenivyyrlpcwsm")
    public suspend fun routeName(`value`: Output<String>) {
        this.routeName = value
    }

    /**
     * @param value The name of the route table.
     */
    @JvmName("kmximlafdqlwnehv")
    public suspend fun routeTableName(`value`: Output<String>) {
        this.routeTableName = value
    }

    /**
     * @param value The type of the resource.
     */
    @JvmName("tkiomegixccnyenb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The destination CIDR to which the route applies.
     */
    @JvmName("pmgwgpecywpjtgde")
    public suspend fun addressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefix = mapped
    }

    /**
     * @param value A value indicating whether this route overrides overlapping BGP routes regardless of LPM.
     */
    @JvmName("aesrmpswwulklwpb")
    public suspend fun hasBgpOverride(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hasBgpOverride = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("axljlqvrhutkaihh")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("cvsdgqviwxvbrdhx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
     */
    @JvmName("vwngndeygenqvvdw")
    public suspend fun nextHopIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextHopIpAddress = mapped
    }

    /**
     * @param value The type of Azure hop the packet should be sent to.
     */
    @JvmName("xjmbxihrfyeladkc")
    public suspend fun nextHopType(`value`: Either<String, RouteNextHopType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextHopType = mapped
    }

    /**
     * @param value The type of Azure hop the packet should be sent to.
     */
    @JvmName("ilwnicqlaaixxbrr")
    public fun nextHopType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RouteNextHopType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nextHopType = mapped
    }

    /**
     * @param value The type of Azure hop the packet should be sent to.
     */
    @JvmName("oessesspxavtblmm")
    public fun nextHopType(`value`: RouteNextHopType) {
        val toBeMapped = Either.ofRight<String, RouteNextHopType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nextHopType = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("owytkpckjihlejoc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the route.
     */
    @JvmName("vddxinywbsthmyww")
    public suspend fun routeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeName = mapped
    }

    /**
     * @param value The name of the route table.
     */
    @JvmName("ymylkksjlxaoryoe")
    public suspend fun routeTableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTableName = mapped
    }

    /**
     * @param value The type of the resource.
     */
    @JvmName("txalfahwqnlawmfb")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RouteArgs = RouteArgs(
        addressPrefix = addressPrefix,
        hasBgpOverride = hasBgpOverride,
        id = id,
        name = name,
        nextHopIpAddress = nextHopIpAddress,
        nextHopType = nextHopType,
        resourceGroupName = resourceGroupName,
        routeName = routeName,
        routeTableName = routeTableName,
        type = type,
    )
}
