@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.RouteMapArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.RouteMapRuleArgs
import com.pulumi.azurenative.network.kotlin.inputs.RouteMapRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The RouteMap child resource of a Virtual hub.
 * Azure REST API version: 2023-02-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### RouteMapPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var routeMap = new AzureNative.Network.RouteMap("routeMap", new()
 *     {
 *         AssociatedInboundConnections = new[]
 *         {
 *             "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteGateways/exrGateway1/expressRouteConnections/exrConn1",
 *         },
 *         AssociatedOutboundConnections = new[] {},
 *         ResourceGroupName = "rg1",
 *         RouteMapName = "routeMap1",
 *         Rules = new[]
 *         {
 *             new AzureNative.Network.Inputs.RouteMapRuleArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.ActionArgs
 *                     {
 *                         Parameters = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.ParameterArgs
 *                             {
 *                                 AsPath = new[]
 *                                 {
 *                                     "22334",
 *                                 },
 *                                 Community = new() { },
 *                                 RoutePrefix = new() { },
 *                             },
 *                         },
 *                         Type = AzureNative.Network.RouteMapActionType.Add,
 *                     },
 *                 },
 *                 MatchCriteria = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.CriterionArgs
 *                     {
 *                         AsPath = new() { },
 *                         Community = new() { },
 *                         MatchCondition = AzureNative.Network.RouteMapMatchCondition.Contains,
 *                         RoutePrefix = new[]
 *                         {
 *                             "10.0.0.0/8",
 *                         },
 *                     },
 *                 },
 *                 Name = "rule1",
 *                 NextStepIfMatched = AzureNative.Network.NextStep.Continue,
 *             },
 *         },
 *         VirtualHubName = "virtualHub1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRouteMap(ctx, "routeMap", &network.RouteMapArgs{
 * 			AssociatedInboundConnections: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteGateways/exrGateway1/expressRouteConnections/exrConn1"),
 * 			},
 * 			AssociatedOutboundConnections: pulumi.StringArray{},
 * 			ResourceGroupName:             pulumi.String("rg1"),
 * 			RouteMapName:                  pulumi.String("routeMap1"),
 * 			Rules: network.RouteMapRuleArray{
 * 				&network.RouteMapRuleArgs{
 * 					Actions: network.ActionArray{
 * 						&network.ActionArgs{
 * 							Parameters: network.ParameterArray{
 * 								&network.ParameterArgs{
 * 									AsPath: pulumi.StringArray{
 * 										pulumi.String("22334"),
 * 									},
 * 									Community:   pulumi.StringArray{},
 * 									RoutePrefix: pulumi.StringArray{},
 * 								},
 * 							},
 * 							Type: pulumi.String(network.RouteMapActionTypeAdd),
 * 						},
 * 					},
 * 					MatchCriteria: network.CriterionArray{
 * 						&network.CriterionArgs{
 * 							AsPath:         pulumi.StringArray{},
 * 							Community:      pulumi.StringArray{},
 * 							MatchCondition: pulumi.String(network.RouteMapMatchConditionContains),
 * 							RoutePrefix: pulumi.StringArray{
 * 								pulumi.String("10.0.0.0/8"),
 * 							},
 * 						},
 * 					},
 * 					Name:              pulumi.String("rule1"),
 * 					NextStepIfMatched: pulumi.String(network.NextStepContinue),
 * 				},
 * 			},
 * 			VirtualHubName: pulumi.String("virtualHub1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RouteMap;
 * import com.pulumi.azurenative.network.RouteMapArgs;
 * import com.pulumi.azurenative.network.inputs.RouteMapRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var routeMap = new RouteMap("routeMap", RouteMapArgs.builder()
 *             .associatedInboundConnections("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteGateways/exrGateway1/expressRouteConnections/exrConn1")
 *             .associatedOutboundConnections()
 *             .resourceGroupName("rg1")
 *             .routeMapName("routeMap1")
 *             .rules(RouteMapRuleArgs.builder()
 *                 .actions(ActionArgs.builder()
 *                     .parameters(ParameterArgs.builder()
 *                         .asPath("22334")
 *                         .community()
 *                         .routePrefix()
 *                         .build())
 *                     .type("Add")
 *                     .build())
 *                 .matchCriteria(CriterionArgs.builder()
 *                     .asPath()
 *                     .community()
 *                     .matchCondition("Contains")
 *                     .routePrefix("10.0.0.0/8")
 *                     .build())
 *                 .name("rule1")
 *                 .nextStepIfMatched("Continue")
 *                 .build())
 *             .virtualHubName("virtualHub1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:RouteMap routeMap1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routeMaps/{routeMapName}
 * ```
 * @property associatedInboundConnections List of connections which have this RoutMap associated for inbound traffic.
 * @property associatedOutboundConnections List of connections which have this RoutMap associated for outbound traffic.
 * @property id Resource ID.
 * @property resourceGroupName The resource group name of the RouteMap's resource group.
 * @property routeMapName The name of the RouteMap.
 * @property rules List of RouteMap rules to be applied.
 * @property virtualHubName The name of the VirtualHub containing the RouteMap.
 */
public data class RouteMapArgs(
    public val associatedInboundConnections: Output<List<String>>? = null,
    public val associatedOutboundConnections: Output<List<String>>? = null,
    public val id: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routeMapName: Output<String>? = null,
    public val rules: Output<List<RouteMapRuleArgs>>? = null,
    public val virtualHubName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.RouteMapArgs> {
    override fun toJava(): com.pulumi.azurenative.network.RouteMapArgs =
        com.pulumi.azurenative.network.RouteMapArgs.builder()
            .associatedInboundConnections(
                associatedInboundConnections?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .associatedOutboundConnections(
                associatedOutboundConnections?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routeMapName(routeMapName?.applyValue({ args0 -> args0 }))
            .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .virtualHubName(virtualHubName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteMapArgs].
 */
@PulumiTagMarker
public class RouteMapArgsBuilder internal constructor() {
    private var associatedInboundConnections: Output<List<String>>? = null

    private var associatedOutboundConnections: Output<List<String>>? = null

    private var id: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var routeMapName: Output<String>? = null

    private var rules: Output<List<RouteMapRuleArgs>>? = null

    private var virtualHubName: Output<String>? = null

    /**
     * @param value List of connections which have this RoutMap associated for inbound traffic.
     */
    @JvmName("jglmvctfbirvgvbq")
    public suspend fun associatedInboundConnections(`value`: Output<List<String>>) {
        this.associatedInboundConnections = value
    }

    @JvmName("qrsfbiifnyerhksh")
    public suspend fun associatedInboundConnections(vararg values: Output<String>) {
        this.associatedInboundConnections = Output.all(values.asList())
    }

    /**
     * @param values List of connections which have this RoutMap associated for inbound traffic.
     */
    @JvmName("gfxdsdwkxnqgqwlb")
    public suspend fun associatedInboundConnections(values: List<Output<String>>) {
        this.associatedInboundConnections = Output.all(values)
    }

    /**
     * @param value List of connections which have this RoutMap associated for outbound traffic.
     */
    @JvmName("uhmbwqxirmktlaco")
    public suspend fun associatedOutboundConnections(`value`: Output<List<String>>) {
        this.associatedOutboundConnections = value
    }

    @JvmName("kghafsjhwsrifdkq")
    public suspend fun associatedOutboundConnections(vararg values: Output<String>) {
        this.associatedOutboundConnections = Output.all(values.asList())
    }

    /**
     * @param values List of connections which have this RoutMap associated for outbound traffic.
     */
    @JvmName("cimyyjeepblyudwd")
    public suspend fun associatedOutboundConnections(values: List<Output<String>>) {
        this.associatedOutboundConnections = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("qyeaymwcamskfayq")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The resource group name of the RouteMap's resource group.
     */
    @JvmName("rfgeajqhqlliumml")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the RouteMap.
     */
    @JvmName("ohwhhrbldgfhtmot")
    public suspend fun routeMapName(`value`: Output<String>) {
        this.routeMapName = value
    }

    /**
     * @param value List of RouteMap rules to be applied.
     */
    @JvmName("rfgrvnsnbnwtmpdk")
    public suspend fun rules(`value`: Output<List<RouteMapRuleArgs>>) {
        this.rules = value
    }

    @JvmName("wrtourqjkcjwwcji")
    public suspend fun rules(vararg values: Output<RouteMapRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values List of RouteMap rules to be applied.
     */
    @JvmName("rydufgtpqcdmcdio")
    public suspend fun rules(values: List<Output<RouteMapRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value The name of the VirtualHub containing the RouteMap.
     */
    @JvmName("dfhtbmeqdhcgofdm")
    public suspend fun virtualHubName(`value`: Output<String>) {
        this.virtualHubName = value
    }

    /**
     * @param value List of connections which have this RoutMap associated for inbound traffic.
     */
    @JvmName("mtqbivfswgyumebc")
    public suspend fun associatedInboundConnections(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associatedInboundConnections = mapped
    }

    /**
     * @param values List of connections which have this RoutMap associated for inbound traffic.
     */
    @JvmName("hxdjinswlogywhbq")
    public suspend fun associatedInboundConnections(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.associatedInboundConnections = mapped
    }

    /**
     * @param value List of connections which have this RoutMap associated for outbound traffic.
     */
    @JvmName("rgpiuceoekhaeurp")
    public suspend fun associatedOutboundConnections(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associatedOutboundConnections = mapped
    }

    /**
     * @param values List of connections which have this RoutMap associated for outbound traffic.
     */
    @JvmName("vtlagcgmohbclayl")
    public suspend fun associatedOutboundConnections(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.associatedOutboundConnections = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("fmlunhmsdifrhvwd")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The resource group name of the RouteMap's resource group.
     */
    @JvmName("kigilnrmjchalkog")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the RouteMap.
     */
    @JvmName("ukudymyrhqdbaccj")
    public suspend fun routeMapName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeMapName = mapped
    }

    /**
     * @param value List of RouteMap rules to be applied.
     */
    @JvmName("dikymmphrwcmkoja")
    public suspend fun rules(`value`: List<RouteMapRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument List of RouteMap rules to be applied.
     */
    @JvmName("vffmvkwbeokdavdd")
    public suspend fun rules(argument: List<suspend RouteMapRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RouteMapRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument List of RouteMap rules to be applied.
     */
    @JvmName("myvhluwncbommbgq")
    public suspend fun rules(vararg argument: suspend RouteMapRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RouteMapRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument List of RouteMap rules to be applied.
     */
    @JvmName("otrcspemcwtlwpmr")
    public suspend fun rules(argument: suspend RouteMapRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RouteMapRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values List of RouteMap rules to be applied.
     */
    @JvmName("iyhmokhitmknjwhn")
    public suspend fun rules(vararg values: RouteMapRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value The name of the VirtualHub containing the RouteMap.
     */
    @JvmName("rkdteeeegrqsmhor")
    public suspend fun virtualHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualHubName = mapped
    }

    internal fun build(): RouteMapArgs = RouteMapArgs(
        associatedInboundConnections = associatedInboundConnections,
        associatedOutboundConnections = associatedOutboundConnections,
        id = id,
        resourceGroupName = resourceGroupName,
        routeMapName = routeMapName,
        rules = rules,
        virtualHubName = virtualHubName,
    )
}
