@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.RouteResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.RouteResponse.Companion.toKotlin as routeResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse.Companion.toKotlin as subnetResponseToKotlin

/**
 * Builder for [RouteTable].
 */
@PulumiTagMarker
public class RouteTableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouteTableArgs = RouteTableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouteTableArgsBuilder.() -> Unit) {
        val builder = RouteTableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RouteTable {
        val builtJavaResource = com.pulumi.azurenative.network.RouteTable(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RouteTable(builtJavaResource)
    }
}

/**
 * Route table resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2015-05-01-preview, 2016-03-30, 2019-06-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create route table
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var routeTable = new AzureNative.Network.RouteTable("routeTable", new()
 *     {
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *         RouteTableName = "testrt",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRouteTable(ctx, "routeTable", &network.RouteTableArgs{
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			RouteTableName:    pulumi.String("testrt"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RouteTable;
 * import com.pulumi.azurenative.network.RouteTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var routeTable = new RouteTable("routeTable", RouteTableArgs.builder()
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .routeTableName("testrt")
 *             .build());
 *     }
 * }
 * ```
 * ### Create route table with route
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var routeTable = new AzureNative.Network.RouteTable("routeTable", new()
 *     {
 *         DisableBgpRoutePropagation = true,
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *         RouteTableName = "testrt",
 *         Routes = new[]
 *         {
 *             new AzureNative.Network.Inputs.RouteArgs
 *             {
 *                 AddressPrefix = "10.0.3.0/24",
 *                 Name = "route1",
 *                 NextHopType = AzureNative.Network.RouteNextHopType.VirtualNetworkGateway,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRouteTable(ctx, "routeTable", &network.RouteTableArgs{
 * 			DisableBgpRoutePropagation: pulumi.Bool(true),
 * 			Location:                   pulumi.String("westus"),
 * 			ResourceGroupName:          pulumi.String("rg1"),
 * 			RouteTableName:             pulumi.String("testrt"),
 * 			Routes: network.RouteTypeArray{
 * 				&network.RouteTypeArgs{
 * 					AddressPrefix: pulumi.String("10.0.3.0/24"),
 * 					Name:          pulumi.String("route1"),
 * 					NextHopType:   pulumi.String(network.RouteNextHopTypeVirtualNetworkGateway),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RouteTable;
 * import com.pulumi.azurenative.network.RouteTableArgs;
 * import com.pulumi.azurenative.network.inputs.RouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var routeTable = new RouteTable("routeTable", RouteTableArgs.builder()
 *             .disableBgpRoutePropagation(true)
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .routeTableName("testrt")
 *             .routes(RouteArgs.builder()
 *                 .addressPrefix("10.0.3.0/24")
 *                 .name("route1")
 *                 .nextHopType("VirtualNetworkGateway")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:RouteTable testrt /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeTables/{routeTableName}
 * ```
 */
public class RouteTable internal constructor(
    override val javaResource: com.pulumi.azurenative.network.RouteTable,
) : KotlinCustomResource(javaResource, RouteTableMapper) {
    /**
     * Whether to disable the routes learned by BGP on that route table. True means disable.
     */
    public val disableBgpRoutePropagation: Output<Boolean>?
        get() = javaResource.disableBgpRoutePropagation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the route table resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resource GUID property of the route table.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * Collection of routes contained within a route table.
     */
    public val routes: Output<List<RouteResponse>>?
        get() = javaResource.routes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> routeResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A collection of references to subnets.
     */
    public val subnets: Output<List<SubnetResponse>>
        get() = javaResource.subnets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subnetResponseToKotlin(args0)
                })
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RouteTableMapper : ResourceMapper<RouteTable> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.RouteTable::class == javaResource::class

    override fun map(javaResource: Resource): RouteTable = RouteTable(
        javaResource as
            com.pulumi.azurenative.network.RouteTable,
    )
}

/**
 * @see [RouteTable].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RouteTable].
 */
public suspend fun routeTable(name: String, block: suspend RouteTableResourceBuilder.() -> Unit):
    RouteTable {
    val builder = RouteTableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RouteTable].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routeTable(name: String): RouteTable {
    val builder = RouteTableResourceBuilder()
    builder.name(name)
    return builder.build()
}
