@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.RouteTableArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.RouteArgs
import com.pulumi.azurenative.network.kotlin.inputs.RouteArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Route table resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2015-05-01-preview, 2016-03-30, 2019-06-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create route table
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var routeTable = new AzureNative.Network.RouteTable("routeTable", new()
 *     {
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *         RouteTableName = "testrt",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRouteTable(ctx, "routeTable", &network.RouteTableArgs{
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			RouteTableName:    pulumi.String("testrt"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RouteTable;
 * import com.pulumi.azurenative.network.RouteTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var routeTable = new RouteTable("routeTable", RouteTableArgs.builder()
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .routeTableName("testrt")
 *             .build());
 *     }
 * }
 * ```
 * ### Create route table with route
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var routeTable = new AzureNative.Network.RouteTable("routeTable", new()
 *     {
 *         DisableBgpRoutePropagation = true,
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *         RouteTableName = "testrt",
 *         Routes = new[]
 *         {
 *             new AzureNative.Network.Inputs.RouteArgs
 *             {
 *                 AddressPrefix = "10.0.3.0/24",
 *                 Name = "route1",
 *                 NextHopType = AzureNative.Network.RouteNextHopType.VirtualNetworkGateway,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRouteTable(ctx, "routeTable", &network.RouteTableArgs{
 * 			DisableBgpRoutePropagation: pulumi.Bool(true),
 * 			Location:                   pulumi.String("westus"),
 * 			ResourceGroupName:          pulumi.String("rg1"),
 * 			RouteTableName:             pulumi.String("testrt"),
 * 			Routes: network.RouteTypeArray{
 * 				&network.RouteTypeArgs{
 * 					AddressPrefix: pulumi.String("10.0.3.0/24"),
 * 					Name:          pulumi.String("route1"),
 * 					NextHopType:   pulumi.String(network.RouteNextHopTypeVirtualNetworkGateway),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RouteTable;
 * import com.pulumi.azurenative.network.RouteTableArgs;
 * import com.pulumi.azurenative.network.inputs.RouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var routeTable = new RouteTable("routeTable", RouteTableArgs.builder()
 *             .disableBgpRoutePropagation(true)
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .routeTableName("testrt")
 *             .routes(RouteArgs.builder()
 *                 .addressPrefix("10.0.3.0/24")
 *                 .name("route1")
 *                 .nextHopType("VirtualNetworkGateway")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:RouteTable testrt /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeTables/{routeTableName}
 * ```
 * @property disableBgpRoutePropagation Whether to disable the routes learned by BGP on that route table. True means disable.
 * @property id Resource ID.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group.
 * @property routeTableName The name of the route table.
 * @property routes Collection of routes contained within a route table.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property tags Resource tags.
 */
public data class RouteTableArgs(
    public val disableBgpRoutePropagation: Output<Boolean>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routeTableName: Output<String>? = null,
    public val routes: Output<List<RouteArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.RouteTableArgs> {
    override fun toJava(): com.pulumi.azurenative.network.RouteTableArgs =
        com.pulumi.azurenative.network.RouteTableArgs.builder()
            .disableBgpRoutePropagation(disableBgpRoutePropagation?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routeTableName(routeTableName?.applyValue({ args0 -> args0 }))
            .routes(routes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RouteTableArgs].
 */
@PulumiTagMarker
public class RouteTableArgsBuilder internal constructor() {
    private var disableBgpRoutePropagation: Output<Boolean>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var routeTableName: Output<String>? = null

    private var routes: Output<List<RouteArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Whether to disable the routes learned by BGP on that route table. True means disable.
     */
    @JvmName("ujyrywksrxbcefra")
    public suspend fun disableBgpRoutePropagation(`value`: Output<Boolean>) {
        this.disableBgpRoutePropagation = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("iwvnxlxfabmguckk")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("hanoktmbteqsakuy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vwuhjwfacuynqcsx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the route table.
     */
    @JvmName("lriygkaifenqoqbo")
    public suspend fun routeTableName(`value`: Output<String>) {
        this.routeTableName = value
    }

    /**
     * @param value Collection of routes contained within a route table.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("nfgdaqrccwksbawm")
    public suspend fun routes(`value`: Output<List<RouteArgs>>) {
        this.routes = value
    }

    @JvmName("dxccuwgfnqtnbmuk")
    public suspend fun routes(vararg values: Output<RouteArgs>) {
        this.routes = Output.all(values.asList())
    }

    /**
     * @param values Collection of routes contained within a route table.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("jfkxdrbcjlicytcr")
    public suspend fun routes(values: List<Output<RouteArgs>>) {
        this.routes = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lgogpqbxxccagnuj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether to disable the routes learned by BGP on that route table. True means disable.
     */
    @JvmName("bnviasyglwyeillf")
    public suspend fun disableBgpRoutePropagation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableBgpRoutePropagation = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("jgybbpijpnpwkaha")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("hunayuatgswlmpis")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qyrvijmlphdqnfxs")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the route table.
     */
    @JvmName("neybklngqxmwyvfl")
    public suspend fun routeTableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTableName = mapped
    }

    /**
     * @param value Collection of routes contained within a route table.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("yrmrpeoopnnslkni")
    public suspend fun routes(`value`: List<RouteArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param argument Collection of routes contained within a route table.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("jmrdcsktvfsfxnfw")
    public suspend fun routes(argument: List<suspend RouteArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { RouteArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument Collection of routes contained within a route table.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("orhslhdstuefoefn")
    public suspend fun routes(vararg argument: suspend RouteArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { RouteArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument Collection of routes contained within a route table.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("sojxybwgpguqudvw")
    public suspend fun routes(argument: suspend RouteArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RouteArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param values Collection of routes contained within a route table.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("karrpqmigtpqxeps")
    public suspend fun routes(vararg values: RouteArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("usrkwfdtitjjlgpu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("urcbhlyfrjuesfwy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RouteTableArgs = RouteTableArgs(
        disableBgpRoutePropagation = disableBgpRoutePropagation,
        id = id,
        location = location,
        resourceGroupName = resourceGroupName,
        routeTableName = routeTableName,
        routes = routes,
        tags = tags,
    )
}
