@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.RulesEngineArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.RulesEngineRuleArgs
import com.pulumi.azurenative.network.kotlin.inputs.RulesEngineRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A rules engine configuration containing a list of rules that will run to modify the runtime behavior of the request and response.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Create or update a specific Rules Engine Configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var rulesEngine = new AzureNative.Network.RulesEngine("rulesEngine", new()
 *     {
 *         FrontDoorName = "frontDoor1",
 *         ResourceGroupName = "rg1",
 *         Rules = new[]
 *         {
 *             new AzureNative.Network.Inputs.RulesEngineRuleArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.RulesEngineActionArgs
 *                 {
 *                     RouteConfigurationOverride = new AzureNative.Network.Inputs.RedirectConfigurationArgs
 *                     {
 *                         CustomFragment = "fragment",
 *                         CustomHost = "www.bing.com",
 *                         CustomPath = "/api",
 *                         CustomQueryString = "a=b",
 *                         OdataType = "#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration",
 *                         RedirectProtocol = AzureNative.Network.FrontDoorRedirectProtocol.HttpsOnly,
 *                         RedirectType = AzureNative.Network.FrontDoorRedirectType.Moved,
 *                     },
 *                 },
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.RulesEngineMatchConditionArgs
 *                     {
 *                         RulesEngineMatchValue = new[]
 *                         {
 *                             "CH",
 *                         },
 *                         RulesEngineMatchVariable = AzureNative.Network.RulesEngineMatchVariable.RemoteAddr,
 *                         RulesEngineOperator = AzureNative.Network.RulesEngineOperator.GeoMatch,
 *                     },
 *                 },
 *                 MatchProcessingBehavior = AzureNative.Network.MatchProcessingBehavior.Stop,
 *                 Name = "Rule1",
 *                 Priority = 1,
 *             },
 *             new AzureNative.Network.Inputs.RulesEngineRuleArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.RulesEngineActionArgs
 *                 {
 *                     ResponseHeaderActions = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.HeaderActionArgs
 *                         {
 *                             HeaderActionType = AzureNative.Network.HeaderActionType.Overwrite,
 *                             HeaderName = "Cache-Control",
 *                             Value = "public, max-age=31536000",
 *                         },
 *                     },
 *                 },
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.RulesEngineMatchConditionArgs
 *                     {
 *                         RulesEngineMatchValue = new[]
 *                         {
 *                             "jpg",
 *                         },
 *                         RulesEngineMatchVariable = AzureNative.Network.RulesEngineMatchVariable.RequestFilenameExtension,
 *                         RulesEngineOperator = AzureNative.Network.RulesEngineOperator.Equal,
 *                         Transforms = new[]
 *                         {
 *                             AzureNative.Network.Transform.Lowercase,
 *                         },
 *                     },
 *                 },
 *                 Name = "Rule2",
 *                 Priority = 2,
 *             },
 *             new AzureNative.Network.Inputs.RulesEngineRuleArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.RulesEngineActionArgs
 *                 {
 *                     RouteConfigurationOverride = new AzureNative.Network.Inputs.ForwardingConfigurationArgs
 *                     {
 *                         BackendPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/backendPools/backendPool1",
 *                         },
 *                         CacheConfiguration = new AzureNative.Network.Inputs.CacheConfigurationArgs
 *                         {
 *                             CacheDuration = "P1DT12H20M30S",
 *                             DynamicCompression = AzureNative.Network.DynamicCompressionEnabled.Disabled,
 *                             QueryParameterStripDirective = AzureNative.Network.FrontDoorQuery.StripOnly,
 *                             QueryParameters = "a=b,p=q",
 *                         },
 *                         ForwardingProtocol = AzureNative.Network.FrontDoorForwardingProtocol.HttpsOnly,
 *                         OdataType = "#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration",
 *                     },
 *                 },
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.RulesEngineMatchConditionArgs
 *                     {
 *                         NegateCondition = false,
 *                         RulesEngineMatchValue = new[]
 *                         {
 *                             "allowoverride",
 *                         },
 *                         RulesEngineMatchVariable = AzureNative.Network.RulesEngineMatchVariable.RequestHeader,
 *                         RulesEngineOperator = AzureNative.Network.RulesEngineOperator.Equal,
 *                         Selector = "Rules-Engine-Route-Forward",
 *                         Transforms = new[]
 *                         {
 *                             AzureNative.Network.Transform.Lowercase,
 *                         },
 *                     },
 *                 },
 *                 Name = "Rule3",
 *                 Priority = 3,
 *             },
 *         },
 *         RulesEngineName = "rulesEngine1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRulesEngine(ctx, "rulesEngine", &network.RulesEngineArgs{
 * 			FrontDoorName:     pulumi.String("frontDoor1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Rules: network.RulesEngineRuleArray{
 * 				&network.RulesEngineRuleArgs{
 * 					Action: &network.RulesEngineActionArgs{
 * 						RouteConfigurationOverride: network.RedirectConfiguration{
 * 							CustomFragment:    "fragment",
 * 							CustomHost:        "www.bing.com",
 * 							CustomPath:        "/api",
 * 							CustomQueryString: "a=b",
 * 							OdataType:         "#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration",
 * 							RedirectProtocol:  network.FrontDoorRedirectProtocolHttpsOnly,
 * 							RedirectType:      network.FrontDoorRedirectTypeMoved,
 * 						},
 * 					},
 * 					MatchConditions: network.RulesEngineMatchConditionArray{
 * 						&network.RulesEngineMatchConditionArgs{
 * 							RulesEngineMatchValue: pulumi.StringArray{
 * 								pulumi.String("CH"),
 * 							},
 * 							RulesEngineMatchVariable: pulumi.String(network.RulesEngineMatchVariableRemoteAddr),
 * 							RulesEngineOperator:      pulumi.String(network.RulesEngineOperatorGeoMatch),
 * 						},
 * 					},
 * 					MatchProcessingBehavior: pulumi.String(network.MatchProcessingBehaviorStop),
 * 					Name:                    pulumi.String("Rule1"),
 * 					Priority:                pulumi.Int(1),
 * 				},
 * 				&network.RulesEngineRuleArgs{
 * 					Action: &network.RulesEngineActionArgs{
 * 						ResponseHeaderActions: network.HeaderActionArray{
 * 							&network.HeaderActionArgs{
 * 								HeaderActionType: pulumi.String(network.HeaderActionTypeOverwrite),
 * 								HeaderName:       pulumi.String("Cache-Control"),
 * 								Value:            pulumi.String("public, max-age=31536000"),
 * 							},
 * 						},
 * 					},
 * 					MatchConditions: network.RulesEngineMatchConditionArray{
 * 						&network.RulesEngineMatchConditionArgs{
 * 							RulesEngineMatchValue: pulumi.StringArray{
 * 								pulumi.String("jpg"),
 * 							},
 * 							RulesEngineMatchVariable: pulumi.String(network.RulesEngineMatchVariableRequestFilenameExtension),
 * 							RulesEngineOperator:      pulumi.String(network.RulesEngineOperatorEqual),
 * 							Transforms: pulumi.StringArray{
 * 								pulumi.String(network.TransformLowercase),
 * 							},
 * 						},
 * 					},
 * 					Name:     pulumi.String("Rule2"),
 * 					Priority: pulumi.Int(2),
 * 				},
 * 				&network.RulesEngineRuleArgs{
 * 					Action: &network.RulesEngineActionArgs{
 * 						RouteConfigurationOverride: network.ForwardingConfiguration{
 * 							BackendPool: network.SubResource{
 * 								Id: "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/backendPools/backendPool1",
 * 							},
 * 							CacheConfiguration: network.CacheConfiguration{
 * 								CacheDuration:                "P1DT12H20M30S",
 * 								DynamicCompression:           network.DynamicCompressionEnabledDisabled,
 * 								QueryParameterStripDirective: network.FrontDoorQueryStripOnly,
 * 								QueryParameters:              "a=b,p=q",
 * 							},
 * 							ForwardingProtocol: network.FrontDoorForwardingProtocolHttpsOnly,
 * 							OdataType:          "#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration",
 * 						},
 * 					},
 * 					MatchConditions: network.RulesEngineMatchConditionArray{
 * 						&network.RulesEngineMatchConditionArgs{
 * 							NegateCondition: pulumi.Bool(false),
 * 							RulesEngineMatchValue: pulumi.StringArray{
 * 								pulumi.String("allowoverride"),
 * 							},
 * 							RulesEngineMatchVariable: pulumi.String(network.RulesEngineMatchVariableRequestHeader),
 * 							RulesEngineOperator:      pulumi.String(network.RulesEngineOperatorEqual),
 * 							Selector:                 pulumi.String("Rules-Engine-Route-Forward"),
 * 							Transforms: pulumi.StringArray{
 * 								pulumi.String(network.TransformLowercase),
 * 							},
 * 						},
 * 					},
 * 					Name:     pulumi.String("Rule3"),
 * 					Priority: pulumi.Int(3),
 * 				},
 * 			},
 * 			RulesEngineName: pulumi.String("rulesEngine1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RulesEngine;
 * import com.pulumi.azurenative.network.RulesEngineArgs;
 * import com.pulumi.azurenative.network.inputs.RulesEngineRuleArgs;
 * import com.pulumi.azurenative.network.inputs.RulesEngineActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var rulesEngine = new RulesEngine("rulesEngine", RulesEngineArgs.builder()
 *             .frontDoorName("frontDoor1")
 *             .resourceGroupName("rg1")
 *             .rules(
 *                 RulesEngineRuleArgs.builder()
 *                     .action(RulesEngineActionArgs.builder()
 *                         .routeConfigurationOverride(ForwardingConfigurationArgs.builder()
 *                             .customFragment("fragment")
 *                             .customHost("www.bing.com")
 *                             .customPath("/api")
 *                             .customQueryString("a=b")
 *                             .odataType("#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration")
 *                             .redirectProtocol("HttpsOnly")
 *                             .redirectType("Moved")
 *                             .build())
 *                         .build())
 *                     .matchConditions(RulesEngineMatchConditionArgs.builder()
 *                         .rulesEngineMatchValue("CH")
 *                         .rulesEngineMatchVariable("RemoteAddr")
 *                         .rulesEngineOperator("GeoMatch")
 *                         .build())
 *                     .matchProcessingBehavior("Stop")
 *                     .name("Rule1")
 *                     .priority(1)
 *                     .build(),
 *                 RulesEngineRuleArgs.builder()
 *                     .action(RulesEngineActionArgs.builder()
 *                         .responseHeaderActions(HeaderActionArgs.builder()
 *                             .headerActionType("Overwrite")
 *                             .headerName("Cache-Control")
 *                             .value("public, max-age=31536000")
 *                             .build())
 *                         .build())
 *                     .matchConditions(RulesEngineMatchConditionArgs.builder()
 *                         .rulesEngineMatchValue("jpg")
 *                         .rulesEngineMatchVariable("RequestFilenameExtension")
 *                         .rulesEngineOperator("Equal")
 *                         .transforms("Lowercase")
 *                         .build())
 *                     .name("Rule2")
 *                     .priority(2)
 *                     .build(),
 *                 RulesEngineRuleArgs.builder()
 *                     .action(RulesEngineActionArgs.builder()
 *                         .routeConfigurationOverride(ForwardingConfigurationArgs.builder()
 *                             .backendPool(SubResourceArgs.builder()
 *                                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/backendPools/backendPool1")
 *                                 .build())
 *                             .cacheConfiguration(CacheConfigurationArgs.builder()
 *                                 .cacheDuration("P1DT12H20M30S")
 *                                 .dynamicCompression("Disabled")
 *                                 .queryParameterStripDirective("StripOnly")
 *                                 .queryParameters("a=b,p=q")
 *                                 .build())
 *                             .forwardingProtocol("HttpsOnly")
 *                             .odataType("#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration")
 *                             .build())
 *                         .build())
 *                     .matchConditions(RulesEngineMatchConditionArgs.builder()
 *                         .negateCondition(false)
 *                         .rulesEngineMatchValue("allowoverride")
 *                         .rulesEngineMatchVariable("RequestHeader")
 *                         .rulesEngineOperator("Equal")
 *                         .selector("Rules-Engine-Route-Forward")
 *                         .transforms("Lowercase")
 *                         .build())
 *                     .name("Rule3")
 *                     .priority(3)
 *                     .build())
 *             .rulesEngineName("rulesEngine1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:RulesEngine rulesEngine1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}/rulesEngines/{rulesEngineName}
 * ```
 * @property frontDoorName Name of the Front Door which is globally unique.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property rules A list of rules that define a particular Rules Engine Configuration.
 * @property rulesEngineName Name of the Rules Engine which is unique within the Front Door.
 */
public data class RulesEngineArgs(
    public val frontDoorName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val rules: Output<List<RulesEngineRuleArgs>>? = null,
    public val rulesEngineName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.RulesEngineArgs> {
    override fun toJava(): com.pulumi.azurenative.network.RulesEngineArgs =
        com.pulumi.azurenative.network.RulesEngineArgs.builder()
            .frontDoorName(frontDoorName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .rulesEngineName(rulesEngineName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RulesEngineArgs].
 */
@PulumiTagMarker
public class RulesEngineArgsBuilder internal constructor() {
    private var frontDoorName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var rules: Output<List<RulesEngineRuleArgs>>? = null

    private var rulesEngineName: Output<String>? = null

    /**
     * @param value Name of the Front Door which is globally unique.
     */
    @JvmName("mrvjakcuiwswcywb")
    public suspend fun frontDoorName(`value`: Output<String>) {
        this.frontDoorName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("vicqldpucjfnvsdm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value A list of rules that define a particular Rules Engine Configuration.
     */
    @JvmName("cepxromkbqahvths")
    public suspend fun rules(`value`: Output<List<RulesEngineRuleArgs>>) {
        this.rules = value
    }

    @JvmName("gojbuprhpaeaukbt")
    public suspend fun rules(vararg values: Output<RulesEngineRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values A list of rules that define a particular Rules Engine Configuration.
     */
    @JvmName("dcjeovxbirpthfmy")
    public suspend fun rules(values: List<Output<RulesEngineRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Name of the Rules Engine which is unique within the Front Door.
     */
    @JvmName("ypoluiermjogcwmo")
    public suspend fun rulesEngineName(`value`: Output<String>) {
        this.rulesEngineName = value
    }

    /**
     * @param value Name of the Front Door which is globally unique.
     */
    @JvmName("qsjvqapadgooobfr")
    public suspend fun frontDoorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontDoorName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("silurcgojkxnaiem")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value A list of rules that define a particular Rules Engine Configuration.
     */
    @JvmName("nssdodcalgfvyjgg")
    public suspend fun rules(`value`: List<RulesEngineRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument A list of rules that define a particular Rules Engine Configuration.
     */
    @JvmName("drqwwqnlknpxrhdd")
    public suspend fun rules(argument: List<suspend RulesEngineRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RulesEngineRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument A list of rules that define a particular Rules Engine Configuration.
     */
    @JvmName("dhthvoixkouiyhue")
    public suspend fun rules(vararg argument: suspend RulesEngineRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RulesEngineRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument A list of rules that define a particular Rules Engine Configuration.
     */
    @JvmName("orllxroamnboxqmv")
    public suspend fun rules(argument: suspend RulesEngineRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RulesEngineRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values A list of rules that define a particular Rules Engine Configuration.
     */
    @JvmName("dvqfbwniykemeljj")
    public suspend fun rules(vararg values: RulesEngineRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value Name of the Rules Engine which is unique within the Front Door.
     */
    @JvmName("mjkrrjxdekjplayb")
    public suspend fun rulesEngineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rulesEngineName = mapped
    }

    internal fun build(): RulesEngineArgs = RulesEngineArgs(
        frontDoorName = frontDoorName,
        resourceGroupName = resourceGroupName,
        rules = rules,
        rulesEngineName = rulesEngineName,
    )
}
