@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ApplicationSecurityGroupResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationSecurityGroupResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [SecurityRule].
 */
@PulumiTagMarker
public class SecurityRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityRuleArgs = SecurityRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityRuleArgsBuilder.() -> Unit) {
        val builder = SecurityRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SecurityRule {
        val builtJavaResource = com.pulumi.azurenative.network.SecurityRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecurityRule(builtJavaResource)
    }
}

/**
 * Network security rule.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2017-03-01, 2019-06-01, 2022-07-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create security rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securityRule = new AzureNative.Network.SecurityRule("securityRule", new()
 *     {
 *         Access = AzureNative.Network.SecurityRuleAccess.Deny,
 *         DestinationAddressPrefix = "11.0.0.0/8",
 *         DestinationPortRange = "8080",
 *         Direction = AzureNative.Network.SecurityRuleDirection.Outbound,
 *         NetworkSecurityGroupName = "testnsg",
 *         Priority = 100,
 *         Protocol = AzureNative.Network.SecurityRuleProtocol.Asterisk,
 *         ResourceGroupName = "rg1",
 *         SecurityRuleName = "rule1",
 *         SourceAddressPrefix = "10.0.0.0/8",
 *         SourcePortRange = "*",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewSecurityRule(ctx, "securityRule", &network.SecurityRuleArgs{
 * 			Access:                   pulumi.String(network.SecurityRuleAccessDeny),
 * 			DestinationAddressPrefix: pulumi.String("11.0.0.0/8"),
 * 			DestinationPortRange:     pulumi.String("8080"),
 * 			Direction:                pulumi.String(network.SecurityRuleDirectionOutbound),
 * 			NetworkSecurityGroupName: pulumi.String("testnsg"),
 * 			Priority:                 pulumi.Int(100),
 * 			Protocol:                 pulumi.String(network.SecurityRuleProtocolAsterisk),
 * 			ResourceGroupName:        pulumi.String("rg1"),
 * 			SecurityRuleName:         pulumi.String("rule1"),
 * 			SourceAddressPrefix:      pulumi.String("10.0.0.0/8"),
 * 			SourcePortRange:          pulumi.String("*"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.SecurityRule;
 * import com.pulumi.azurenative.network.SecurityRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securityRule = new SecurityRule("securityRule", SecurityRuleArgs.builder()
 *             .access("Deny")
 *             .destinationAddressPrefix("11.0.0.0/8")
 *             .destinationPortRange("8080")
 *             .direction("Outbound")
 *             .networkSecurityGroupName("testnsg")
 *             .priority(100)
 *             .protocol("*")
 *             .resourceGroupName("rg1")
 *             .securityRuleName("rule1")
 *             .sourceAddressPrefix("10.0.0.0/8")
 *             .sourcePortRange("*")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:SecurityRule rule1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityGroups/{networkSecurityGroupName}/securityRules/{securityRuleName}
 * ```
 */
public class SecurityRule internal constructor(
    override val javaResource: com.pulumi.azurenative.network.SecurityRule,
) : KotlinCustomResource(javaResource, SecurityRuleMapper) {
    /**
     * The network traffic is allowed or denied.
     */
    public val access: Output<String>
        get() = javaResource.access().applyValue({ args0 -> args0 })

    /**
     * A description for this rule. Restricted to 140 chars.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
     */
    public val destinationAddressPrefix: Output<String>?
        get() = javaResource.destinationAddressPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The destination address prefixes. CIDR or destination IP ranges.
     */
    public val destinationAddressPrefixes: Output<List<String>>?
        get() = javaResource.destinationAddressPrefixes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The application security group specified as destination.
     */
    public val destinationApplicationSecurityGroups: Output<List<ApplicationSecurityGroupResponse>>?
        get() = javaResource.destinationApplicationSecurityGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        toKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
     */
    public val destinationPortRange: Output<String>?
        get() = javaResource.destinationPortRange().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The destination port ranges.
     */
    public val destinationPortRanges: Output<List<String>>?
        get() = javaResource.destinationPortRanges().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
     */
    public val direction: Output<String>
        get() = javaResource.direction().applyValue({ args0 -> args0 })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
     */
    public val priority: Output<Int>
        get() = javaResource.priority().applyValue({ args0 -> args0 })

    /**
     * Network protocol this rule applies to.
     */
    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the security rule resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
     */
    public val sourceAddressPrefix: Output<String>?
        get() = javaResource.sourceAddressPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The CIDR or source IP ranges.
     */
    public val sourceAddressPrefixes: Output<List<String>>?
        get() = javaResource.sourceAddressPrefixes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The application security group specified as source.
     */
    public val sourceApplicationSecurityGroups: Output<List<ApplicationSecurityGroupResponse>>?
        get() = javaResource.sourceApplicationSecurityGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
     */
    public val sourcePortRange: Output<String>?
        get() = javaResource.sourcePortRange().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The source port ranges.
     */
    public val sourcePortRanges: Output<List<String>>?
        get() = javaResource.sourcePortRanges().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object SecurityRuleMapper : ResourceMapper<SecurityRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.SecurityRule::class == javaResource::class

    override fun map(javaResource: Resource): SecurityRule = SecurityRule(
        javaResource as
            com.pulumi.azurenative.network.SecurityRule,
    )
}

/**
 * @see [SecurityRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityRule].
 */
public suspend fun securityRule(
    name: String,
    block: suspend SecurityRuleResourceBuilder.() -> Unit,
): SecurityRule {
    val builder = SecurityRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityRule(name: String): SecurityRule {
    val builder = SecurityRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
