@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SecurityUserConfiguration].
 */
@PulumiTagMarker
public class SecurityUserConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityUserConfigurationArgs = SecurityUserConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityUserConfigurationArgsBuilder.() -> Unit) {
        val builder = SecurityUserConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SecurityUserConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.network.SecurityUserConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SecurityUserConfiguration(builtJavaResource)
    }
}

/**
 * Defines the security user configuration
 * Azure REST API version: 2022-04-01-preview. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2021-05-01-preview.
 * ## Example Usage
 * ### Create network manager security user configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securityUserConfiguration = new AzureNative.Network.SecurityUserConfiguration("securityUserConfiguration", new()
 *     {
 *         ConfigurationName = "myTestSecurityConfig",
 *         DeleteExistingNSGs = AzureNative.Network.DeleteExistingNSGs.True,
 *         Description = "A sample policy",
 *         NetworkManagerName = "testNetworkManager",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewSecurityUserConfiguration(ctx, "securityUserConfiguration", &network.SecurityUserConfigurationArgs{
 * 			ConfigurationName:  pulumi.String("myTestSecurityConfig"),
 * 			DeleteExistingNSGs: pulumi.String(network.DeleteExistingNSGsTrue),
 * 			Description:        pulumi.String("A sample policy"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.SecurityUserConfiguration;
 * import com.pulumi.azurenative.network.SecurityUserConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securityUserConfiguration = new SecurityUserConfiguration("securityUserConfiguration", SecurityUserConfigurationArgs.builder()
 *             .configurationName("myTestSecurityConfig")
 *             .deleteExistingNSGs("True")
 *             .description("A sample policy")
 *             .networkManagerName("testNetworkManager")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:SecurityUserConfiguration myTestSecurityConfig /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/securityUserConfigurations/{configurationName}
 * ```
 */
public class SecurityUserConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.network.SecurityUserConfiguration,
) : KotlinCustomResource(javaResource, SecurityUserConfigurationMapper) {
    /**
     * Flag if need to delete existing network security groups.
     */
    public val deleteExistingNSGs: Output<String>?
        get() = javaResource.deleteExistingNSGs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A description of the security user configuration.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The system metadata related to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SecurityUserConfigurationMapper : ResourceMapper<SecurityUserConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.SecurityUserConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): SecurityUserConfiguration =
        SecurityUserConfiguration(
            javaResource as
                com.pulumi.azurenative.network.SecurityUserConfiguration,
        )
}

/**
 * @see [SecurityUserConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityUserConfiguration].
 */
public suspend fun securityUserConfiguration(
    name: String,
    block: suspend SecurityUserConfigurationResourceBuilder.() -> Unit,
): SecurityUserConfiguration {
    val builder = SecurityUserConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityUserConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityUserConfiguration(name: String): SecurityUserConfiguration {
    val builder = SecurityUserConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
