@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TrafficManagerUserMetricsKey].
 */
@PulumiTagMarker
public class TrafficManagerUserMetricsKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrafficManagerUserMetricsKeyArgs = TrafficManagerUserMetricsKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrafficManagerUserMetricsKeyArgsBuilder.() -> Unit) {
        val builder = TrafficManagerUserMetricsKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TrafficManagerUserMetricsKey {
        val builtJavaResource =
            com.pulumi.azurenative.network.TrafficManagerUserMetricsKey(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TrafficManagerUserMetricsKey(builtJavaResource)
    }
}

/**
 * Class representing Traffic Manager User Metrics.
 * Azure REST API version: 2022-04-01. Prior API version in Azure Native 1.x: 2018-08-01.
 * Other available API versions: 2017-09-01-preview, 2022-04-01-preview.
 * ## Example Usage
 * ### TrafficManagerUserMetricsKeys-PUT
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var trafficManagerUserMetricsKey = new AzureNative.Network.TrafficManagerUserMetricsKey("trafficManagerUserMetricsKey");
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewTrafficManagerUserMetricsKey(ctx, "trafficManagerUserMetricsKey", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.TrafficManagerUserMetricsKey;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var trafficManagerUserMetricsKey = new TrafficManagerUserMetricsKey("trafficManagerUserMetricsKey");
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:TrafficManagerUserMetricsKey default /subscriptions/{subscriptionId}/providers/Microsoft.Network/trafficManagerUserMetricsKeys/default
 * ```
 */
public class TrafficManagerUserMetricsKey internal constructor(
    override val javaResource: com.pulumi.azurenative.network.TrafficManagerUserMetricsKey,
) : KotlinCustomResource(javaResource, TrafficManagerUserMetricsKeyMapper) {
    /**
     * The key returned by the User Metrics operation.
     */
    public val key: Output<String>?
        get() = javaResource.key().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object TrafficManagerUserMetricsKeyMapper : ResourceMapper<TrafficManagerUserMetricsKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.TrafficManagerUserMetricsKey::class == javaResource::class

    override fun map(javaResource: Resource): TrafficManagerUserMetricsKey =
        TrafficManagerUserMetricsKey(
            javaResource as
                com.pulumi.azurenative.network.TrafficManagerUserMetricsKey,
        )
}

/**
 * @see [TrafficManagerUserMetricsKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrafficManagerUserMetricsKey].
 */
public suspend fun trafficManagerUserMetricsKey(
    name: String,
    block: suspend TrafficManagerUserMetricsKeyResourceBuilder.() -> Unit,
):
    TrafficManagerUserMetricsKey {
    val builder = TrafficManagerUserMetricsKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrafficManagerUserMetricsKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trafficManagerUserMetricsKey(name: String): TrafficManagerUserMetricsKey {
    val builder = TrafficManagerUserMetricsKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
