@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.TrafficManagerUserMetricsKeyArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress

/**
 * Class representing Traffic Manager User Metrics.
 * Azure REST API version: 2022-04-01. Prior API version in Azure Native 1.x: 2018-08-01.
 * Other available API versions: 2017-09-01-preview, 2022-04-01-preview.
 * ## Example Usage
 * ### TrafficManagerUserMetricsKeys-PUT
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var trafficManagerUserMetricsKey = new AzureNative.Network.TrafficManagerUserMetricsKey("trafficManagerUserMetricsKey");
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewTrafficManagerUserMetricsKey(ctx, "trafficManagerUserMetricsKey", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.TrafficManagerUserMetricsKey;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var trafficManagerUserMetricsKey = new TrafficManagerUserMetricsKey("trafficManagerUserMetricsKey");
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:TrafficManagerUserMetricsKey default /subscriptions/{subscriptionId}/providers/Microsoft.Network/trafficManagerUserMetricsKeys/default
 * ```
 */
public class TrafficManagerUserMetricsKeyArgs() :
    ConvertibleToJava<com.pulumi.azurenative.network.TrafficManagerUserMetricsKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.network.TrafficManagerUserMetricsKeyArgs =
        com.pulumi.azurenative.network.TrafficManagerUserMetricsKeyArgs.builder().build()
}

/**
 * Builder for [TrafficManagerUserMetricsKeyArgs].
 */
@PulumiTagMarker
public class TrafficManagerUserMetricsKeyArgsBuilder internal constructor() {
    internal fun build(): TrafficManagerUserMetricsKeyArgs = TrafficManagerUserMetricsKeyArgs()
}
