@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.AddressPrefixItemResponse
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.network.kotlin.outputs.AddressPrefixItemResponse.Companion.toKotlin as addressPrefixItemResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [UserRule].
 */
@PulumiTagMarker
public class UserRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserRuleArgs = UserRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserRuleArgsBuilder.() -> Unit) {
        val builder = UserRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UserRule {
        val builtJavaResource = com.pulumi.azurenative.network.UserRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserRule(builtJavaResource)
    }
}

/**
 * Network security user rule.
 * Azure REST API version: 2022-04-01-preview. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2021-05-01-preview.
 * ## Example Usage
 * ### Create a default user rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var userRule = new AzureNative.Network.UserRule("userRule", new()
 *     {
 *         ConfigurationName = "myTestSecurityConfig",
 *         NetworkManagerName = "testNetworkManager",
 *         ResourceGroupName = "rg1",
 *         RuleCollectionName = "testRuleCollection",
 *         RuleName = "SampleDefaultUserRule",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewUserRule(ctx, "userRule", &network.UserRuleArgs{
 * 			ConfigurationName:  pulumi.String("myTestSecurityConfig"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			RuleCollectionName: pulumi.String("testRuleCollection"),
 * 			RuleName:           pulumi.String("SampleDefaultUserRule"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.UserRule;
 * import com.pulumi.azurenative.network.UserRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var userRule = new UserRule("userRule", UserRuleArgs.builder()
 *             .configurationName("myTestSecurityConfig")
 *             .networkManagerName("testNetworkManager")
 *             .resourceGroupName("rg1")
 *             .ruleCollectionName("testRuleCollection")
 *             .ruleName("SampleDefaultUserRule")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a user rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var userRule = new AzureNative.Network.UserRule("userRule", new()
 *     {
 *         ConfigurationName = "myTestSecurityConfig",
 *         Description = "Sample User Rule",
 *         DestinationPortRanges = new[]
 *         {
 *             "22",
 *         },
 *         Destinations = new[]
 *         {
 *             new AzureNative.Network.Inputs.AddressPrefixItemArgs
 *             {
 *                 AddressPrefix = "*",
 *                 AddressPrefixType = AzureNative.Network.AddressPrefixType.IPPrefix,
 *             },
 *         },
 *         Direction = AzureNative.Network.SecurityConfigurationRuleDirection.Inbound,
 *         Kind = "Custom",
 *         NetworkManagerName = "testNetworkManager",
 *         Protocol = AzureNative.Network.SecurityConfigurationRuleProtocol.Tcp,
 *         ResourceGroupName = "rg1",
 *         RuleCollectionName = "testRuleCollection",
 *         RuleName = "SampleUserRule",
 *         SourcePortRanges = new[]
 *         {
 *             "0-65535",
 *         },
 *         Sources = new[]
 *         {
 *             new AzureNative.Network.Inputs.AddressPrefixItemArgs
 *             {
 *                 AddressPrefix = "*",
 *                 AddressPrefixType = AzureNative.Network.AddressPrefixType.IPPrefix,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewUserRule(ctx, "userRule", &network.UserRuleArgs{
 * 			ConfigurationName: pulumi.String("myTestSecurityConfig"),
 * 			Description:       pulumi.String("Sample User Rule"),
 * 			DestinationPortRanges: pulumi.StringArray{
 * 				pulumi.String("22"),
 * 			},
 * 			Destinations: network.AddressPrefixItemArray{
 * 				&network.AddressPrefixItemArgs{
 * 					AddressPrefix:     pulumi.String("*"),
 * 					AddressPrefixType: pulumi.String(network.AddressPrefixTypeIPPrefix),
 * 				},
 * 			},
 * 			Direction:          pulumi.String(network.SecurityConfigurationRuleDirectionInbound),
 * 			Kind:               pulumi.String("Custom"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			Protocol:           pulumi.String(network.SecurityConfigurationRuleProtocolTcp),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			RuleCollectionName: pulumi.String("testRuleCollection"),
 * 			RuleName:           pulumi.String("SampleUserRule"),
 * 			SourcePortRanges: pulumi.StringArray{
 * 				pulumi.String("0-65535"),
 * 			},
 * 			Sources: network.AddressPrefixItemArray{
 * 				&network.AddressPrefixItemArgs{
 * 					AddressPrefix:     pulumi.String("*"),
 * 					AddressPrefixType: pulumi.String(network.AddressPrefixTypeIPPrefix),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.UserRule;
 * import com.pulumi.azurenative.network.UserRuleArgs;
 * import com.pulumi.azurenative.network.inputs.AddressPrefixItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var userRule = new UserRule("userRule", UserRuleArgs.builder()
 *             .configurationName("myTestSecurityConfig")
 *             .description("Sample User Rule")
 *             .destinationPortRanges("22")
 *             .destinations(AddressPrefixItemArgs.builder()
 *                 .addressPrefix("*")
 *                 .addressPrefixType("IPPrefix")
 *                 .build())
 *             .direction("Inbound")
 *             .kind("Custom")
 *             .networkManagerName("testNetworkManager")
 *             .protocol("Tcp")
 *             .resourceGroupName("rg1")
 *             .ruleCollectionName("testRuleCollection")
 *             .ruleName("SampleUserRule")
 *             .sourcePortRanges("0-65535")
 *             .sources(AddressPrefixItemArgs.builder()
 *                 .addressPrefix("*")
 *                 .addressPrefixType("IPPrefix")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:UserRule SampleUserRule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/securityUserConfigurations/{configurationName}/ruleCollections/{ruleCollectionName}/rules/{ruleName}
 * ```
 */
public class UserRule internal constructor(
    override val javaResource: com.pulumi.azurenative.network.UserRule,
) : KotlinCustomResource(javaResource, UserRuleMapper) {
    /**
     * A description for this rule.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The destination port ranges.
     */
    public val destinationPortRanges: Output<List<String>>?
        get() = javaResource.destinationPortRanges().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The destination address prefixes. CIDR or destination IP ranges.
     */
    public val destinations: Output<List<AddressPrefixItemResponse>>?
        get() = javaResource.destinations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> addressPrefixItemResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Indicates if the traffic matched against the rule in inbound or outbound.
     */
    public val direction: Output<String>
        get() = javaResource.direction().applyValue({ args0 -> args0 })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Whether the rule is custom or default.
     * Expected value is 'Custom'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network protocol this rule applies to.
     */
    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the security configuration user rule resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The source port ranges.
     */
    public val sourcePortRanges: Output<List<String>>?
        get() = javaResource.sourcePortRanges().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The CIDR or source IP ranges.
     */
    public val sources: Output<List<AddressPrefixItemResponse>>?
        get() = javaResource.sources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> addressPrefixItemResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The system metadata related to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object UserRuleMapper : ResourceMapper<UserRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.UserRule::class == javaResource::class

    override fun map(javaResource: Resource): UserRule = UserRule(
        javaResource as
            com.pulumi.azurenative.network.UserRule,
    )
}

/**
 * @see [UserRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserRule].
 */
public suspend fun userRule(name: String, block: suspend UserRuleResourceBuilder.() -> Unit):
    UserRule {
    val builder = UserRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userRule(name: String): UserRule {
    val builder = UserRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
