@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.PublicIPAddressResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.network.kotlin.outputs.PublicIPAddressResponse.Companion.toKotlin as publicIPAddressResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse.Companion.toKotlin as subnetResponseToKotlin

/**
 * Builder for [VirtualHubIpConfiguration].
 */
@PulumiTagMarker
public class VirtualHubIpConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualHubIpConfigurationArgs = VirtualHubIpConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualHubIpConfigurationArgsBuilder.() -> Unit) {
        val builder = VirtualHubIpConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualHubIpConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.network.VirtualHubIpConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualHubIpConfiguration(builtJavaResource)
    }
}

/**
 * IpConfigurations.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### VirtualHubIpConfigurationPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualHubIpConfiguration = new AzureNative.Network.VirtualHubIpConfiguration("virtualHubIpConfiguration", new()
 *     {
 *         IpConfigName = "ipconfig1",
 *         ResourceGroupName = "rg1",
 *         Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1",
 *         },
 *         VirtualHubName = "hub1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualHubIpConfiguration(ctx, "virtualHubIpConfiguration", &network.VirtualHubIpConfigurationArgs{
 * 			IpConfigName:      pulumi.String("ipconfig1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Subnet: &network.SubnetTypeArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
 * 			},
 * 			VirtualHubName: pulumi.String("hub1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualHubIpConfiguration;
 * import com.pulumi.azurenative.network.VirtualHubIpConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualHubIpConfiguration = new VirtualHubIpConfiguration("virtualHubIpConfiguration", VirtualHubIpConfigurationArgs.builder()
 *             .ipConfigName("ipconfig1")
 *             .resourceGroupName("rg1")
 *             .subnet(SubnetArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1")
 *                 .build())
 *             .virtualHubName("hub1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualHubIpConfiguration ipconfig1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/ipConfigurations/{ipConfigName}
 * ```
 */
public class VirtualHubIpConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.network.VirtualHubIpConfiguration,
) : KotlinCustomResource(javaResource, VirtualHubIpConfigurationMapper) {
    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Name of the Ip Configuration.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The private IP address of the IP configuration.
     */
    public val privateIPAddress: Output<String>?
        get() = javaResource.privateIPAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The private IP address allocation method.
     */
    public val privateIPAllocationMethod: Output<String>?
        get() = javaResource.privateIPAllocationMethod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provisioning state of the IP configuration resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The reference to the public IP resource.
     */
    public val publicIPAddress: Output<PublicIPAddressResponse>?
        get() = javaResource.publicIPAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> publicIPAddressResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The reference to the subnet resource.
     */
    public val subnet: Output<SubnetResponse>?
        get() = javaResource.subnet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subnetResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Ipconfiguration type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VirtualHubIpConfigurationMapper : ResourceMapper<VirtualHubIpConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.VirtualHubIpConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): VirtualHubIpConfiguration =
        VirtualHubIpConfiguration(
            javaResource as
                com.pulumi.azurenative.network.VirtualHubIpConfiguration,
        )
}

/**
 * @see [VirtualHubIpConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualHubIpConfiguration].
 */
public suspend fun virtualHubIpConfiguration(
    name: String,
    block: suspend VirtualHubIpConfigurationResourceBuilder.() -> Unit,
): VirtualHubIpConfiguration {
    val builder = VirtualHubIpConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualHubIpConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualHubIpConfiguration(name: String): VirtualHubIpConfiguration {
    val builder = VirtualHubIpConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
