@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.FrontendIPConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceIPConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceTapConfigurationResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.FrontendIPConfigurationResponse.Companion.toKotlin as frontendIPConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceIPConfigurationResponse.Companion.toKotlin as networkInterfaceIPConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceTapConfigurationResponse.Companion.toKotlin as networkInterfaceTapConfigurationResponseToKotlin

/**
 * Builder for [VirtualNetworkTap].
 */
@PulumiTagMarker
public class VirtualNetworkTapResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualNetworkTapArgs = VirtualNetworkTapArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualNetworkTapArgsBuilder.() -> Unit) {
        val builder = VirtualNetworkTapArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualNetworkTap {
        val builtJavaResource =
            com.pulumi.azurenative.network.VirtualNetworkTap(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualNetworkTap(builtJavaResource)
    }
}

/**
 * Virtual Network Tap resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create Virtual Network Tap
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetworkTap = new AzureNative.Network.VirtualNetworkTap("virtualNetworkTap", new()
 *     {
 *         DestinationNetworkInterfaceIPConfiguration = new AzureNative.Network.Inputs.NetworkInterfaceIPConfigurationArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkInterfaces/testNetworkInterface/ipConfigurations/ipconfig1",
 *         },
 *         Location = "centraluseuap",
 *         ResourceGroupName = "rg1",
 *         TapName = "test-vtap",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetworkTap(ctx, "virtualNetworkTap", &network.VirtualNetworkTapArgs{
 * 			DestinationNetworkInterfaceIPConfiguration: &network.NetworkInterfaceIPConfigurationArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkInterfaces/testNetworkInterface/ipConfigurations/ipconfig1"),
 * 			},
 * 			Location:          pulumi.String("centraluseuap"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			TapName:           pulumi.String("test-vtap"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetworkTap;
 * import com.pulumi.azurenative.network.VirtualNetworkTapArgs;
 * import com.pulumi.azurenative.network.inputs.NetworkInterfaceIPConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetworkTap = new VirtualNetworkTap("virtualNetworkTap", VirtualNetworkTapArgs.builder()
 *             .destinationNetworkInterfaceIPConfiguration(NetworkInterfaceIPConfigurationArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkInterfaces/testNetworkInterface/ipConfigurations/ipconfig1")
 *                 .build())
 *             .location("centraluseuap")
 *             .resourceGroupName("rg1")
 *             .tapName("test-vtap")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualNetworkTap testvtap /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps/{tapName}
 * ```
 */
public class VirtualNetworkTap internal constructor(
    override val javaResource: com.pulumi.azurenative.network.VirtualNetworkTap,
) : KotlinCustomResource(javaResource, VirtualNetworkTapMapper) {
    /**
     * The reference to the private IP address on the internal Load Balancer that will receive the tap.
     */
    public val destinationLoadBalancerFrontEndIPConfiguration:
        Output<FrontendIPConfigurationResponse>?
        get() = javaResource.destinationLoadBalancerFrontEndIPConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    frontendIPConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The reference to the private IP Address of the collector nic that will receive the tap.
     */
    public val destinationNetworkInterfaceIPConfiguration:
        Output<NetworkInterfaceIPConfigurationResponse>?
        get() = javaResource.destinationNetworkInterfaceIPConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    networkInterfaceIPConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The VXLAN destination port that will receive the tapped traffic.
     */
    public val destinationPort: Output<Int>?
        get() = javaResource.destinationPort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the list of resource IDs for the network interface IP configuration that needs to be tapped.
     */
    public val networkInterfaceTapConfigurations:
        Output<List<NetworkInterfaceTapConfigurationResponse>>
        get() = javaResource.networkInterfaceTapConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    networkInterfaceTapConfigurationResponseToKotlin(args0)
                })
            })
        })

    /**
     * The provisioning state of the virtual network tap resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resource GUID property of the virtual network tap resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VirtualNetworkTapMapper : ResourceMapper<VirtualNetworkTap> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.VirtualNetworkTap::class == javaResource::class

    override fun map(javaResource: Resource): VirtualNetworkTap = VirtualNetworkTap(
        javaResource as
            com.pulumi.azurenative.network.VirtualNetworkTap,
    )
}

/**
 * @see [VirtualNetworkTap].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualNetworkTap].
 */
public suspend fun virtualNetworkTap(
    name: String,
    block: suspend VirtualNetworkTapResourceBuilder.() -> Unit,
): VirtualNetworkTap {
    val builder = VirtualNetworkTapResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualNetworkTap].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualNetworkTap(name: String): VirtualNetworkTap {
    val builder = VirtualNetworkTapResourceBuilder()
    builder.name(name)
    return builder.build()
}
