@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [VirtualRouter].
 */
@PulumiTagMarker
public class VirtualRouterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualRouterArgs = VirtualRouterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualRouterArgsBuilder.() -> Unit) {
        val builder = VirtualRouterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualRouter {
        val builtJavaResource = com.pulumi.azurenative.network.VirtualRouter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VirtualRouter(builtJavaResource)
    }
}

/**
 * VirtualRouter Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2022-01-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create VirtualRouter
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualRouter = new AzureNative.Network.VirtualRouter("virtualRouter", new()
 *     {
 *         HostedGateway = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vnetGateway",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         VirtualRouterName = "virtualRouter",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualRouter(ctx, "virtualRouter", &network.VirtualRouterArgs{
 * 			HostedGateway: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vnetGateway"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			VirtualRouterName: pulumi.String("virtualRouter"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualRouter;
 * import com.pulumi.azurenative.network.VirtualRouterArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualRouter = new VirtualRouter("virtualRouter", VirtualRouterArgs.builder()
 *             .hostedGateway(SubResourceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vnetGateway")
 *                 .build())
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "value1"))
 *             .virtualRouterName("virtualRouter")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualRouter virtualRouter /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}
 * ```
 */
public class VirtualRouter internal constructor(
    override val javaResource: com.pulumi.azurenative.network.VirtualRouter,
) : KotlinCustomResource(javaResource, VirtualRouterMapper) {
    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The Gateway on which VirtualRouter is hosted.
     */
    public val hostedGateway: Output<SubResourceResponse>?
        get() = javaResource.hostedGateway().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The Subnet on which VirtualRouter is hosted.
     */
    public val hostedSubnet: Output<SubResourceResponse>?
        get() = javaResource.hostedSubnet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of references to VirtualRouterPeerings.
     */
    public val peerings: Output<List<SubResourceResponse>>
        get() = javaResource.peerings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * VirtualRouter ASN.
     */
    public val virtualRouterAsn: Output<Double>?
        get() = javaResource.virtualRouterAsn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * VirtualRouter IPs.
     */
    public val virtualRouterIps: Output<List<String>>?
        get() = javaResource.virtualRouterIps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })
}

public object VirtualRouterMapper : ResourceMapper<VirtualRouter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.VirtualRouter::class == javaResource::class

    override fun map(javaResource: Resource): VirtualRouter = VirtualRouter(
        javaResource as
            com.pulumi.azurenative.network.VirtualRouter,
    )
}

/**
 * @see [VirtualRouter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualRouter].
 */
public suspend fun virtualRouter(
    name: String,
    block: suspend VirtualRouterResourceBuilder.() -> Unit,
): VirtualRouter {
    val builder = VirtualRouterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualRouter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualRouter(name: String): VirtualRouter {
    val builder = VirtualRouterResourceBuilder()
    builder.name(name)
    return builder.build()
}
