@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.BgpSettingsResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.VpnConnectionResponse
import com.pulumi.azurenative.network.kotlin.outputs.VpnGatewayIpConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.VpnGatewayNatRuleResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.BgpSettingsResponse.Companion.toKotlin as bgpSettingsResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VpnConnectionResponse.Companion.toKotlin as vpnConnectionResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VpnGatewayIpConfigurationResponse.Companion.toKotlin as vpnGatewayIpConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VpnGatewayNatRuleResponse.Companion.toKotlin as vpnGatewayNatRuleResponseToKotlin

/**
 * Builder for [VpnGateway].
 */
@PulumiTagMarker
public class VpnGatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpnGatewayArgs = VpnGatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpnGatewayArgsBuilder.() -> Unit) {
        val builder = VpnGatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpnGateway {
        val builtJavaResource = com.pulumi.azurenative.network.VpnGateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpnGateway(builtJavaResource)
    }
}

/**
 * VpnGateway Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2018-07-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### VpnGatewayPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vpnGateway = new AzureNative.Network.VpnGateway("vpnGateway", new()
 *     {
 *         BgpSettings = new AzureNative.Network.Inputs.BgpSettingsArgs
 *         {
 *             Asn = 65515,
 *             BgpPeeringAddresses = new[]
 *             {
 *                 new AzureNative.Network.Inputs.IPConfigurationBgpPeeringAddressArgs
 *                 {
 *                     CustomBgpIpAddresses = new[]
 *                     {
 *                         "169.254.21.5",
 *                     },
 *                     IpconfigurationId = "Instance0",
 *                 },
 *                 new AzureNative.Network.Inputs.IPConfigurationBgpPeeringAddressArgs
 *                 {
 *                     CustomBgpIpAddresses = new[]
 *                     {
 *                         "169.254.21.10",
 *                     },
 *                     IpconfigurationId = "Instance1",
 *                 },
 *             },
 *             PeerWeight = 0,
 *         },
 *         Connections = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnConnectionArgs
 *             {
 *                 Name = "vpnConnection1",
 *                 RemoteVpnSite = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1",
 *                 },
 *                 VpnLinkConnections = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.VpnSiteLinkConnectionArgs
 *                     {
 *                         ConnectionBandwidth = 200,
 *                         EgressNatRules = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.SubResourceArgs
 *                             {
 *                                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/natRules/nat03",
 *                             },
 *                         },
 *                         Name = "Connection-Link1",
 *                         SharedKey = "key",
 *                         VpnConnectionProtocolType = AzureNative.Network.VirtualNetworkGatewayConnectionProtocol.IKEv2,
 *                         VpnSiteLink = new AzureNative.Network.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1/vpnSiteLinks/siteLink1",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         EnableBgpRouteTranslationForNat = false,
 *         GatewayName = "gateway1",
 *         IsRoutingPreferenceInternet = false,
 *         Location = "westcentralus",
 *         NatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnGatewayNatRuleArgs
 *             {
 *                 ExternalMappings = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.VpnNatRuleMappingArgs
 *                     {
 *                         AddressSpace = "192.168.0.0/26",
 *                     },
 *                 },
 *                 InternalMappings = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.VpnNatRuleMappingArgs
 *                     {
 *                         AddressSpace = "0.0.0.0/26",
 *                     },
 *                 },
 *                 IpConfigurationId = "",
 *                 Mode = AzureNative.Network.VpnNatRuleMode.EgressSnat,
 *                 Name = "nat03",
 *                 Type = AzureNative.Network.VpnNatRuleType.Static,
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         VirtualHub = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVpnGateway(ctx, "vpnGateway", &network.VpnGatewayArgs{
 * 			BgpSettings: &network.BgpSettingsArgs{
 * 				Asn: pulumi.Float64(65515),
 * 				BgpPeeringAddresses: network.IPConfigurationBgpPeeringAddressArray{
 * 					&network.IPConfigurationBgpPeeringAddressArgs{
 * 						CustomBgpIpAddresses: pulumi.StringArray{
 * 							pulumi.String("169.254.21.5"),
 * 						},
 * 						IpconfigurationId: pulumi.String("Instance0"),
 * 					},
 * 					&network.IPConfigurationBgpPeeringAddressArgs{
 * 						CustomBgpIpAddresses: pulumi.StringArray{
 * 							pulumi.String("169.254.21.10"),
 * 						},
 * 						IpconfigurationId: pulumi.String("Instance1"),
 * 					},
 * 				},
 * 				PeerWeight: pulumi.Int(0),
 * 			},
 * 			Connections: network.VpnConnectionTypeArray{
 * 				&network.VpnConnectionTypeArgs{
 * 					Name: pulumi.String("vpnConnection1"),
 * 					RemoteVpnSite: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1"),
 * 					},
 * 					VpnLinkConnections: network.VpnSiteLinkConnectionArray{
 * 						&network.VpnSiteLinkConnectionArgs{
 * 							ConnectionBandwidth: pulumi.Int(200),
 * 							EgressNatRules: network.SubResourceArray{
 * 								&network.SubResourceArgs{
 * 									Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/natRules/nat03"),
 * 								},
 * 							},
 * 							Name:                      pulumi.String("Connection-Link1"),
 * 							SharedKey:                 pulumi.String("key"),
 * 							VpnConnectionProtocolType: pulumi.String(network.VirtualNetworkGatewayConnectionProtocolIKEv2),
 * 							VpnSiteLink: &network.SubResourceArgs{
 * 								Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1/vpnSiteLinks/siteLink1"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			EnableBgpRouteTranslationForNat: pulumi.Bool(false),
 * 			GatewayName:                     pulumi.String("gateway1"),
 * 			IsRoutingPreferenceInternet:     pulumi.Bool(false),
 * 			Location:                        pulumi.String("westcentralus"),
 * 			NatRules: network.VpnGatewayNatRuleArray{
 * 				&network.VpnGatewayNatRuleArgs{
 * 					ExternalMappings: network.VpnNatRuleMappingArray{
 * 						&network.VpnNatRuleMappingArgs{
 * 							AddressSpace: pulumi.String("192.168.0.0/26"),
 * 						},
 * 					},
 * 					InternalMappings: network.VpnNatRuleMappingArray{
 * 						&network.VpnNatRuleMappingArgs{
 * 							AddressSpace: pulumi.String("0.0.0.0/26"),
 * 						},
 * 					},
 * 					IpConfigurationId: pulumi.String(""),
 * 					Mode:              pulumi.String(network.VpnNatRuleModeEgressSnat),
 * 					Name:              pulumi.String("nat03"),
 * 					Type:              pulumi.String(network.VpnNatRuleTypeStatic),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			VirtualHub: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VpnGateway;
 * import com.pulumi.azurenative.network.VpnGatewayArgs;
 * import com.pulumi.azurenative.network.inputs.BgpSettingsArgs;
 * import com.pulumi.azurenative.network.inputs.VpnConnectionArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.VpnGatewayNatRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpnGateway = new VpnGateway("vpnGateway", VpnGatewayArgs.builder()
 *             .bgpSettings(BgpSettingsArgs.builder()
 *                 .asn(65515)
 *                 .bgpPeeringAddresses(
 *                     IPConfigurationBgpPeeringAddressArgs.builder()
 *                         .customBgpIpAddresses("169.254.21.5")
 *                         .ipconfigurationId("Instance0")
 *                         .build(),
 *                     IPConfigurationBgpPeeringAddressArgs.builder()
 *                         .customBgpIpAddresses("169.254.21.10")
 *                         .ipconfigurationId("Instance1")
 *                         .build())
 *                 .peerWeight(0)
 *                 .build())
 *             .connections(VpnConnectionArgs.builder()
 *                 .name("vpnConnection1")
 *                 .remoteVpnSite(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1")
 *                     .build())
 *                 .vpnLinkConnections(VpnSiteLinkConnectionArgs.builder()
 *                     .connectionBandwidth(200)
 *                     .egressNatRules(SubResourceArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/natRules/nat03")
 *                         .build())
 *                     .name("Connection-Link1")
 *                     .sharedKey("key")
 *                     .vpnConnectionProtocolType("IKEv2")
 *                     .vpnSiteLink(SubResourceArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1/vpnSiteLinks/siteLink1")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .enableBgpRouteTranslationForNat(false)
 *             .gatewayName("gateway1")
 *             .isRoutingPreferenceInternet(false)
 *             .location("westcentralus")
 *             .natRules(VpnGatewayNatRuleArgs.builder()
 *                 .externalMappings(VpnNatRuleMappingArgs.builder()
 *                     .addressSpace("192.168.0.0/26")
 *                     .build())
 *                 .internalMappings(VpnNatRuleMappingArgs.builder()
 *                     .addressSpace("0.0.0.0/26")
 *                     .build())
 *                 .ipConfigurationId("")
 *                 .mode("EgressSnat")
 *                 .name("nat03")
 *                 .type("Static")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "value1"))
 *             .virtualHub(SubResourceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VpnGateway gateway1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}
 * ```
 */
public class VpnGateway internal constructor(
    override val javaResource: com.pulumi.azurenative.network.VpnGateway,
) : KotlinCustomResource(javaResource, VpnGatewayMapper) {
    /**
     * Local network gateway's BGP speaker settings.
     */
    public val bgpSettings: Output<BgpSettingsResponse>?
        get() = javaResource.bgpSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    bgpSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of all vpn connections to the gateway.
     */
    public val connections: Output<List<VpnConnectionResponse>>?
        get() = javaResource.connections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> vpnConnectionResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Enable BGP routes translation for NAT on this VpnGateway.
     */
    public val enableBgpRouteTranslationForNat: Output<Boolean>?
        get() = javaResource.enableBgpRouteTranslationForNat().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * List of all IPs configured on the gateway.
     */
    public val ipConfigurations: Output<List<VpnGatewayIpConfigurationResponse>>
        get() = javaResource.ipConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> vpnGatewayIpConfigurationResponseToKotlin(args0) })
            })
        })

    /**
     * Enable Routing Preference property for the Public IP Interface of the VpnGateway.
     */
    public val isRoutingPreferenceInternet: Output<Boolean>?
        get() = javaResource.isRoutingPreferenceInternet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of all the nat Rules associated with the gateway.
     */
    public val natRules: Output<List<VpnGatewayNatRuleResponse>>?
        get() = javaResource.natRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> vpnGatewayNatRuleResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the VPN gateway resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The VirtualHub to which the gateway belongs.
     */
    public val virtualHub: Output<SubResourceResponse>?
        get() = javaResource.virtualHub().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subResourceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The scale unit for this vpn gateway.
     */
    public val vpnGatewayScaleUnit: Output<Int>?
        get() = javaResource.vpnGatewayScaleUnit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object VpnGatewayMapper : ResourceMapper<VpnGateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.VpnGateway::class == javaResource::class

    override fun map(javaResource: Resource): VpnGateway = VpnGateway(
        javaResource as
            com.pulumi.azurenative.network.VpnGateway,
    )
}

/**
 * @see [VpnGateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpnGateway].
 */
public suspend fun vpnGateway(name: String, block: suspend VpnGatewayResourceBuilder.() -> Unit):
    VpnGateway {
    val builder = VpnGatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpnGateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpnGateway(name: String): VpnGateway {
    val builder = VpnGatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
